/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import a.c.p;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphViewUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityNodeClickedUpdater;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.ProximityRangeCalculator;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.HashSet;
import java.util.Set;

public class ProximityBrowserUnhideNode
implements ICommand {
    private final BinDiffGraph<ZyGraphNode<?>, ?> graph;
    private final ZyGraphNode<?> nodeToShow;

    public ProximityBrowserUnhideNode(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        this.graph = Preconditions.checkNotNull(binDiffGraph);
        this.nodeToShow = Preconditions.checkNotNull(zyGraphNode);
    }

    private static void updateVisibility(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, Set<ZyGraphNode<?>> set) {
        for (ZyGraphNode<?> zyGraphNode : set) {
            p p2;
            p p3;
            if (zyGraphNode.isVisible()) continue;
            if (zyGraphNode instanceof SingleDiffNode) {
                p3 = ((SingleDiffNode)zyGraphNode).getCombinedDiffNode().getNode();
                p2 = ((SingleDiffNode)zyGraphNode).getSuperDiffNode().getNode();
                if (!((CombinedDiffNode)binDiffGraph.getCombinedGraph().getNode(p3)).getRawNode().isVisible()) {
                    ((CombinedDiffNode)binDiffGraph.getCombinedGraph().getNode(p3)).getRawNode().setVisible(true);
                }
                if (((SuperDiffNode)binDiffGraph.getSuperGraph().getNode(p2)).getRawNode().isVisible()) continue;
                ((SuperDiffNode)binDiffGraph.getSuperGraph().getNode(p2)).getRawNode().setVisible(true);
                continue;
            }
            if (!(zyGraphNode instanceof CombinedDiffNode)) continue;
            p3 = ((CombinedDiffNode)zyGraphNode).getNode();
            p2 = ((CombinedDiffNode)zyGraphNode).getSuperDiffNode().getNode();
            if (!((CombinedDiffNode)binDiffGraph.getCombinedGraph().getNode(p3)).getRawNode().isVisible()) {
                ((CombinedDiffNode)binDiffGraph.getCombinedGraph().getNode(p3)).getRawNode().setVisible(true);
            }
            if (((SuperDiffNode)binDiffGraph.getSuperGraph().getNode(p2)).getRawNode().isVisible()) continue;
            ((SuperDiffNode)binDiffGraph.getSuperGraph().getNode(p2)).getRawNode().setVisible(true);
        }
    }

    public static void executeStatic(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        HashSet hashSet = new HashSet();
        hashSet.add(zyGraphNode);
        GraphProximityBrowsingSettings graphProximityBrowsingSettings = binDiffGraph.getSettings().getProximitySettings();
        Set<ZyGraphNode<?>> set = ProximityRangeCalculator.getNeighbors(binDiffGraph, hashSet, graphProximityBrowsingSettings.getProximityBrowsingChildren(), graphProximityBrowsingSettings.getProximityBrowsingParents());
        ProximityBrowserUnhideNode.updateVisibility(binDiffGraph, set);
        ProximityNodeClickedUpdater.updateProximityNodes(binDiffGraph);
        GraphViewUpdater.updateViews(binDiffGraph);
        GraphsIntermediateListeners.notifyIntermediateVisibilityListeners(binDiffGraph);
        if (LayoutCommandHelper.isAutolayout(binDiffGraph)) {
            GraphLayoutUpdater.executeStatic(binDiffGraph, true);
        }
    }

    @Override
    public void execute() {
        ProximityBrowserUnhideNode.executeStatic(this.graph, this.nodeToShow);
    }
}

