/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUpdater;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.Collection;

public class ProximityBrowserInitializer {
    private static final int EDGE_COUNT_THRESHOLD = 3;

    private ProximityBrowserInitializer() {
    }

    private static SingleDiffNode getProximityBrowsingStartNode(SingleGraph singleGraph) {
        SingleDiffNode singleDiffNode = null;
        IAddress iAddress = null;
        if (singleGraph.getGraphType() == EGraphType.CALLGRAPH) {
            for (SingleDiffNode singleDiffNode2 : singleGraph.getNodes()) {
                SingleViewNode singleViewNode;
                if (singleDiffNode2.getRawNode().getMatchState() != EMatchState.MATCHED || (singleViewNode = singleDiffNode2.getRawNode()).getIncomingEdges().size() + singleViewNode.getOutgoingEdges().size() != 3) continue;
                IAddress iAddress2 = singleViewNode.getAddress();
                if (iAddress != null && iAddress.compareTo(iAddress2) <= 0) continue;
                iAddress = iAddress2;
                singleDiffNode = singleDiffNode2;
            }
        } else {
            for (SingleDiffNode singleDiffNode3 : singleGraph.getNodes()) {
                RawBasicBlock rawBasicBlock = (RawBasicBlock)singleDiffNode3.getRawNode();
                if (!rawBasicBlock.getAddress().equals(rawBasicBlock.getFunctionAddr())) continue;
                singleDiffNode = singleDiffNode3;
                break;
            }
        }
        return singleDiffNode;
    }

    private static void getVisibleAndInvisibleNodeSets(BinDiffGraph<?, ?> binDiffGraph, SingleDiffNode singleDiffNode, SingleDiffNode singleDiffNode2, Collection<SuperDiffNode> collection, Collection<SuperDiffNode> collection2, Collection<CombinedDiffNode> collection3, Collection<CombinedDiffNode> collection4) {
        collection4.addAll(binDiffGraph.getCombinedGraph().getNodes());
        collection2.addAll(binDiffGraph.getSuperGraph().getNodes());
        if (singleDiffNode == null && singleDiffNode2 == null) {
            return;
        }
        if (singleDiffNode == null) {
            singleDiffNode = singleDiffNode2.getOtherSideDiffNode();
        } else {
            singleDiffNode2 = singleDiffNode2 == null ? singleDiffNode.getOtherSideDiffNode() : singleDiffNode.getOtherSideDiffNode();
        }
        SuperDiffNode superDiffNode = singleDiffNode.getSuperDiffNode();
        collection2.remove(superDiffNode);
        collection.add(superDiffNode);
        CombinedDiffNode combinedDiffNode = singleDiffNode.getCombinedDiffNode();
        collection4.remove(combinedDiffNode);
        collection3.add(combinedDiffNode);
    }

    private static void initialProximityBrowsing(BinDiffGraph<?, ?> binDiffGraph) {
        GraphProximityBrowsingSettings graphProximityBrowsingSettings = binDiffGraph.getSettings().getProximitySettings();
        int n2 = graphProximityBrowsingSettings.getAutoProximityBrowsingActivationThreshold();
        Collection collection = binDiffGraph.getCombinedGraph().getNodes();
        int n3 = collection.size();
        if (n3 < n2) {
            return;
        }
        graphProximityBrowsingSettings.setProximityBrowsing(true);
        SingleDiffNode singleDiffNode = ProximityBrowserInitializer.getProximityBrowsingStartNode(binDiffGraph.getPrimaryGraph());
        SingleDiffNode singleDiffNode2 = ProximityBrowserInitializer.getProximityBrowsingStartNode(binDiffGraph.getSecondaryGraph());
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        ArrayList<CombinedDiffNode> arrayList2 = new ArrayList<CombinedDiffNode>();
        ArrayList<SuperDiffNode> arrayList3 = new ArrayList<SuperDiffNode>();
        ArrayList<SuperDiffNode> arrayList4 = new ArrayList<SuperDiffNode>();
        ProximityBrowserInitializer.getVisibleAndInvisibleNodeSets(binDiffGraph, singleDiffNode, singleDiffNode2, arrayList3, arrayList4, arrayList, arrayList2);
        GraphLayoutSettings graphLayoutSettings = binDiffGraph.getSettings().getLayoutSettings();
        boolean bl2 = graphLayoutSettings.getAutomaticLayouting();
        graphLayoutSettings.setAutomaticLayouting(false);
        binDiffGraph.getSuperGraph().showNodes(arrayList3, arrayList4);
        binDiffGraph.getCombinedGraph().showNodes(arrayList, arrayList2);
        ProximityBrowserUpdater.adoptSuperGraphVisibility(binDiffGraph.getSuperGraph());
        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getPrimaryGraph());
        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getSecondaryGraph());
        ProximityBrowserUpdater.createProximityNodesAndEdges(binDiffGraph.getSuperGraph());
        graphLayoutSettings.setAutomaticLayouting(bl2);
    }

    public static void executeStatic(BinDiffGraph<?, ?> binDiffGraph) {
        ProximityBrowserInitializer.initialProximityBrowsing(binDiffGraph);
        try {
            GraphsIntermediateListeners.notifyIntermediateVisibilityListeners(binDiffGraph);
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, exception.getMessage());
        }
    }
}

