/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.ProximityBrowser;
import com.google.security.zynamics.bindiff.graph.filter.GraphEdgeFilter;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeFilter;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphViewUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUpdater;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class ProximityBrowserDeactivator
implements ICommand {
    private final BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> graph;

    public ProximityBrowserDeactivator(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        Preconditions.checkNotNull(binDiffGraph);
        this.graph = binDiffGraph;
    }

    private static boolean hasHiddenNodes(BinDiffGraph<?, ?> binDiffGraph) {
        return GraphNodeFilter.filterNodesCountOnly(binDiffGraph, GraphNodeFilter.Criterion.INVISIBLE) > 0;
    }

    private static boolean showAllNodesVisibilityWarningDialog(BinDiffGraph<?, ?> binDiffGraph) {
        int n2 = GraphEdgeFilter.filterInvisibleEdges(binDiffGraph).size();
        int n3 = GraphNodeFilter.filterNodesCountOnly(binDiffGraph, GraphNodeFilter.Criterion.INVISIBLE);
        int n4 = binDiffGraph.getSettings().getLayoutSettings().getVisibilityWarningThreshold();
        if (n2 >= n4) {
            int n5 = CMessageBox.showYesNoQuestion(BinDiffGraph.getParentWindow(binDiffGraph), String.format("The selected operation makes %d more nodes with %d edges visible. Do you want to continue?", n3, n2));
            return n5 == 0;
        }
        return true;
    }

    private static void unhideAll(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getPrimaryGraph());
        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getSecondaryGraph());
        for (SuperDiffNode superDiffNode : binDiffGraph.getSuperGraph().getNodes()) {
            superDiffNode.getRawNode().setVisible(true);
            superDiffNode.getCombinedRawNode().setVisible(true);
        }
        ProximityBrowserUpdater.adoptSuperGraphVisibility(binDiffGraph.getSuperGraph());
        GraphViewUpdater.updateViews(binDiffGraph);
    }

    public static void executeStatic(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        if (!ProximityBrowserDeactivator.hasHiddenNodes(binDiffGraph)) {
            return;
        }
        if (ProximityBrowserDeactivator.showAllNodesVisibilityWarningDialog(binDiffGraph)) {
            ((ProximityBrowser)binDiffGraph.getCombinedGraph().getProximityBrowser()).deleteProximityBrowsingNodes();
            ((ProximityBrowser)binDiffGraph.getSuperGraph().getProximityBrowser()).deleteProximityBrowsingNodes();
            ProximityBrowserDeactivator.unhideAll(binDiffGraph);
            GraphsIntermediateListeners.notifyIntermediateVisibilityListeners(binDiffGraph);
            if (binDiffGraph.getSettings().getLayoutSettings().getAutomaticLayouting()) {
                GraphLayoutUpdater.executeStatic(binDiffGraph, true);
            }
            GraphViewUpdater.updateViews(binDiffGraph);
        } else {
            binDiffGraph.getSettings().getProximitySettings().setProximityBrowsing(true);
        }
    }

    @Override
    public void execute() {
        ProximityBrowserDeactivator.executeStatic(this.graph);
    }
}

