/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.ProximityBrowser;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphViewUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUpdater;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class ProximityBrowserActivator
implements ICommand {
    private final BinDiffGraph<ZyGraphNode<?>, ?> graph;

    public ProximityBrowserActivator(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        this.graph = Preconditions.checkNotNull(binDiffGraph);
    }

    public static void executeStatic(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        ((ProximityBrowser)binDiffGraph.getCombinedGraph().getProximityBrowser()).addSettingsListener();
        ((ProximityBrowser)binDiffGraph.getSuperGraph().getProximityBrowser()).addSettingsListener();
        try {
            binDiffGraph.getSettings().getProximitySettings().setProximityBrowsing(true);
        }
        finally {
            ((ProximityBrowser)binDiffGraph.getSuperGraph().getProximityBrowser()).removeSettingsListener();
            ((ProximityBrowser)binDiffGraph.getCombinedGraph().getProximityBrowser()).removeSettingsListener();
        }
        if (!LayoutCommandHelper.isProximityBrowsingFrozen(binDiffGraph)) {
            if (LayoutCommandHelper.hasSelectedNodes(binDiffGraph)) {
                ProximityBrowserUpdater.executeStatic(binDiffGraph);
                if (binDiffGraph.getSettings().getLayoutSettings().getAutomaticLayouting() && !binDiffGraph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
                    GraphLayoutUpdater.executeStatic(binDiffGraph, true);
                }
            }
            GraphViewUpdater.updateViews(binDiffGraph);
        }
    }

    @Override
    public void execute() {
        ProximityBrowserActivator.executeStatic(this.graph);
    }
}

