/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import a.b.b;
import a.b.e;
import a.b.g;
import a.f.F;
import a.f.N;
import a.f.P;
import a.f.c;
import a.h.U;
import a.h.ar;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.helpers.GraphViewFitter;
import com.google.security.zynamics.bindiff.graph.layout.LayoutMorpher;
import com.google.security.zynamics.bindiff.graph.layout.SuperLayoutMorpher;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutCalculator;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class GraphViewUpdater
implements ICommand {
    private final BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> referenceGraph;
    private final GraphLayoutCalculator layoutCalculator;

    public GraphViewUpdater(GraphLayoutCalculator graphLayoutCalculator) {
        Preconditions.checkNotNull(graphLayoutCalculator);
        this.layoutCalculator = graphLayoutCalculator;
        this.referenceGraph = graphLayoutCalculator.getReferenceGraph();
    }

    public static void updateViews(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        binDiffGraph.getPrimaryGraph().getGraph().updateViews();
        binDiffGraph.getSecondaryGraph().getGraph().updateViews();
        binDiffGraph.getCombinedGraph().getGraph().updateViews();
        binDiffGraph.getSuperGraph().getGraph().updateViews();
    }

    private void applyGraphLayout() {
        GraphSettings graphSettings = this.referenceGraph.getSettings();
        if (graphSettings.isSync()) {
            a.f.U.a((P)this.referenceGraph.getPrimaryGraph().getGraph(), this.layoutCalculator.getPrimaryGraphLayout());
            a.f.U.a((P)this.referenceGraph.getSecondaryGraph().getGraph(), this.layoutCalculator.getSecondaryGraphLayout());
            a.f.U.a((P)this.referenceGraph.getCombinedGraph().getGraph(), this.layoutCalculator.getCombinedGraphLayout());
            this.referenceGraph.getCombinedGraph().getView().fitContent();
        } else {
            a.f.U.a((P)this.referenceGraph.getGraph(), this.getReferenceGraphLayout());
            this.referenceGraph.getView().fitContent();
            this.referenceGraph.getView().setZoom(this.referenceGraph.getView().getZoom() * 0.95);
        }
    }

    private F getReferenceGraphLayout() {
        if (this.referenceGraph instanceof SingleGraph) {
            ESide eSide = ((SingleGraph)this.referenceGraph).getSide();
            return eSide == ESide.PRIMARY ? this.layoutCalculator.getPrimaryGraphLayout() : this.layoutCalculator.getSecondaryGraphLayout();
        }
        return this.layoutCalculator.getCombinedGraphLayout();
    }

    private void morphGraphLayout() {
        try {
            GraphSettings graphSettings = this.referenceGraph.getSettings();
            if (graphSettings.isSync()) {
                if (graphSettings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
                    a.f.U.a((P)this.referenceGraph.getCombinedGraph().getGraph(), this.layoutCalculator.getCombinedGraphLayout());
                    this.referenceGraph.getCombinedGraph().getView().fitContent();
                    double d2 = this.referenceGraph.getCombinedGraph().getView().getZoom() * 0.95;
                    this.referenceGraph.getCombinedGraph().getView().setZoom(d2);
                    this.morphTwoGraphLayouts();
                } else {
                    a.f.U.a((P)this.referenceGraph.getPrimaryGraph().getGraph(), this.layoutCalculator.getPrimaryGraphLayout());
                    a.f.U.a((P)this.referenceGraph.getSecondaryGraph().getGraph(), this.layoutCalculator.getSecondaryGraphLayout());
                    this.morphOneGraphLayout(this.referenceGraph, this.layoutCalculator.getCombinedGraphLayout());
                }
            } else {
                this.morphOneGraphLayout(this.referenceGraph, this.getReferenceGraphLayout());
            }
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Graph layout failed. Could not morph graph layout.");
        }
    }

    private void morphOneGraphLayout(BinDiffGraph<?, ?> binDiffGraph, F f2) {
        GraphSettings graphSettings = binDiffGraph.getSettings();
        c c2 = graphSettings.getLayoutSettings().getCurrentLayouter();
        ar ar2 = binDiffGraph.getView();
        c2.c(new N());
        c2.j(true);
        int n2 = 100;
        int n3 = binDiffGraph.getSettings().getDisplaySettings().getAnimationSpeed();
        e e2 = new e();
        e2.e(true);
        e2.a(ar2);
        LayoutMorpher layoutMorpher = new LayoutMorpher(ar2, f2);
        layoutMorpher.setKeepZoomFactor(false);
        layoutMorpher.setEasedExecution(true);
        layoutMorpher.setPreferredDuration(100 * n3);
        layoutMorpher.setSmoothViewTransform(true);
        g g2 = b.P();
        g2.e(layoutMorpher);
        e2.c(g2);
    }

    private void morphTwoGraphLayouts() {
        U u2 = this.referenceGraph.getSuperGraph().getGraph();
        F f2 = this.layoutCalculator.getPrimaryGraphLayout();
        F f3 = this.layoutCalculator.getSecondaryGraphLayout();
        ar ar2 = this.referenceGraph.getPrimaryGraph().getView();
        ar ar3 = this.referenceGraph.getSecondaryGraph().getView();
        e e2 = new e();
        e2.e(true);
        e2.a(ar2);
        e2.a(ar3);
        SuperLayoutMorpher superLayoutMorpher = new SuperLayoutMorpher(ar2, f2, u2);
        SuperLayoutMorpher superLayoutMorpher2 = new SuperLayoutMorpher(ar3, f3, u2);
        int n2 = this.referenceGraph.getSettings().getDisplaySettings().getAnimationSpeed();
        int n3 = 100;
        superLayoutMorpher.setSmoothViewTransform(true);
        superLayoutMorpher.setPreferredDuration(100 * n2);
        superLayoutMorpher.setEasedExecution(true);
        superLayoutMorpher2.setSmoothViewTransform(true);
        superLayoutMorpher2.setPreferredDuration(100 * n2);
        superLayoutMorpher2.setEasedExecution(true);
        g g2 = b.P();
        g2.e(superLayoutMorpher);
        g2.e(superLayoutMorpher2);
        e2.c(g2);
    }

    @Override
    public void execute() {
        try {
            GraphSettings graphSettings = this.referenceGraph.getSettings();
            GraphViewFitter.adoptSuperViewCanvasProperties(this.referenceGraph.getSuperGraph());
            GraphViewFitter.fitSingleViewToSuperViewContent(this.referenceGraph.getSuperGraph());
            if (graphSettings.getLayoutSettings().getAnimateLayout()) {
                this.morphGraphLayout();
            } else {
                this.applyGraphLayout();
            }
            GraphViewUpdater.updateViews(this.referenceGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            throw graphLayoutException;
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Could update graph view.");
        }
    }
}

