/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeFilter;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUpdater;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.ProximityRangeCalculator;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GraphSelectionUpdater
implements ICommand {
    private final BinDiffGraph<ZyGraphNode<?>, ?> referenceGraph;

    public GraphSelectionUpdater(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        Preconditions.checkNotNull(binDiffGraph);
        Preconditions.checkArgument(!(binDiffGraph instanceof SuperGraph), "Reference graph cannot be a super graph");
        this.referenceGraph = binDiffGraph;
    }

    private static <EdgeType extends ZyGraphEdge<?, ?, ?>, GraphType extends AbstractZyGraph<? extends ZyGraphNode<?>, EdgeType>> void selectRawEdges(GraphType GraphType2) {
        final ArrayList arrayList = new ArrayList();
        GraphType2.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType EdgeType2) {
                if (((ZyGraphNode)((ZyGraphEdge)EdgeType2).getSource()).getRawNode().isSelected() || ((ZyGraphNode)((ZyGraphEdge)EdgeType2).getTarget()).getRawNode().isSelected()) {
                    arrayList.add(EdgeType2);
                }
                return IterationMode.CONTINUE;
            }
        });
        GraphType2.getGraph().Bs();
        for (ZyGraphEdge zyGraphEdge : arrayList) {
            zyGraphEdge.getRawEdge().setSelected(true);
            GraphType2.getGraph().co(zyGraphEdge.getEdge()).setSelected(true);
        }
    }

    private static void selectRawGraph(CombinedGraph combinedGraph, Collection<CombinedDiffNode> collection, Collection<CombinedDiffNode> collection2) {
        combinedGraph.selectNodes(collection, collection2);
        GraphSelectionUpdater.selectRawNodes(combinedGraph);
        GraphSelectionUpdater.selectRawEdges(combinedGraph);
    }

    private static void selectRawGraph(SingleGraph singleGraph, Collection<SingleDiffNode> collection, Collection<SingleDiffNode> collection2) {
        singleGraph.selectNodes(collection, collection2);
        GraphSelectionUpdater.selectRawNodes(singleGraph);
        GraphSelectionUpdater.selectRawEdges(singleGraph);
    }

    private static void selectRawGraph(SuperGraph superGraph, Collection<SuperDiffNode> collection, Collection<SuperDiffNode> collection2) {
        superGraph.selectNodes(collection, collection2);
        GraphSelectionUpdater.selectRawNodes(superGraph);
        GraphSelectionUpdater.selectRawEdges(superGraph);
    }

    private static <GraphType extends AbstractZyGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>>> void selectRawNodes(GraphType GraphType2) {
        for (ZyGraphNode<?> zyGraphNode : GraphType2.getSelectedNodes()) {
            if (zyGraphNode instanceof CombinedDiffNode) {
                ((CombinedDiffNode)zyGraphNode).getRawNode().setSelected(true);
            }
            if (!(zyGraphNode instanceof SuperDiffNode)) continue;
            ((SuperDiffNode)zyGraphNode).getRawNode().setSelected(true);
        }
    }

    private static boolean showVisibilityWarningDialog(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        int n2 = binDiffGraph.getSettings().getProximitySettings().getProximityBrowsingChildren();
        int n3 = binDiffGraph.getSettings().getProximitySettings().getProximityBrowsingParents();
        List<ZyGraphNode<IViewNode<ZyGraphNode<IViewNode<Object>>>>> list = GraphNodeFilter.filterNodes(binDiffGraph, GraphNodeFilter.Criterion.VISIBLE);
        List<ZyGraphNode<? extends IViewNode<?>>> list2 = GraphNodeFilter.filterNodes(binDiffGraph, GraphNodeFilter.Criterion.SELECTED_VISIBLE);
        Set<ZyGraphNode<IViewNode<?>>> set = ProximityRangeCalculator.getNeighbors(binDiffGraph, list2, n2, n3);
        HashSet hashSet = new HashSet();
        int n4 = 0;
        for (ZyGraphNode<IViewNode<?>> zyGraphNode : set) {
            if (!zyGraphNode.isVisible()) {
                ++n4;
                continue;
            }
            hashSet.add(zyGraphNode);
        }
        list.removeAll(list2);
        list.removeAll(hashSet);
        int n5 = list.size();
        int n6 = n4 - n5;
        int n7 = binDiffGraph.getSettings().getLayoutSettings().getVisibilityWarningThreshold();
        if (n6 >= n7) {
            int n8 = CMessageBox.showYesNoQuestion(BinDiffGraph.getParentWindow(binDiffGraph), String.format("The selected operation makes %d more nodes visible. Do you want to continue?", n6));
            return n8 == 0;
        }
        return true;
    }

    private static void synchronizeNodesSelection(CombinedGraph combinedGraph, Set<CombinedDiffNode> set) {
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SuperDiffNode> arrayList3 = new ArrayList<SuperDiffNode>();
        ArrayList<SuperDiffNode> arrayList4 = new ArrayList<SuperDiffNode>();
        ArrayList<SingleDiffNode> arrayList5 = new ArrayList<SingleDiffNode>();
        ArrayList<SingleDiffNode> arrayList6 = new ArrayList<SingleDiffNode>();
        ArrayList<SingleDiffNode> arrayList7 = new ArrayList<SingleDiffNode>();
        ArrayList<SingleDiffNode> arrayList8 = new ArrayList<SingleDiffNode>();
        for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
            boolean bl2 = set.contains(combinedDiffNode);
            SingleDiffNode singleDiffNode = combinedDiffNode.getPrimaryDiffNode();
            SingleDiffNode singleDiffNode2 = combinedDiffNode.getSecondaryDiffNode();
            SuperDiffNode superDiffNode = combinedDiffNode.getSuperDiffNode();
            ArrayList<SuperDiffNode> arrayList9 = bl2 ? arrayList3 : arrayList4;
            ArrayList<CombinedDiffNode> arrayList10 = bl2 ? arrayList : arrayList2;
            ArrayList<SingleDiffNode> arrayList11 = bl2 ? arrayList5 : arrayList6;
            ArrayList<SingleDiffNode> arrayList12 = bl2 ? arrayList7 : arrayList8;
            arrayList10.add(combinedDiffNode);
            arrayList9.add(superDiffNode);
            if (singleDiffNode != null) {
                arrayList11.add(singleDiffNode);
            }
            if (singleDiffNode2 == null) continue;
            arrayList12.add(singleDiffNode2);
        }
        combinedGraph.selectNodes(arrayList, arrayList2);
        GraphSelectionUpdater.selectRawEdges(combinedGraph);
        GraphSelectionUpdater.selectRawGraph(combinedGraph.getSuperGraph(), arrayList3, arrayList4);
        GraphSelectionUpdater.selectRawGraph(combinedGraph.getPrimaryGraph(), arrayList5, arrayList6);
        GraphSelectionUpdater.selectRawGraph(combinedGraph.getSecondaryGraph(), arrayList7, arrayList8);
        GraphSelectionUpdater.updateAllGraphViews(combinedGraph);
    }

    private static void synchronizeNodesSelection(SingleGraph singleGraph, Set<SingleDiffNode> set) {
        ESide eSide = singleGraph.getSide();
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        ArrayList<CombinedDiffNode> arrayList2 = new ArrayList<CombinedDiffNode>();
        ArrayList<SuperDiffNode> arrayList3 = new ArrayList<SuperDiffNode>();
        ArrayList<SuperDiffNode> arrayList4 = new ArrayList<SuperDiffNode>();
        ArrayList<SingleDiffNode> arrayList5 = new ArrayList<SingleDiffNode>();
        ArrayList<SingleDiffNode> arrayList6 = new ArrayList<SingleDiffNode>();
        for (CombinedDiffNode combinedDiffNode : singleGraph.getCombinedGraph().getNodes()) {
            SingleDiffNode singleDiffNode = eSide == ESide.PRIMARY ? combinedDiffNode.getPrimaryDiffNode() : combinedDiffNode.getSecondaryDiffNode();
            SingleDiffNode singleDiffNode2 = eSide == ESide.SECONDARY ? combinedDiffNode.getPrimaryDiffNode() : combinedDiffNode.getSecondaryDiffNode();
            SuperDiffNode superDiffNode = combinedDiffNode.getSuperDiffNode();
            boolean bl2 = singleDiffNode == null && singleDiffNode2.isSelected() || singleDiffNode != null && set.contains(singleDiffNode);
            ArrayList<SuperDiffNode> arrayList7 = bl2 ? arrayList3 : arrayList4;
            ArrayList<CombinedDiffNode> arrayList8 = bl2 ? arrayList : arrayList2;
            ArrayList<SingleDiffNode> arrayList9 = bl2 ? arrayList5 : arrayList6;
            arrayList8.add(combinedDiffNode);
            arrayList7.add(superDiffNode);
            if (singleDiffNode2 == null) continue;
            arrayList9.add(singleDiffNode2);
        }
        GraphSelectionUpdater.selectRawGraph(singleGraph.getOtherSideGraph(), arrayList5, arrayList6);
        GraphSelectionUpdater.selectRawGraph(singleGraph.getCombinedGraph(), arrayList, arrayList2);
        GraphSelectionUpdater.selectRawGraph(singleGraph.getSuperGraph(), arrayList3, arrayList4);
        GraphSelectionUpdater.selectRawEdges(singleGraph);
        GraphSelectionUpdater.updateAllGraphViews(singleGraph);
    }

    private static void updateAllGraphViews(BinDiffGraph<?, ?> binDiffGraph) {
        binDiffGraph.getPrimaryGraph().getGraph().updateViews();
        binDiffGraph.getSecondaryGraph().getGraph().updateViews();
        binDiffGraph.getSuperGraph().getGraph().updateViews();
        binDiffGraph.getCombinedGraph().getGraph().updateViews();
    }

    private static boolean willChangeNodeVisibility(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, Set<ZyGraphNode<? extends IViewNode<?>>> set) {
        GraphProximityBrowsingSettings graphProximityBrowsingSettings = binDiffGraph.getSettings().getProximitySettings();
        if (graphProximityBrowsingSettings.getProximityBrowsing() && !graphProximityBrowsingSettings.getProximityBrowsingFrozen()) {
            int n2 = graphProximityBrowsingSettings.getProximityBrowsingChildren();
            int n3 = graphProximityBrowsingSettings.getProximityBrowsingParents();
            Set<ZyGraphNode<IViewNode<?>>> set2 = ProximityRangeCalculator.getNeighbors(binDiffGraph, set, n2, n3);
            for (ZyGraphNode<IViewNode<?>> zyGraphNode : binDiffGraph.getNodes()) {
                if (!(zyGraphNode.isVisible() ? !set.contains(zyGraphNode) && !set2.contains(zyGraphNode) : set.contains(zyGraphNode) || set2.contains(zyGraphNode))) continue;
                return true;
            }
        }
        return false;
    }

    public static void executeStatic(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        if (binDiffGraph.getSettings().isSync()) {
            if (binDiffGraph instanceof SingleGraph) {
                GraphSelectionUpdater.synchronizeNodesSelection((SingleGraph)binDiffGraph, ((SingleGraph)binDiffGraph).getSelectedNodes());
            } else if (binDiffGraph instanceof CombinedGraph) {
                GraphSelectionUpdater.synchronizeNodesSelection((CombinedGraph)binDiffGraph, ((CombinedGraph)binDiffGraph).getSelectedNodes());
            }
            GraphSelectionUpdater.updateAllGraphViews(binDiffGraph);
        } else {
            if (binDiffGraph instanceof CombinedGraph) {
                CombinedGraph combinedGraph = (CombinedGraph)binDiffGraph;
                Set<CombinedDiffNode> set = combinedGraph.getSelectedNodes();
                HashSet hashSet = new HashSet();
                hashSet.addAll(combinedGraph.getNodes());
                hashSet.removeAll(set);
                combinedGraph.selectNodes(set, hashSet);
            }
            GraphSelectionUpdater.selectRawEdges(binDiffGraph);
        }
        GraphsIntermediateListeners.notifyIntermediateSelectionListeners(binDiffGraph);
        if (LayoutCommandHelper.hasSelectedNodes(binDiffGraph) && GraphSelectionUpdater.willChangeNodeVisibility(binDiffGraph, binDiffGraph.getSelectedNodes()) && GraphSelectionUpdater.showVisibilityWarningDialog(binDiffGraph)) {
            ProximityBrowserUpdater.executeStatic(binDiffGraph);
            if (LayoutCommandHelper.isAutolayout(binDiffGraph) && !LayoutCommandHelper.isProximityBrowsingFrozen(binDiffGraph)) {
                GraphLayoutUpdater.executeStatic(binDiffGraph, true);
            }
        }
    }

    @Override
    public void execute() {
        GraphSelectionUpdater.executeStatic(this.referenceGraph);
    }
}

