/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutCalculator;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphViewUpdater;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CUnlimitedProgressDialog;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Window;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class GraphLayoutUpdater
implements ICommand {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> referenceGraph;
    private final boolean showProgress;

    public GraphLayoutUpdater(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph, boolean bl2) {
        this.referenceGraph = Preconditions.checkNotNull(binDiffGraph);
        this.showProgress = bl2;
    }

    private static Window getParentWindow(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph.getSettings().getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            return BinDiffGraph.getParentWindow(binDiffGraph.getPrimaryGraph());
        }
        return BinDiffGraph.getParentWindow(binDiffGraph.getCombinedGraph());
    }

    public static void executeStatic(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph, boolean bl2) {
        Object object;
        GraphLayoutCalculator graphLayoutCalculator = new GraphLayoutCalculator(binDiffGraph);
        Window window = GraphLayoutUpdater.getParentWindow(binDiffGraph.getPrimaryGraph());
        try {
            if (bl2) {
                object = new CUnlimitedProgressDialog(window, "BinDiff", "Calculating the new graph layout...", graphLayoutCalculator);
                ((CUnlimitedProgressDialog)object).setVisible(true);
                if (((CUnlimitedProgressDialog)object).wasCanceled()) {
                    return;
                }
                if (((CUnlimitedProgressDialog)object).getException() != null) {
                    throw ((CUnlimitedProgressDialog)object).getException();
                }
            } else {
                graphLayoutCalculator.execute();
            }
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Couldn't calculate graph layout.");
        }
        if (bl2) {
            SwingUtilities.invokeLater(new InternalGraphViewUpdater(graphLayoutCalculator, window));
        } else {
            object = new GraphViewUpdater(graphLayoutCalculator);
            ((GraphViewUpdater)object).execute();
        }
    }

    @Override
    public void execute() {
        GraphLayoutUpdater.executeStatic(this.referenceGraph, this.showProgress);
    }

    private static final class InternalGraphViewUpdater
    implements Runnable {
        private final GraphLayoutCalculator layoutCalculator;
        private final Window window;

        public InternalGraphViewUpdater(GraphLayoutCalculator graphLayoutCalculator, Window window) {
            this.layoutCalculator = graphLayoutCalculator;
            this.window = window;
        }

        @Override
        public void run() {
            try {
                GraphViewUpdater graphViewUpdater = new GraphViewUpdater(this.layoutCalculator);
                graphViewUpdater.execute();
            }
            catch (GraphLayoutException graphLayoutException) {
                CMessageBox.showWarning(this.window, "Couldn't update graph layout.");
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log("Couldn't update graph layout");
            }
        }
    }
}

