/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserInitializer;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class GraphLayoutInitializer
implements ICommand {
    private final BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> graph;

    public GraphLayoutInitializer(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        Preconditions.checkNotNull(binDiffGraph);
        this.graph = binDiffGraph;
    }

    public static void executeStatic(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        GraphLayoutSettings graphLayoutSettings = binDiffGraph.getSettings().getLayoutSettings();
        boolean bl2 = graphLayoutSettings.getAnimateLayout();
        graphLayoutSettings.setAnimateLayout(false);
        try {
            ProximityBrowserInitializer.executeStatic(binDiffGraph);
            if (LayoutCommandHelper.isAutolayout(binDiffGraph)) {
                GraphLayoutUpdater.executeStatic(binDiffGraph, false);
            }
        }
        finally {
            graphLayoutSettings.setAnimateLayout(bl2);
        }
    }

    @Override
    public void execute() {
        GraphLayoutInitializer.executeStatic(this.graph);
    }
}

