/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import a.c.d;
import a.c.e;
import a.c.p;
import a.f.B;
import a.f.F;
import a.f.P;
import a.f.a.b;
import a.f.ae;
import a.f.c;
import a.f.d.r;
import a.f.o;
import a.h.U;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperDiffEdge;
import com.google.security.zynamics.bindiff.graph.helpers.GraphViewFitter;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCreator;
import com.google.security.zynamics.bindiff.graph.layout.util.CustomizedPCListOptimizer;
import com.google.security.zynamics.bindiff.graph.layout.util.PortConstraints;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.zylib.types.common.ICancelableCommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ProximityHelper;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.layouters.ZyGraphLayouter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class GraphLayoutCalculator
implements ICancelableCommand {
    private final BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> referenceGraph;
    private F primaryLayout = new o();
    private F secondaryLayout = new o();
    private F combinedLayout = null;
    private InternalLayoutThread superLayoutThread = null;
    private InternalLayoutThread combinedLayoutThread = null;
    private CountDownLatch doneLatch;
    private volatile boolean canceled;

    public GraphLayoutCalculator(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        Preconditions.checkNotNull(binDiffGraph);
        Preconditions.checkArgument(!(binDiffGraph instanceof SuperGraph), "Reference graph cannot be a super graph");
        this.referenceGraph = binDiffGraph;
    }

    private static void addSuperProxiEdgesToMaps(SuperGraph superGraph, Map<d, d> map, Map<d, d> map2) {
        U u2 = superGraph.getGraph();
        block0: for (d d2 : u2.as()) {
            e e2;
            Object object;
            Object object2;
            boolean bl2;
            if (!ProximityHelper.isProximityEdge(superGraph.getGraph(), d2)) continue;
            p p2 = d2.U();
            p p3 = d2.V();
            SuperDiffNode superDiffNode = (SuperDiffNode)superGraph.getNode(p2);
            boolean bl3 = bl2 = superDiffNode == null;
            if (bl2) {
                superDiffNode = (SuperDiffNode)superGraph.getNode(d2.V());
            }
            if (!ProximityHelper.isProximityNode(superGraph.getGraph(), bl2 ? p2 : p3)) continue;
            SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
            if (singleDiffNode != null) {
                object2 = singleDiffNode.getNode();
                Object object3 = object = bl2 ? ((p)object2).aP() : ((p)object2).aQ();
                while (object.J()) {
                    if (ProximityHelper.isProximityEdge(superGraph.getPrimaryGraph().getGraph(), object.ac())) {
                        map.put(d2, object.ac());
                        break;
                    }
                    object.next();
                }
            }
            if ((object2 = superDiffNode.getSecondaryDiffNode()) == null) continue;
            object = ((ZyGraphNode)object2).getNode();
            e e3 = e2 = bl2 ? ((p)object).aP() : ((p)object).aQ();
            while (e2.J()) {
                if (ProximityHelper.isProximityEdge(superGraph.getSecondaryGraph().getGraph(), e2.ac())) {
                    map2.put(d2, e2.ac());
                    continue block0;
                }
                e2.next();
            }
        }
    }

    private static void addSuperProxiNodesToMaps(SuperGraph superGraph, Map<p, p> map, Map<p, p> map2) {
        U u2 = superGraph.getGraph();
        block0: for (p p2 : u2.ar()) {
            p p3;
            e e2;
            p p4;
            if (superGraph.getNode(p2) != null || p2.aI() != 1) continue;
            p p5 = p2.aR().aU();
            SuperDiffNode superDiffNode = (SuperDiffNode)superGraph.getNode(p5);
            SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
            SingleDiffNode singleDiffNode2 = superDiffNode.getSecondaryDiffNode();
            if (p2.aK() == 1) {
                if (singleDiffNode != null) {
                    p4 = singleDiffNode.getNode();
                    e2 = p4.aP();
                    while (e2.J()) {
                        if (ProximityHelper.isProximityEdge(superGraph.getPrimaryGraph().getGraph(), e2.ac())) {
                            p3 = e2.ac().U();
                            map.put(p2, p3);
                            break;
                        }
                        e2.next();
                    }
                }
                if (singleDiffNode2 == null) continue;
                p4 = singleDiffNode2.getNode();
                e2 = p4.aP();
                while (e2.J()) {
                    if (ProximityHelper.isProximityEdge(superGraph.getSecondaryGraph().getGraph(), e2.ac())) {
                        p3 = e2.ac().U();
                        map2.put(p2, p3);
                        continue block0;
                    }
                    e2.next();
                }
                continue;
            }
            if (p2.aJ() != 1) continue;
            if (singleDiffNode != null) {
                p4 = singleDiffNode.getNode();
                e2 = p4.aQ();
                while (e2.J()) {
                    if (ProximityHelper.isProximityEdge(superGraph.getPrimaryGraph().getGraph(), e2.ac())) {
                        p3 = e2.ac().V();
                        map.put(p2, p3);
                        break;
                    }
                    e2.next();
                }
            }
            if (singleDiffNode2 == null) continue;
            p4 = singleDiffNode2.getNode();
            e2 = p4.aQ();
            while (e2.J()) {
                if (ProximityHelper.isProximityEdge(superGraph.getSecondaryGraph().getGraph(), e2.ac())) {
                    p3 = e2.ac().V();
                    map2.put(p2, p3);
                    continue block0;
                }
                e2.next();
            }
        }
    }

    private static void createSuperEdgeMaps(SuperGraph superGraph, Map<d, d> map, Map<d, d> map2) {
        for (SuperDiffEdge superDiffEdge : superGraph.getEdges()) {
            d d2;
            SingleDiffEdge singleDiffEdge = superDiffEdge.getPrimaryDiffEdge();
            SingleDiffEdge singleDiffEdge2 = superDiffEdge.getSecondaryDiffEdge();
            if (singleDiffEdge != null && superDiffEdge.isVisible()) {
                d2 = singleDiffEdge.getEdge();
                map.put(superDiffEdge.getEdge(), d2);
            }
            if (singleDiffEdge2 == null || !superDiffEdge.isVisible()) continue;
            d2 = singleDiffEdge2.getEdge();
            map2.put(superDiffEdge.getEdge(), d2);
        }
        GraphLayoutCalculator.addSuperProxiEdgesToMaps(superGraph, map, map2);
    }

    private static void createSuperNodeMaps(SuperGraph superGraph, Map<p, p> map, Map<p, p> map2) {
        for (SuperDiffNode superDiffNode : superGraph.getNodes()) {
            p p2;
            SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
            SingleDiffNode singleDiffNode2 = superDiffNode.getSecondaryDiffNode();
            if (singleDiffNode != null && superDiffNode.isVisible()) {
                p2 = singleDiffNode.getNode();
                map.put(superDiffNode.getNode(), p2);
            }
            if (singleDiffNode2 == null || !superDiffNode.isVisible()) continue;
            p2 = singleDiffNode2.getNode();
            map2.put(superDiffNode.getNode(), p2);
        }
        GraphLayoutCalculator.addSuperProxiNodesToMaps(superGraph, map, map2);
    }

    private void adoptSuperGraphLayout(F f2) {
        Object object;
        SuperGraph superGraph = this.referenceGraph.getSuperGraph();
        HashMap<p, p> hashMap = new HashMap<p, p>();
        HashMap<p, p> hashMap2 = new HashMap<p, p>();
        GraphLayoutCalculator.createSuperNodeMaps(superGraph, hashMap, hashMap2);
        for (p p2 : this.referenceGraph.getSuperGraph().getGraph().ar()) {
            ae ae2 = f2.w(p2);
            p x2 = (p)hashMap.get(p2);
            object = (p)hashMap2.get(p2);
            if (x2 != null) {
                ((o)this.primaryLayout).a((Object)x2, ae2);
            }
            if (object == null) continue;
            ((o)this.secondaryLayout).a(object, ae2);
        }
        hashMap.clear();
        hashMap2.clear();
        HashMap hashMap3 = new HashMap();
        HashMap<d, d> hashMap4 = new HashMap<d, d>();
        GraphLayoutCalculator.createSuperEdgeMaps(superGraph, hashMap3, hashMap4);
        for (d d2 : superGraph.getGraph().as()) {
            object = f2.x(d2);
            d d3 = (d)hashMap3.get(d2);
            d d4 = (d)hashMap4.get(d2);
            if (d3 != null) {
                ((o)this.primaryLayout).a((Object)d3, (B)object);
            }
            if (d4 == null) continue;
            ((o)this.secondaryLayout).a((Object)d4, (B)object);
        }
    }

    private void cancelLayoutCalculation() {
        if (this.superLayoutThread != null && this.superLayoutThread.isAlive()) {
            this.superLayoutThread.stop();
            this.superLayoutThread = null;
            this.doneLatch.countDown();
        }
        if (this.combinedLayoutThread != null && this.combinedLayoutThread.isAlive()) {
            this.combinedLayoutThread.stop();
            this.combinedLayoutThread = null;
            this.doneLatch.countDown();
        }
        this.setCanceled();
    }

    private c createSecondThreadLayouter(c c2, GraphLayoutSettings graphLayoutSettings) {
        if (c2 instanceof b) {
            return LayoutCreator.getCircularLayout(graphLayoutSettings);
        }
        if (c2 instanceof r || c2 instanceof a.f.d.p) {
            return LayoutCreator.getHierarchicalLayout(graphLayoutSettings);
        }
        if (c2 instanceof a.f.g.d) {
            return LayoutCreator.getOrthogonalLayout(graphLayoutSettings);
        }
        throw new IllegalStateException("Unsupported graph layout style.");
    }

    private synchronized void setCanceled() {
        this.canceled = true;
    }

    @Override
    public void cancel() {
        this.cancelLayoutCalculation();
    }

    @Override
    public void execute() {
        try {
            GraphSettings graphSettings = this.referenceGraph.getSettings();
            if (graphSettings.isSync()) {
                Object object;
                SuperGraph superGraph = this.referenceGraph.getSuperGraph();
                CombinedGraph combinedGraph = this.referenceGraph.getCombinedGraph();
                c c2 = graphSettings.getLayoutSettings().getCurrentLayouter();
                c c3 = this.createSecondThreadLayouter(c2, graphSettings.getLayoutSettings());
                if (c3 instanceof r) {
                    object = (r)c3;
                    ((r)object).S(false);
                    ((c)object).i(false);
                    CustomizedPCListOptimizer customizedPCListOptimizer = new CustomizedPCListOptimizer();
                    customizedPCListOptimizer.setBackloopRouting(true);
                    ((r)object).iw().a(customizedPCListOptimizer);
                }
                ZyGraphLayouter.alignNodesToTopLayer(superGraph.getGraph(), c2);
                ZyGraphLayouter.alignNodesToTopLayer(combinedGraph.getGraph(), c3);
                this.doneLatch = new CountDownLatch(2);
                this.superLayoutThread = new InternalLayoutThread(superGraph, c2);
                this.combinedLayoutThread = new InternalLayoutThread(combinedGraph, c3);
                this.superLayoutThread.start();
                this.combinedLayoutThread.start();
                this.doneLatch.await();
                if (this.superLayoutThread != null && this.combinedLayoutThread != null) {
                    if (this.superLayoutThread.getException() != null) {
                        throw this.superLayoutThread.getException();
                    }
                    if (this.combinedLayoutThread.getException() != null) {
                        throw this.combinedLayoutThread.getException();
                    }
                    this.combinedLayout = this.combinedLayoutThread.getGraphLayout();
                    object = this.superLayoutThread.getGraphLayout();
                    a.f.U.a((P)superGraph.getGraph(), (F)object);
                    GraphViewFitter.adoptSuperViewCanvasProperties(superGraph);
                    this.adoptSuperGraphLayout((F)object);
                }
            } else if (this.referenceGraph instanceof SingleGraph) {
                if (((SingleGraph)this.referenceGraph).getSide() == ESide.PRIMARY) {
                    this.primaryLayout = this.referenceGraph.calculateLayout();
                } else {
                    this.secondaryLayout = this.referenceGraph.calculateLayout();
                }
            } else if (this.referenceGraph instanceof CombinedGraph) {
                this.combinedLayout = this.referenceGraph.calculateLayout();
            }
        }
        catch (GraphLayoutException graphLayoutException) {
            throw graphLayoutException;
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Could not calculate graph layouts.");
        }
    }

    public F getCombinedGraphLayout() {
        return this.combinedLayout;
    }

    public F getPrimaryGraphLayout() {
        return this.primaryLayout;
    }

    public BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> getReferenceGraph() {
        return this.referenceGraph;
    }

    public F getSecondaryGraphLayout() {
        return this.secondaryLayout;
    }

    @Override
    public synchronized boolean wasCanceled() {
        return this.canceled;
    }

    private class InternalLayoutThread
    extends Thread {
        private final BinDiffGraph<?, ?> graph;
        private final c layouter;
        private F graphLayout = null;
        private GraphLayoutException exception = null;

        protected InternalLayoutThread(BinDiffGraph<?, ?> binDiffGraph, c c2) {
            this.graph = binDiffGraph;
            this.layouter = c2;
        }

        protected GraphLayoutException getException() {
            return this.exception;
        }

        protected F getGraphLayout() {
            return this.graphLayout;
        }

        @Override
        public void run() {
            try {
                if (this.graph instanceof CombinedGraph) {
                    PortConstraints.configureConstraints((CombinedGraph)this.graph);
                }
                this.graphLayout = this.graph.calculateLayout(this.layouter);
            }
            catch (GraphLayoutException graphLayoutException) {
                this.exception = graphLayoutException;
            }
            finally {
                GraphLayoutCalculator.this.doneLatch.countDown();
            }
        }
    }
}

