/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.labelcontent.lineeditor;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EPlaceholderType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.builders.ViewCodeNodeBuilder;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.BasicBlockLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.PlaceholderObject;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.helpers.MatchesGetter;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyLineEditor;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.strings.StringHelper;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.List;

public class BasicBlockContentEditor
implements IZyLineEditor {
    private static final int NODELABEL_PADDING = 10;
    private final GraphsContainer graphContainer;
    private final FunctionMatchData functionMatch;
    private final ESide side;

    public BasicBlockContentEditor(FunctionMatchData functionMatchData, GraphsContainer graphsContainer, ESide eSide) {
        this.functionMatch = functionMatchData;
        this.graphContainer = Preconditions.checkNotNull(graphsContainer);
        this.side = Preconditions.checkNotNull(eSide);
    }

    private int preCountLabelCommentLines(RawBasicBlock rawBasicBlock, ESide eSide) {
        int n2 = 0;
        if (eSide == rawBasicBlock.getSide()) {
            if (!rawBasicBlock.getComment().isEmpty()) {
                n2 = StringHelper.count(rawBasicBlock.getComment(), '\n') + 1;
            }
        } else {
            RawBasicBlock rawBasicBlock2;
            SingleDiffNode singleDiffNode = null;
            singleDiffNode = eSide == ESide.PRIMARY ? GraphGetter.getPrimaryDiffNode(this.graphContainer.getSecondaryGraph(), rawBasicBlock) : GraphGetter.getSecondaryDiffNode(this.graphContainer.getPrimaryGraph(), rawBasicBlock);
            if (singleDiffNode != null && !(rawBasicBlock2 = (RawBasicBlock)singleDiffNode.getRawNode()).getComment().isEmpty()) {
                n2 = StringHelper.count(rawBasicBlock2.getComment(), '\n') + 1;
            }
        }
        return n2;
    }

    private void recreateInstruction(ZyLabelContent zyLabelContent, RawInstruction rawInstruction, int n2, int n3, int n4) {
        int n5;
        RawBasicBlock rawBasicBlock = ((BasicBlockLineObject)zyLabelContent.getModel()).getRawBasicblock();
        int n6 = rawBasicBlock.getMaxOperandLength();
        int n7 = zyLabelContent.getLastLineIndexOfModelAt(n2);
        for (n5 = n2; n5 <= n7; ++n5) {
            zyLabelContent.removeLine(n2);
        }
        n5 = 0;
        if (this.functionMatch != null && rawInstruction != null) {
            n5 = MatchesGetter.isMatchedInstruction(this.functionMatch, rawBasicBlock, rawInstruction) ? 1 : 0;
        }
        List<ZyLineContent> list = ViewCodeNodeBuilder.buildInstruction(rawInstruction, n6, n5 == 0, this.side, n3, n4);
        int n8 = n2;
        for (ZyLineContent zyLineContent : list) {
            zyLabelContent.insertLine(zyLineContent, n8++);
        }
    }

    private void recreateInstructionSynchronized(ZyLabelContent zyLabelContent, RawInstruction rawInstruction, int n2) {
        Object object;
        Object object2;
        BasicBlockMatchData basicBlockMatchData;
        RawBasicBlock rawBasicBlock;
        RawBasicBlock rawBasicBlock2 = ((BasicBlockLineObject)zyLabelContent.getModel()).getRawBasicblock();
        ESide eSide = rawBasicBlock2.getSide();
        RawInstruction rawInstruction2 = null;
        RawInstruction rawInstruction3 = null;
        if (rawBasicBlock2.getSide() == ESide.PRIMARY) {
            rawInstruction2 = rawInstruction;
            rawInstruction3 = null;
            rawBasicBlock = GraphGetter.getSecondaryRawBasicblock(this.graphContainer, rawBasicBlock2);
            basicBlockMatchData = MatchesGetter.getBasicBlockMatch(this.functionMatch, rawBasicBlock2);
            if (basicBlockMatchData != null) {
                object2 = basicBlockMatchData.getSecondaryInstructionAddr(rawInstruction2.getAddress());
                rawInstruction3 = rawBasicBlock.getInstruction((IAddress)object2);
            }
        } else {
            rawInstruction2 = null;
            rawInstruction3 = rawInstruction;
            rawBasicBlock = GraphGetter.getPrimaryRawBasicblock(this.graphContainer, rawBasicBlock2);
            basicBlockMatchData = MatchesGetter.getBasicBlockMatch(this.functionMatch, rawBasicBlock2);
            if (basicBlockMatchData != null) {
                object2 = basicBlockMatchData.getPrimaryInstructionAddr(rawInstruction3.getAddress());
                rawInstruction2 = rawBasicBlock.getInstruction((IAddress)object2);
            }
        }
        int n3 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction3, ECommentPlacement.ABOVE_LINE);
        int n4 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction3, ECommentPlacement.BEHIND_LINE);
        zyLabelContent.setRightPadding(10);
        this.recreateInstruction(zyLabelContent, rawInstruction, n2, n3, n4);
        object2 = null;
        object2 = eSide == ESide.PRIMARY ? GraphGetter.getSecondaryDiffNode(this.graphContainer.getPrimaryGraph(), rawBasicBlock2) : GraphGetter.getPrimaryDiffNode(this.graphContainer.getSecondaryGraph(), rawBasicBlock2);
        if (object2 != null) {
            object = ((ZyGraphNode)object2).getRealizer().getNodeContent();
            ((ZyLabelContent)object).setRightPadding(10);
            this.recreateInstruction((ZyLabelContent)object, eSide == ESide.PRIMARY ? rawInstruction3 : rawInstruction2, n2, n3, n4);
            double d2 = zyLabelContent.getBounds().getWidth();
            double d3 = ((ZyLabelContent)object).getBounds().getWidth();
            if (d2 > d3) {
                ((ZyLabelContent)object).setRightPadding((int)Math.round(d2 - d3) + 10);
            } else {
                zyLabelContent.setRightPadding((int)Math.round(d3 - d2) + 10);
            }
            ((ZyGraphNode)object2).getRealizer().regenerate();
        }
        object = GraphGetter.getDiffNode(this.graphContainer, rawBasicBlock2);
        ((ZyGraphNode)object).getRealizer().regenerate();
        this.graphContainer.getSuperGraph().refreshSuperNodeSize(this.graphContainer.getPrimaryGraph(), this.graphContainer.getSecondaryGraph(), ((SingleDiffNode)object).getSuperDiffNode());
        this.graphContainer.updateViews();
    }

    private void recreateLabelComment(ZyLabelContent zyLabelContent, RawBasicBlock rawBasicBlock, int n2) {
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        int n3 = zyLabelContent.getLineCount();
        arrayList.addAll(ViewCodeNodeBuilder.buildBasicblockComment(rawBasicBlock, n2));
        int n4 = n3;
        while (--n4 > 0) {
            ZyLineContent zyLineContent = zyLabelContent.getLineContent(n4);
            IZyEditableObject object = zyLineContent.getLineObject();
            if (object.isPlaceholder()) {
                if (((PlaceholderObject)object).getPlaceholderType() != EPlaceholderType.BASICBLOCK_COMMENT) break;
                zyLabelContent.removeLine(n4);
                continue;
            }
            if (!(object.getPersistentModel() instanceof RawBasicBlock)) break;
            zyLabelContent.removeLine(n4);
        }
        for (ZyLineContent zyLineContent : arrayList) {
            zyLabelContent.addLineContent(zyLineContent);
        }
    }

    private void recreateLabelCommentSynchronized(ZyLabelContent zyLabelContent, RawBasicBlock rawBasicBlock) {
        Object object;
        ESide eSide = rawBasicBlock.getSide();
        int n2 = this.preCountLabelCommentLines(rawBasicBlock, eSide);
        int n3 = this.preCountLabelCommentLines(rawBasicBlock, eSide == ESide.PRIMARY ? ESide.SECONDARY : ESide.PRIMARY);
        int n4 = Math.max(n2, n3);
        zyLabelContent.setRightPadding(10);
        this.recreateLabelComment(zyLabelContent, rawBasicBlock, n4);
        SingleDiffNode singleDiffNode = null;
        RawBasicBlock rawBasicBlock2 = null;
        if (eSide == ESide.PRIMARY) {
            singleDiffNode = GraphGetter.getSecondaryDiffNode(this.graphContainer.getPrimaryGraph(), rawBasicBlock);
            rawBasicBlock2 = GraphGetter.getSecondaryRawBasicblock(this.graphContainer, rawBasicBlock);
        } else {
            singleDiffNode = GraphGetter.getPrimaryDiffNode(this.graphContainer.getSecondaryGraph(), rawBasicBlock);
            rawBasicBlock2 = GraphGetter.getPrimaryRawBasicblock(this.graphContainer, rawBasicBlock);
        }
        if (rawBasicBlock2 != null) {
            object = singleDiffNode.getRealizer().getNodeContent();
            ((ZyLabelContent)object).setRightPadding(10);
            this.recreateLabelComment((ZyLabelContent)object, rawBasicBlock2, n4);
            double d2 = zyLabelContent.getBounds().getWidth();
            double d3 = ((ZyLabelContent)object).getBounds().getWidth();
            if (d2 > d3) {
                ((ZyLabelContent)object).setRightPadding((int)Math.round(d2 - d3) + 10);
            } else {
                zyLabelContent.setRightPadding((int)Math.round(d3 - d2) + 10);
            }
            singleDiffNode.getRealizer().regenerate();
        }
        object = GraphGetter.getDiffNode(this.graphContainer, rawBasicBlock);
        ((ZyGraphNode)object).getRealizer().regenerate();
        this.graphContainer.getSuperGraph().refreshSuperNodeSize(this.graphContainer.getPrimaryGraph(), this.graphContainer.getSecondaryGraph(), ((SingleDiffNode)object).getSuperDiffNode());
        this.graphContainer.updateViews();
    }

    private boolean validateLineCountEquality(ZyLabelContent zyLabelContent, RawBasicBlock rawBasicBlock) {
        RawBasicBlock rawBasicBlock2;
        SingleDiffNode singleDiffNode;
        ESide eSide = rawBasicBlock.getSide();
        if (eSide == ESide.PRIMARY) {
            singleDiffNode = GraphGetter.getSecondaryDiffNode(this.graphContainer.getPrimaryGraph(), rawBasicBlock);
            rawBasicBlock2 = GraphGetter.getSecondaryRawBasicblock(this.graphContainer, rawBasicBlock);
        } else {
            singleDiffNode = GraphGetter.getPrimaryDiffNode(this.graphContainer.getSecondaryGraph(), rawBasicBlock);
            rawBasicBlock2 = GraphGetter.getPrimaryRawBasicblock(this.graphContainer, rawBasicBlock);
        }
        if (rawBasicBlock2 != null) {
            ZyLabelContent zyLabelContent2 = singleDiffNode.getRealizer().getNodeContent();
            return zyLabelContent.getLineCount() == zyLabelContent2.getLineCount();
        }
        return true;
    }

    @Override
    public void recreateLabelLines(ZyLabelContent zyLabelContent, Object object) {
        int n2 = 0;
        for (ZyLineContent zyLineContent : zyLabelContent.getContent()) {
            IZyEditableObject iZyEditableObject = zyLineContent.getLineObject();
            if (iZyEditableObject != null && iZyEditableObject.getPersistentModel() == object) {
                if (object instanceof RawBasicBlock) {
                    this.recreateLabelCommentSynchronized(zyLabelContent, (RawBasicBlock)object);
                    return;
                }
                if (object instanceof RawInstruction) {
                    n2 = zyLabelContent.getFirstLineIndexOfModelAt(n2);
                    this.recreateInstructionSynchronized(zyLabelContent, (RawInstruction)object, n2);
                    if (!this.validateLineCountEquality(zyLabelContent, ((BasicBlockLineObject)zyLabelContent.getModel()).getRawBasicblock())) {
                        throw new RuntimeException("Pimary and secondary basicblock label content line count are not equal.");
                    }
                }
            }
            ++n2;
        }
        if (object instanceof RawBasicBlock) {
            this.recreateLabelCommentSynchronized(zyLabelContent, (RawBasicBlock)object);
            if (!this.validateLineCountEquality(zyLabelContent, ((BasicBlockLineObject)zyLabelContent.getModel()).getRawBasicblock())) {
                throw new RuntimeException("Pimary and secondary basicblock label content line count are not equal.");
            }
        }
    }

    @Override
    public void refreshSize(ZyLabelContent zyLabelContent, Object object) {
        RawBasicBlock rawBasicBlock = null;
        if (object instanceof RawBasicBlock) {
            rawBasicBlock = (RawBasicBlock)object;
        } else if (object instanceof RawInstruction) {
            rawBasicBlock = ((BasicBlockLineObject)zyLabelContent.getModel()).getRawBasicblock();
        } else {
            return;
        }
        SingleDiffNode singleDiffNode = GraphGetter.getDiffNode(this.graphContainer, rawBasicBlock);
        this.graphContainer.getSuperGraph().refreshSuperNodeSize(this.graphContainer.getPrimaryGraph(), this.graphContainer.getPrimaryGraph(), singleDiffNode.getSuperDiffNode());
    }
}

