/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.helpers;

import a.h.ar;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.eventhandlers.GraphLayoutEventHandler;
import com.google.security.zynamics.bindiff.graph.helpers.GraphAnimator;
import com.google.security.zynamics.bindiff.graph.helpers.GraphViewFitter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ZoomHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;

public class GraphZoomer {
    public static final double ZOOM_OUT_FACTOR = 0.95;

    private static void fitContent(ar ar2) {
        ar2.fitContent();
        ar2.setZoom(ar2.getZoom() * 0.95);
    }

    private static void zoomToArea(BinDiffGraph<?, ?> binDiffGraph, Rectangle2D rectangle2D) {
        ar ar2 = binDiffGraph.getView();
        double d2 = ar2.getZoom();
        Point2D point2D = ar2.getCenter();
        ar2.zoomToArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        ar2.setZoom(ar2.getZoom() * 0.95);
        ZoomHelpers.keepZoomValid(ar2);
        double d3 = ar2.getZoom();
        Point2D.Double double_ = new Point2D.Double(ar2.getCenter().getX(), ar2.getCenter().getY());
        ar2.setZoom(d2);
        ar2.setCenter(point2D.getX(), point2D.getY());
        GraphAnimator.zoomGraph(binDiffGraph, double_, d3);
        ar2.getGraph2D().updateViews();
    }

    private static void zoomToArea(SuperGraph superGraph, Rectangle2D rectangle2D, Collection<SuperDiffNode> collection) {
        GraphViewFitter.adoptSuperViewCanvasProperties(superGraph);
        ar ar2 = superGraph.getPrimaryGraph().getView();
        ar ar3 = superGraph.getSecondaryGraph().getView();
        double d2 = ar2.getZoom();
        Point2D point2D = ar2.getViewPoint2D();
        ar2.zoomToArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        ar2.setZoom(ar2.getZoom() * 0.95);
        ZoomHelpers.keepZoomValid(ar2);
        double d3 = ar2.getZoom();
        ar2.setZoom(d2);
        ar2.setViewPoint2D(point2D.getX(), point2D.getY());
        double d4 = ar3.getZoom();
        Point2D point2D2 = ar3.getViewPoint2D();
        ar3.zoomToArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        ar3.setZoom(ar3.getZoom() * 0.95);
        ZoomHelpers.keepZoomValid(ar3);
        double d5 = ar3.getZoom();
        ar3.setZoom(d4);
        ar3.setViewPoint2D(point2D2.getX(), point2D2.getY());
        GraphAnimator.zoomGraph(superGraph, rectangle2D, d3, d5);
        ar2.getGraph2D().updateViews();
        ar3.getGraph2D().updateViews();
    }

    private static void zoomToNodes(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, Collection<ZyGraphNode<?>> collection) {
        if (collection.size() == 0) {
            return;
        }
        Rectangle2D rectangle2D = GraphHelpers.calculateBoundingBox(collection);
        GraphZoomer.zoomToArea(binDiffGraph, rectangle2D);
    }

    public static void fitContent(BinDiffGraph<?, ?> binDiffGraph) {
        GraphZoomer.fitContent(binDiffGraph.getView());
        binDiffGraph.getGraph().updateViews();
    }

    public static void fitContent(SuperGraph superGraph) {
        GraphSettings graphSettings = superGraph.getSettings();
        if (graphSettings.isSync()) {
            superGraph.getView().fitContent();
            GraphViewFitter.adoptSuperViewCanvasProperties(superGraph);
            GraphViewFitter.fitSingleViewToSuperViewContent(superGraph);
        } else if (graphSettings.getFocus() == ESide.PRIMARY) {
            GraphZoomer.fitContent(superGraph.getPrimaryGraph().getView());
        } else {
            GraphZoomer.fitContent(superGraph.getSecondaryGraph().getView());
        }
        superGraph.getPrimaryGraph().getGraph().updateViews();
        superGraph.getSecondaryGraph().getGraph().updateViews();
    }

    public static void zoomToNode(BinDiffGraph<?, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        Preconditions.checkNotNull(binDiffGraph);
        Preconditions.checkNotNull(zyGraphNode);
        if (!zyGraphNode.isVisible()) {
            GraphLayoutEventHandler.handleUnhideInvisibleNode(binDiffGraph, zyGraphNode);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(zyGraphNode);
        SwingUtilities.invokeLater(() -> GraphZoomer.zoomToNodes(binDiffGraph, arrayList));
    }

    public static void zoomToNodes(CombinedGraph combinedGraph, Collection<CombinedDiffNode> collection) {
        Preconditions.checkNotNull(combinedGraph);
        Preconditions.checkNotNull(collection);
        for (CombinedDiffNode combinedDiffNode : collection) {
            if (combinedDiffNode.isVisible()) continue;
            throw new IllegalArgumentException("This function does not handle invisible nodes. Each node must be visible.");
        }
        if (collection.size() == 0) {
            return;
        }
        Rectangle2D rectangle2D = GraphHelpers.calculateBoundingBox(collection);
        GraphZoomer.zoomToArea(combinedGraph, rectangle2D);
    }

    public static void zoomToNodes(SuperGraph superGraph, Collection<SuperDiffNode> collection) {
        Preconditions.checkNotNull(superGraph);
        Preconditions.checkNotNull(collection);
        for (SuperDiffNode superDiffNode : collection) {
            if (superDiffNode.isVisible()) continue;
            throw new IllegalArgumentException("This function does not handle invisible nodes. Each node must be visible.");
        }
        if (collection.size() == 0) {
            return;
        }
        GraphViewFitter.adoptSuperViewCanvasProperties(superGraph);
        Rectangle2D rectangle2D = GraphHelpers.calculateBoundingBox(collection);
        if (superGraph.getSettings().isSync()) {
            GraphZoomer.zoomToArea(superGraph, rectangle2D, collection);
        } else if (superGraph.getSettings().getFocus() == ESide.PRIMARY) {
            GraphZoomer.zoomToArea(superGraph.getPrimaryGraph(), rectangle2D);
        } else {
            GraphZoomer.zoomToArea(superGraph.getSecondaryGraph(), rectangle2D);
        }
        superGraph.getPrimaryGraph().getGraph().updateViews();
        superGraph.getSecondaryGraph().getGraph().updateViews();
    }
}

