/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.helpers;

import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphSelector {
    private static <NodeType extends ZyGraphNode<?>> void deselectNodes(BinDiffGraph<NodeType, ?> binDiffGraph, Collection<NodeType> collection) {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        HashSet<NodeType> hashSet2 = new HashSet<NodeType>();
        hashSet.addAll(binDiffGraph.getSelectedNodes());
        boolean bl2 = binDiffGraph.getSettings().getProximitySettings().getProximityBrowsing() && binDiffGraph.getSettings().getProximitySettings().getProximityBrowsingFrozen();
        for (ZyGraphNode zyGraphNode : collection) {
            if (!zyGraphNode.isVisible() && bl2) continue;
            hashSet.remove(zyGraphNode);
        }
        hashSet2.addAll(binDiffGraph.getNodes());
        hashSet2.removeAll(hashSet);
        binDiffGraph.selectNodes(hashSet, hashSet2);
    }

    private static Set<CombinedDiffNode> getSelectedLeafNodes(CombinedGraph combinedGraph) {
        HashSet<CombinedDiffNode> hashSet = new HashSet<CombinedDiffNode>();
        for (CombinedDiffNode combinedDiffNode : combinedGraph.getSelectedNodes()) {
            boolean bl2 = false;
            for (CombinedViewNode combinedViewNode : GraphAlgorithms.getSuccessors(combinedDiffNode.getRawNode(), 1)) {
                if (!combinedViewNode.isSelected()) continue;
                bl2 = true;
            }
            if (bl2) continue;
            hashSet.add(combinedDiffNode);
        }
        return hashSet;
    }

    private static Collection<SingleDiffNode> getSelectedLeafNodes(SingleGraph singleGraph) {
        HashSet<SingleDiffNode> hashSet = new HashSet<SingleDiffNode>();
        for (SingleDiffNode singleDiffNode : singleGraph.getSelectedNodes()) {
            boolean bl2 = false;
            for (SingleViewNode singleViewNode : GraphAlgorithms.getSuccessors(singleDiffNode.getRawNode(), 1)) {
                if (!singleViewNode.isSelected()) continue;
                bl2 = true;
            }
            if (bl2) continue;
            hashSet.add(singleDiffNode);
        }
        return hashSet;
    }

    private static Set<CombinedDiffNode> getSelectedRootNodes(CombinedGraph combinedGraph) {
        HashSet<CombinedDiffNode> hashSet = new HashSet<CombinedDiffNode>();
        for (CombinedDiffNode combinedDiffNode : combinedGraph.getSelectedNodes()) {
            boolean bl2 = false;
            for (CombinedViewNode combinedViewNode : GraphAlgorithms.getPredecessors(combinedDiffNode.getRawNode(), 1)) {
                if (!combinedViewNode.isSelected()) continue;
                bl2 = true;
            }
            if (bl2) continue;
            hashSet.add(combinedDiffNode);
        }
        return hashSet;
    }

    private static Set<SingleDiffNode> getSelectedRootNodes(SingleGraph singleGraph) {
        HashSet<SingleDiffNode> hashSet = new HashSet<SingleDiffNode>();
        for (SingleDiffNode singleDiffNode : singleGraph.getSelectedNodes()) {
            boolean bl2 = false;
            for (SingleViewNode singleViewNode : GraphAlgorithms.getPredecessors(singleDiffNode.getRawNode(), 1)) {
                if (!singleViewNode.isSelected()) continue;
                bl2 = true;
            }
            if (bl2) continue;
            hashSet.add(singleDiffNode);
        }
        return hashSet;
    }

    private static <NodeType extends ZyGraphNode<?>> void selectNodes(BinDiffGraph<NodeType, ?> binDiffGraph, Collection<NodeType> collection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<NodeType> hashSet2 = new HashSet<NodeType>();
        hashSet2.addAll(binDiffGraph.getNodes());
        hashSet.addAll(binDiffGraph.getSelectedNodes());
        boolean bl2 = binDiffGraph.getSettings().getProximitySettings().getProximityBrowsing() && binDiffGraph.getSettings().getProximitySettings().getProximityBrowsingFrozen();
        for (ZyGraphNode zyGraphNode : collection) {
            if (!zyGraphNode.isVisible() && bl2) continue;
            hashSet.add(zyGraphNode);
        }
        hashSet2.removeAll(hashSet);
        binDiffGraph.selectNodes(hashSet, hashSet2);
    }

    public static void deselectLeafs(CombinedGraph combinedGraph) {
        GraphSelector.deselectNodes(combinedGraph, GraphSelector.getSelectedLeafNodes(combinedGraph));
    }

    public static void deselectLeafs(SingleGraph singleGraph) {
        GraphSelector.deselectNodes(singleGraph, GraphSelector.getSelectedLeafNodes(singleGraph));
    }

    public static void deselectPeriphery(CombinedGraph combinedGraph) {
        Set<CombinedDiffNode> set = GraphSelector.getSelectedRootNodes(combinedGraph);
        set.addAll(GraphSelector.getSelectedLeafNodes(combinedGraph));
        GraphSelector.deselectNodes(combinedGraph, set);
    }

    public static void deselectPeriphery(SingleGraph singleGraph) {
        Set<SingleDiffNode> set = GraphSelector.getSelectedRootNodes(singleGraph);
        set.addAll(GraphSelector.getSelectedLeafNodes(singleGraph));
        GraphSelector.deselectNodes(singleGraph, set);
    }

    public static void deselectRoots(CombinedGraph combinedGraph) {
        GraphSelector.deselectNodes(combinedGraph, GraphSelector.getSelectedRootNodes(combinedGraph));
    }

    public static void deselectRoots(SingleGraph singleGraph) {
        GraphSelector.deselectNodes(singleGraph, GraphSelector.getSelectedRootNodes(singleGraph));
    }

    public static void invertSelection(CombinedGraph combinedGraph) {
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        ArrayList<CombinedDiffNode> arrayList2 = new ArrayList<CombinedDiffNode>();
        boolean bl2 = combinedGraph.getSettings().getProximitySettings().getProximityBrowsing() && combinedGraph.getSettings().getProximitySettings().getProximityBrowsingFrozen();
        for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
            if (bl2 && !combinedDiffNode.isVisible()) continue;
            if (combinedDiffNode.isSelected()) {
                arrayList2.add(combinedDiffNode);
                continue;
            }
            arrayList.add(combinedDiffNode);
        }
        combinedGraph.selectNodes(arrayList, arrayList2);
    }

    public static void invertSelection(SingleGraph singleGraph) {
        ArrayList<SingleDiffNode> arrayList = new ArrayList<SingleDiffNode>();
        ArrayList<SingleDiffNode> arrayList2 = new ArrayList<SingleDiffNode>();
        boolean bl2 = singleGraph.getSettings().getProximitySettings().getProximityBrowsing() && singleGraph.getSettings().getProximitySettings().getProximityBrowsingFrozen();
        for (SingleDiffNode singleDiffNode : singleGraph.getNodes()) {
            if (bl2 && !singleDiffNode.isVisible()) continue;
            if (singleDiffNode.isSelected()) {
                arrayList2.add(singleDiffNode);
                continue;
            }
            arrayList.add(singleDiffNode);
        }
        singleGraph.selectNodes(arrayList, arrayList2);
    }

    public static void selectAncestorsOfSelection(CombinedGraph combinedGraph) {
        List list = GraphConverters.convert(combinedGraph.getSelectedNodes());
        GraphSelector.selectNodes(combinedGraph, GraphConverters.convert(combinedGraph, GraphAlgorithms.getPredecessors(list)));
    }

    public static void selectAncestorsOfSelection(SingleGraph singleGraph) {
        List list = GraphConverters.convert(singleGraph.getSelectedNodes());
        GraphSelector.selectNodes(singleGraph, GraphConverters.convert(singleGraph, GraphAlgorithms.getPredecessors(list)));
    }

    public static void selectChildrenOfSelection(CombinedGraph combinedGraph) {
        List list = GraphConverters.convert(combinedGraph.getSelectedNodes());
        GraphSelector.selectNodes(combinedGraph, GraphConverters.convert(combinedGraph, GraphAlgorithms.getSuccessors(list, 1)));
    }

    public static void selectChildrenOfSelection(SingleGraph singleGraph) {
        List list = GraphConverters.convert(singleGraph.getSelectedNodes());
        GraphSelector.selectNodes(singleGraph, GraphConverters.convert(singleGraph, GraphAlgorithms.getSuccessors(list, 1)));
    }

    public static void selectNeighboursOfSelection(CombinedGraph combinedGraph) {
        List list = GraphConverters.convert(combinedGraph.getSelectedNodes());
        HashSet<CombinedDiffNode> hashSet = new HashSet<CombinedDiffNode>();
        hashSet.addAll(GraphConverters.convert(combinedGraph, GraphAlgorithms.getPredecessors(list, 1)));
        hashSet.addAll(GraphConverters.convert(combinedGraph, GraphAlgorithms.getSuccessors(list, 1)));
        GraphSelector.selectNodes(combinedGraph, hashSet);
    }

    public static void selectNeighboursOfSelection(SingleGraph singleGraph) {
        List list = GraphConverters.convert(singleGraph.getSelectedNodes());
        HashSet<SingleDiffNode> hashSet = new HashSet<SingleDiffNode>();
        hashSet.addAll(GraphConverters.convert(singleGraph, GraphAlgorithms.getPredecessors(list, 1)));
        hashSet.addAll(GraphConverters.convert(singleGraph, GraphAlgorithms.getSuccessors(list, 1)));
        GraphSelector.selectNodes(singleGraph, hashSet);
    }

    public static void selectParentsOfSelection(CombinedGraph combinedGraph) {
        List list = GraphConverters.convert(combinedGraph.getSelectedNodes());
        GraphSelector.selectNodes(combinedGraph, GraphConverters.convert(combinedGraph, GraphAlgorithms.getPredecessors(list, 1)));
    }

    public static void selectParentsOfSelection(SingleGraph singleGraph) {
        List list = GraphConverters.convert(singleGraph.getSelectedNodes());
        GraphSelector.selectNodes(singleGraph, GraphConverters.convert(singleGraph, GraphAlgorithms.getPredecessors(list, 1)));
    }

    public static void selectSuccessorsOfSelection(CombinedGraph combinedGraph) {
        List list = GraphConverters.convert(combinedGraph.getSelectedNodes());
        GraphSelector.selectNodes(combinedGraph, GraphConverters.convert(combinedGraph, GraphAlgorithms.getSuccessors(list)));
    }

    public static void selectSuccessorsOfSelection(SingleGraph singleGraph) {
        List list = GraphConverters.convert(singleGraph.getSelectedNodes());
        GraphSelector.selectNodes(singleGraph, GraphConverters.convert(singleGraph, GraphAlgorithms.getSuccessors(list)));
    }
}

