/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.helpers;

import com.google.security.zynamics.bindiff.enums.EJumpType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.builders.ViewFlowGraphBuilder;
import com.google.security.zynamics.bindiff.graph.edges.CombinedDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.CombinedViewEdge;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperViewEdge;
import com.google.security.zynamics.bindiff.graph.helpers.BasicBlockMatchRemover;
import com.google.security.zynamics.bindiff.graph.labelcontent.lineeditor.BasicBlockContentEditor;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperViewNode;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewManager;
import com.google.security.zynamics.bindiff.types.Matches;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBlockMatchAdder {
    private static BasicBlockMatchData createBasicblockMatchData(RawCombinedBasicBlock rawCombinedBasicBlock, RawCombinedBasicBlock rawCombinedBasicBlock2) {
        long l2 = rawCombinedBasicBlock.getAddress(ESide.PRIMARY).toLong();
        long l3 = rawCombinedBasicBlock2.getAddress(ESide.SECONDARY).toLong();
        int n2 = -1;
        Matches<InstructionMatchData> matches = new Matches<InstructionMatchData>(BasicBlockMatchAdder.getNewInstructionMatches());
        return new BasicBlockMatchData(l2, l3, -1, matches);
    }

    private static List<InstructionMatchData> getNewInstructionMatches() {
        return new ArrayList<InstructionMatchData>();
    }

    private static RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> getRawCombinedFlowgraph(GraphsContainer graphsContainer, CombinedDiffNode combinedDiffNode, CombinedDiffNode combinedDiffNode2) {
        IAddress iAddress = ((RawCombinedBasicBlock)combinedDiffNode.getRawNode()).getPrimaryFunctionAddress();
        IAddress iAddress2 = ((RawCombinedBasicBlock)combinedDiffNode2.getRawNode()).getSecondaryFunctionAddress();
        ViewManager viewManager = graphsContainer.getDiff().getViewManager();
        FlowGraphViewData flowGraphViewData = viewManager.getFlowGraphViewData(iAddress, iAddress2);
        return flowGraphViewData.getCombinedRawGraph();
    }

    private static void insertNewDiffEdges(GraphsContainer graphsContainer, SuperDiffNode superDiffNode) {
        SuperGraph superGraph = graphsContainer.getSuperGraph();
        CombinedGraph combinedGraph = graphsContainer.getCombinedGraph();
        SingleGraph singleGraph = graphsContainer.getPrimaryGraph();
        SingleGraph singleGraph2 = graphsContainer.getSecondaryGraph();
        SuperViewNode superViewNode = superDiffNode.getRawNode();
        HashSet hashSet = new HashSet();
        hashSet.addAll(superViewNode.getIncomingEdges());
        hashSet.addAll(superViewNode.getOutgoingEdges());
        for (SuperViewEdge superViewEdge : hashSet) {
            SingleDiffEdge singleDiffEdge = SingleGraph.buildDiffEdge(singleGraph, superViewEdge);
            SingleDiffEdge singleDiffEdge2 = SingleGraph.buildDiffEdge(singleGraph2, superViewEdge);
            SuperDiffEdge superDiffEdge = SuperGraph.buildDiffEdge(superGraph, superViewEdge, singleDiffEdge, singleDiffEdge2);
            CombinedDiffEdge combinedDiffEdge = CombinedGraph.buildDiffEdge(combinedGraph, superViewEdge, superDiffEdge);
            ZyEdgeRealizer<SingleDiffEdge> zyEdgeRealizer = null;
            ZyEdgeRealizer<SingleDiffEdge> zyEdgeRealizer2 = null;
            superDiffEdge.setCombinedDiffEdge(combinedDiffEdge);
            if (singleDiffEdge != null) {
                singleDiffEdge.setCombinedDiffEdge(combinedDiffEdge);
                zyEdgeRealizer = singleDiffEdge.getRealizer();
            }
            if (singleDiffEdge2 != null) {
                singleDiffEdge2.setCombinedDiffEdge(combinedDiffEdge);
                zyEdgeRealizer2 = singleDiffEdge2.getRealizer();
            }
            RawCombinedJump rawCombinedJump = (RawCombinedJump)superViewEdge.getCombinedEdge();
            ViewFlowGraphBuilder.colorizeJumps(rawCombinedJump, zyEdgeRealizer, zyEdgeRealizer2);
            ViewFlowGraphBuilder.stylizeJumps(rawCombinedJump, combinedDiffEdge.getRealizer(), zyEdgeRealizer, zyEdgeRealizer2);
        }
    }

    private static void insertNewDiffNodesAndEdges(GraphsContainer graphsContainer, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, SuperViewNode superViewNode) {
        RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)superViewNode.getCombinedNode();
        CombinedGraph combinedGraph = graphsContainer.getCombinedGraph();
        SuperGraph superGraph = graphsContainer.getSuperGraph();
        SingleGraph singleGraph = graphsContainer.getPrimaryGraph();
        SingleGraph singleGraph2 = graphsContainer.getSecondaryGraph();
        MatchData matchData = graphsContainer.getDiff().getMatches();
        FunctionMatchData functionMatchData = matchData.getFunctionMatch(rawCombinedBasicBlock.getPrimaryFunctionAddress(), ESide.PRIMARY);
        SingleDiffNode singleDiffNode = SingleGraph.buildDiffNode(singleGraph, functionMatchData, rawCombinedFlowGraph, rawCombinedBasicBlock);
        SingleDiffNode singleDiffNode2 = SingleGraph.buildDiffNode(singleGraph2, functionMatchData, rawCombinedFlowGraph, rawCombinedBasicBlock);
        SuperDiffNode superDiffNode = SuperGraph.buildDiffNode(superGraph, singleDiffNode, singleDiffNode2, superViewNode);
        CombinedDiffNode combinedDiffNode = CombinedGraph.buildDiffNode(combinedGraph, singleDiffNode, singleDiffNode2, superDiffNode, rawCombinedBasicBlock);
        superDiffNode.setCombinedDiffNode(combinedDiffNode);
        singleDiffNode.setCombinedDiffNode(combinedDiffNode);
        singleDiffNode2.setCombinedDiffNode(combinedDiffNode);
        singleGraph.addNodeToMappings(singleDiffNode);
        singleGraph2.addNodeToMappings(singleDiffNode2);
        combinedGraph.addNodeToMappings(combinedDiffNode);
        superGraph.addNodeToMappings(superDiffNode);
        BasicBlockContentEditor basicBlockContentEditor = new BasicBlockContentEditor(functionMatchData, graphsContainer, ESide.PRIMARY);
        singleDiffNode.getRealizer().getNodeContent().setLineEditor(basicBlockContentEditor);
        BasicBlockContentEditor basicBlockContentEditor2 = new BasicBlockContentEditor(functionMatchData, graphsContainer, ESide.SECONDARY);
        singleDiffNode2.getRealizer().getNodeContent().setLineEditor(basicBlockContentEditor2);
        ViewFlowGraphBuilder.colorizeBasicBlocks(functionMatchData, rawCombinedBasicBlock);
        ViewFlowGraphBuilder.colorizeCombinedNodeLineBorders(combinedGraph.getNodes(), combinedGraph.getPrimaryGraph().getFunctionAddress(), combinedGraph.getSecondaryGraph().getFunctionAddress());
        ViewFlowGraphBuilder.colorizeSingleNodeLineBorders(singleGraph.getNodes(), singleGraph.getFunctionAddress());
        ViewFlowGraphBuilder.colorizeSingleNodeLineBorders(singleGraph2.getNodes(), singleGraph2.getFunctionAddress());
        superGraph.refreshSuperNodeSize(graphsContainer.getPrimaryGraph(), graphsContainer.getSecondaryGraph(), superDiffNode);
        BasicBlockMatchAdder.insertNewDiffEdges(graphsContainer, superDiffNode);
    }

    private static void insertNewRawNodesAndEdges(RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, Set<SuperViewEdge<? extends SuperViewNode>> set, SuperViewNode superViewNode, SuperViewNode superViewNode2, RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2, RawCombinedBasicBlock rawCombinedBasicBlock, SuperViewNode superViewNode3) {
        Object object;
        Object object2;
        Object object3;
        RawFlowGraph rawFlowGraph = rawCombinedFlowGraph.getPrimaryFlowgraph();
        RawFlowGraph rawFlowGraph2 = rawCombinedFlowGraph.getSecondaryFlowgraph();
        rawFlowGraph.addNode(rawBasicBlock);
        rawFlowGraph2.addNode(rawBasicBlock2);
        rawCombinedFlowGraph.addNode(rawCombinedBasicBlock);
        HashMap<Object, ArrayList<InternalStruct>> hashMap = new HashMap<Object, ArrayList<InternalStruct>>();
        for (SuperViewEdge<? extends SuperViewNode> object4 : set) {
            Object object5 = (SuperViewNode)object4.getSource();
            Object object6 = (RawCombinedBasicBlock)((SuperViewNode)object5).getCombinedNode();
            object3 = ((RawCombinedBasicBlock)object6).getRawNode(ESide.PRIMARY);
            object2 = ((RawCombinedBasicBlock)object6).getRawNode(ESide.SECONDARY);
            object = (SuperViewNode)object4.getTarget();
            RawCombinedBasicBlock rawCombinedBasicBlock2 = (RawCombinedBasicBlock)((SuperViewNode)object).getCombinedNode();
            RawBasicBlock rawBasicBlock3 = rawCombinedBasicBlock2.getRawNode(ESide.PRIMARY);
            RawBasicBlock rawBasicBlock4 = rawCombinedBasicBlock2.getRawNode(ESide.SECONDARY);
            if (object == superViewNode || object == superViewNode2) {
                object = superViewNode3;
                rawCombinedBasicBlock2 = rawCombinedBasicBlock;
                rawBasicBlock3 = rawBasicBlock;
                rawBasicBlock4 = rawBasicBlock2;
            }
            if (object5 == superViewNode || object5 == superViewNode2) {
                object5 = superViewNode3;
                object6 = rawCombinedBasicBlock;
                object3 = rawBasicBlock;
                object2 = rawBasicBlock2;
            }
            InternalStruct internalStruct = null;
            ArrayList<InternalStruct> arrayList = (ArrayList<InternalStruct>)hashMap.get(object5);
            if (arrayList != null) {
                for (InternalStruct internalStruct2 : arrayList) {
                    if (internalStruct2.superTarget != object) continue;
                    internalStruct = internalStruct2;
                    break;
                }
            }
            if (internalStruct == null) {
                internalStruct = new InternalStruct();
                internalStruct.superTarget = object;
                internalStruct.combinedSource = object6;
                internalStruct.combinedTarget = rawCombinedBasicBlock2;
                internalStruct.priSource = object3;
                internalStruct.priTarget = rawBasicBlock3;
                internalStruct.secSource = object2;
                internalStruct.secTarget = rawBasicBlock4;
                if (arrayList == null) {
                    arrayList = new ArrayList<InternalStruct>();
                    hashMap.put(object5, arrayList);
                }
                arrayList.add(internalStruct);
            } else if (object3 != null && rawBasicBlock3 != null) {
                internalStruct.priSource = object3;
                internalStruct.priTarget = rawBasicBlock3;
            } else {
                internalStruct.secSource = object2;
                internalStruct.secTarget = rawBasicBlock4;
            }
            if (object4.getSingleEdge(ESide.PRIMARY) != null) {
                internalStruct.priJumpType = ((RawJump)object4.getSingleEdge(ESide.PRIMARY)).getJumpType();
            }
            if (object4.getSingleEdge(ESide.SECONDARY) == null) continue;
            internalStruct.secJumpType = ((RawJump)object4.getSingleEdge(ESide.SECONDARY)).getJumpType();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            for (Object object6 : (List)entry.getValue()) {
                object3 = null;
                if (((InternalStruct)object6).priJumpType != null) {
                    object3 = new RawJump(((InternalStruct)object6).priSource, ((InternalStruct)object6).priTarget, ((InternalStruct)object6).priJumpType);
                    rawFlowGraph.addEdge((RawJump)object3);
                }
                object2 = null;
                if (((InternalStruct)object6).secJumpType != null) {
                    object2 = new RawJump(((InternalStruct)object6).secSource, ((InternalStruct)object6).secTarget, ((InternalStruct)object6).secJumpType);
                    rawFlowGraph2.addEdge((RawJump)object2);
                }
                object = new RawCombinedJump<RawCombinedBasicBlock>(((InternalStruct)object6).combinedSource, ((InternalStruct)object6).combinedTarget, (RawJump)object3, (RawJump)object2);
                rawCombinedFlowGraph.addEdge((RawCombinedJump<RawCombinedBasicBlock>)object);
                new SuperViewEdge<SuperViewNode>((CombinedViewEdge<? extends CombinedViewNode>)object, (SuperViewNode)entry.getKey(), ((InternalStruct)object6).superTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBasicblockMatch(GraphsContainer graphsContainer, CombinedDiffNode combinedDiffNode, CombinedDiffNode combinedDiffNode2) {
        graphsContainer.getCombinedGraph().getIntermediateListeners().blockZyLibVisibilityListeners();
        graphsContainer.getCombinedGraph().getIntermediateListeners().blockZyLibSelectionListeners();
        try {
            SuperDiffNode superDiffNode = combinedDiffNode.getSuperDiffNode();
            SuperDiffNode superDiffNode2 = combinedDiffNode2.getSuperDiffNode();
            SingleDiffNode singleDiffNode = combinedDiffNode.getPrimaryDiffNode();
            SingleDiffNode singleDiffNode2 = combinedDiffNode2.getSecondaryDiffNode();
            RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)combinedDiffNode.getRawNode();
            RawCombinedBasicBlock rawCombinedBasicBlock2 = (RawCombinedBasicBlock)combinedDiffNode2.getRawNode();
            RawBasicBlock rawBasicBlock = (RawBasicBlock)singleDiffNode.getRawNode();
            RawBasicBlock rawBasicBlock2 = (RawBasicBlock)singleDiffNode2.getRawNode();
            SuperViewNode superViewNode = superDiffNode.getRawNode();
            SuperViewNode superViewNode2 = superDiffNode2.getRawNode();
            RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph = BasicBlockMatchAdder.getRawCombinedFlowgraph(graphsContainer, combinedDiffNode, combinedDiffNode2);
            RawFlowGraph rawFlowGraph = rawCombinedFlowGraph.getPrimaryFlowgraph();
            RawFlowGraph rawFlowGraph2 = rawCombinedFlowGraph.getSecondaryFlowgraph();
            BasicBlockMatchRemover.syncBasicBlockVisibility(graphsContainer, combinedDiffNode);
            BasicBlockMatchRemover.syncBasicBlockVisibility(graphsContainer, combinedDiffNode2);
            HashSet<SuperViewEdge<? extends SuperViewNode>> hashSet = new HashSet<SuperViewEdge<? extends SuperViewNode>>();
            hashSet.addAll(superViewNode.getIncomingEdges());
            hashSet.addAll(superViewNode.getOutgoingEdges());
            hashSet.addAll(superViewNode2.getIncomingEdges());
            hashSet.addAll(superViewNode2.getOutgoingEdges());
            rawCombinedFlowGraph.removeNode(rawCombinedBasicBlock);
            rawCombinedFlowGraph.removeNode(rawCombinedBasicBlock2);
            superViewNode.removeNode();
            superViewNode2.removeNode();
            rawFlowGraph.removeNode(rawBasicBlock);
            rawFlowGraph2.removeNode(rawBasicBlock2);
            graphsContainer.getCombinedGraph().deleteNode(combinedDiffNode);
            graphsContainer.getCombinedGraph().deleteNode(combinedDiffNode2);
            graphsContainer.getSuperGraph().deleteNode(superDiffNode);
            graphsContainer.getSuperGraph().deleteNode(superDiffNode2);
            graphsContainer.getPrimaryGraph().deleteNode(singleDiffNode);
            graphsContainer.getSecondaryGraph().deleteNode(singleDiffNode2);
            BasicBlockMatchData basicBlockMatchData = BasicBlockMatchAdder.createBasicblockMatchData(rawCombinedBasicBlock, rawCombinedBasicBlock2);
            RawBasicBlock rawBasicBlock3 = rawBasicBlock.clone(EMatchState.MATCHED);
            RawBasicBlock rawBasicBlock4 = rawBasicBlock2.clone(EMatchState.MATCHED);
            RawCombinedBasicBlock rawCombinedBasicBlock3 = new RawCombinedBasicBlock(rawBasicBlock3, rawBasicBlock4, basicBlockMatchData, rawBasicBlock3.getFunctionAddr(), rawBasicBlock4.getFunctionAddr());
            SuperViewNode superViewNode3 = new SuperViewNode(rawCombinedBasicBlock3);
            BasicBlockMatchAdder.insertNewRawNodesAndEdges(rawCombinedFlowGraph, hashSet, superViewNode, superViewNode2, rawBasicBlock3, rawBasicBlock4, rawCombinedBasicBlock3, superViewNode3);
            FunctionMatchData functionMatchData = graphsContainer.getDiff().getMatches().getFunctionMatch(rawCombinedBasicBlock3.getPrimaryFunctionAddress(), ESide.PRIMARY);
            functionMatchData.addBasicblockMatch(graphsContainer.getDiff(), basicBlockMatchData, rawCombinedBasicBlock3);
            BasicBlockMatchAdder.insertNewDiffNodesAndEdges(graphsContainer, rawCombinedFlowGraph, superViewNode3);
            graphsContainer.getDiff().getMatches().notifyBasicBlockMatchAddedListener(rawBasicBlock3.getFunctionAddr(), rawBasicBlock4.getFunctionAddr(), rawBasicBlock3.getAddress(), rawBasicBlock4.getAddress());
        }
        finally {
            graphsContainer.getCombinedGraph().getIntermediateListeners().freeZyLibVisibilityListeners();
            graphsContainer.getCombinedGraph().getIntermediateListeners().freeZyLibSelectionListeners();
        }
        BasicBlockMatchRemover.doSynchronizedLayout(graphsContainer.getCombinedGraph());
    }

    public static Pair<CombinedDiffNode, CombinedDiffNode> getAffectedCombinedNodes(BinDiffGraph<?, ?> binDiffGraph) {
        CombinedDiffNode combinedDiffNode = null;
        CombinedDiffNode combinedDiffNode2 = null;
        int n2 = 0;
        if (binDiffGraph instanceof CombinedGraph) {
            for (CombinedDiffNode combinedDiffNode3 : ((CombinedGraph)binDiffGraph).getSelectedNodes()) {
                if (combinedDiffNode3.getRawNode().getMatchState() == EMatchState.PRIMARY_UNMATCHED) {
                    ++n2;
                    combinedDiffNode = combinedDiffNode3;
                    continue;
                }
                if (combinedDiffNode3.getRawNode().getMatchState() != EMatchState.SECONDRAY_UNMATCHED) continue;
                ++n2;
                combinedDiffNode2 = combinedDiffNode3;
            }
            if (n2 == 2 && combinedDiffNode != null && combinedDiffNode2 != null && combinedDiffNode.isVisible() && combinedDiffNode2.isVisible()) {
                return new Pair<CombinedDiffNode, CombinedDiffNode>(combinedDiffNode, combinedDiffNode2);
            }
        } else if (binDiffGraph instanceof SingleGraph) {
            SingleGraph singleGraph = binDiffGraph.getPrimaryGraph();
            SingleGraph singleGraph2 = binDiffGraph.getSecondaryGraph();
            for (SingleDiffNode singleDiffNode : singleGraph.getSelectedNodes()) {
                if (singleDiffNode.getRawNode().getMatchState() != EMatchState.PRIMARY_UNMATCHED) continue;
                ++n2;
                combinedDiffNode = singleDiffNode.getCombinedDiffNode();
            }
            if (n2 == 1) {
                for (SingleDiffNode singleDiffNode : singleGraph2.getSelectedNodes()) {
                    if (singleDiffNode.getRawNode().getMatchState() != EMatchState.SECONDRAY_UNMATCHED) continue;
                    ++n2;
                    combinedDiffNode2 = singleDiffNode.getCombinedDiffNode();
                }
            }
        }
        if (n2 == 2 && combinedDiffNode != null && combinedDiffNode2 != null && combinedDiffNode.getPrimaryDiffNode().isVisible() && combinedDiffNode2.getSecondaryDiffNode().isVisible()) {
            return new Pair<CombinedDiffNode, CombinedDiffNode>(combinedDiffNode, combinedDiffNode2);
        }
        return null;
    }

    public static Pair<CombinedDiffNode, CombinedDiffNode> getAffectedCombinedNodes(BinDiffGraph<?, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        SingleDiffNode singleDiffNode;
        CombinedDiffNode combinedDiffNode = null;
        CombinedDiffNode combinedDiffNode2 = null;
        int n2 = 0;
        int n3 = 0;
        if (zyGraphNode instanceof CombinedDiffNode) {
            CombinedDiffNode combinedDiffNode3 = (CombinedDiffNode)zyGraphNode;
            if (combinedDiffNode3.getRawNode().getMatchState() == EMatchState.PRIMARY_UNMATCHED) {
                combinedDiffNode = combinedDiffNode3;
                for (CombinedDiffNode combinedDiffNode4 : binDiffGraph.getCombinedGraph().getSelectedNodes()) {
                    if (combinedDiffNode4 == combinedDiffNode) {
                        ++n2;
                        continue;
                    }
                    if (combinedDiffNode4.getRawNode().getMatchState() != EMatchState.SECONDRAY_UNMATCHED) continue;
                    ++n3;
                    combinedDiffNode2 = combinedDiffNode4;
                }
            } else if (combinedDiffNode3.getRawNode().getMatchState() == EMatchState.SECONDRAY_UNMATCHED) {
                combinedDiffNode2 = combinedDiffNode3;
                for (CombinedDiffNode combinedDiffNode5 : binDiffGraph.getCombinedGraph().getSelectedNodes()) {
                    if (!combinedDiffNode5.isVisible()) continue;
                    if (combinedDiffNode5 == combinedDiffNode2) {
                        ++n3;
                        continue;
                    }
                    if (combinedDiffNode5.getRawNode().getMatchState() != EMatchState.PRIMARY_UNMATCHED) continue;
                    ++n2;
                    combinedDiffNode = combinedDiffNode5;
                }
            }
        } else if (zyGraphNode instanceof SingleDiffNode && (singleDiffNode = (SingleDiffNode)zyGraphNode).isSelected() && singleDiffNode.isVisible()) {
            if (singleDiffNode.getSide() == ESide.PRIMARY) {
                combinedDiffNode = singleDiffNode.getCombinedDiffNode();
                n2 = 1;
                for (SingleDiffNode singleDiffNode2 : binDiffGraph.getSecondaryGraph().getSelectedNodes()) {
                    if (singleDiffNode2.getRawNode().getMatchState() != EMatchState.SECONDRAY_UNMATCHED || !singleDiffNode2.isVisible()) continue;
                    ++n3;
                    combinedDiffNode2 = singleDiffNode2.getCombinedDiffNode();
                }
            } else {
                combinedDiffNode2 = singleDiffNode.getCombinedDiffNode();
                n3 = 1;
                for (SingleDiffNode singleDiffNode3 : binDiffGraph.getPrimaryGraph().getSelectedNodes()) {
                    if (singleDiffNode3.getRawNode().getMatchState() != EMatchState.PRIMARY_UNMATCHED || !singleDiffNode3.isVisible()) continue;
                    ++n2;
                    combinedDiffNode = singleDiffNode3.getCombinedDiffNode();
                }
            }
        }
        if (n2 == 1 && n3 == 1 && combinedDiffNode != null && combinedDiffNode2 != null) {
            return new Pair<CombinedDiffNode, CombinedDiffNode>(combinedDiffNode, combinedDiffNode2);
        }
        return null;
    }

    private static class InternalStruct {
        SuperViewNode superTarget = null;
        RawBasicBlock priSource = null;
        RawBasicBlock priTarget = null;
        RawBasicBlock secTarget = null;
        RawBasicBlock secSource = null;
        RawCombinedBasicBlock combinedSource = null;
        RawCombinedBasicBlock combinedTarget = null;
        EJumpType priJumpType = null;
        EJumpType secJumpType = null;

        private InternalStruct() {
        }
    }
}

