/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.filter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.filter.IGraphNodeMultiFilterListener;
import com.google.security.zynamics.bindiff.graph.filter.enums.EMatchStateFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESelectionFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESideFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.EVisibilityFilter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.MatchesGetter;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public class GraphNodeMultiFilter {
    private final ListenerProvider<IGraphNodeMultiFilterListener> listeners = new ListenerProvider();
    private final Diff diff;
    private EMatchStateFilter matchStateFilter;
    private ESelectionFilter selectionFilter;
    private EVisibilityFilter visibilityFilter;
    private ESideFilter sideFilter;
    private IAddress startRangeAddr;
    private IAddress endRangeAddr;
    private ESideFilter addrRangeSide;
    private boolean notify = false;
    final RawFlowGraph priFlowgraph;
    final RawFlowGraph secFlowgraph;

    public GraphNodeMultiFilter(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, IAddress iAddress, IAddress iAddress2, EMatchStateFilter eMatchStateFilter, ESelectionFilter eSelectionFilter, EVisibilityFilter eVisibilityFilter, ESideFilter eSideFilter) {
        this.diff = Preconditions.checkNotNull(diff);
        this.startRangeAddr = Preconditions.checkNotNull(iAddress);
        this.endRangeAddr = Preconditions.checkNotNull(iAddress2);
        this.matchStateFilter = Preconditions.checkNotNull(eMatchStateFilter);
        this.selectionFilter = Preconditions.checkNotNull(eSelectionFilter);
        this.visibilityFilter = Preconditions.checkNotNull(eVisibilityFilter);
        this.sideFilter = Preconditions.checkNotNull(eSideFilter);
        this.priFlowgraph = rawFlowGraph;
        this.secFlowgraph = rawFlowGraph2;
    }

    private boolean filterAddressRange(CombinedViewNode combinedViewNode) {
        String string;
        IAddress iAddress = combinedViewNode.getAddress(ESide.PRIMARY);
        IAddress iAddress2 = combinedViewNode.getAddress(ESide.SECONDARY);
        boolean bl2 = false;
        String string2 = this.startRangeAddr.toHexString();
        String string3 = this.endRangeAddr.toHexString();
        if (iAddress != null) {
            string = iAddress.toHexString();
            boolean bl3 = bl2 = string.compareTo(string2) >= 0 && string.compareTo(string3) <= 0;
        }
        if (iAddress2 != null && !bl2) {
            string = iAddress2.toHexString();
            bl2 = string.compareTo(string2) >= 0 && string.compareTo(string3) <= 0;
        }
        return bl2;
    }

    private boolean filterAddressRange(SingleViewNode singleViewNode) {
        String string = singleViewNode.getAddress().toHexString();
        String string2 = this.startRangeAddr.toHexString();
        String string3 = this.endRangeAddr.toHexString();
        return string.compareTo(string2) >= 0 && string.compareTo(string3) <= 0;
    }

    private boolean filterMatchState(CombinedViewNode combinedViewNode) {
        if (this.matchStateFilter == EMatchStateFilter.NONE) {
            return true;
        }
        if (combinedViewNode.getMatchState() == EMatchState.MATCHED) {
            if (this.matchStateFilter == EMatchStateFilter.MATCHED) {
                return true;
            }
            if (combinedViewNode instanceof RawCombinedBasicBlock) {
                boolean bl2 = false;
                RawBasicBlock rawBasicBlock = ((RawCombinedBasicBlock)combinedViewNode).getRawNode(ESide.PRIMARY);
                RawBasicBlock rawBasicBlock2 = ((RawCombinedBasicBlock)combinedViewNode).getRawNode(ESide.SECONDARY);
                bl2 = MatchesGetter.isIdenticalBasicBlock(this.diff, rawBasicBlock, rawBasicBlock2);
                if (this.matchStateFilter == EMatchStateFilter.MATCHED_IDENTICAL && bl2) {
                    return true;
                }
                if (this.matchStateFilter == EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES && !bl2) {
                    return true;
                }
            } else if (combinedViewNode instanceof RawCombinedFunction) {
                boolean bl3;
                RawFunction rawFunction = ((RawCombinedFunction)combinedViewNode).getRawNode(ESide.PRIMARY);
                boolean bl4 = rawFunction != null && rawFunction.isIdenticalMatch();
                boolean bl5 = rawFunction != null && rawFunction.isChangedInstructionsOnlyMatch();
                boolean bl6 = bl3 = rawFunction != null && rawFunction.isChangedStructuralMatch();
                if (this.matchStateFilter == EMatchStateFilter.MATCHED_IDENTICAL && bl4) {
                    return true;
                }
                if (this.matchStateFilter == EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES && bl5) {
                    return true;
                }
                if (this.matchStateFilter == EMatchStateFilter.MATCHED_STRUTURAL_CHANGES && bl3) {
                    return true;
                }
            }
        } else if (combinedViewNode.getMatchState() != EMatchState.MATCHED && this.matchStateFilter == EMatchStateFilter.UNMATCHED) {
            return true;
        }
        return false;
    }

    private boolean filterMatchState(RawBasicBlock rawBasicBlock, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2) {
        if (this.matchStateFilter == EMatchStateFilter.NONE) {
            return true;
        }
        if (rawBasicBlock.getMatchState() == EMatchState.MATCHED) {
            if (this.matchStateFilter == EMatchStateFilter.MATCHED) {
                return true;
            }
            boolean bl2 = false;
            ESide eSide = rawBasicBlock.getSide();
            RawBasicBlock rawBasicBlock2 = rawBasicBlock;
            RawBasicBlock rawBasicBlock3 = rawBasicBlock;
            if (eSide == ESide.PRIMARY) {
                BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(this.diff, rawBasicBlock);
                rawBasicBlock3 = rawFlowGraph2.getBasicblock(basicBlockMatchData.getIAddress(ESide.SECONDARY));
            } else {
                BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(this.diff, rawBasicBlock);
                rawBasicBlock2 = rawFlowGraph.getBasicblock(basicBlockMatchData.getIAddress(ESide.PRIMARY));
            }
            bl2 = MatchesGetter.isIdenticalBasicBlock(this.diff, rawBasicBlock2, rawBasicBlock3);
            if (this.matchStateFilter == EMatchStateFilter.MATCHED_IDENTICAL && bl2) {
                return true;
            }
            if (this.matchStateFilter == EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES && !bl2) {
                return true;
            }
        } else if (rawBasicBlock.getMatchState() != EMatchState.MATCHED && this.matchStateFilter == EMatchStateFilter.UNMATCHED) {
            return true;
        }
        return false;
    }

    private boolean filterMatchState(RawFunction rawFunction) {
        if (this.matchStateFilter == EMatchStateFilter.NONE) {
            return true;
        }
        if (rawFunction.getMatchState() == EMatchState.MATCHED) {
            if (this.matchStateFilter == EMatchStateFilter.MATCHED) {
                return true;
            }
            boolean bl2 = rawFunction.isIdenticalMatch();
            boolean bl3 = rawFunction.isChangedInstructionsOnlyMatch();
            boolean bl4 = rawFunction.isChangedStructuralMatch();
            if (this.matchStateFilter == EMatchStateFilter.MATCHED_IDENTICAL && bl2) {
                return true;
            }
            if (this.matchStateFilter == EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES && bl3) {
                return true;
            }
            if (this.matchStateFilter == EMatchStateFilter.MATCHED_STRUTURAL_CHANGES && bl4) {
                return true;
            }
        } else if (rawFunction.getMatchState() != EMatchState.MATCHED && this.matchStateFilter == EMatchStateFilter.UNMATCHED) {
            return true;
        }
        return false;
    }

    private boolean filterSelection(CombinedViewNode combinedViewNode) {
        if (this.selectionFilter == ESelectionFilter.NONE) {
            return true;
        }
        if (combinedViewNode.isSelected() && this.selectionFilter == ESelectionFilter.SELECTED) {
            return true;
        }
        return !combinedViewNode.isSelected() && this.selectionFilter == ESelectionFilter.UNSELECTED;
    }

    private boolean filterSelection(SingleViewNode singleViewNode) {
        if (this.selectionFilter == ESelectionFilter.NONE) {
            return true;
        }
        if (singleViewNode.isSelected() && this.selectionFilter == ESelectionFilter.SELECTED) {
            return true;
        }
        return !singleViewNode.isSelected() && this.selectionFilter == ESelectionFilter.UNSELECTED;
    }

    private boolean filterSide(CombinedViewNode combinedViewNode) {
        IAddress iAddress = combinedViewNode.getAddress(ESide.PRIMARY);
        IAddress iAddress2 = combinedViewNode.getAddress(ESide.SECONDARY);
        if (this.sideFilter == ESideFilter.NONE) {
            return true;
        }
        if (iAddress != null && this.sideFilter == ESideFilter.PRIMARY) {
            return true;
        }
        return iAddress2 != null && this.sideFilter == ESideFilter.SECONDARY;
    }

    private boolean filterSide(SingleViewNode singleViewNode) {
        if (this.sideFilter == ESideFilter.NONE) {
            return true;
        }
        if (singleViewNode.getSide() == ESide.PRIMARY && this.sideFilter == ESideFilter.PRIMARY) {
            return true;
        }
        return singleViewNode.getSide() == ESide.SECONDARY && this.sideFilter == ESideFilter.SECONDARY;
    }

    private boolean filterVisibility(CombinedViewNode combinedViewNode) {
        if (this.visibilityFilter == EVisibilityFilter.NONE) {
            return true;
        }
        if (combinedViewNode.isVisible() && this.visibilityFilter == EVisibilityFilter.VISIBLE) {
            return true;
        }
        return !combinedViewNode.isVisible() && this.visibilityFilter == EVisibilityFilter.INVISIBLE;
    }

    private boolean filterVisibility(SingleViewNode singleViewNode) {
        if (this.visibilityFilter == EVisibilityFilter.NONE) {
            return true;
        }
        if (singleViewNode.isVisible() && this.visibilityFilter == EVisibilityFilter.VISIBLE) {
            return true;
        }
        return !singleViewNode.isVisible() && this.visibilityFilter == EVisibilityFilter.INVISIBLE;
    }

    private void setAddressRangeFilter(IAddress iAddress, IAddress iAddress2) {
        if (!this.startRangeAddr.equals(iAddress) || !this.endRangeAddr.equals(iAddress2)) {
            this.startRangeAddr = iAddress;
            this.endRangeAddr = iAddress2;
            this.notify = true;
        }
    }

    private void setMatchStateFilter(EMatchStateFilter eMatchStateFilter) {
        if (this.matchStateFilter != eMatchStateFilter) {
            this.matchStateFilter = eMatchStateFilter;
            this.notify = true;
        }
    }

    private void setSelectionFilter(ESelectionFilter eSelectionFilter) {
        if (this.selectionFilter != eSelectionFilter) {
            this.selectionFilter = eSelectionFilter;
            this.notify = true;
        }
    }

    private void setSideFilter(ESideFilter eSideFilter) {
        if (eSideFilter != this.sideFilter) {
            this.sideFilter = eSideFilter;
            this.notify = true;
        }
    }

    private void setVisibilityFilter(EVisibilityFilter eVisibilityFilter) {
        if (this.visibilityFilter != eVisibilityFilter) {
            this.visibilityFilter = eVisibilityFilter;
            this.notify = true;
        }
    }

    public void addListener(IGraphNodeMultiFilterListener iGraphNodeMultiFilterListener) {
        this.listeners.addListener(iGraphNodeMultiFilterListener);
    }

    public void clearSettings(boolean bl2) {
        this.matchStateFilter = EMatchStateFilter.NONE;
        this.selectionFilter = ESelectionFilter.NONE;
        this.visibilityFilter = EVisibilityFilter.NONE;
        this.sideFilter = ESideFilter.NONE;
        this.startRangeAddr = new CAddress(0L);
        this.endRangeAddr = new CAddress(-1L);
        if (bl2) {
            this.notifyListeners();
        }
    }

    public boolean filterRawBasicblock(RawBasicBlock rawBasicBlock) {
        return rawBasicBlock != null && this.filterAddressRange(rawBasicBlock) && this.filterMatchState(rawBasicBlock, this.priFlowgraph, this.secFlowgraph) && this.filterSelection(rawBasicBlock) && this.filterVisibility(rawBasicBlock) && this.filterSide(rawBasicBlock);
    }

    public boolean filterRawCombinedBasicblock(RawCombinedBasicBlock rawCombinedBasicBlock) {
        return rawCombinedBasicBlock != null && this.filterAddressRange(rawCombinedBasicBlock) && this.filterMatchState(rawCombinedBasicBlock) && this.filterSelection(rawCombinedBasicBlock) && this.filterVisibility(rawCombinedBasicBlock) && this.filterSide(rawCombinedBasicBlock);
    }

    public List<RawCombinedBasicBlock> filterRawCombinedBasicblocks(List<RawCombinedBasicBlock> list) {
        Preconditions.checkNotNull(this.addrRangeSide);
        ArrayList<RawCombinedBasicBlock> arrayList = new ArrayList<RawCombinedBasicBlock>();
        for (RawCombinedBasicBlock rawCombinedBasicBlock : list) {
            if (!this.filterRawCombinedBasicblock(rawCombinedBasicBlock)) continue;
            arrayList.add(rawCombinedBasicBlock);
        }
        return arrayList;
    }

    public boolean filterRawCombinedFunction(RawCombinedFunction rawCombinedFunction) {
        return rawCombinedFunction != null && this.filterAddressRange(rawCombinedFunction) && this.filterMatchState(rawCombinedFunction) && this.filterSelection(rawCombinedFunction) && this.filterVisibility(rawCombinedFunction) && this.filterSide(rawCombinedFunction);
    }

    public List<RawCombinedFunction> filterRawCombinedFunctions(List<RawCombinedFunction> list) {
        Preconditions.checkNotNull(this.addrRangeSide);
        ArrayList<RawCombinedFunction> arrayList = new ArrayList<RawCombinedFunction>();
        for (RawCombinedFunction rawCombinedFunction : list) {
            if (!this.filterRawCombinedFunction(rawCombinedFunction)) continue;
            arrayList.add(rawCombinedFunction);
        }
        return arrayList;
    }

    public boolean filterRawFunction(RawFunction rawFunction) {
        return rawFunction != null && this.filterAddressRange(rawFunction) && this.filterMatchState(rawFunction) && this.filterSelection(rawFunction) && this.filterVisibility(rawFunction) && this.filterSide(rawFunction);
    }

    public List<RawFunction> filterRawFunctions(List<RawFunction> list) {
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        for (RawFunction rawFunction : list) {
            if (!this.filterRawFunction(rawFunction)) continue;
            arrayList.add(rawFunction);
        }
        return arrayList;
    }

    public ESelectionFilter getSelectionFilterValue() {
        return this.selectionFilter;
    }

    public EVisibilityFilter getVisibilityFilterValue() {
        return this.visibilityFilter;
    }

    public void notifyListeners() {
        if (this.notify) {
            for (IGraphNodeMultiFilterListener iGraphNodeMultiFilterListener : this.listeners) {
                iGraphNodeMultiFilterListener.filterChanged(this);
            }
            this.notify = false;
        }
    }

    public void removeListener(IGraphNodeMultiFilterListener iGraphNodeMultiFilterListener) {
        this.listeners.removeListener(iGraphNodeMultiFilterListener);
    }

    public void setFilter(IAddress iAddress, IAddress iAddress2, EMatchStateFilter eMatchStateFilter, ESelectionFilter eSelectionFilter, EVisibilityFilter eVisibilityFilter, ESideFilter eSideFilter, boolean bl2) {
        this.setAddressRangeFilter(iAddress, iAddress2);
        this.setMatchStateFilter(eMatchStateFilter);
        this.setSelectionFilter(eSelectionFilter);
        this.setVisibilityFilter(eVisibilityFilter);
        this.setSideFilter(eSideFilter);
        if (bl2) {
            this.notifyListeners();
        }
    }
}

