/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.filter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GraphNodeFilter {
    private GraphNodeFilter() {
    }

    private static <NodeType extends ZyGraphNode<?>> int internalFilterNodes(Collection<NodeType> collection, Criterion criterion, Collection<NodeType> collection2) {
        Preconditions.checkNotNull(criterion);
        int n2 = 0;
        for (ZyGraphNode zyGraphNode : collection) {
            boolean bl2;
            switch (criterion) {
                case VISIBLE: {
                    bl2 = zyGraphNode.isVisible();
                    break;
                }
                case INVISIBLE: {
                    bl2 = !zyGraphNode.isVisible();
                    break;
                }
                case SELECTED: {
                    bl2 = zyGraphNode.isSelected();
                    break;
                }
                case SELECTED_VISIBLE: {
                    bl2 = zyGraphNode.isSelected() && zyGraphNode.isVisible();
                    break;
                }
                case UNSELECTED_VISIBLE: {
                    bl2 = !zyGraphNode.isSelected() && zyGraphNode.isVisible();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid node filter criterion");
                }
            }
            if (!bl2) continue;
            ++n2;
            if (collection2 == null) continue;
            collection2.add(zyGraphNode);
        }
        return n2;
    }

    private static <NodeType extends ZyGraphNode<?>> int internalFilterNodes(AbstractZyGraph<NodeType, ?> abstractZyGraph, Criterion criterion, Collection<NodeType> collection) {
        return GraphNodeFilter.internalFilterNodes(abstractZyGraph.getNodes(), criterion, collection);
    }

    public static <NodeType extends ZyGraphNode<?>> List<NodeType> filterNodes(AbstractZyGraph<NodeType, ?> abstractZyGraph, Criterion criterion) {
        ArrayList arrayList = new ArrayList();
        GraphNodeFilter.internalFilterNodes(abstractZyGraph, criterion, arrayList);
        return arrayList;
    }

    public static int filterNodesCountOnly(AbstractZyGraph<?, ?> abstractZyGraph, Criterion criterion) {
        return GraphNodeFilter.internalFilterNodes(abstractZyGraph, criterion, null);
    }

    public static <NodeType extends ZyGraphNode<?>> List<NodeType> filterNodes(Collection<NodeType> collection, Criterion criterion) {
        ArrayList arrayList = new ArrayList();
        GraphNodeFilter.internalFilterNodes(collection, criterion, arrayList);
        return arrayList;
    }

    public static enum Criterion {
        VISIBLE,
        INVISIBLE,
        SELECTED,
        SELECTED_VISIBLE,
        UNSELECTED_VISIBLE;

    }
}

