/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.eventhandlers;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutInitializer;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphReactivateViewSynchronization;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphSelectionUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserActivator;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserDeactivator;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUnhideNode;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityNodeClickedUpdater;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.util.logging.Level;

public class GraphLayoutEventHandler {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    private static void blockAllGraphsIntermediateListeners(BinDiffGraph<?, ?> binDiffGraph) {
        binDiffGraph.getIntermediateListeners().blockZyLibSelectionListeners();
        binDiffGraph.getIntermediateListeners().blockZyLibVisibilityListeners();
    }

    private static void freeAllGraphsIntermediateListeners(BinDiffGraph<?, ?> binDiffGraph) {
        binDiffGraph.getIntermediateListeners().freeZyLibVisibilityListeners();
        binDiffGraph.getIntermediateListeners().freeZyLibSelectionListeners();
    }

    public static void handleDoLayoutButtonEvent(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph, boolean bl2) {
        try {
            GraphLayoutUpdater.executeStatic(binDiffGraph, bl2);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
    }

    public static void handleInitialLayoutEvent(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            GraphLayoutInitializer.executeStatic(binDiffGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleProximityBrowsingActivatedEvent(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            ProximityBrowserActivator.executeStatic(binDiffGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleProximityBrowsingDeactivatedEvent(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        try {
            binDiffGraph.getSettings().getProximitySettings().setProximityBrowsing(false);
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            ProximityBrowserDeactivator.executeStatic(binDiffGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleProximityNodeClickedEvent(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            ProximityNodeClickedUpdater.executeStatic(binDiffGraph, zyProximityNode);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleReactivateViewSynchronization(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            GraphReactivateViewSynchronization.executeStatic(binDiffGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleSelectionChangedEvent(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, boolean bl2) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            GraphSelectionUpdater.executeStatic(binDiffGraph);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }

    public static void handleUnhideInvisibleNode(BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        try {
            GraphLayoutEventHandler.blockAllGraphsIntermediateListeners(binDiffGraph);
            ProximityBrowserUnhideNode.executeStatic(binDiffGraph, zyGraphNode);
        }
        catch (GraphLayoutException graphLayoutException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
            CMessageBox.showError(BinDiffGraph.getParentWindow(binDiffGraph), graphLayoutException.getMessage());
        }
        finally {
            GraphLayoutEventHandler.freeAllGraphsIntermediateListeners(binDiffGraph);
        }
    }
}

