/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.editmode.helpers;

import com.google.common.base.Strings;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.resources.Fonts;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.HtmlGenerator;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.CProximityNode;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class TooltipGenerationHelper {
    private static final int NODE_TOOLTIP_MAX_LINES = 25;
    private static final String MISSING_STRING = "missing";

    private static String createTwoSidedContent(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(String.format("<html><font face=\"%s\" size=\"3\" color=\"000000\">", string));
        stringBuilder.append("<table cellspacing=\"5\" border=\"0\" cellpadding=\"0\">");
        stringBuilder.append("<tr valign=\"middle\" align=\"left\">");
        stringBuilder.append("<td>");
        stringBuilder.append(string2);
        stringBuilder.append("</td>");
        stringBuilder.append("<td width=\"1\" bgcolor=\"#000000\"><br></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string3);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("</font></html>");
        return stringBuilder.toString();
    }

    private static String getHtml(ZyLabelContent zyLabelContent, String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(String.format("<html><font face=\"%s\" size=\"3\" color=\"000000\">", string));
        int n3 = Math.min(zyLabelContent.getLineCount(), 25);
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2 = zyLabelContent.getLineContent(i2).getText();
            if (i2 == 0 && string2.length() < n2) {
                for (int i3 = string2.length(); i3 < n2; ++i3) {
                    string2 = string2 + " ";
                }
            }
            stringBuilder.append(HtmlGenerator.escapeHtml(string2));
            stringBuilder.append("<br>");
        }
        if (zyLabelContent.getLineCount() > 25) {
            stringBuilder.append("...");
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</font></html>");
        return stringBuilder.toString();
    }

    private static int getMaxLineCharacterCount(SingleDiffNode singleDiffNode) {
        if (singleDiffNode == null) {
            return MISSING_STRING.length();
        }
        int n2 = 0;
        int n3 = 0;
        for (ZyLineContent zyLineContent : singleDiffNode.getRealizer().getNodeContent()) {
            n3 = Math.max(n3, zyLineContent.getText().length());
            if (++n2 <= 25) continue;
            return n3;
        }
        return n3;
    }

    public static String generateCombinedEdgeTooltips(String string, CombinedDiffNode combinedDiffNode, CombinedDiffNode combinedDiffNode2) {
        StringBuilder stringBuilder = new StringBuilder();
        SingleDiffNode singleDiffNode = combinedDiffNode.getPrimaryDiffNode();
        SingleDiffNode singleDiffNode2 = combinedDiffNode.getSecondaryDiffNode();
        SingleDiffNode singleDiffNode3 = combinedDiffNode2.getPrimaryDiffNode();
        SingleDiffNode singleDiffNode4 = combinedDiffNode2.getSecondaryDiffNode();
        int n2 = TooltipGenerationHelper.getMaxLineCharacterCount(singleDiffNode);
        n2 = Math.max(n2, TooltipGenerationHelper.getMaxLineCharacterCount(singleDiffNode3));
        int n3 = TooltipGenerationHelper.getMaxLineCharacterCount(singleDiffNode2);
        n3 = Math.max(n3, TooltipGenerationHelper.getMaxLineCharacterCount(singleDiffNode4));
        String string2 = TooltipGenerationHelper.generateCombinedNodeTooltip(string, singleDiffNode, singleDiffNode2, n2, n3);
        string2 = string2.replace("</html>", "");
        String string3 = TooltipGenerationHelper.generateCombinedNodeTooltip(string, singleDiffNode3, singleDiffNode4, n2, n3);
        string3 = string3.replace("<html>", "");
        stringBuilder.append(string2);
        stringBuilder.append("<hr></hr>");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String generateCombinedNodeTooltip(String string, SingleDiffNode singleDiffNode, SingleDiffNode singleDiffNode2, int n2, int n3) {
        Iterable<ZyLineContent> iterable;
        String string2 = Strings.padEnd(MISSING_STRING, n2 + 1, ' ');
        String string3 = Strings.padEnd(MISSING_STRING, n3 + 1, ' ');
        if (singleDiffNode != null) {
            iterable = singleDiffNode.getRealizer().getNodeContent();
            string2 = TooltipGenerationHelper.getHtml(iterable, Fonts.NORMAL_FONT.getName(), n2);
            string2 = string2.replace("<html>", "");
            string2 = string2.replace("</html>", "");
        } else {
            iterable = new ArrayList();
            iterable.add(string2);
            string2 = HtmlGenerator.getHtml(iterable, Fonts.NORMAL_FONT.getName(), false);
        }
        if (singleDiffNode2 != null) {
            iterable = singleDiffNode2.getRealizer().getNodeContent();
            string3 = TooltipGenerationHelper.getHtml(iterable, Fonts.NORMAL_FONT.getName(), n3);
            string3 = string3.replace("<html>", "");
            string3 = string3.replace("</html>", "");
        } else {
            iterable = new ArrayList();
            iterable.add((String)string3);
            string3 = HtmlGenerator.getHtml(iterable, Fonts.NORMAL_FONT.getName(), false);
        }
        return TooltipGenerationHelper.createTwoSidedContent(string, string2, string3);
    }

    public static <NodeType extends ZyGraphNode<?>> String generateProximityNodeTooltip(ZyProximityNode<?> zyProximityNode) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        List list = zyProximityNode.isIncoming() ? ((IGraphNode)((CProximityNode)zyProximityNode.getRawNode()).getAttachedNode()).getChildren() : ((IGraphNode)((CProximityNode)zyProximityNode.getRawNode()).getAttachedNode()).getParents();
        boolean bl2 = false;
        int n2 = 0;
        for (Object t2 : list) {
            SingleViewNode singleViewNode;
            IViewNode iViewNode = (IViewNode)t2;
            if (iViewNode.isVisible()) continue;
            if (bl2) {
                n2 = 0;
                break;
            }
            if (t2 instanceof RawFunction) {
                singleViewNode = (RawFunction)t2;
                linkedHashSet.add(String.format("%s  %s", singleViewNode.getAddress().toHexString(), ((RawFunction)singleViewNode).getName()));
            } else if (t2 instanceof RawBasicBlock) {
                singleViewNode = (RawBasicBlock)t2;
                linkedHashSet.add(singleViewNode.getAddress().toHexString());
            }
            if (++n2 != 25) continue;
            bl2 = true;
        }
        if (bl2 && n2 == 0) {
            linkedHashSet.add("...");
        }
        return HtmlGenerator.getHtml(linkedHashSet, GuiHelper.getMonospacedFont().getFontName(), false);
    }

    public static <NodeType extends ZyGraphNode<?>> String generateProximityNodeTooltip(String string, ZyProximityNode<?> zyProximityNode) {
        List list = zyProximityNode.isIncoming() ? ((IGraphNode)((CProximityNode)zyProximityNode.getRawNode()).getAttachedNode()).getChildren() : ((IGraphNode)((CProximityNode)zyProximityNode.getRawNode()).getAttachedNode()).getParents();
        boolean bl2 = false;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (Object t2 : list) {
            Object object;
            SingleViewNode singleViewNode;
            CombinedViewNode combinedViewNode;
            IViewNode iViewNode = (IViewNode)t2;
            if (iViewNode.isVisible()) continue;
            if (bl2) {
                n2 = 0;
                break;
            }
            if (t2 instanceof RawCombinedFunction) {
                combinedViewNode = (RawCombinedFunction)t2;
                singleViewNode = ((RawCombinedFunction)combinedViewNode).getRawNode(ESide.PRIMARY);
                object = singleViewNode == null ? MISSING_STRING : String.format("%s  %s", singleViewNode.getAddress().toHexString(), HtmlGenerator.escapeHtml(((RawFunction)singleViewNode).getName()));
                stringBuffer.append((String)object);
                RawFunction rawFunction = ((RawCombinedFunction)combinedViewNode).getRawNode(ESide.SECONDARY);
                String string2 = rawFunction == null ? MISSING_STRING : String.format("%s  %s", rawFunction.getAddress().toHexString(), HtmlGenerator.escapeHtml(rawFunction.getName()));
                stringBuffer2.append(string2);
            } else {
                if (!(t2 instanceof RawCombinedBasicBlock)) continue;
                combinedViewNode = (RawCombinedBasicBlock)t2;
                singleViewNode = ((RawCombinedBasicBlock)combinedViewNode).getRawNode(ESide.PRIMARY);
                stringBuffer.append(singleViewNode == null ? MISSING_STRING : singleViewNode.getAddress().toHexString());
                object = ((RawCombinedBasicBlock)combinedViewNode).getRawNode(ESide.SECONDARY);
                stringBuffer2.append(object == null ? MISSING_STRING : ((SingleViewNode)object).getAddress().toHexString());
            }
            stringBuffer.append("<br>");
            stringBuffer2.append("<br>");
            if (++n2 != 25) continue;
            bl2 = true;
        }
        if (bl2 && n2 == 0) {
            stringBuffer.append("...");
            stringBuffer2.append("...");
        }
        return TooltipGenerationHelper.createTwoSidedContent(string, stringBuffer.toString(), stringBuffer2.toString());
    }
}

