/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.builders;

import com.google.common.base.Strings;
import com.google.security.zynamics.bindiff.enums.EInstructionHighlighting;
import com.google.security.zynamics.bindiff.enums.EPlaceholderType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.BasicBlockCommentDelimiterLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.BasicBlockCommentLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.BasicBlockHeadLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.BasicBlockLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.CInstructionCommentLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.InstructionCommentDelimiterLineObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.InstructionObject;
import com.google.security.zynamics.bindiff.graph.labelcontent.editableline.PlaceholderObject;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstructionComment;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.bindiff.resources.Fonts;
import com.google.security.zynamics.bindiff.types.AddressPairComparator;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.Tokenizer.CMultiCommentLineTokenizer;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.strings.StringHelper;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ViewCodeNodeBuilder {
    private static final String ABOVE_INSTRUCTION_COMMENT_ESCAPE_STRING = "// ";
    private static final String BEHIND_INSTRUCTION_COMMENT_ESCAPE_STRING = " // ";
    private static final String BASICBLOCK_COMMENT_HEADLINE_STRING = "// Basic Block Commment: ";
    private static final String BASICBLOCK_COMMENT_ESCAPE_STRING = "// ";
    public static final int MAX_MNEMONIC_SIZE = 12;
    private static final String PADDING_AFTER_ADDRESS = "   ";
    private static final PlaceholderObject PLACEHOLDER_MATCHED_ABOVE_INSTRUCTION_COMMENT = new PlaceholderObject(EPlaceholderType.MATCHED_ABOVE_INSTRUCTION_COMMENT);
    private static final PlaceholderObject PLACEHOLDER_MATCHED_BEHIND_INSTRUCTION_COMMENT = new PlaceholderObject(EPlaceholderType.MATCHED_BEHIND_INSTRUCTION_COMMENT);
    private static final PlaceholderObject PLACEHOLDER_UNMATCHED_ABOVE_INSTRUCTION_COMMENT = new PlaceholderObject(EPlaceholderType.UNMATCHED_ABOVE_INSTRUCTION_COMMENT);
    private static final PlaceholderObject PLACEHOLDER_UNMATCHED_INSTRUCTION = new PlaceholderObject(EPlaceholderType.UNMATCHED_INSTRUCTION);
    private static final PlaceholderObject PLACEHOLDER_UNMATCHED_BEHIND_INSTRUCTION_COMMENT = new PlaceholderObject(EPlaceholderType.UNMATCHED_BEHIND_INSTRUCTION_COMMENT);
    private static final PlaceholderObject PLACEHOLDER_BASICBLOCK_COMMENT = new PlaceholderObject(EPlaceholderType.BASICBLOCK_COMMENT);

    private static void buildAddress(IAddress iAddress, StringBuffer stringBuffer, List<CStyleRunData> list) {
        String string = iAddress.toHexString() + PADDING_AFTER_ADDRESS;
        Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_ADDRESS);
        list.add(new CStyleRunData(stringBuffer.length(), string.length(), color));
        stringBuffer.append(string);
    }

    private static ZyLineContent buildHeadline(RawBasicBlock rawBasicBlock) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<CStyleRunData> arrayList = new ArrayList<CStyleRunData>();
        ViewCodeNodeBuilder.buildAddress(rawBasicBlock.getFunctionAddr(), stringBuffer, arrayList);
        Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_DEFAULT);
        arrayList.add(new CStyleRunData(stringBuffer.length(), -1, color));
        stringBuffer.append(rawBasicBlock.getFunctionName());
        BasicBlockHeadLineObject basicBlockHeadLineObject = new BasicBlockHeadLineObject(rawBasicBlock);
        return new ZyLineContent(stringBuffer.toString(), Fonts.BOLD_FONT, arrayList, basicBlockHeadLineObject);
    }

    private static void buildBasicblockComments(RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2, ZyLabelContent zyLabelContent, ESide eSide) {
        int n2 = 0;
        if (rawBasicBlock != null) {
            n2 = StringHelper.count(rawBasicBlock.getComment(), '\n');
        }
        if (rawBasicBlock2 != null) {
            n2 = Math.max(n2, StringHelper.count(rawBasicBlock2.getComment(), '\n'));
        }
        RawBasicBlock rawBasicBlock3 = eSide == ESide.PRIMARY ? rawBasicBlock : rawBasicBlock2;
        for (ZyLineContent zyLineContent : ViewCodeNodeBuilder.buildBasicblockComment(rawBasicBlock3, n2)) {
            zyLabelContent.addLineContent(zyLineContent);
        }
    }

    private static void buildMatchedCodeNodeContent(RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2, List<Pair<IAddress, IAddress>> list, ZyLabelContent zyLabelContent, ESide eSide) {
        int n2;
        int n3;
        RawInstruction rawInstruction;
        RawInstruction rawInstruction2;
        int n4;
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        if (eSide == ESide.PRIMARY) {
            zyLabelContent.addLineContent(ViewCodeNodeBuilder.buildHeadline(rawBasicBlock));
            n4 = rawBasicBlock.getMaxOperandLength();
            for (Pair<IAddress, IAddress> pair : list) {
                rawInstruction2 = null;
                if (rawBasicBlock != null && pair.first() != null) {
                    rawInstruction2 = rawBasicBlock.getInstruction(pair.first());
                }
                rawInstruction = null;
                if (rawBasicBlock2 != null && pair.second() != null) {
                    rawInstruction = rawBasicBlock2.getInstruction(pair.second());
                }
                n3 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction, ECommentPlacement.ABOVE_LINE);
                n2 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction, ECommentPlacement.BEHIND_LINE);
                arrayList.addAll(ViewCodeNodeBuilder.buildInstruction(rawInstruction2, n4, pair.second() == null, eSide, n3, n2));
            }
        } else {
            zyLabelContent.addLineContent(ViewCodeNodeBuilder.buildHeadline(rawBasicBlock2));
            n4 = rawBasicBlock2.getMaxOperandLength();
            for (Pair<IAddress, IAddress> pair : list) {
                rawInstruction2 = null;
                if (rawBasicBlock != null && pair.first() != null) {
                    rawInstruction2 = rawBasicBlock.getInstruction(pair.first());
                }
                rawInstruction = null;
                if (rawBasicBlock2 != null && pair.second() != null) {
                    rawInstruction = rawBasicBlock2.getInstruction(pair.second());
                }
                n3 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction, ECommentPlacement.ABOVE_LINE);
                n2 = ViewCodeNodeBuilder.precalcMaxCommentLineCount(rawInstruction2, rawInstruction, ECommentPlacement.BEHIND_LINE);
                arrayList.addAll(ViewCodeNodeBuilder.buildInstruction(rawInstruction, n4, pair.first() == null, eSide, n3, n2));
            }
        }
        for (ZyLineContent zyLineContent : arrayList) {
            zyLabelContent.addLineContent(zyLineContent);
        }
        ViewCodeNodeBuilder.buildBasicblockComments(rawBasicBlock, rawBasicBlock2, zyLabelContent, eSide);
    }

    private static void buildMnemonic(RawInstruction rawInstruction, StringBuffer stringBuffer, List<CStyleRunData> list) {
        if (rawInstruction.getMnemonic().length() == 0) {
            return;
        }
        String string = rawInstruction.getMnemonic();
        if (rawInstruction.getOperands().length > 0) {
            string = Strings.padEnd(string, rawInstruction.getMaxMnemonicLen(), ' ');
        }
        Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_MNEMONIC);
        list.add(new CStyleRunData(stringBuffer.length(), string.length(), color));
        stringBuffer.append(string);
    }

    private static boolean appendStyleRunData(ByteArrayOutputStream byteArrayOutputStream, Color color, StringBuffer stringBuffer, List<CStyleRunData> list) {
        if (byteArrayOutputStream == null || color == null) {
            return true;
        }
        if (byteArrayOutputStream.size() == 0) {
            return false;
        }
        String string = byteArrayOutputStream.toString();
        list.add(new CStyleRunData(stringBuffer.length(), string.length(), color));
        stringBuffer.append(string);
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static void buildOperands(RawInstruction rawInstruction, StringBuffer stringBuffer, List<CStyleRunData> list) {
        byte[] byArray = rawInstruction.getOperands();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Color color = null;
        for (byte by2 : byArray) {
            if (by2 > 0 && by2 < EInstructionHighlighting.getSize()) {
                if (!ViewCodeNodeBuilder.appendStyleRunData(byteArrayOutputStream, color, stringBuffer, list)) continue;
                color = EInstructionHighlighting.getColor(by2);
                byteArrayOutputStream.reset();
                continue;
            }
            byteArrayOutputStream.write(by2);
        }
        ViewCodeNodeBuilder.appendStyleRunData(byteArrayOutputStream, color, stringBuffer, list);
    }

    private static List<ZyLineContent> buildTrailingComment(RawInstruction rawInstruction, InstructionObject instructionObject, RawInstructionComment rawInstructionComment, StringBuffer stringBuffer, List<CStyleRunData> list, int n2, boolean bl2, ESide eSide, int n3) {
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        String string = "";
        if (rawInstructionComment != null) {
            int n4 = stringBuffer.length();
            int n5 = rawInstruction.getAddress().toHexString().length() + PADDING_AFTER_ADDRESS.length() + 12 + n2;
            Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_COMMENT);
            string = rawInstructionComment.getText();
            CMultiCommentLineTokenizer cMultiCommentLineTokenizer = new CMultiCommentLineTokenizer(string, "\n");
            boolean bl3 = true;
            while (cMultiCommentLineTokenizer.hasMoreTokens()) {
                CStyleRunData cStyleRunData;
                Object object;
                CStyleRunData cStyleRunData2;
                InstructionCommentDelimiterLineObject instructionCommentDelimiterLineObject;
                Object object2;
                String string2 = cMultiCommentLineTokenizer.nextToken();
                if (bl3) {
                    bl3 = false;
                    object2 = Strings.repeat(" ", Math.max(0, n5 - n4));
                    object2 = (String)object2 + BEHIND_INSTRUCTION_COMMENT_ESCAPE_STRING;
                    int n6 = ((String)object2).length();
                    instructionCommentDelimiterLineObject = new InstructionCommentDelimiterLineObject(rawInstruction, rawInstructionComment.getPlacement(), n4, n6);
                    cStyleRunData2 = new CStyleRunData(n4, n6, color, instructionCommentDelimiterLineObject);
                    list.add(cStyleRunData2);
                    stringBuffer.append((String)object2);
                    if (!string2.isEmpty()) {
                        object = new CInstructionCommentLineObject(rawInstruction, rawInstructionComment.getPlacement(), stringBuffer.length(), string2.length());
                        cStyleRunData = new CStyleRunData(stringBuffer.length(), string2.length(), color, (IZyEditableObject)object);
                        list.add(cStyleRunData);
                        stringBuffer.append(string2);
                    }
                    object = new ZyLineContent(stringBuffer.toString(), Fonts.NORMAL_FONT, list, instructionObject);
                    if (bl2) {
                        ((ZyLineContent)object).setBackgroundColor(0, n4, eSide == ESide.PRIMARY ? Colors.PRIMARY_BASE : Colors.SECONDARY_BASE);
                    }
                    arrayList.add((ZyLineContent)object);
                    continue;
                }
                object2 = new ArrayList();
                String string3 = String.format("%s%s", Strings.repeat(" ", n5), BEHIND_INSTRUCTION_COMMENT_ESCAPE_STRING);
                instructionCommentDelimiterLineObject = new InstructionCommentDelimiterLineObject(rawInstruction, rawInstructionComment.getPlacement(), 0, string3.length());
                cStyleRunData2 = new CStyleRunData(0, string3.length(), color, instructionCommentDelimiterLineObject);
                object2.add(cStyleRunData2);
                if (!string2.equals("")) {
                    object = new CInstructionCommentLineObject(rawInstruction, rawInstructionComment.getPlacement(), string3.length(), string2.length());
                    cStyleRunData = new CStyleRunData(string3.length(), string2.length(), color, (IZyEditableObject)object);
                    object2.add(cStyleRunData);
                    string3 = string3 + string2;
                }
                object = new ZyLineContent(string3, Fonts.NORMAL_FONT, (List<CStyleRunData>)object2, instructionObject);
                arrayList.add((ZyLineContent)object);
            }
        }
        if (string.isEmpty()) {
            ZyLineContent zyLineContent = new ZyLineContent(stringBuffer.toString(), Fonts.NORMAL_FONT, list, instructionObject);
            if (bl2) {
                zyLineContent.setBackgroundColor(0, stringBuffer.length(), eSide == ESide.PRIMARY ? Colors.PRIMARY_BASE : Colors.SECONDARY_BASE);
            }
            arrayList.add(zyLineContent);
        }
        if (arrayList.size() < n3) {
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(n3 - arrayList.size(), EPlaceholderType.MATCHED_BEHIND_INSTRUCTION_COMMENT));
        }
        return arrayList;
    }

    private static List<ZyLineContent> buildTopComment(RawInstruction rawInstruction, InstructionObject instructionObject, RawInstructionComment rawInstructionComment, int n2) {
        ArrayList<ZyLineContent> arrayList;
        if (rawInstructionComment == null) {
            return ViewCodeNodeBuilder.buildPlaceholderLines(n2, EPlaceholderType.MATCHED_ABOVE_INSTRUCTION_COMMENT);
        }
        ArrayList<ZyLineContent> arrayList2 = new ArrayList<ZyLineContent>();
        String string = rawInstructionComment.getText();
        CMultiCommentLineTokenizer cMultiCommentLineTokenizer = new CMultiCommentLineTokenizer(string, "\n");
        Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_COMMENT);
        while (cMultiCommentLineTokenizer.hasMoreTokens()) {
            arrayList = new ArrayList<ZyLineContent>();
            String string2 = "// ";
            InstructionCommentDelimiterLineObject instructionCommentDelimiterLineObject = new InstructionCommentDelimiterLineObject(rawInstruction, rawInstructionComment.getPlacement(), 0, string2.length());
            CStyleRunData cStyleRunData = new CStyleRunData(0, string2.length(), color, instructionCommentDelimiterLineObject);
            arrayList.add((ZyLineContent)((Object)cStyleRunData));
            String string3 = cMultiCommentLineTokenizer.nextToken();
            CInstructionCommentLineObject cInstructionCommentLineObject = new CInstructionCommentLineObject(rawInstruction, rawInstructionComment.getPlacement(), string2.length(), string3.length());
            string2 = string2 + string3;
            CStyleRunData cStyleRunData2 = new CStyleRunData(0, string2.length(), color, cInstructionCommentLineObject);
            arrayList.add((ZyLineContent)((Object)cStyleRunData2));
            ZyLineContent zyLineContent = new ZyLineContent(string2, Fonts.NORMAL_FONT, arrayList, instructionObject);
            arrayList2.add(zyLineContent);
        }
        if (arrayList2.size() < n2) {
            arrayList = new ArrayList();
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(n2 - arrayList2.size(), EPlaceholderType.MATCHED_ABOVE_INSTRUCTION_COMMENT));
            arrayList.addAll(arrayList2);
            return arrayList;
        }
        return arrayList2;
    }

    private static void buildUnmatchedCodeNodeContent(RawBasicBlock rawBasicBlock, ZyLabelContent zyLabelContent) {
        zyLabelContent.addLineContent(ViewCodeNodeBuilder.buildHeadline(rawBasicBlock));
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        int n2 = rawBasicBlock.getMaxOperandLength();
        for (RawInstruction object : rawBasicBlock) {
            arrayList.addAll(ViewCodeNodeBuilder.buildInstruction(object, n2, false, null, 0, 0));
        }
        for (ZyLineContent zyLineContent : arrayList) {
            zyLabelContent.addLineContent(zyLineContent);
        }
        ViewCodeNodeBuilder.buildBasicblockComments(rawBasicBlock.getSide() == ESide.PRIMARY ? rawBasicBlock : null, rawBasicBlock.getSide() == ESide.SECONDARY ? rawBasicBlock : null, zyLabelContent, rawBasicBlock.getSide());
    }

    private static List<Pair<IAddress, IAddress>> getMatchedFunctionsBasicblockInstructionAddressPairs(FunctionMatchData functionMatchData, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, IAddress iAddress, IAddress iAddress2) {
        ArrayList<Pair<IAddress, IAddress>> arrayList;
        block6: {
            RawFlowGraph rawFlowGraph;
            block7: {
                RawFlowGraph rawFlowGraph2;
                block5: {
                    arrayList = new ArrayList<Pair<IAddress, IAddress>>();
                    rawFlowGraph2 = rawCombinedFlowGraph.getPrimaryFlowgraph();
                    rawFlowGraph = rawCombinedFlowGraph.getSecondaryFlowgraph();
                    if (iAddress == null || iAddress2 == null) break block5;
                    BasicBlockMatchData basicBlockMatchData = functionMatchData.getBasicBlockMatch(iAddress, ESide.PRIMARY);
                    for (InstructionMatchData entry : basicBlockMatchData.getInstructionMatches()) {
                        arrayList.add(new Pair<IAddress, IAddress>(entry.getIAddress(ESide.PRIMARY), entry.getIAddress(ESide.SECONDARY)));
                    }
                    RawBasicBlock rawBasicBlock = rawFlowGraph2.getBasicblock(iAddress);
                    for (Map.Entry<IAddress, RawInstruction> entry : rawBasicBlock.getInstructions().entrySet()) {
                        if (basicBlockMatchData.getInstructionMatch(entry.getKey(), ESide.PRIMARY) != null) continue;
                        arrayList.add(new Pair<IAddress, Object>(entry.getKey(), null));
                    }
                    RawBasicBlock rawBasicBlock2 = rawFlowGraph.getBasicblock(iAddress2);
                    for (Map.Entry<IAddress, RawInstruction> entry : rawBasicBlock2.getInstructions().entrySet()) {
                        if (basicBlockMatchData.getInstructionMatch(entry.getKey(), ESide.SECONDARY) != null) continue;
                        arrayList.add(new Pair<Object, IAddress>(null, entry.getKey()));
                    }
                    break block6;
                }
                if (iAddress == null) break block7;
                RawBasicBlock rawBasicBlock = rawFlowGraph2.getBasicblock(iAddress);
                for (Map.Entry<IAddress, RawInstruction> entry : rawBasicBlock.getInstructions().entrySet()) {
                    arrayList.add(new Pair<IAddress, Object>(entry.getKey(), null));
                }
                break block6;
            }
            if (iAddress2 == null) break block6;
            RawBasicBlock rawBasicBlock = rawFlowGraph.getBasicblock(iAddress2);
            for (Map.Entry<IAddress, RawInstruction> entry : rawBasicBlock.getInstructions().entrySet()) {
                arrayList.add(new Pair<Object, IAddress>(null, entry.getKey()));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Pair<IAddress, IAddress>> getMatchedFunctionsBasicblockInstructionAddressPairs(FunctionMatchData functionMatchData, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, IAddress iAddress, IAddress iAddress2, ESide eSide) {
        void var9_16;
        ArrayList<Pair<IAddress, IAddress>> arrayList = new ArrayList<Pair<IAddress, IAddress>>(ViewCodeNodeBuilder.getMatchedFunctionsBasicblockInstructionAddressPairs(functionMatchData, rawCombinedFlowGraph, iAddress, iAddress2));
        ArrayList<void> arrayList2 = new ArrayList<void>();
        ArrayList<void> arrayList3 = new ArrayList<void>();
        for (Pair n3 : arrayList) {
            void object2;
            if (ESide.SECONDARY == eSide) {
                Pair<IAddress, IAddress> pair = new Pair<IAddress, IAddress>((IAddress)n3.second(), (IAddress)n3.first());
            }
            if (object2.first() != null) {
                arrayList2.add(object2);
            }
            if (object2.second() == null) continue;
            arrayList3.add(object2);
        }
        Collections.sort(arrayList2, new AddressPairComparator(ESide.PRIMARY));
        Collections.sort(arrayList3, new AddressPairComparator(ESide.SECONDARY));
        arrayList.clear();
        if (arrayList2.size() == 0) {
            arrayList = arrayList3;
        }
        if (arrayList3.size() == 0) {
            arrayList = arrayList2;
        }
        if (arrayList2.size() != 0 && arrayList3.size() != 0) {
            int n2 = 0;
            for (Pair pair : arrayList2) {
                if (pair.second() == null) {
                    arrayList.add(pair);
                    continue;
                }
                if (n2 >= arrayList3.size()) continue;
                boolean bl2 = true;
                while (bl2) {
                    Pair pair2 = (Pair)arrayList3.get(n2);
                    if (pair2.first() == null) {
                        arrayList.add(pair2);
                    } else {
                        bl2 = false;
                    }
                    if (++n2 < arrayList3.size()) continue;
                    bl2 = false;
                }
                arrayList.add(pair);
            }
        }
        ArrayList arrayList4 = new ArrayList();
        int n2 = arrayList3.size();
        while (var9_16 > 0 && ((Pair)arrayList3.get((int)(--var9_16))).first() == null) {
            arrayList4.add((Pair)arrayList3.get((int)var9_16));
        }
        Collections.sort(arrayList4, new AddressPairComparator(ESide.SECONDARY));
        arrayList.addAll(arrayList4);
        ArrayList<Pair<IAddress, IAddress>> arrayList5 = arrayList;
        if (ESide.SECONDARY == eSide) {
            arrayList5.clear();
            for (Pair pair : arrayList) {
                arrayList5.add(new Pair<IAddress, IAddress>((IAddress)pair.second(), (IAddress)pair.first()));
            }
        }
        return arrayList5;
    }

    public static List<ZyLineContent> buildBasicblockComment(RawBasicBlock rawBasicBlock, int n2) {
        Color color = EInstructionHighlighting.getColor(EInstructionHighlighting.TYPE_COMMENT);
        BasicBlockLineObject basicBlockLineObject = new BasicBlockLineObject(rawBasicBlock);
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        String string = rawBasicBlock.getComment();
        boolean bl2 = true;
        CMultiCommentLineTokenizer cMultiCommentLineTokenizer = new CMultiCommentLineTokenizer(string, "\n");
        int n3 = 0;
        while (cMultiCommentLineTokenizer.hasMoreTokens()) {
            ++n3;
            String string2 = cMultiCommentLineTokenizer.nextToken();
            String string3 = "// " + string2;
            int n4 = "// ".length();
            if (bl2) {
                string3 = BASICBLOCK_COMMENT_HEADLINE_STRING + string2;
                n4 = BASICBLOCK_COMMENT_HEADLINE_STRING.length();
                bl2 = false;
            }
            BasicBlockCommentDelimiterLineObject basicBlockCommentDelimiterLineObject = new BasicBlockCommentDelimiterLineObject(rawBasicBlock, 0, n4);
            BasicBlockCommentLineObject basicBlockCommentLineObject = new BasicBlockCommentLineObject(rawBasicBlock, n4, string2.length());
            ArrayList<CStyleRunData> arrayList2 = new ArrayList<CStyleRunData>();
            arrayList2.add(new CStyleRunData(0, n4, color, basicBlockCommentDelimiterLineObject));
            arrayList2.add(new CStyleRunData(n4, string2.length(), color, basicBlockCommentLineObject));
            arrayList.add(new ZyLineContent(string3, Fonts.NORMAL_FONT, arrayList2, basicBlockLineObject));
        }
        if (n3 < n2) {
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(n2 - n3, EPlaceholderType.BASICBLOCK_COMMENT));
        }
        return arrayList;
    }

    public static List<ZyLineContent> buildInstruction(RawInstruction rawInstruction, int n2, boolean bl2, ESide eSide, int n3, int n4) {
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<CStyleRunData> arrayList2 = new ArrayList<CStyleRunData>();
        if (rawInstruction != null) {
            RawInstructionComment rawInstructionComment = null;
            RawInstructionComment rawInstructionComment2 = null;
            if (rawInstruction.hasComments()) {
                for (RawInstructionComment rawInstructionComment3 : rawInstruction.getComments()) {
                    if (rawInstructionComment3.getPlacement() == ECommentPlacement.ABOVE_LINE) {
                        rawInstructionComment = rawInstructionComment3;
                        continue;
                    }
                    if (rawInstructionComment3.getPlacement() != ECommentPlacement.BEHIND_LINE) continue;
                    rawInstructionComment2 = rawInstructionComment3;
                }
            }
            ViewCodeNodeBuilder.buildAddress(rawInstruction.getAddress(), stringBuffer, arrayList2);
            ViewCodeNodeBuilder.buildMnemonic(rawInstruction, stringBuffer, arrayList2);
            ViewCodeNodeBuilder.buildOperands(rawInstruction, stringBuffer, arrayList2);
            InstructionObject instructionObject = new InstructionObject(rawInstruction, 0, stringBuffer.length());
            arrayList.addAll(ViewCodeNodeBuilder.buildTopComment(rawInstruction, instructionObject, rawInstructionComment, n3));
            arrayList.addAll(ViewCodeNodeBuilder.buildTrailingComment(rawInstruction, instructionObject, rawInstructionComment2, stringBuffer, arrayList2, n2, bl2, eSide, n4));
        } else {
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(n3, EPlaceholderType.UNMATCHED_ABOVE_INSTRUCTION_COMMENT));
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(1, EPlaceholderType.UNMATCHED_INSTRUCTION));
            arrayList.addAll(ViewCodeNodeBuilder.buildPlaceholderLines(n4 - 1, EPlaceholderType.UNMATCHED_BEHIND_INSTRUCTION_COMMENT));
        }
        return arrayList;
    }

    public static List<ZyLineContent> buildPlaceholderLines(int n2, EPlaceholderType ePlaceholderType) {
        ArrayList<ZyLineContent> arrayList = new ArrayList<ZyLineContent>();
        PlaceholderObject placeholderObject = null;
        switch (ePlaceholderType) {
            case MATCHED_ABOVE_INSTRUCTION_COMMENT: {
                placeholderObject = PLACEHOLDER_MATCHED_ABOVE_INSTRUCTION_COMMENT;
                break;
            }
            case MATCHED_BEHIND_INSTRUCTION_COMMENT: {
                placeholderObject = PLACEHOLDER_MATCHED_BEHIND_INSTRUCTION_COMMENT;
                break;
            }
            case UNMATCHED_ABOVE_INSTRUCTION_COMMENT: {
                placeholderObject = PLACEHOLDER_UNMATCHED_ABOVE_INSTRUCTION_COMMENT;
                break;
            }
            case UNMATCHED_INSTRUCTION: {
                placeholderObject = PLACEHOLDER_UNMATCHED_INSTRUCTION;
                break;
            }
            case UNMATCHED_BEHIND_INSTRUCTION_COMMENT: {
                placeholderObject = PLACEHOLDER_UNMATCHED_BEHIND_INSTRUCTION_COMMENT;
                break;
            }
            case BASICBLOCK_COMMENT: {
                placeholderObject = PLACEHOLDER_BASICBLOCK_COMMENT;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ZyLineContent zyLineContent = new ZyLineContent("\t", Fonts.NORMAL_FONT, placeholderObject);
            arrayList.add(zyLineContent);
        }
        return arrayList;
    }

    public static void buildSingleCodeNodeContent(FunctionMatchData functionMatchData, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, RawCombinedBasicBlock rawCombinedBasicBlock, ZyLabelContent zyLabelContent, ESide eSide) {
        RawBasicBlock rawBasicBlock = rawCombinedBasicBlock.getRawNode(ESide.PRIMARY);
        RawBasicBlock rawBasicBlock2 = rawCombinedBasicBlock.getRawNode(ESide.SECONDARY);
        if (eSide == ESide.PRIMARY) {
            if (rawBasicBlock2 == null) {
                ViewCodeNodeBuilder.buildUnmatchedCodeNodeContent(rawBasicBlock, zyLabelContent);
                return;
            }
        } else if (rawBasicBlock == null) {
            ViewCodeNodeBuilder.buildUnmatchedCodeNodeContent(rawBasicBlock2, zyLabelContent);
            return;
        }
        IAddress iAddress = rawCombinedBasicBlock.getAddress(ESide.PRIMARY);
        IAddress iAddress2 = rawCombinedBasicBlock.getAddress(ESide.SECONDARY);
        List<Pair<IAddress, IAddress>> list = ViewCodeNodeBuilder.getMatchedFunctionsBasicblockInstructionAddressPairs(functionMatchData, rawCombinedFlowGraph, iAddress, iAddress2, ESide.PRIMARY);
        RawBasicBlock rawBasicBlock3 = rawCombinedFlowGraph.getPrimaryFlowgraph().getBasicblock(iAddress);
        RawBasicBlock rawBasicBlock4 = rawCombinedFlowGraph.getSecondaryFlowgraph().getBasicblock(iAddress2);
        ViewCodeNodeBuilder.buildMatchedCodeNodeContent(rawBasicBlock3, rawBasicBlock4, list, zyLabelContent, eSide);
    }

    public static int precalcMaxCommentLineCount(RawInstruction rawInstruction, RawInstruction rawInstruction2, ECommentPlacement eCommentPlacement) {
        int n2;
        int n3 = eCommentPlacement == ECommentPlacement.BEHIND_LINE ? 1 : 0;
        int n4 = n2 = eCommentPlacement == ECommentPlacement.BEHIND_LINE ? 1 : 0;
        if (rawInstruction != null && rawInstruction.hasComments()) {
            for (RawInstructionComment rawInstructionComment : rawInstruction.getComments()) {
                if (eCommentPlacement != rawInstructionComment.getPlacement() || rawInstructionComment.getText().isEmpty()) continue;
                n3 = StringHelper.count(rawInstructionComment.getText(), '\n') + 1;
            }
        }
        if (rawInstruction2 != null && rawInstruction2.getComments() != null) {
            for (RawInstructionComment rawInstructionComment : rawInstruction2.getComments()) {
                if (eCommentPlacement != rawInstructionComment.getPlacement() || rawInstructionComment.getText().isEmpty()) continue;
                n2 = StringHelper.count(rawInstructionComment.getText(), '\n') + 1;
            }
        }
        return Math.max(n3, n2);
    }
}

