/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.backgroundrendering;

import a.h.F;
import a.h.ar;
import com.google.security.zynamics.bindiff.enums.EGraph;
import com.google.security.zynamics.bindiff.graph.backgroundrendering.BackgroundRendererManager;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImageBackgroundRenderer
extends F {
    private static final int OFFSET = 15;
    private final Image primaryTextImage = ImageUtils.getImage("data/graphview/primary.png");
    private final Image secondaryTextImage = ImageUtils.getImage("data/graphview/secondary.png");
    private final Image combinedTextImage = ImageUtils.getImage("data/graphview/combined.png");
    private final ar graphView;
    private final EGraph type;
    private int oldViewWidth = 0;
    private int oldViewHeight = 0;
    private BufferedImage backgroundImage;
    private final String title;

    ImageBackgroundRenderer(ViewData viewData, ar ar2, EGraph eGraph) {
        super(ar2);
        this.graphView = ar2;
        this.type = eGraph;
        this.title = BackgroundRendererManager.buildTitle(viewData, eGraph);
    }

    private Image getTextImage() {
        if (this.type == EGraph.PRIMARY_GRAPH) {
            return this.primaryTextImage;
        }
        if (this.type == EGraph.SECONDARY_GRAPH) {
            return this.secondaryTextImage;
        }
        return this.combinedTextImage;
    }

    private int getX(int n2, int n3) {
        if (this.type == EGraph.SECONDARY_GRAPH) {
            int n4 = 15;
            if (this.graphView.getVerticalScrollBarPolicy() == 22) {
                n4 += 15;
            }
            return n2 - n3 - n4;
        }
        return 15;
    }

    @Override
    public void paint(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        if (graphics2D == null) {
            return;
        }
        int n6 = this.graphView.getWidth();
        int n7 = this.graphView.getHeight();
        if (n6 != this.oldViewWidth || n7 != this.oldViewHeight && n6 != 0 && n7 != 0) {
            this.oldViewWidth = n6;
            this.oldViewHeight = n7;
            this.backgroundImage = new BufferedImage(n6, n7, 1);
        }
        if (this.backgroundImage != null) {
            int n8;
            Graphics2D graphics2D2 = (Graphics2D)this.backgroundImage.getGraphics();
            graphics2D2.setPaint(Color.WHITE);
            graphics2D2.fill(new Rectangle2D.Double(0.0, 0.0, n6, n7));
            graphics2D2.setPaint(Color.GRAY.darker());
            int n9 = n8 = this.getX(n6, this.secondaryTextImage.getWidth(null));
            Font font = graphics2D2.getFont();
            graphics2D2.setFont(new Font(font.getName(), 1, font.getSize()));
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.type == EGraph.SECONDARY_GRAPH) {
                Rectangle2D rectangle2D = graphics2D2.getFont().getStringBounds(this.title, graphics2D2.getFontRenderContext());
                n9 = this.getX(n6, Math.max(15, (int)rectangle2D.getWidth()));
            }
            graphics2D2.drawString(this.title, n9, 15);
            graphics2D2.drawImage(this.getTextImage(), n8, 20, null);
            graphics2D2.setFont(font);
            this.setImage(this.backgroundImage);
        }
        super.paint(graphics2D, n2, n3, n4, n5);
    }

    public void update() {
        EventQueue.invokeLater(() -> this.graphView.getGraph2D().updateViews());
    }
}

