/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.backgroundrendering;

import a.h.ar;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraph;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.backgroundrendering.ImageBackgroundRenderer;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettingsChangedListenerAdapter;
import com.google.security.zynamics.bindiff.project.userview.CallGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public class BackgroundRendererManager
extends GraphSettingsChangedListenerAdapter {
    private final GraphSettings settings;
    private final ImageBackgroundRenderer imageBackgroundRenderer;

    public BackgroundRendererManager(ViewData viewData, ar ar2, EGraph eGraph, GraphSettings graphSettings) {
        Preconditions.checkNotNull(viewData);
        Preconditions.checkNotNull(eGraph);
        this.settings = Preconditions.checkNotNull(graphSettings);
        this.imageBackgroundRenderer = new ImageBackgroundRenderer(viewData, ar2, eGraph);
        ar2.setBackgroundRenderer(this.imageBackgroundRenderer);
        graphSettings.addListener(this);
    }

    static String buildTitle(ViewData viewData, EGraph eGraph) {
        if (viewData instanceof FlowGraphViewData) {
            FlowGraphViewData flowGraphViewData = (FlowGraphViewData)viewData;
            Joiner joiner = Joiner.on(" ").skipNulls();
            switch (eGraph) {
                case PRIMARY_GRAPH: {
                    IAddress iAddress = flowGraphViewData.getAddress(ESide.PRIMARY);
                    return iAddress == null ? "" : iAddress + " " + flowGraphViewData.getFunctionName(ESide.PRIMARY);
                }
                case SECONDARY_GRAPH: {
                    IAddress iAddress = flowGraphViewData.getAddress(ESide.SECONDARY);
                    return iAddress == null ? "" : flowGraphViewData.getFunctionName(ESide.SECONDARY) + " " + iAddress;
                }
                case COMBINED_GRAPH: {
                    IAddress iAddress = flowGraphViewData.getAddress(ESide.PRIMARY);
                    String string = flowGraphViewData.getFunctionName(ESide.PRIMARY);
                    IAddress iAddress2 = flowGraphViewData.getAddress(ESide.SECONDARY);
                    String string2 = flowGraphViewData.getFunctionName(ESide.SECONDARY);
                    return joiner.join(iAddress, string, iAddress == null || iAddress2 == null ? "" : "   vs   ", iAddress2, string2);
                }
            }
        } else if (viewData instanceof CallGraphViewData) {
            CallGraphViewData callGraphViewData = (CallGraphViewData)viewData;
            switch (eGraph) {
                case PRIMARY_GRAPH: {
                    return callGraphViewData.getImageName(ESide.PRIMARY);
                }
                case SECONDARY_GRAPH: {
                    return callGraphViewData.getImageName(ESide.SECONDARY);
                }
                case COMBINED_GRAPH: {
                    return String.format("%s vs %s", callGraphViewData.getImageName(ESide.PRIMARY), callGraphViewData.getImageName(ESide.SECONDARY));
                }
            }
        }
        return "";
    }

    public void removeListener() {
        this.settings.removeListener(this);
    }

    @Override
    public void diffViewModeChanged(GraphSettings graphSettings) {
        this.imageBackgroundRenderer.update();
    }
}

