/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph;

import a.c.d;
import a.c.p;
import a.h.bQ;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperViewNode;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.SuperGraphSearcher;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.zylib.gui.zygraph.edges.ZyEdgeData;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ZyNodeData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyNormalNodeRealizer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class SuperGraph
extends BinDiffGraph<SuperDiffNode, SuperDiffEdge> {
    private static final int NODELABEL_PADDING = 10;
    private GraphSearcher graphSearcher = new SuperGraphSearcher();

    public SuperGraph(ZyGraph2DView zyGraph2DView, LinkedHashMap<p, SuperDiffNode> linkedHashMap, LinkedHashMap<d, SuperDiffEdge> linkedHashMap2, SingleGraph singleGraph, SingleGraph singleGraph2, GraphSettings graphSettings, EGraphType eGraphType) {
        super(zyGraph2DView, linkedHashMap, linkedHashMap2, graphSettings, eGraphType);
        Preconditions.checkArgument(singleGraph != null || singleGraph2 != null, "Primary graph and secondary graph cannot both be null");
    }

    public static SuperDiffEdge buildDiffEdge(SuperGraph superGraph, SuperViewEdge<? extends SuperViewNode> superViewEdge, SingleDiffEdge singleDiffEdge, SingleDiffEdge singleDiffEdge2) {
        d d2 = null;
        ZyLabelContent zyLabelContent = new ZyLabelContent(null);
        ZyEdgeRealizer<SuperDiffEdge> zyEdgeRealizer = new ZyEdgeRealizer<SuperDiffEdge>(zyLabelContent, null);
        ZyGraphNode zyGraphNode = null;
        ZyGraphNode zyGraphNode2 = null;
        if (singleDiffEdge != null) {
            zyGraphNode = ((SingleDiffNode)singleDiffEdge.getSource()).getSuperDiffNode();
            zyGraphNode2 = ((SingleDiffNode)singleDiffEdge.getTarget()).getSuperDiffNode();
        } else if (singleDiffEdge2 != null) {
            zyGraphNode = ((SingleDiffNode)singleDiffEdge2.getSource()).getSuperDiffNode();
            zyGraphNode2 = ((SingleDiffNode)singleDiffEdge2.getTarget()).getSuperDiffNode();
        }
        p p2 = zyGraphNode.getNode();
        p p3 = zyGraphNode2.getNode();
        boolean bl2 = ((SuperDiffNode)zyGraphNode).getRawNode().isVisible();
        boolean bl3 = ((SuperDiffNode)zyGraphNode2).getRawNode().isVisible();
        ((SuperDiffNode)zyGraphNode).getRawNode().setVisible(true);
        ((SuperDiffNode)zyGraphNode2).getRawNode().setVisible(true);
        d2 = superGraph.getGraph().c(p2, p3);
        SuperDiffEdge superDiffEdge = new SuperDiffEdge((SuperDiffNode)zyGraphNode, (SuperDiffNode)zyGraphNode2, d2, zyEdgeRealizer, superViewEdge, singleDiffEdge, singleDiffEdge2);
        SuperDiffNode.link((SuperDiffNode)zyGraphNode, (SuperDiffNode)zyGraphNode2);
        zyEdgeRealizer.setUserData(new ZyEdgeData<SuperDiffEdge>(superDiffEdge));
        ((SuperDiffNode)zyGraphNode).getRawNode().setVisible(bl2);
        ((SuperDiffNode)zyGraphNode2).getRawNode().setVisible(bl3);
        superGraph.addEdgeToMappings(superDiffEdge);
        return superDiffEdge;
    }

    public static SuperDiffNode buildDiffNode(SuperGraph superGraph, SingleDiffNode singleDiffNode, SingleDiffNode singleDiffNode2, SuperViewNode superViewNode) {
        ZyLabelContent zyLabelContent = new ZyLabelContent(null);
        ZyNormalNodeRealizer zyNormalNodeRealizer = new ZyNormalNodeRealizer(zyLabelContent);
        p p2 = superGraph.getGraph().an();
        SuperDiffNode superDiffNode = new SuperDiffNode(p2, zyNormalNodeRealizer, superViewNode, singleDiffNode, singleDiffNode2);
        zyNormalNodeRealizer.setUserData(new ZyNodeData<SuperDiffNode>(superDiffNode));
        return superDiffNode;
    }

    private void synchronizeSize(SingleGraph singleGraph, SingleGraph singleGraph2, SuperDiffNode superDiffNode) {
        if (superDiffNode.getRawNode().getCombinedNode().getMatchState() != EMatchState.MATCHED) {
            return;
        }
        SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
        ZyLabelContent zyLabelContent = singleDiffNode.getRealizer().getNodeContent();
        SingleDiffNode singleDiffNode2 = superDiffNode.getSecondaryDiffNode();
        ZyLabelContent zyLabelContent2 = singleDiffNode2.getRealizer().getNodeContent();
        zyLabelContent.setRightPadding(10);
        zyLabelContent2.setRightPadding(10);
        double d2 = zyLabelContent.getBounds().getWidth();
        double d3 = zyLabelContent2.getBounds().getWidth();
        if (d2 > d3) {
            zyLabelContent2.setRightPadding((int)Math.round(d2 - d3) + 10);
        } else {
            zyLabelContent.setRightPadding((int)Math.round(d3 - d2) + 10);
        }
        singleDiffNode2.getRealizer().regenerate();
        singleDiffNode.getRealizer().regenerate();
        singleGraph.updateViews();
        singleGraph2.updateViews();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.graphSearcher.clearResults();
        this.graphSearcher = null;
    }

    @Override
    public void doLayout() {
    }

    @Override
    public GraphSearcher getGraphSearcher() {
        return this.graphSearcher;
    }

    @Override
    public Set<SuperDiffNode> getSelectedNodes() {
        return new HashSet<SuperDiffNode>(CollectionHelpers.filter(super.getMappings().getNodes(), new ICollectionFilter<SuperDiffNode>(){

            @Override
            public boolean qualifies(SuperDiffNode superDiffNode) {
                return superDiffNode.isSelected();
            }
        }));
    }

    public void refreshAllSuperNodesSizes(SingleGraph singleGraph, SingleGraph singleGraph2) {
        for (SuperDiffNode superDiffNode : this.getMappings().getNodes()) {
            this.refreshSuperNodeSize(singleGraph, singleGraph2, superDiffNode);
        }
    }

    public void refreshSuperNodeSize(SingleGraph singleGraph, SingleGraph singleGraph2, SuperDiffNode superDiffNode) {
        this.synchronizeSize(singleGraph, singleGraph2, superDiffNode);
        SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
        SingleDiffNode singleDiffNode2 = superDiffNode.getSecondaryDiffNode();
        CombinedDiffNode combinedDiffNode = superDiffNode.getCombinedDiffNode();
        p p2 = superDiffNode.getNode();
        p p3 = null;
        p p4 = null;
        bQ bQ2 = this.getGraph().dN(p2);
        bQ bQ3 = combinedDiffNode.getRealizer().getRealizer();
        bQ bQ4 = null;
        bQ bQ5 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (singleDiffNode != null) {
            p3 = singleDiffNode.getNode();
            bQ4 = singleGraph.getGraph().dN(p3);
            d2 = bQ4.getWidth();
            d3 = bQ4.getHeight();
        }
        if (singleDiffNode2 != null) {
            p4 = singleDiffNode2.getNode();
            bQ5 = singleGraph2.getGraph().dN(p4);
            d4 = bQ5.getWidth();
            d5 = bQ5.getHeight();
        }
        bQ2.setWidth(Math.max(d2, d4));
        bQ2.setHeight(Math.max(d3, d5));
        if (bQ4 != null && bQ5 != null) {
            bQ3.setWidth(bQ2.getWidth() * 2.0 + 20.0);
            bQ3.setHeight(bQ2.getHeight());
        }
        if (singleDiffNode != null) {
            bQ4.setWidth(bQ2.getWidth());
            bQ4.setHeight(bQ2.getHeight());
        }
        if (singleDiffNode2 != null) {
            bQ5.setWidth(bQ2.getWidth());
            bQ5.setHeight(bQ2.getHeight());
        }
    }
}

