/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph;

import a.c.d;
import a.c.p;
import a.h.U;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.builders.ViewFlowGraphBuilder;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperViewEdge;
import com.google.security.zynamics.bindiff.graph.editmode.SingleGraphEditMode;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUnhideNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffBasicBlockNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperViewNode;
import com.google.security.zynamics.bindiff.graph.realizers.CodeNodeRealizerUpdater;
import com.google.security.zynamics.bindiff.graph.realizers.SingleEdgeRealizer;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistory;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.edges.ZyEdgeData;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ZyNodeData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.ZyEditMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyNormalNodeRealizer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class SingleGraph
extends BinDiffGraph<SingleDiffNode, SingleDiffEdge> {
    private SelectionHistory selectionHistory = new SelectionHistory(this, 30);
    private GraphSearcher graphSearcher = new GraphSearcher();
    private final IAddress functionAddress;
    private final ESide side;

    public SingleGraph(ZyGraph2DView zyGraph2DView, IAddress iAddress, LinkedHashMap<p, SingleDiffNode> linkedHashMap, LinkedHashMap<d, SingleDiffEdge> linkedHashMap2, GraphSettings graphSettings, ESide eSide, EGraphType eGraphType) {
        super(zyGraph2DView, linkedHashMap, linkedHashMap2, graphSettings, eGraphType);
        Preconditions.checkNotNull(eSide);
        this.functionAddress = iAddress;
        this.side = eSide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleDiffEdge buildDiffEdge(SingleGraph singleGraph, SuperViewEdge<? extends SuperViewNode> superViewEdge) {
        RawJump rawJump;
        SingleDiffEdge singleDiffEdge = null;
        d d2 = null;
        RawCombinedJump rawCombinedJump = (RawCombinedJump)superViewEdge.getCombinedEdge();
        RawBasicBlock rawBasicBlock = ((RawCombinedBasicBlock)rawCombinedJump.getSource()).getRawNode(singleGraph.getSide());
        RawBasicBlock rawBasicBlock2 = ((RawCombinedBasicBlock)rawCombinedJump.getTarget()).getRawNode(singleGraph.getSide());
        RawJump rawJump2 = rawJump = singleGraph.getSide() == ESide.PRIMARY ? rawCombinedJump.getPrimaryEdge() : rawCombinedJump.getSecondaryEdge();
        if (rawJump == null) {
            return null;
        }
        SingleEdgeRealizer singleEdgeRealizer = null;
        if (rawBasicBlock != null && rawBasicBlock2 != null && rawJump != null) {
            ZyLabelContent zyLabelContent = new ZyLabelContent(null);
            singleEdgeRealizer = new SingleEdgeRealizer(zyLabelContent, null, singleGraph.getSettings());
            SingleDiffNode singleDiffNode = (SingleDiffNode)singleGraph.getNode(rawBasicBlock);
            SingleDiffNode singleDiffNode2 = (SingleDiffNode)singleGraph.getNode(rawBasicBlock2);
            boolean bl2 = singleDiffNode.getRawNode().isVisible();
            boolean bl3 = singleDiffNode2.getRawNode().isVisible();
            singleDiffNode.getRawNode().setVisible(true);
            singleDiffNode2.getRawNode().setVisible(true);
            d2 = singleGraph.getGraph().c(singleDiffNode.getNode(), singleDiffNode2.getNode());
            singleDiffEdge = new SingleDiffEdge(singleDiffNode, singleDiffNode2, d2, singleEdgeRealizer, rawJump, singleGraph.getSide());
            SingleDiffNode.link(singleDiffNode, singleDiffNode2);
            singleEdgeRealizer.setUserData(new ZyEdgeData<SingleDiffEdge>(singleDiffEdge));
            singleDiffNode.getRawNode().setVisible(bl2);
            singleDiffNode2.getRawNode().setVisible(bl3);
            singleGraph.addEdgeToMappings(singleDiffEdge);
            if (!bl2 || !bl3) {
                SingleGraph singleGraph2;
                SingleGraph singleGraph3 = singleGraph2 = singleGraph;
                boolean bl4 = LayoutCommandHelper.deactiveAutoLayout(singleGraph3);
                try {
                    ProximityBrowserUnhideNode.executeStatic(singleGraph3, bl2 ? singleDiffNode : singleDiffNode2);
                }
                finally {
                    LayoutCommandHelper.activateAutoLayout(singleGraph3, bl4);
                }
            }
        }
        return singleDiffEdge;
    }

    public static SingleDiffNode buildDiffNode(SingleGraph singleGraph, FunctionMatchData functionMatchData, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, RawCombinedBasicBlock rawCombinedBasicBlock) {
        SingleDiffBasicBlockNode singleDiffBasicBlockNode = null;
        ZyLabelContent zyLabelContent = null;
        U u2 = singleGraph.getGraph();
        RawBasicBlock rawBasicBlock = rawCombinedBasicBlock.getRawNode(singleGraph.getSide());
        if (rawBasicBlock != null) {
            zyLabelContent = ViewFlowGraphBuilder.buildSingleBasicBlockLabelContent(functionMatchData, rawCombinedFlowGraph, rawCombinedBasicBlock, singleGraph.getSide());
            ZyNormalNodeRealizer zyNormalNodeRealizer = new ZyNormalNodeRealizer(zyLabelContent);
            CodeNodeRealizerUpdater codeNodeRealizerUpdater = new CodeNodeRealizerUpdater();
            zyNormalNodeRealizer.setUpdater(codeNodeRealizerUpdater);
            codeNodeRealizerUpdater.setRealizer(zyNormalNodeRealizer);
            p p2 = u2.an();
            singleDiffBasicBlockNode = new SingleDiffBasicBlockNode(p2, zyNormalNodeRealizer, rawBasicBlock, singleGraph.getSide());
            zyNormalNodeRealizer.setUserData(new ZyNodeData<SingleDiffBasicBlockNode>(singleDiffBasicBlockNode));
        }
        return singleDiffBasicBlockNode;
    }

    @Override
    protected ZyEditMode<SingleDiffNode, SingleDiffEdge> createEditMode() {
        return new SingleGraphEditMode(this);
    }

    @Override
    public void dispose() {
        this.selectionHistory.dispose();
        super.dispose();
        this.graphSearcher.clearResults();
        this.selectionHistory = null;
        this.graphSearcher = null;
    }

    public IAddress getFunctionAddress() {
        return this.functionAddress;
    }

    @Override
    public GraphSearcher getGraphSearcher() {
        return this.graphSearcher;
    }

    public SingleGraph getOtherSideGraph() {
        return this.side == ESide.PRIMARY ? this.getSecondaryGraph() : this.getPrimaryGraph();
    }

    @Override
    public Set<SingleDiffNode> getSelectedNodes() {
        return new HashSet<SingleDiffNode>(CollectionHelpers.filter(super.getMappings().getNodes(), new ICollectionFilter<SingleDiffNode>(){

            @Override
            public boolean qualifies(SingleDiffNode singleDiffNode) {
                return singleDiffNode.isSelected();
            }
        }));
    }

    public SelectionHistory getSelectionHistory() {
        return this.selectionHistory;
    }

    public ESide getSide() {
        return this.side;
    }
}

