/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraph;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.AbstractGraphsContainer;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphsContainer
extends AbstractGraphsContainer {
    private final List<BinDiffGraph<?, ?>> graphs;
    private Diff diff;

    public GraphsContainer(Diff diff, SuperGraph superGraph, CombinedGraph combinedGraph, SingleGraph singleGraph, SingleGraph singleGraph2) {
        Preconditions.checkNotNull(superGraph);
        Preconditions.checkNotNull(combinedGraph);
        Preconditions.checkNotNull(singleGraph);
        Preconditions.checkNotNull(singleGraph2);
        this.diff = diff;
        this.graphs = new ArrayList(4);
        this.graphs.add(EGraph.PRIMARY_GRAPH.ordinal(), singleGraph);
        this.graphs.add(EGraph.SECONDARY_GRAPH.ordinal(), singleGraph2);
        this.graphs.add(EGraph.COMBINED_GRAPH.ordinal(), combinedGraph);
        this.graphs.add(EGraph.SUPER_GRAPH.ordinal(), superGraph);
        for (BinDiffGraph<?, ?> binDiffGraph : this.graphs) {
            binDiffGraph.setGraphs(this);
        }
        combinedGraph.getSelectionHistory().registerMatchListener();
        singleGraph.getSelectionHistory().registerMatchListener();
        singleGraph2.getSelectionHistory().registerMatchListener();
    }

    @Override
    public void dispose() {
        for (BinDiffGraph<?, ?> binDiffGraph : this.graphs) {
            if (binDiffGraph == null) continue;
            binDiffGraph.dispose();
        }
        this.graphs.clear();
    }

    @Override
    public CombinedGraph getCombinedGraph() {
        return (CombinedGraph)this.graphs.get(EGraph.COMBINED_GRAPH.ordinal());
    }

    public Diff getDiff() {
        return this.diff;
    }

    @Override
    public BinDiffGraph<?, ?> getFocusedGraph() {
        switch (this.getSettings().getDiffViewMode()) {
            case NORMAL_VIEW: {
                if (this.getSettings().isSync()) {
                    return this.getSuperGraph();
                }
                if (this.getSettings().getFocus() == ESide.PRIMARY) {
                    return this.getPrimaryGraph();
                }
                return this.getSecondaryGraph();
            }
            case COMBINED_VIEW: {
                return this.getCombinedGraph();
            }
            case TEXT_VIEW: {
                return null;
            }
        }
        throw new IllegalStateException("Illegal view mode.");
    }

    @Override
    public SingleGraph getPrimaryGraph() {
        return (SingleGraph)this.graphs.get(EGraph.PRIMARY_GRAPH.ordinal());
    }

    @Override
    public SingleGraph getSecondaryGraph() {
        return (SingleGraph)this.graphs.get(EGraph.SECONDARY_GRAPH.ordinal());
    }

    @Override
    public GraphSettings getSettings() {
        return ((SuperGraph)this.graphs.get(EGraph.SUPER_GRAPH.ordinal())).getSettings();
    }

    @Override
    public SuperGraph getSuperGraph() {
        return (SuperGraph)this.graphs.get(EGraph.SUPER_GRAPH.ordinal());
    }

    @Override
    public Iterator<BinDiffGraph<?, ?>> iterator() {
        return this.graphs.iterator();
    }

    public void setDiff(Diff diff) {
        this.diff = diff;
    }

    @Override
    public void updateViews() {
        for (BinDiffGraph<?, ?> binDiffGraph : this.graphs) {
            if (binDiffGraph == null) continue;
            binDiffGraph.updateViews();
        }
    }
}

