/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph;

import a.c.d;
import a.c.e;
import a.c.p;
import a.f.F;
import a.f.N;
import a.f.b;
import a.f.c;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.ProximityBrowser;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraphMappings;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.LayoutFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ProximityHelper;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public abstract class BinDiffGraph<NodeType extends ZyGraphNode<? extends IViewNode<?>>, EdgeType extends ZyGraphEdge<?, ?, ?>>
extends AbstractZyGraph<NodeType, EdgeType> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private GraphsIntermediateListeners intermediateListeners;
    private final ProximityBrowser<NodeType, EdgeType> proximityBrowser;
    private GraphSettings settings;
    private final EGraphType viewType;
    private GraphsContainer graphs;

    protected BinDiffGraph(ZyGraph2DView zyGraph2DView, LinkedHashMap<p, NodeType> linkedHashMap, LinkedHashMap<d, EdgeType> linkedHashMap2, GraphSettings graphSettings, EGraphType eGraphType) {
        super(zyGraph2DView, linkedHashMap, linkedHashMap2, graphSettings);
        this.settings = Preconditions.checkNotNull(graphSettings);
        this.viewType = Preconditions.checkNotNull(eGraphType);
        this.intermediateListeners = new GraphsIntermediateListeners(this);
        this.proximityBrowser = new ProximityBrowser(this);
        this.setProximityBrowser(this.proximityBrowser);
    }

    public static Window getParentWindow(BinDiffGraph<?, ?> binDiffGraph) {
        return SwingUtilities.getWindowAncestor(binDiffGraph.getView());
    }

    public void addEdgeToMappings(EdgeType EdgeType2) {
        d d2 = ((ZyGraphEdge)EdgeType2).getEdge();
        ZyGraphMappings zyGraphMappings = this.getMappings();
        zyGraphMappings.addEdge(d2, EdgeType2);
    }

    public void addNodeToMappings(NodeType NodeType2) {
        p p2 = ((ZyGraphNode)NodeType2).getNode();
        ZyGraphMappings zyGraphMappings = this.getMappings();
        zyGraphMappings.addNode(p2, NodeType2);
    }

    public F calculateLayout() {
        F f2 = null;
        c c2 = this.getSettings().getLayoutSettings().getCurrentLayouter();
        try {
            c2.c(new N());
            c2.j(true);
            f2 = new b(c2).b(this.getGraph());
            LayoutFunctions.recalculatePorts(c2, this.getGraph());
        }
        catch (a.a.c c3) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(c3)).log(c3.getMessage());
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Could not calculate graph layout.");
        }
        return f2;
    }

    public F calculateLayout(c c2) {
        F f2 = null;
        try {
            c2.c(new N());
            c2.j(true);
            f2 = new b(c2).b(this.getGraph());
            LayoutFunctions.recalculatePorts(c2, this.getGraph());
        }
        catch (a.a.c c3) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(c3)).log(c3.getMessage());
        }
        catch (Exception exception) {
            throw new GraphLayoutException(exception, "Could not calculate graph layout.");
        }
        return f2;
    }

    public void deleteEdge(EdgeType EdgeType2) {
        if (EdgeType2 == null) {
            return;
        }
        Object NodeTypeT = ((ZyGraphEdge)EdgeType2).getSource();
        Object NodeTypeT2 = ((ZyGraphEdge)EdgeType2).getTarget();
        p p2 = null;
        if (ProximityHelper.isProximityNode(this.getGraph(), ((ZyGraphNode)NodeTypeT).getNode())) {
            p2 = ((ZyGraphNode)NodeTypeT).getNode();
        } else if (ProximityHelper.isProximityNode(this.getGraph(), ((ZyGraphNode)NodeTypeT2).getNode())) {
            p2 = ((ZyGraphNode)NodeTypeT2).getNode();
        }
        if (p2 != null) {
            ((ProximityBrowser)this.getProximityBrowser()).deleteProximityBrowsingNode(p2);
        } else {
            ((ZyGraphEdge)EdgeType2).dispose();
            this.getMappings().removeEdge(EdgeType2);
            this.getGraph().e(((ZyGraphEdge)EdgeType2).getEdge());
            if (NodeTypeT instanceof SingleDiffNode && NodeTypeT2 instanceof SingleDiffNode) {
                SingleDiffNode.unlink((SingleDiffNode)NodeTypeT, (SingleDiffNode)NodeTypeT2);
            } else if (NodeTypeT instanceof CombinedDiffNode && NodeTypeT2 instanceof CombinedDiffNode) {
                CombinedDiffNode.unlink((CombinedDiffNode)NodeTypeT, (CombinedDiffNode)NodeTypeT2);
            } else if (NodeTypeT instanceof SuperDiffNode && NodeTypeT2 instanceof SuperDiffNode) {
                SuperDiffNode.unlink((SuperDiffNode)NodeTypeT, (SuperDiffNode)NodeTypeT2);
            }
        }
        EdgeType2 = null;
    }

    public void deleteNode(NodeType NodeType2) {
        if (NodeType2 == null) {
            return;
        }
        p p2 = ((ZyGraphNode)NodeType2).getNode();
        CViewNode cViewNode = (CViewNode)((ZyGraphNode)NodeType2).getRawNode();
        cViewNode.removeAllListeners();
        ZyGraphMappings zyGraphMappings = this.getMappings();
        e e2 = p2.af();
        while (e2.J()) {
            Object EdgeType2 = zyGraphMappings.getEdge(e2.ac());
            this.deleteEdge(EdgeType2);
            e2.next();
        }
        this.getMappings().removeNode(NodeType2);
        this.getGraph().h(p2);
        p2 = null;
        cViewNode = null;
        NodeType2 = null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.intermediateListeners.dispose();
        this.settings = null;
        this.intermediateListeners = null;
        this.graphs = null;
    }

    @Override
    public void doLayout() {
    }

    public CombinedGraph getCombinedGraph() {
        return this.graphs.getCombinedGraph();
    }

    @Override
    public Collection<EdgeType> getEdges() {
        return super.getEdges();
    }

    public GraphsContainer getGraphs() {
        return this.graphs;
    }

    public abstract GraphSearcher getGraphSearcher();

    public EGraphType getGraphType() {
        return this.viewType;
    }

    public GraphsIntermediateListeners getIntermediateListeners() {
        return this.intermediateListeners;
    }

    @Override
    public Collection<NodeType> getNodes() {
        return super.getNodes();
    }

    public SingleGraph getPrimaryGraph() {
        return this.graphs.getPrimaryGraph();
    }

    @Override
    public ProximityBrowser<NodeType, EdgeType> getProximityBrowser() {
        return this.proximityBrowser;
    }

    public SingleGraph getSecondaryGraph() {
        return this.graphs.getSecondaryGraph();
    }

    @Override
    public abstract Set<NodeType> getSelectedNodes();

    @Override
    public GraphSettings getSettings() {
        return this.settings;
    }

    public SuperGraph getSuperGraph() {
        return this.graphs.getSuperGraph();
    }

    public boolean isCombinedGraph() {
        return this == this.getCombinedGraph();
    }

    public boolean isPrimaryGraph() {
        return this == this.getPrimaryGraph();
    }

    public boolean isSecondaryGraph() {
        return this == this.getSuperGraph();
    }

    public boolean isSingleGraph() {
        return this.isPrimaryGraph() || this.isSecondaryGraph();
    }

    public boolean isSuperGraph() {
        return this == this.getSuperGraph();
    }

    public void setGraphs(GraphsContainer graphsContainer) {
        this.graphs = Preconditions.checkNotNull(graphsContainer);
    }
}

