/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.enums;

public enum ESortByCriterion {
    NONE,
    ADDRESS,
    FUNCTION_TYPE,
    SIDE,
    MATCH_STATE,
    SELECTION,
    VISIBILITY,
    FUNCTION_NAME;

    private static final String SORT_CRITERION_NONE = "None";
    private static final String SORT_CRITERION_ADDRESS = "Address";
    private static final String SORT_CRITERION_FUNCTION_TYPE = "Function Type";
    private static final String SORT_CRITERION_SIDE = "Side";
    private static final String SORT_CRITERION_MATCH_STATE = "Match State";
    private static final String SORT_CRITERION_SELECTION = "Selection";
    private static final String SORT_CRITERION_VISIBILITY = "Visibility";
    private static final String SORT_CRITERION_FUNCTION_NAME = "Function Name";

    public static ESortByCriterion toSortCriterion(String string) {
        if (SORT_CRITERION_ADDRESS.equals(string)) {
            return ADDRESS;
        }
        if (SORT_CRITERION_FUNCTION_TYPE.equals(string)) {
            return FUNCTION_TYPE;
        }
        if (SORT_CRITERION_SIDE.equals(string)) {
            return SIDE;
        }
        if (SORT_CRITERION_MATCH_STATE.equals(string)) {
            return MATCH_STATE;
        }
        if (SORT_CRITERION_SELECTION.equals(string)) {
            return SELECTION;
        }
        if (SORT_CRITERION_VISIBILITY.equals(string)) {
            return VISIBILITY;
        }
        if (SORT_CRITERION_FUNCTION_NAME.equals(string)) {
            return FUNCTION_NAME;
        }
        return NONE;
    }

    public String toString() {
        switch (this) {
            case NONE: {
                return SORT_CRITERION_NONE;
            }
            case ADDRESS: {
                return SORT_CRITERION_ADDRESS;
            }
            case FUNCTION_TYPE: {
                return SORT_CRITERION_FUNCTION_TYPE;
            }
            case SIDE: {
                return SORT_CRITERION_SIDE;
            }
            case MATCH_STATE: {
                return SORT_CRITERION_MATCH_STATE;
            }
            case SELECTION: {
                return SORT_CRITERION_SELECTION;
            }
            case VISIBILITY: {
                return SORT_CRITERION_VISIBILITY;
            }
            case FUNCTION_NAME: {
                return SORT_CRITERION_FUNCTION_NAME;
            }
        }
        return SORT_CRITERION_NONE;
    }
}

