/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.enums;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.ThemeConfigItem;
import java.awt.Color;

public enum EInstructionHighlighting {
    TYPE_DEFAULT,
    TYPE_ADDRESS,
    TYPE_MNEMONIC,
    TYPE_SYMBOL,
    TYPE_IMMEDIATE,
    TYPE_OPERATOR,
    TYPE_REGISTER,
    TYPE_SIZEPREFIX,
    TYPE_DEREFERENCE,
    TYPE_NEWOPERAND_COMMA,
    TYPE_STACKVARIABLE,
    TYPE_GLOBALVARIABLE,
    TYPE_JUMPLABEL,
    TYPE_FUNCTION,
    TYPE_COMMENT;

    public static final int ENUM_ENTRY_COUNT = 15;

    public static int convertExporterOrdinal(int n2) {
        switch (n2) {
            case 0: {
                return EInstructionHighlighting.getOrdinal(TYPE_MNEMONIC);
            }
            case 1: {
                return EInstructionHighlighting.getOrdinal(TYPE_SYMBOL);
            }
            case 2: {
                return EInstructionHighlighting.getOrdinal(TYPE_IMMEDIATE);
            }
            case 3: {
                return EInstructionHighlighting.getOrdinal(TYPE_IMMEDIATE);
            }
            case 4: {
                return EInstructionHighlighting.getOrdinal(TYPE_OPERATOR);
            }
            case 5: {
                return EInstructionHighlighting.getOrdinal(TYPE_REGISTER);
            }
            case 6: {
                return EInstructionHighlighting.getOrdinal(TYPE_SIZEPREFIX);
            }
            case 7: {
                return EInstructionHighlighting.getOrdinal(TYPE_DEREFERENCE);
            }
            case 8: {
                return EInstructionHighlighting.getOrdinal(TYPE_NEWOPERAND_COMMA);
            }
            case 9: {
                return EInstructionHighlighting.getOrdinal(TYPE_STACKVARIABLE);
            }
            case 10: {
                return EInstructionHighlighting.getOrdinal(TYPE_GLOBALVARIABLE);
            }
            case 11: {
                return EInstructionHighlighting.getOrdinal(TYPE_JUMPLABEL);
            }
            case 12: {
                return EInstructionHighlighting.getOrdinal(TYPE_FUNCTION);
            }
        }
        return EInstructionHighlighting.getOrdinal(TYPE_DEFAULT);
    }

    public static Color getColor(EInstructionHighlighting eInstructionHighlighting) {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        ThemeConfigItem themeConfigItem = binDiffConfig.getThemeSettings();
        switch (eInstructionHighlighting) {
            case TYPE_DEFAULT: {
                return themeConfigItem.getDefaultColor();
            }
            case TYPE_ADDRESS: {
                return themeConfigItem.getAddressColor();
            }
            case TYPE_MNEMONIC: {
                return themeConfigItem.getMnemonicColor();
            }
            case TYPE_SYMBOL: {
                return themeConfigItem.getSymbolColor();
            }
            case TYPE_IMMEDIATE: {
                return themeConfigItem.getImmediateColor();
            }
            case TYPE_OPERATOR: {
                return themeConfigItem.getOperatorColor();
            }
            case TYPE_REGISTER: {
                return themeConfigItem.getRegisterColor();
            }
            case TYPE_SIZEPREFIX: {
                return themeConfigItem.getSizePrefixColor();
            }
            case TYPE_DEREFERENCE: {
                return themeConfigItem.getDereferenceColor();
            }
            case TYPE_NEWOPERAND_COMMA: {
                return themeConfigItem.getOperatorSeparatorColor();
            }
            case TYPE_STACKVARIABLE: {
                return themeConfigItem.getStackVariableColor();
            }
            case TYPE_GLOBALVARIABLE: {
                return themeConfigItem.getGlobalVariableColor();
            }
            case TYPE_JUMPLABEL: {
                return themeConfigItem.getJumpLabelColor();
            }
            case TYPE_FUNCTION: {
                return themeConfigItem.getFunctionColor();
            }
            case TYPE_COMMENT: {
                return themeConfigItem.getCommentColor();
            }
        }
        return binDiffConfig.getThemeSettings().getDefaultColor();
    }

    public static Color getColor(int n2) {
        return EInstructionHighlighting.getColor(EInstructionHighlighting.getEnum(n2));
    }

    public static EInstructionHighlighting getEnum(int n2) {
        switch (n2) {
            case 0: {
                return TYPE_DEFAULT;
            }
            case 1: {
                return TYPE_ADDRESS;
            }
            case 2: {
                return TYPE_MNEMONIC;
            }
            case 3: {
                return TYPE_SYMBOL;
            }
            case 4: {
                return TYPE_IMMEDIATE;
            }
            case 5: {
                return TYPE_OPERATOR;
            }
            case 6: {
                return TYPE_REGISTER;
            }
            case 7: {
                return TYPE_SIZEPREFIX;
            }
            case 8: {
                return TYPE_DEREFERENCE;
            }
            case 9: {
                return TYPE_NEWOPERAND_COMMA;
            }
            case 10: {
                return TYPE_STACKVARIABLE;
            }
            case 11: {
                return TYPE_GLOBALVARIABLE;
            }
            case 12: {
                return TYPE_JUMPLABEL;
            }
            case 13: {
                return TYPE_FUNCTION;
            }
            case 14: {
                return TYPE_COMMENT;
            }
        }
        throw new IllegalStateException("Unknown operand highlighting type.");
    }

    public static int getOrdinal(EInstructionHighlighting eInstructionHighlighting) {
        switch (eInstructionHighlighting) {
            case TYPE_DEFAULT: {
                return 0;
            }
            case TYPE_ADDRESS: {
                return 1;
            }
            case TYPE_MNEMONIC: {
                return 2;
            }
            case TYPE_SYMBOL: {
                return 3;
            }
            case TYPE_IMMEDIATE: {
                return 4;
            }
            case TYPE_OPERATOR: {
                return 5;
            }
            case TYPE_REGISTER: {
                return 6;
            }
            case TYPE_SIZEPREFIX: {
                return 7;
            }
            case TYPE_DEREFERENCE: {
                return 8;
            }
            case TYPE_NEWOPERAND_COMMA: {
                return 9;
            }
            case TYPE_STACKVARIABLE: {
                return 10;
            }
            case TYPE_GLOBALVARIABLE: {
                return 11;
            }
            case TYPE_JUMPLABEL: {
                return 12;
            }
            case TYPE_FUNCTION: {
                return 13;
            }
            case TYPE_COMMENT: {
                return 14;
            }
        }
        throw new IllegalStateException("Unknown operand highlighting type.");
    }

    public static int getSize() {
        return 15;
    }
}

