/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.database;

import com.google.security.zynamics.bindiff.database.SqliteDatabase;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class WorkspaceDatabase
extends SqliteDatabase {
    private static final String STATEMENT_CREATE_METADATA_TABLE = "CREATE TABLE IF NOT EXISTS metadata (version INT NOT NULL)";
    private static final String STATEMENT_CREATE_DIFFS_TABLE = "CREATE TABLE IF NOT EXISTS diffs (matchesDbPath VARCHAR NOT NULL, isfunctiondiff NUMERIC NOT NULL DEFAULT 0)";

    public WorkspaceDatabase(File file) {
        super(file);
        this.createTables();
    }

    private void setFormatVersionNumber() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO metadata (version) VALUES (?)");){
            preparedStatement.setInt(1, 2);
            preparedStatement.executeUpdate();
        }
    }

    private void createTables() {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(STATEMENT_CREATE_METADATA_TABLE);
            this.setFormatVersionNumber();
        }
        statement = this.connection.createStatement();
        try {
            statement.executeUpdate(STATEMENT_CREATE_DIFFS_TABLE);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public List<String> loadDiffPaths(boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT matchesDbPath FROM diffs WHERE isfunctiondiff = ?");){
            preparedStatement.setBoolean(1, bl2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(BinDiffFileUtils.forceFileSeparator(resultSet.getString("matchesDbPath")));
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                throw new SQLException("Failed to load workspace: Couldn't load function diff paths.", sQLException);
            }
            throw new SQLException("Failed to load workspace: Couldn't load diff paths.", sQLException);
        }
        return arrayList;
    }

    public void saveWorkspace(Workspace workspace) {
        PreparedStatement preparedStatement;
        this.connection.setAutoCommit(false);
        try {
            preparedStatement = this.connection.prepareStatement("DELETE FROM diffs");
            try {
                preparedStatement.executeUpdate();
                this.connection.commit();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            this.connection.rollback();
            throw new SQLException("Failed to write to workspace file. Couldn't delete old entries: " + sQLException.getMessage(), sQLException);
        }
        finally {
            this.connection.setAutoCommit(true);
        }
        this.connection.setAutoCommit(false);
        try {
            preparedStatement = this.connection.prepareStatement("INSERT INTO diffs (matchesDbPath, isfunctiondiff) VALUES (?, ?)");
            try {
                String string = FileUtils.ensureTrailingSlash(workspace.getWorkspaceDirPath());
                for (Diff diff : workspace.getDiffList()) {
                    String string2 = diff.getMatchesDatabase().getAbsolutePath();
                    if (string2.startsWith(string)) {
                        string2 = string2.substring(string.length());
                    }
                    preparedStatement.setString(1, string2);
                    preparedStatement.setInt(2, !diff.isFunctionDiff() ? 0 : 1);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                this.connection.commit();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            this.connection.rollback();
            throw new SQLException("Failed to save workspace file. Couldn't write new entries: " + sQLException.getMessage(), sQLException);
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }
}

