/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class SqliteDatabase
implements AutoCloseable {
    final Connection connection;

    SqliteDatabase(File file) {
        Preconditions.checkNotNull(file);
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("JDBC driver for SQLite not found", classNotFoundException);
        }
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + (SystemHelpers.isRunningWindows() ? "\\\\?\\" : "") + file.getPath());
    }

    @Override
    public void close() {
        this.connection.close();
    }
}

