/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.database;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder {
    protected static final int SQLITE_MAX_QUERY_SIZE = 1000000;
    private final List<StringBuffer> queries = new ArrayList<StringBuffer>();
    private final String baseQuery;
    private StringBuffer currentBuffer;

    public QueryBuilder(String string) {
        Preconditions.checkArgument(string != null && !string.isEmpty());
        Preconditions.checkArgument(!string.toLowerCase().startsWith("insert"), "Multi row inserts are not supported by sqlite");
        Preconditions.checkArgument(!string.toLowerCase().startsWith("update"), "Multi row updates with more than one value set are not supported by SQLite");
        this.currentBuffer = new StringBuffer();
        this.baseQuery = string + (string.endsWith(" ") ? "" : " ");
    }

    private void addCurrentQuery() {
        if (this.currentBuffer.charAt(this.currentBuffer.length() - 1) != ')') {
            this.currentBuffer.append(")");
        }
        this.currentBuffer.append(";");
        this.queries.add(this.currentBuffer);
        this.currentBuffer = new StringBuffer();
    }

    public void appendInSet(String string) {
        Preconditions.checkArgument(string != null && !string.isEmpty(), "Row insert string cannot be null or empty");
        Preconditions.checkArgument(!string.startsWith("(") && !string.endsWith(")"), "In set values can not start with a \"(\" and end with a \")\")");
        if (this.currentBuffer.length() + string.length() >= 999997) {
            this.currentBuffer.append(")");
            this.addCurrentQuery();
        }
        if (this.currentBuffer.length() == 0) {
            this.currentBuffer.append(this.baseQuery);
            this.currentBuffer.append("(");
        } else {
            this.currentBuffer.append(",");
        }
        this.currentBuffer.append(string);
    }

    public void execute(Connection connection) {
        Preconditions.checkNotNull(connection);
        if (this.currentBuffer.length() != 0) {
            this.addCurrentQuery();
        }
        for (StringBuffer stringBuffer : this.queries) {
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate(stringBuffer.toString());
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }
}

