/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.database;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.QueryBuilder;
import com.google.security.zynamics.bindiff.database.SqliteDatabase;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.io.BinExport2Reader;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffDirectories;
import com.google.security.zynamics.bindiff.project.matches.AddressPair;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionDiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.IAddressPair;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.types.Matches;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class MatchesDatabase
extends SqliteDatabase {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final int UNSAVED_BASIC_BLOCK_MATCH_ALGORITHM_ID = -1;
    private static final int DEFAULT_FILE_TABLE_COLUMN_COUNT = 13;

    public MatchesDatabase(File file) {
        super(file);
    }

    private void addBasicBlockMatches(FunctionMatchData functionMatchData) {
        int n2 = this.getFunctionMatchId(functionMatchData);
        int n3 = this.getNextBasicBlockMatchId();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO basicblock VALUES (?, ?, ?, ?, ?, ?)");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("INSERT INTO instruction VALUES (?, ?, ?)");){
            int n4 = this.getAlgorithmIdForManuallyMatchedBasicBlocks();
            for (BasicBlockMatchData basicBlockMatchData : functionMatchData.getBasicBlockMatches()) {
                int n5 = basicBlockMatchData.getAlgorithmId();
                preparedStatement.setInt(1, n3);
                preparedStatement.setInt(2, n2);
                preparedStatement.setLong(3, basicBlockMatchData.getAddress(ESide.PRIMARY));
                preparedStatement.setLong(4, basicBlockMatchData.getAddress(ESide.SECONDARY));
                preparedStatement.setInt(5, n5 == -1 ? n4 : n5);
                preparedStatement.setInt(6, n5 == -1 ? 1 : 0);
                preparedStatement.addBatch();
                for (InstructionMatchData instructionMatchData : basicBlockMatchData.getInstructionMatches()) {
                    preparedStatement2.setInt(1, n3);
                    preparedStatement2.setLong(2, instructionMatchData.getAddress(ESide.PRIMARY));
                    preparedStatement2.setLong(3, instructionMatchData.getAddress(ESide.SECONDARY));
                    preparedStatement2.addBatch();
                }
                ++n3;
            }
            preparedStatement.executeBatch();
            preparedStatement2.executeBatch();
        }
    }

    private void alterFileTable() {
        block24: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM file");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.getMetaData().getColumnCount() != 13) break block24;
                try (PreparedStatement preparedStatement2 = this.connection.prepareStatement("ALTER TABLE file ADD COLUMN functionname VARCHAR");
                     PreparedStatement preparedStatement3 = this.connection.prepareStatement("ALTER TABLE file ADD COLUMN functiontype INT");){
                    preparedStatement2.executeUpdate();
                    preparedStatement3.executeUpdate();
                }
            }
        }
    }

    private int countFunctionSimilarity(double d2, double d3) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT COUNT(*) AS intervalcount FROM function WHERE similarity >= ? AND similarity < ?");){
            preparedStatement.setDouble(1, d2);
            preparedStatement.setDouble(2, d3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = resultSet.getInt("intervalcount");
                return n2;
            }
        }
        return 0;
    }

    private int[] countFunctionSimilarityIntervals() {
        int[] nArray = new int[11];
        for (int i2 = 0; i2 <= 10; ++i2) {
            nArray[i2] = this.countFunctionSimilarity((double)i2 * 0.1, (double)(i2 + 1) * 0.1);
        }
        return nArray;
    }

    private int countMatchedFunctions() {
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) AS matchedfunctioncount FROM function");
            if (resultSet.next()) {
                int n2 = resultSet.getInt("matchedfunctioncount");
                return n2;
            }
        }
        return 0;
    }

    private void deleteBasicBlockMatches(long l2, long l3) {
        QueryBuilder queryBuilder;
        ResultSet resultSet;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT basicblock.id FROM function INNER JOIN basicblock ON basicblock.functionid = function.id WHERE function.address1 = ? AND function.address2 = ?");){
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l3);
            resultSet = preparedStatement.executeQuery();
            try {
                queryBuilder = new QueryBuilder("DELETE FROM instruction WHERE basicblockid IN ");
                while (resultSet.next()) {
                    queryBuilder.appendInSet(resultSet.getString(1));
                }
                queryBuilder.execute(this.connection);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        preparedStatement = this.connection.prepareStatement("SELECT id FROM function WHERE address1 = ? AND address2 = ?");
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l3);
            resultSet = preparedStatement.executeQuery();
            try {
                queryBuilder = new QueryBuilder("DELETE FROM basicblock WHERE functionid IN ");
                if (resultSet.next()) {
                    queryBuilder.appendInSet(resultSet.getString(1));
                }
                queryBuilder.execute(this.connection);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private int getAlgorithmIdForManuallyMatchedBasicBlocks() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT MAX(id) AS maxid FROM basicblockalgorithm");){
            int n2;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    n2 = resultSet.getInt("maxid");
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n2;
        }
    }

    private int getFunctionMatchId(FunctionMatchData functionMatchData) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT id FROM function WHERE address1 = ? AND address2 = ?");){
            preparedStatement.setLong(1, functionMatchData.getAddress(ESide.PRIMARY));
            preparedStatement.setLong(2, functionMatchData.getAddress(ESide.SECONDARY));
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = resultSet.next() ? resultSet.getInt(1) : -1;
            return n2;
        }
    }

    private int getNextBasicBlockMatchId() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT COALESCE(MAX(id) + 1, 1) AS maxid FROM basicblock");){
            int n2;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    int n3 = n2 = resultSet.next() ? resultSet.getInt(1) : -1;
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n2;
        }
    }

    private static void addBinExportMetaData(File file, DiffMetadata diffMetadata) {
        Object object;
        if (file == null) {
            return;
        }
        File file2 = DiffDirectories.getBinExportFile(file, diffMetadata, ESide.PRIMARY);
        if (file2.canRead()) {
            object = new BinExport2Reader(file2, ESide.PRIMARY);
            diffMetadata.setArchitectureName(((BinExport2Reader)object).getArchitectureName(), ESide.PRIMARY);
            diffMetadata.setMaxMnemonicLen(((BinExport2Reader)object).getMaxMnemonicLen(), ESide.PRIMARY);
        }
        if (((File)(object = DiffDirectories.getBinExportFile(file, diffMetadata, ESide.SECONDARY))).canRead()) {
            BinExport2Reader binExport2Reader = new BinExport2Reader(file2, ESide.SECONDARY);
            diffMetadata.setArchitectureName(binExport2Reader.getArchitectureName(), ESide.SECONDARY);
            diffMetadata.setMaxMnemonicLen(binExport2Reader.getMaxMnemonicLen(), ESide.SECONDARY);
        }
    }

    private void setFunctionMatchCounts(long l2, long l3, FunctionMatchData functionMatchData) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE function SET basicblocks = ?, edges = ?, instructions = ?WHERE address1 = ? and address2 = ?");){
            preparedStatement.setInt(1, functionMatchData.getSizeOfMatchedBasicBlocks());
            preparedStatement.setInt(2, functionMatchData.getSizeOfMatchedJumps());
            preparedStatement.setInt(3, functionMatchData.getSizeOfMatchedInstructions());
            preparedStatement.setLong(4, l2);
            preparedStatement.setLong(5, l3);
            preparedStatement.executeUpdate();
        }
    }

    public void changeExportFilename(String string, ESide eSide) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE FILE SET filename = ? WHERE id = ?");){
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, eSide == ESide.PRIMARY ? 1 : 2);
            preparedStatement.executeUpdate();
        }
    }

    public void changeFileTable(Diff diff) {
        if (!diff.isLoaded()) {
            throw new IllegalStateException("Function diff has to be loaded before saving.");
        }
        if (!diff.isFunctionDiff()) {
            throw new IllegalArgumentException("Must be a function diff.");
        }
        this.alterFileTable();
        RawFunction rawFunction = (RawFunction)diff.getCallGraph(ESide.PRIMARY).getNodes().get(0);
        RawFunction rawFunction2 = (RawFunction)diff.getCallGraph(ESide.SECONDARY).getNodes().get(0);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE file SET functionname = ?, functiontype = ? WHERE id = ?");){
            preparedStatement.setString(1, rawFunction.getName());
            preparedStatement.setInt(2, EFunctionType.getOrdinal(rawFunction.getFunctionType()));
            preparedStatement.setInt(3, 1);
            preparedStatement.addBatch();
            preparedStatement.setString(1, rawFunction2.getName());
            preparedStatement.setInt(2, EFunctionType.getOrdinal(rawFunction2.getFunctionType()));
            preparedStatement.setInt(3, 2);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
        }
    }

    public void deleteBasicBlockMatch(FunctionMatchData functionMatchData, BasicBlockMatchData basicBlockMatchData) {
        PreparedStatement preparedStatement;
        int n2 = -1;
        int n3 = -1;
        try {
            preparedStatement = this.connection.prepareStatement("SELECT function.id, basicblock.id FROM function INNER JOIN basicblock ON basicblock.address1 = ? and basicblock.address2 = ? INNER JOIN instruction ON basicblock.id = instruction.basicblockid WHERE function.address1 = ? and function.address2 = ? GROUP BY basicblock.functionid;");
            try {
                preparedStatement.setLong(1, basicBlockMatchData.getAddress(ESide.PRIMARY));
                preparedStatement.setLong(2, basicBlockMatchData.getAddress(ESide.SECONDARY));
                preparedStatement.setLong(3, functionMatchData.getAddress(ESide.PRIMARY));
                preparedStatement.setLong(4, functionMatchData.getAddress(ESide.SECONDARY));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    n3 = resultSet.getInt(2);
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Couldn't delete non existing basicblock match from database.", sQLException);
        }
        try {
            preparedStatement = this.connection.prepareStatement("DELETE FROM basicblock WHERE id = ? AND functionid = ? ");
            try {
                preparedStatement.setInt(1, n3);
                preparedStatement.setInt(2, n2);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Failed to delete basic block match from database: " + sQLException.getMessage());
        }
        try {
            preparedStatement = this.connection.prepareStatement("DELETE FROM instruction WHERE basicblockid = ?");
            try {
                preparedStatement.setInt(1, n3);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Failed to delete instruction matches of removed basic block match from database: " + sQLException.getMessage());
        }
    }

    public String[] getIDBNames() {
        String[] stringArray;
        block9: {
            String[] stringArray2 = new String[2];
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT filename FROM file ORDER BY id");
                int n2 = 0;
                while (resultSet.next()) {
                    stringArray2[n2++] = resultSet.getString("filename");
                }
                stringArray = stringArray2;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new SQLException("Couldn't read IDB names: " + sQLException.getMessage());
                }
            }
            statement.close();
        }
        return stringArray;
    }

    public void loadBasicBlockMatches(FunctionMatchData functionMatchData) {
        if (functionMatchData == null) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT basicblock.address1 AS priBasicBlockAddr, basicblock.address2 AS secBasicBlockAddr, basicblock.algorithm, instruction.address1 AS priInstructionAddr, instruction.address2 AS secInstructionAddr FROM function INNER JOIN basicblock ON basicblock.functionid = function.id INNER JOIN basicblockalgorithm ON basicblockalgorithm.id = basicblock.algorithm LEFT JOIN instruction ON basicblock.id = instruction.basicblockid WHERE function.address1 = ? AND function.address2 = ? ORDER BY priBasicBlockAddr, priInstructionAddr;");){
            IAddressPair iAddressPair;
            preparedStatement.setLong(1, functionMatchData.getAddress(ESide.PRIMARY));
            preparedStatement.setLong(2, functionMatchData.getAddress(ESide.SECONDARY));
            ArrayList<BasicBlockMatchData> arrayList = new ArrayList<BasicBlockMatchData>();
            ArrayList<BasicBlockMatchData> arrayList2 = new ArrayList<BasicBlockMatchData>();
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n2 = 0;
            long l5 = 0L;
            long l6 = 0L;
            while (resultSet.next()) {
                boolean bl2;
                l3 = resultSet.getLong(1);
                if (l2 != l3 && !resultSet.isFirst()) {
                    Matches<InstructionMatchData> matches = new Matches<InstructionMatchData>(arrayList2);
                    iAddressPair = new BasicBlockMatchData(l2, l4, n2, matches);
                    arrayList.add((BasicBlockMatchData)iAddressPair);
                    arrayList2 = new ArrayList();
                    l2 = l3;
                    l4 = resultSet.getLong(2);
                    n2 = resultSet.getInt(3);
                }
                boolean bl3 = bl2 = resultSet.getObject(4) == null || resultSet.getObject(5) == null;
                if (!bl2) {
                    l5 = resultSet.getLong(4);
                    l6 = resultSet.getLong(5);
                }
                if (resultSet.isFirst()) {
                    l4 = resultSet.getLong(2);
                    n2 = resultSet.getInt(3);
                    l2 = l3;
                    arrayList2 = new ArrayList();
                }
                if (bl2) continue;
                iAddressPair = new InstructionMatchData(l5, l6);
                arrayList2.add((BasicBlockMatchData)iAddressPair);
            }
            Matches<InstructionMatchData> matches = new Matches<InstructionMatchData>(arrayList2);
            iAddressPair = new BasicBlockMatchData(l3, l4, n2, matches);
            arrayList.add((BasicBlockMatchData)iAddressPair);
            functionMatchData.loadBasicBlockMatches(arrayList);
        }
        catch (SQLException sQLException) {
            throw new IOException("Couldn't read basic block and instruction matches.\n" + sQLException.getMessage());
        }
    }

    public String loadDiffDescription() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT description FROM metadata");){
            String string;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    String string2 = string = resultSet.next() ? resultSet.getString("description") : "";
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return string;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public DiffMetadata loadDiffMetadata(File file) {
        try {
            double d2;
            double d3;
            String string;
            String string2;
            String string3;
            ResultSet resultSet;
            try (Statement statement = this.connection.createStatement();){
                resultSet = statement.executeQuery("SELECT version, description, created, similarity, confidence FROM metadata");
                try {
                    resultSet.next();
                    string3 = resultSet.getString("version");
                    string2 = resultSet.getString("description");
                    string = resultSet.getString("created");
                    d3 = resultSet.getDouble("similarity");
                    d2 = resultSet.getDouble("confidence");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            statement = this.connection.createStatement();
            try {
                DiffMetadata diffMetadata;
                block27: {
                    resultSet = statement.executeQuery("SELECT filename, exefilename, hash, functions, libfunctions, calls, basicblocks, libbasicblocks, edges, libedges, instructions, libinstructions FROM file");
                    try {
                        resultSet.next();
                        String string4 = resultSet.getString("filename");
                        String string5 = resultSet.getString("exefilename");
                        String string6 = resultSet.getString("hash");
                        int n2 = resultSet.getInt("functions") + resultSet.getInt("libfunctions");
                        int n3 = resultSet.getInt("calls");
                        int n4 = resultSet.getInt("basicblocks") + resultSet.getInt("libbasicblocks");
                        int n5 = resultSet.getInt("edges") + resultSet.getInt("libedges");
                        int n6 = resultSet.getInt("instructions") + resultSet.getInt("libinstructions");
                        resultSet.next();
                        String string7 = resultSet.getString("filename");
                        String string8 = resultSet.getString("exefilename");
                        String string9 = resultSet.getString("hash");
                        int n7 = resultSet.getInt("functions") + resultSet.getInt("libfunctions");
                        int n8 = resultSet.getInt("calls");
                        int n9 = resultSet.getInt("basicblocks") + resultSet.getInt("libbasicblocks");
                        int n10 = resultSet.getInt("edges") + resultSet.getInt("libedges");
                        int n11 = resultSet.getInt("instructions") + resultSet.getInt("libinstructions");
                        int[] nArray = this.countFunctionSimilarityIntervals();
                        int n12 = this.countMatchedFunctions();
                        DiffMetadata diffMetadata2 = new DiffMetadata(string3, string2, DiffMetadata.dbDateStringToCalendar(string), d3, d2, string4, string7, string5, string8, string6, string9, nArray, n12, n2, n7, n3, n8, n4, n9, n5, n10, n6, n11);
                        MatchesDatabase.addBinExportMetaData(file, diffMetadata2);
                        diffMetadata = diffMetadata2;
                        if (resultSet == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return diffMetadata;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (IOException | SQLException exception) {
            throw new SQLException("Couldn't load diff. Reading meta data from matches database failed: " + exception.getMessage(), exception);
        }
    }

    public IAddressPair loadFunctionDiffAddressPair() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT function.address1, function.address2 FROM function");){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong(1);
                long l3 = resultSet.getLong(2);
                if (!resultSet.next()) {
                    AddressPair addressPair = new AddressPair(l2, l3);
                    return addressPair;
                }
            }
            throw new SQLException("Illegal BinDiff database state: Function matches must be unique.");
        }
    }

    public FunctionDiffMetadata loadFunctionDiffMetadata(boolean bl2) {
        DiffMetadata diffMetadata = this.loadDiffMetadata(null);
        if (bl2) {
            return new FunctionDiffMetadata(diffMetadata, null, null, null, null, null, null);
        }
        IAddressPair iAddressPair = this.loadFunctionDiffAddressPair();
        IAddress iAddress = iAddressPair.getIAddress(ESide.PRIMARY);
        IAddress iAddress2 = iAddressPair.getIAddress(ESide.SECONDARY);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT functionname, functiontype FROM file ORDER BY id");){
            String string = null;
            String string2 = null;
            EFunctionType eFunctionType = null;
            EFunctionType eFunctionType2 = null;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString("functionname");
                eFunctionType = EFunctionType.getType(resultSet.getInt("functiontype"));
            }
            if (resultSet.next()) {
                string2 = resultSet.getString("functionname");
                eFunctionType2 = EFunctionType.getType(resultSet.getInt("functiontype"));
            }
            if (string == null || string2 == null) {
                throw new SQLException("Failed to load function diff meta data: Primary and secondary function must not be null.");
            }
            if (eFunctionType == null || eFunctionType2 == null) {
                throw new SQLException("Failed to load function diff meta data: Primary and secondary function type must not be null.");
            }
            FunctionDiffMetadata functionDiffMetadata = new FunctionDiffMetadata(diffMetadata, iAddress, iAddress2, string, string2, eFunctionType, eFunctionType2);
            return functionDiffMetadata;
        }
    }

    public MatchData loadFunctionMatches(Diff diff) {
        Object object;
        block9: {
            DiffMetadata diffMetadata = diff.getMetadata();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT function.id, function.address1, function.address2, function.similarity, function.confidence, function.flags, function.algorithm, function.basicblocks, function.edges, function.instructions FROM function");
                ArrayList<FunctionMatchData> arrayList = new ArrayList<FunctionMatchData>();
                while (resultSet.next()) {
                    n2 += resultSet.getInt("basicblocks");
                    n3 += resultSet.getInt("edges");
                    n4 += resultSet.getInt("instructions");
                    object = new FunctionMatchData(resultSet.getInt("id"), resultSet.getLong("address1"), resultSet.getLong("address2"), resultSet.getDouble("similarity"), resultSet.getDouble("confidence"), resultSet.getInt("flags"), resultSet.getInt("algorithm"), resultSet.getInt("basicblocks"), resultSet.getInt("edges"), resultSet.getInt("instructions"));
                    arrayList.add((FunctionMatchData)object);
                }
                diffMetadata.setSizeOfMatchedBasicBlocks(n2);
                diffMetadata.setSizeOfMatchedJumps(n3);
                diffMetadata.setSizeOfMatchedInstructions(n4);
                object = new MatchData(arrayList, diffMetadata);
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new SQLException("Couldn't load diff. Reading function matches from database failed: " + sQLException.getMessage());
                }
            }
            statement.close();
        }
        return object;
    }

    public Map<AddressPair, AddressPair> loadMatchedCallAddresses(Diff diff) {
        HashMap<AddressPair, AddressPair> hashMap;
        block34: {
            Object object2;
            hashMap = new HashMap<AddressPair, AddressPair>();
            ArrayList<IAddress> arrayList = new ArrayList<IAddress>();
            for (Object object2 : diff.getCallGraph(ESide.PRIMARY).getEdges()) {
                arrayList.add(((RawCall)object2).getSourceInstructionAddr());
            }
            String string = "SELECT function.address1, instruction.address1, function.address2, instruction.address2 FROM function INNER JOIN basicblock ON function.id = basicblock.functionid INNER JOIN instruction ON basicblock.id = instruction.basicblockid WHERE instruction.address1 IN ";
            object2 = new StringBuilder("SELECT function.address1, instruction.address1, function.address2, instruction.address2 FROM function INNER JOIN basicblock ON function.id = basicblock.functionid INNER JOIN instruction ON basicblock.id = instruction.basicblockid WHERE instruction.address1 IN ");
            boolean bl2 = true;
            try {
                long l2;
                long l3;
                long l4;
                try (Statement statement = this.connection.createStatement();){
                    for (IAddress iAddress : arrayList) {
                        if (bl2) {
                            ((StringBuilder)object2).append("(");
                            bl2 = false;
                        } else {
                            ((StringBuilder)object2).append(",");
                        }
                        ((StringBuilder)object2).append("" + iAddress.toLong());
                        if (((StringBuilder)object2).length() < 999990) continue;
                        ((StringBuilder)object2).append(")");
                        try (ResultSet resultSet = statement.executeQuery(((StringBuilder)object2).toString());){
                            while (resultSet.next()) {
                                l4 = resultSet.getLong(1);
                                l3 = resultSet.getLong(2);
                                l2 = resultSet.getLong(3);
                                long l5 = resultSet.getLong(4);
                                hashMap.put(new AddressPair(l4, l3), new AddressPair(l2, l5));
                            }
                        }
                        object2 = new StringBuilder("SELECT function.address1, instruction.address1, function.address2, instruction.address2 FROM function INNER JOIN basicblock ON function.id = basicblock.functionid INNER JOIN instruction ON basicblock.id = instruction.basicblockid WHERE instruction.address1 IN ");
                        bl2 = true;
                    }
                }
                if (bl2 || ((StringBuilder)object2).length() == "SELECT function.address1, instruction.address1, function.address2, instruction.address2 FROM function INNER JOIN basicblock ON function.id = basicblock.functionid INNER JOIN instruction ON basicblock.id = instruction.basicblockid WHERE instruction.address1 IN ".length()) break block34;
                ((StringBuilder)object2).append(")");
                statement = this.connection.createStatement();
                try (ResultSet resultSet = statement.executeQuery(((StringBuilder)object2).toString());){
                    while (resultSet.next()) {
                        long l6 = resultSet.getLong(1);
                        l4 = resultSet.getLong(2);
                        l3 = resultSet.getLong(3);
                        l2 = resultSet.getLong(4);
                        hashMap.put(new AddressPair(l6, l4), new AddressPair(l3, l2));
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new SQLException("Couldn't read calls matches from database: " + sQLException.getMessage());
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public void saveDiffDescription(String string) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE metadata SET description = ?");){
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
    }

    public void setFunctionDiffCounts(RawFunction rawFunction, RawFunction rawFunction2) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT basicblocks, libbasicblocks, edges, libedges, instructions, libinstructions FROM file ORDER BY id ");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                rawFunction.setSizeOfBasicBlocks(resultSet.getInt("basicblocks") + resultSet.getInt("libbasicblocks"));
                rawFunction.setSizeOfJumps(resultSet.getInt("edges") + resultSet.getInt("libedges"));
                rawFunction.setSizeOfInstructions(resultSet.getInt("instructions") + resultSet.getInt("libinstructions"));
            }
            if (resultSet.next()) {
                rawFunction2.setSizeOfBasicBlocks(resultSet.getInt("basicblocks") + resultSet.getInt("libbasicblocks"));
                rawFunction2.setSizeOfJumps(resultSet.getInt("edges") + resultSet.getInt("libedges"));
                rawFunction2.setSizeOfInstructions(resultSet.getInt("instructions") + resultSet.getInt("libinstructions"));
                return;
            }
            throw new SQLException("Invalid matches database state. File table must consist of exactly two records.");
        }
    }

    public void updateFunctionMatch(long l2, long l3, FunctionMatchData functionMatchData) {
        boolean bl2 = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            this.deleteBasicBlockMatches(l2, l3);
            this.addBasicBlockMatches(functionMatchData);
            this.setFunctionMatchCounts(l2, l3, functionMatchData);
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Couldn't update function match. Executing rollback.");
            this.connection.rollback();
        }
        this.connection.setAutoCommit(bl2);
    }
}

