/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.database;

import com.google.security.zynamics.bindiff.database.SqliteDatabase;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CommentsDatabase
extends SqliteDatabase {
    private static final String STATEMENT_CREATE_BASICBLOCK_COMMENT_TABLE = "CREATE TABLE IF NOT EXISTS bd_basicblockComments (pe_hash VARCHAR(40) NOT NULL, functionAddr BIGINT NOT NULL, basicblockAddr BIGINT NOT NULL, comment long VARCHAR NOT NULL, primary key (pe_hash, functionAddr, basicblockAddr))";
    private static final String STATEMENT_CREATE_INSTRUCTION_COMMENT_TABLE = "CREATE TABLE IF NOT EXISTS bd_instructionComments(pe_hash VARCHAR(40) NOT NULL, functionAddr BIGINT NOT NULL, instructionAddr BIGINT NOT NULL, placement SMALLINT NOT NULL, comment long VARCHAR NOT NULL, PRIMARY KEY (pe_hash, functionAddr, instructionAddr, placement))";

    public CommentsDatabase(Workspace workspace, boolean bl2) {
        super(workspace.getWorkspaceFile());
        if (bl2) {
            this.createTables();
        }
    }

    private void createTables() {
        Statement statement;
        try {
            statement = this.connection.createStatement();
            try {
                statement.executeUpdate(STATEMENT_CREATE_BASICBLOCK_COMMENT_TABLE);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Could not create basic block comment tables: " + sQLException.getMessage(), sQLException);
        }
        try {
            statement = this.connection.createStatement();
            try {
                statement.executeUpdate(STATEMENT_CREATE_INSTRUCTION_COMMENT_TABLE);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Could not create instruction comment tables: " + sQLException.getMessage(), sQLException);
        }
    }

    public Map<IAddress, String> readBasicblockComments(String string, IAddress iAddress) {
        HashMap<IAddress, String> hashMap = new HashMap<IAddress, String>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT basicblockAddr, comment FROM bd_basicblockComments WHERE pe_hash = ? AND functionAddr = ?");){
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, iAddress.toLong());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CAddress cAddress = new CAddress(resultSet.getLong("basicblockAddr"));
                String string2 = resultSet.getString("comment");
                hashMap.put(cAddress, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Couldn't read basic block comments: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    public Map<IAddress, String> readFunctionComments(String string) {
        HashMap<IAddress, String> hashMap = new HashMap<IAddress, String>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT functionAddr, comment FROM bd_functionComments WHERE pe_hash = ?");){
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CAddress cAddress = new CAddress(resultSet.getLong("functionAddr"));
                String string2 = resultSet.getString("comment");
                hashMap.put(cAddress, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Couldn't read function comments: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    public Map<Pair<IAddress, ECommentPlacement>, String> readInstructionComments(String string, IAddress iAddress) {
        HashMap<Pair<IAddress, ECommentPlacement>, String> hashMap = new HashMap<Pair<IAddress, ECommentPlacement>, String>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT instructionAddr, placement, comment FROM bd_instructionComments WHERE pe_hash = ? AND functionAddr = ?");){
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, iAddress.toLong());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CAddress cAddress = new CAddress(resultSet.getLong("instructionAddr"));
                ECommentPlacement eCommentPlacement = ECommentPlacement.valueOf(resultSet.getInt("placement"));
                String string2 = resultSet.getString("comment");
                Pair<CAddress, ECommentPlacement> pair = Pair.make(cAddress, eCommentPlacement);
                hashMap.put(pair, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Couldn't read instruction comments: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    public void writeBasicblockComment(String string, IAddress iAddress, IAddress iAddress2, String string2) {
        block28: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT COUNT(*) AS counter FROM bd_basicblockComments WHERE pe_hash = ? AND functionAddr = ? AND basicblockAddr = ?");){
                preparedStatement.setString(1, string);
                preparedStatement.setLong(2, iAddress.toLong());
                preparedStatement.setLong(3, iAddress2.toLong());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block28;
                if (resultSet.getInt("counter") == 0) {
                    if (string2.isEmpty()) break block28;
                    try (PreparedStatement preparedStatement2 = this.connection.prepareStatement("INSERT INTO bd_basicblockComments VALUES (?, ?, ?, ?)");){
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setLong(2, iAddress.toLong());
                        preparedStatement2.setLong(3, iAddress2.toLong());
                        preparedStatement2.setString(4, string2);
                        preparedStatement2.executeUpdate();
                        break block28;
                    }
                }
                if (string2.isEmpty()) {
                    try (PreparedStatement preparedStatement3 = this.connection.prepareStatement("DELETE FROM bd_basicblockComments WHERE pe_hash = ? AND functionAddr = ? AND basicblockAddr = ?");){
                        preparedStatement3.setString(1, string);
                        preparedStatement3.setLong(2, iAddress.toLong());
                        preparedStatement3.setLong(3, iAddress2.toLong());
                        preparedStatement3.executeUpdate();
                        break block28;
                    }
                }
                try (PreparedStatement preparedStatement4 = this.connection.prepareStatement("UPDATE bd_basicblockComments SET comment = ? WHERE pe_hash = ? AND functionAddr = ? AND basicblockAddr = ?");){
                    preparedStatement4.setString(1, string2);
                    preparedStatement4.setString(2, string);
                    preparedStatement4.setLong(3, iAddress.toLong());
                    preparedStatement4.setLong(4, iAddress2.toLong());
                    preparedStatement4.executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                throw new SQLException("Couldn't write basic block comment into database: " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public void writeFunctionComment(String string, IAddress iAddress, String string2) {
        block30: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT COUNT(*) AS counter FROM bd_functionComments WHERE pe_hash = ? AND functionAddr = ?");){
                preparedStatement.setString(1, string);
                preparedStatement.setLong(2, iAddress.toLong());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    return;
                }
                if (resultSet.getInt("counter") == 0) {
                    if (string2.isEmpty()) break block30;
                    try (PreparedStatement preparedStatement2 = this.connection.prepareStatement("INSERT INTO bd_functionComments VALUES (?, ?, ?)");){
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setLong(2, iAddress.toLong());
                        preparedStatement2.setString(3, string2);
                        preparedStatement2.executeUpdate();
                        break block30;
                    }
                }
                if (string2.isEmpty()) {
                    try (PreparedStatement preparedStatement3 = this.connection.prepareStatement("DELETE FROM bd_functionComments WHERE pe_hash = ? AND functionAddr = ?");){
                        preparedStatement3.setString(1, string);
                        preparedStatement3.setLong(2, iAddress.toLong());
                        preparedStatement3.executeUpdate();
                        break block30;
                    }
                }
                try (PreparedStatement preparedStatement4 = this.connection.prepareStatement("UPDATE bd_functionComments SET comment = ? WHERE pe_hash = ? AND functionAddr = ?");){
                    preparedStatement4.setString(1, string2);
                    preparedStatement4.setString(2, string);
                    preparedStatement4.setLong(3, iAddress.toLong());
                    preparedStatement4.executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                throw new SQLException("Couldn't save function comment in database: " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public void writeInstructionComment(String string, IAddress iAddress, IAddress iAddress2, ECommentPlacement eCommentPlacement, String string2) {
        block15: {
            try {
                if (!string2.isEmpty()) {
                    try (PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT OR REPLACE INTO bd_instructionComments (pe_hash, functionAddr, instructionAddr, placement, comment) VALUES (?, ?, ?, ?, ?)");){
                        preparedStatement.setString(1, string);
                        preparedStatement.setLong(2, iAddress.toLong());
                        preparedStatement.setLong(3, iAddress2.toLong());
                        preparedStatement.setShort(4, (short)ECommentPlacement.getOrdinal(eCommentPlacement));
                        preparedStatement.setString(5, string2);
                        preparedStatement.executeUpdate();
                        break block15;
                    }
                }
                try (PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM bd_instructionComments WHERE pe_hash = ? AND functionAddr = ? AND instructionAddr = ? AND placement = ?");){
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, iAddress.toLong());
                    preparedStatement.setLong(3, iAddress2.toLong());
                    preparedStatement.setShort(4, (short)ECommentPlacement.getOrdinal(eCommentPlacement));
                    preparedStatement.executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                throw new SQLException("Couldn't store instruction comment in database: " + sQLException.getMessage(), sQLException);
            }
        }
    }
}

