/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.config;

import com.google.security.zynamics.bindiff.config.ConfigItem;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class ThemeConfigItem
extends ConfigItem {
    private static final String USE_THEME = "/bindiff/preferences/use-theme/@name";
    private static final String USE_THEME_DEFAULT = "Google Material";
    private String useTheme = "Google Material";
    private static final String BASED_ON_FMT = "/bindiff/theme[@name='%s']/@based-on";
    private String basedOn;
    private static final String SIMILARITY_COLOR_RAMP_FMT = "/bindiff/theme[@name='%s']/ramp[@for='similarity']/c/@v";
    private static final Color[] SIMILARITY_COLOR_RAMP_DEFAULT = new Color[]{new Color(16733986), new Color(16733986), new Color(16734498), new Color(16734498), new Color(16734754), new Color(16735009), new Color(16735009), new Color(16735265), new Color(16735521), new Color(16735777), new Color(16736033), new Color(16736033), new Color(16736033), new Color(16736544), new Color(16736544), new Color(16736800), new Color(16736800), new Color(16737056), new Color(16737312), new Color(16737568), new Color(0xFF661F), new Color(16738079), new Color(0xFF661F), new Color(16738079), new Color(16738335), new Color(16738591), new Color(16738591), new Color(16738846), new Color(16739102), new Color(16739358), new Color(16673822), new Color(16674078), new Color(16674590), new Color(16674590), new Color(16674845), new Color(16675101), new Color(16674845), new Color(16675357), new Color(16675357), new Color(16675613), new Color(16675613), new Color(16675869), new Color(16610588), new Color(16676124), new Color(16610844), new Color(16611100), new Color(16611100), new Color(16611611), new Color(16611611), new Color(16611867), new Color(16611867), new Color(16611867), new Color(16546843), new Color(16547099), new Color(16547098), new Color(16547354), new Color(16547610), new Color(16547610), new Color(16547610), new Color(16482586), new Color(16482585), new Color(16482585), new Color(16483097), new Color(16482841), new Color(16483353), new Color(16483353), new Color(16418072), new Color(16418328), new Color(16418584), new Color(16418584), new Color(16418840), new Color(16418584), new Color(16353815), new Color(16353559), new Color(16354071), new Color(16353815), new Color(16354327), new Color(16289047), new Color(16288791), new Color(16289046), new Color(16289302), new Color(16224022), new Color(16224278), new Color(16224277), new Color(16224533), new Color(16224789), new Color(16159253), new Color(16159253), new Color(16159509), new Color(16159765), new Color(16094484), new Color(16094484), new Color(16094740), new Color(16029460), new Color(16029460), new Color(16029715), new Color(16029715), new Color(16029971), new Color(15964691), new Color(15964691), new Color(15964947), new Color(15899666), new Color(15899922), new Color(15899922), new Color(15834642), new Color(15834641), new Color(0xF19F11), new Color(15769617), new Color(15835153), new Color(15769617), new Color(15769873), new Color(15704592), new Color(15704592), new Color(15705104), new Color(15639568), new Color(15639824), new Color(15639823), new Color(15574543), new Color(15574799), new Color(15575055), new Color(15509774), new Color(15509518), new Color(15509774), new Color(15444238), new Color(15444494), new Color(15444750), new Color(15379469), new Color(15379469), new Color(15314189), new Color(15314189), new Color(15248908), new Color(15249164), new Color(15249164), new Color(15183883), new Color(15184139), new Color(15118859), new Color(15118859), new Color(15118859), new Color(15053578), new Color(15053578), new Color(14988554), new Color(14988554), new Color(14923273), new Color(14923529), new Color(14923529), new Color(14857993), new Color(14792713), new Color(14792968), new Color(14793224), new Color(14792968), new Color(14662408), new Color(14662408), new Color(14597127), new Color(14597127), new Color(14597639), new Color(14597383), new Color(14532103), new Color(14532103), new Color(14401542), new Color(14401542), new Color(14336518), new Color(14336262), new Color(14336518), new Color(14270981), new Color(14205957), new Color(14205957), new Color(14140421), new Color(14140676), new Color(14140676), new Color(14075396), new Color(14010372), new Color(14010116), new Color(13945092), new Color(13879555), new Color(13879811), new Color(13814531), new Color(13814275), new Color(13749251), new Color(13683971), new Color(13683715), new Color(13683715), new Color(13618434), new Color(13553154), new Color(13487874), new Color(13357058), new Color(13357314), new Color(13357058), new Color(13292034), new Color(13291778), new Color(13226753), new Color(13161473), new Color(13095937), new Color(13096193), new Color(12965377), new Color(12965377), new Color(12900097), new Color(12834816), new Color(12834560), new Color(12769280), new Color(12769280), new Color(12638720), new Color(12573184), new Color(12573184), new Color(12508160), new Color(12507904), new Color(12377344), new Color(12312064), new Color(0xBBDD00), new Color(12246528), new Color(12246528), new Color(12115968), new Color(12050688), new Color(12050688), new Color(11919616), new Color(11919616), new Color(11854592), new Color(11854336), new Color(11723776), new Color(11658240), new Color(11658240), new Color(11527680), new Color(11462144), new Color(11396608), new Color(11331584), new Color(11331328), new Color(11200768), new Color(11200512), new Color(11069696), new Color(10939136), new Color(10938880), new Color(10808064), new Color(10808320), new Color(10743040), new Color(10612224), new Color(10612224), new Color(10611968), new Color(10481152), new Color(10350336), new Color(10350336), new Color(10219520), new Color(10023424), new Color(10023424), new Color(9892608), new Color(9892608), new Color(9761537), new Color(9761793), new Color(9630721), new Color(9434625), new Color(9434625), new Color(9303553), new Color(9238273), new Color(9172737), new Color(8976386), new Color(8976642), new Color(8780290), new Color(8714754)};
    private static Color[] similarityColorRamp = SIMILARITY_COLOR_RAMP_DEFAULT;
    private static final String DEFAULT_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='default']/@v";
    private static final Color DEFAULT_COLOR_DEFAULT = new Color(-16777216);
    private Color defaultColor = DEFAULT_COLOR_DEFAULT;
    private static final String ADDRESS_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='address']/@v";
    private static final Color ADDRESS_COLOR_DEFAULT = new Color(-16777216);
    private Color addressColor = ADDRESS_COLOR_DEFAULT;
    private static final String MNEMONIC_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='mnemonic']/@v";
    private static final Color MNEMONIC_COLOR_DEFAULT = new Color(-16777088);
    private Color mnemonicColor = MNEMONIC_COLOR_DEFAULT;
    private static final String SYMBOL_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='symbol']/@v";
    private static final Color SYMBOL_COLOR_DEFAULT = new Color(-7076089);
    private Color symbolColor = SYMBOL_COLOR_DEFAULT;
    private static final String IMMEDIATE_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='immediate']/@v";
    private static final Color IMMEDIATE_COLOR_DEFAULT = new Color(-7602176);
    private Color immediateColor = IMMEDIATE_COLOR_DEFAULT;
    private static final String OPERATOR_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='operator']/@v";
    private static final Color OPERATOR_COLOR_DEFAULT = new Color(-16711423);
    private Color operatorColor = OPERATOR_COLOR_DEFAULT;
    private static final String REGISTER_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='register']/@v";
    private static final Color REGISTER_COLOR_DEFAULT = new Color(-16750615);
    private Color registerColor = REGISTER_COLOR_DEFAULT;
    private static final String SIZE_PREFIX_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='size-prefix']/@v";
    private static final Color SIZE_PREFIX_COLOR_DEFAULT = new Color(-6316386);
    private Color sizePrefixColor = SIZE_PREFIX_COLOR_DEFAULT;
    private static final String DEREFERENCE_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='dereference']/@v";
    private static final Color DEREFERENCE_COLOR_DEFAULT = new Color(-16711423);
    private Color dereferenceColor = DEREFERENCE_COLOR_DEFAULT;
    private static final String OPERATOR_SEPARATOR_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='operator-separator']/@v";
    private static final Color OPERATOR_SEPARATOR_COLOR_DEFAULT = new Color(-16777216);
    private Color operatorSeparatorColor = OPERATOR_SEPARATOR_COLOR_DEFAULT;
    private static final String STACK_VARIABLE_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='stack-var']/@v";
    private static final Color STACK_VARIABLE_COLOR_DEFAULT = new Color(-7602176);
    private Color stackVariableColor = STACK_VARIABLE_COLOR_DEFAULT;
    private static final String GLOBAL_VARIABLE_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='global-var']/@v";
    private static final Color GLOBAL_VARIABLE_COLOR_DEFAULT = new Color(-7602176);
    private Color globalVariableColor = GLOBAL_VARIABLE_COLOR_DEFAULT;
    private static final String JUMP_LABEL_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='jump-label']/@v";
    private static final Color JUMP_LABEL_COLOR_DEFAULT = new Color(-6291296);
    private Color jumpLabelColor = JUMP_LABEL_COLOR_DEFAULT;
    private static final String FUNCTION_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='function']/@v";
    private static final Color FUNCTION_COLOR_DEFAULT = new Color(-7602176);
    private Color functionColor = FUNCTION_COLOR_DEFAULT;
    private static final String COMMENT_COLOR_FMT = "/bindiff/theme[@name='%s']/c[@for='comment']/@v";
    private static final Color COMMENT_COLOR_DEFAULT = new Color(-10197916);
    private Color commentColor = COMMENT_COLOR_DEFAULT;
    private static final String UI_FONT_NAME_FMT = "/bindiff/theme[@name='%s']/f[@for='ui']/@v";
    private static final String UI_FONT_SIZE_FMT = "/bindiff/theme[@name='%s']/f[@for='ui']/@s";
    private static final String UI_FONT_NAME_DEFAULT = "Roboto";
    private Font uiFont;
    private static final String CODE_FONT_NAME_FMT = "/bindiff/theme[@name='%s']/f[@for='code']/@v";
    private static final String CODE_FONT_SIZE_FMT = "/bindiff/theme[@name='%s']/f[@for='code']/@s";
    private static final String CODE_FONT_NAME_DEFAULT = "Roboto Mono";
    private Font codeFont;

    private Color getThemeColor(Document document, String string, Color color) {
        Color color2 = ThemeConfigItem.getColor(document, String.format(string, this.useTheme), this.basedOn.isEmpty() ? color : null);
        return color2 == null ? ThemeConfigItem.getColor(document, String.format(string, this.basedOn), color) : color2;
    }

    private void setThemeColor(Document document, String string, Color color) {
        ThemeConfigItem.setColor(document, String.format(string, this.useTheme), color);
    }

    private Font getThemeFont(Document document, String string, String string2, String string3) {
        int n2;
        String string4 = ThemeConfigItem.getString(document, String.format(string, this.useTheme), this.basedOn.isEmpty() ? string3 : null);
        if (string4 == null) {
            string4 = ThemeConfigItem.getString(document, String.format(string, this.basedOn), string3);
        }
        if ((n2 = ThemeConfigItem.getInteger(document, String.format(string2, this.useTheme), this.basedOn.isEmpty() ? 13 : -1)) == -1) {
            string4 = ThemeConfigItem.getString(document, String.format(string2, this.basedOn), string3);
        }
        return new Font(string4, 0, n2);
    }

    private void setThemeFont(Document document, String string, String string2, Font font) {
        ThemeConfigItem.setString(document, String.format(string, this.useTheme), font.getFontName());
        ThemeConfigItem.setInteger(document, String.format(string2, this.useTheme), font.getSize());
    }

    @Override
    public void load(Document document) {
        this.useTheme = ThemeConfigItem.getString(document, USE_THEME, USE_THEME_DEFAULT);
        this.basedOn = ThemeConfigItem.getString(document, String.format(BASED_ON_FMT, this.useTheme), "");
        List<String> list = ThemeConfigItem.getStrings(document, String.format(SIMILARITY_COLOR_RAMP_FMT, this.useTheme), null);
        if (list != null) {
            ArrayList<Color> arrayList = new ArrayList<Color>();
            try {
                for (String string : list) {
                    arrayList.add(Color.decode(string));
                }
                if (!arrayList.isEmpty()) {
                    similarityColorRamp = arrayList.toArray(new Color[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.defaultColor = this.getThemeColor(document, DEFAULT_COLOR_FMT, DEFAULT_COLOR_DEFAULT);
        this.addressColor = this.getThemeColor(document, ADDRESS_COLOR_FMT, ADDRESS_COLOR_DEFAULT);
        this.mnemonicColor = this.getThemeColor(document, MNEMONIC_COLOR_FMT, MNEMONIC_COLOR_DEFAULT);
        this.symbolColor = this.getThemeColor(document, SYMBOL_COLOR_FMT, SYMBOL_COLOR_DEFAULT);
        this.immediateColor = this.getThemeColor(document, IMMEDIATE_COLOR_FMT, IMMEDIATE_COLOR_DEFAULT);
        this.operatorColor = this.getThemeColor(document, OPERATOR_COLOR_FMT, OPERATOR_COLOR_DEFAULT);
        this.registerColor = this.getThemeColor(document, REGISTER_COLOR_FMT, REGISTER_COLOR_DEFAULT);
        this.sizePrefixColor = this.getThemeColor(document, SIZE_PREFIX_COLOR_FMT, SIZE_PREFIX_COLOR_DEFAULT);
        this.dereferenceColor = this.getThemeColor(document, DEREFERENCE_COLOR_FMT, DEREFERENCE_COLOR_DEFAULT);
        this.operatorSeparatorColor = this.getThemeColor(document, OPERATOR_SEPARATOR_COLOR_FMT, OPERATOR_SEPARATOR_COLOR_DEFAULT);
        this.stackVariableColor = this.getThemeColor(document, STACK_VARIABLE_COLOR_FMT, STACK_VARIABLE_COLOR_DEFAULT);
        this.globalVariableColor = this.getThemeColor(document, GLOBAL_VARIABLE_COLOR_FMT, GLOBAL_VARIABLE_COLOR_DEFAULT);
        this.jumpLabelColor = this.getThemeColor(document, JUMP_LABEL_COLOR_FMT, JUMP_LABEL_COLOR_DEFAULT);
        this.functionColor = this.getThemeColor(document, FUNCTION_COLOR_FMT, FUNCTION_COLOR_DEFAULT);
        this.commentColor = this.getThemeColor(document, COMMENT_COLOR_FMT, COMMENT_COLOR_DEFAULT);
        this.uiFont = this.getThemeFont(document, UI_FONT_NAME_FMT, UI_FONT_SIZE_FMT, UI_FONT_NAME_DEFAULT);
        this.codeFont = this.getThemeFont(document, CODE_FONT_NAME_FMT, CODE_FONT_SIZE_FMT, CODE_FONT_NAME_DEFAULT);
    }

    @Override
    public void store(Document document) {
        ThemeConfigItem.setString(document, USE_THEME, this.useTheme);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Color color : similarityColorRamp) {
            arrayList.add(String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
        }
        ThemeConfigItem.setStrings(document, String.format(SIMILARITY_COLOR_RAMP_FMT, this.useTheme), arrayList);
        this.setThemeColor(document, DEFAULT_COLOR_FMT, this.defaultColor);
        this.setThemeColor(document, ADDRESS_COLOR_FMT, this.addressColor);
        this.setThemeColor(document, MNEMONIC_COLOR_FMT, this.mnemonicColor);
        this.setThemeColor(document, SYMBOL_COLOR_FMT, this.symbolColor);
        this.setThemeColor(document, IMMEDIATE_COLOR_FMT, this.immediateColor);
        this.setThemeColor(document, OPERATOR_COLOR_FMT, this.operatorColor);
        this.setThemeColor(document, REGISTER_COLOR_FMT, this.registerColor);
        this.setThemeColor(document, SIZE_PREFIX_COLOR_FMT, this.sizePrefixColor);
        this.setThemeColor(document, DEREFERENCE_COLOR_FMT, this.dereferenceColor);
        this.setThemeColor(document, OPERATOR_SEPARATOR_COLOR_FMT, this.operatorSeparatorColor);
        this.setThemeColor(document, STACK_VARIABLE_COLOR_FMT, this.stackVariableColor);
        this.setThemeColor(document, GLOBAL_VARIABLE_COLOR_FMT, this.globalVariableColor);
        this.setThemeColor(document, JUMP_LABEL_COLOR_FMT, this.jumpLabelColor);
        this.setThemeColor(document, FUNCTION_COLOR_FMT, this.functionColor);
        this.setThemeColor(document, COMMENT_COLOR_FMT, this.commentColor);
        this.setThemeFont(document, UI_FONT_NAME_FMT, UI_FONT_SIZE_FMT, this.uiFont);
        this.setThemeFont(document, CODE_FONT_NAME_FMT, CODE_FONT_SIZE_FMT, this.codeFont);
    }

    public final Color[] getSimilarityColorRamp() {
        return similarityColorRamp;
    }

    public final Color getDefaultColor() {
        return this.defaultColor;
    }

    public final Color getAddressColor() {
        return this.addressColor;
    }

    public final Color getMnemonicColor() {
        return this.mnemonicColor;
    }

    public final Color getSymbolColor() {
        return this.symbolColor;
    }

    public final Color getImmediateColor() {
        return this.immediateColor;
    }

    public final Color getOperatorColor() {
        return this.operatorColor;
    }

    public final Color getRegisterColor() {
        return this.registerColor;
    }

    public final Color getSizePrefixColor() {
        return this.sizePrefixColor;
    }

    public final Color getDereferenceColor() {
        return this.dereferenceColor;
    }

    public final Color getOperatorSeparatorColor() {
        return this.operatorSeparatorColor;
    }

    public final Color getStackVariableColor() {
        return this.stackVariableColor;
    }

    public final Color getGlobalVariableColor() {
        return this.globalVariableColor;
    }

    public final Color getJumpLabelColor() {
        return this.jumpLabelColor;
    }

    public final Color getFunctionColor() {
        return this.functionColor;
    }

    public final Color getCommentColor() {
        return this.commentColor;
    }

    public Font getUiFont() {
        return this.uiFont;
    }

    public Font getCodeFont() {
        return this.codeFont;
    }

    public final void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public final void setAddressColor(Color color) {
        this.addressColor = color;
    }

    public final void setMnemonicColor(Color color) {
        this.mnemonicColor = color;
    }

    public final void setSymbolColor(Color color) {
        this.symbolColor = color;
    }

    public final void setImmediateColor(Color color) {
        this.immediateColor = color;
    }

    public final void setOperatorColor(Color color) {
        this.operatorColor = color;
    }

    public final void setRegisterColor(Color color) {
        this.registerColor = color;
    }

    public final void setSizePrefixColor(Color color) {
        this.sizePrefixColor = color;
    }

    public final void setDereferenceColor(Color color) {
        this.dereferenceColor = color;
    }

    public final void setOperatorSeparatorColor(Color color) {
        this.operatorSeparatorColor = color;
    }

    public final void setStackVariableColor(Color color) {
        this.stackVariableColor = color;
    }

    public final void setGlobalVariableColor(Color color) {
        this.globalVariableColor = color;
    }

    public final void setJumpLabelColor(Color color) {
        this.jumpLabelColor = color;
    }

    public final void setFunctionColor(Color color) {
        this.functionColor = color;
    }

    public final void setCommentColor(Color color) {
        this.commentColor = color;
    }

    public void setUiFont(Font font) {
        this.uiFont = font;
    }

    public void setCodeFont(Font font) {
        this.codeFont = font;
    }
}

