/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.config;

import com.google.common.base.Ascii;
import com.google.security.zynamics.bindiff.config.ConfigItem;
import com.google.security.zynamics.bindiff.enums.ECircularLayoutStyle;
import com.google.security.zynamics.bindiff.enums.EGraphLayout;
import com.google.security.zynamics.bindiff.enums.ELayoutOrientation;
import com.google.security.zynamics.bindiff.enums.EMouseAction;
import com.google.security.zynamics.bindiff.enums.EOrthogonalLayoutStyle;
import org.w3c.dom.Document;

public abstract class GraphViewSettingsConfigItem
extends ConfigItem {
    private static final String DEFAULT_GRAPH_LAYOUT = "layout/@default";
    private static final EGraphLayout DEFAULT_GRAPH_LAYOUT_DEFAULT = EGraphLayout.HIERARCHICAL;
    private EGraphLayout defaultGraphLayout = DEFAULT_GRAPH_LAYOUT_DEFAULT;
    private static final String AUTO_LAYOUTING = "layout/@auto";
    private static final boolean AUTO_LAYOUTING_DEFAULT = true;
    private boolean autoLayouting = true;
    private static final String PROXIMITY_BROWSING = "proximity-browsing/@enabled";
    private static final boolean PROXIMITY_BROWSING_DEFAULT = true;
    private boolean proximityBrowsing = true;
    private static final String PROXIMITY_BROWSING_CHILD_DEPTH = "proximity-browsing/@child-depth";
    private int proximityBrowsingChildDepth;
    private static final String PROXIMITY_BROWSING_PARENT_DEPTH = "proximity-browsing/@parent-depth";
    private int proximityBrowsingParentDepth;
    private static final String AUTO_PROXIMITY_BROWSING_ACTIVATION_THRESHOLD = "proximity-browsing/@auto-enable-threshold";
    private int autoProximityBrowsingActivationThreshold;
    private static final String VISIBILITY_WARNING_THRESHOLD = "proximity-browsing/@visibility-warn-threshold";
    private int visibilityWarningThreshold;
    private static final String DRAW_BENDS = "layout/@draw-bends";
    private static final boolean DRAW_BENDS_DEFAULT = false;
    private boolean drawBends = false;
    private static final String HIERARCHICAL_ORTHOGONAL_EDGEROUTING = "hierarchical-layout/@style";
    private static final boolean HIERARCHICAL_ORTHOGONAL_EDGEROUTING_DEFAULT = false;
    private boolean hierarchicalOrthogonalEdgeRouting = false;
    private static final String HIERARCHICAL_ORIENTATION = "hierarchical-layout/@orientation";
    private int hierarchicalOrientation;
    private static final String HIERARCHICAL_MINIMUM_LAYER_DISTANCE = "hierarchical-layout/@min-layer-distance";
    private static final int HIERARCHICAL_MINIMUM_LAYER_DISTANCE_DEFAULT = 50;
    private int hierarchicalMinimumLayerDistance = 50;
    private static final String HIERARCHICAL_MINIMUM_NODE_DISTANCE = "hierarchical-layout/@min-node-distance";
    private static final int HIERARCHICAL_MINIMUM_NODE_DISTANCE_DEFAULT = 25;
    private int hierarchicalMinimumNodeDistance = 25;
    private static final String ORTHOGONAL_LAYOUT_STYLE = "orthogonal-layout/@style";
    private static final EOrthogonalLayoutStyle ORTHOGONAL_LAYOUT_STYLE_DEFAULT = EOrthogonalLayoutStyle.NORMAL;
    private EOrthogonalLayoutStyle orthogonalLayoutStyle = ORTHOGONAL_LAYOUT_STYLE_DEFAULT;
    private static final String ORTHOGONAL_ORIENTATION = "orthogonal-layout/@orientation";
    private static final ELayoutOrientation ORTHOGONAL_ORIENTATION_DEFAULT = ELayoutOrientation.VERTICAL;
    private ELayoutOrientation orthogonalOrientation = ORTHOGONAL_ORIENTATION_DEFAULT;
    private static final String ORTHOGONAL_MINIMUM_NODE_DISTANCE = "orthogonal-layout/@min-node-distance";
    private static final int ORTHOGONAL_MINIMUM_NODE_DISTANCE_DEFAULT = 50;
    private int orthogonalMinimumNodeDistance = 50;
    private static final String CIRCULAR_LAYOUT_STYLE = "circular-layout/@style";
    private static final ECircularLayoutStyle CIRCULAR_LAYOUT_STYLE_DEFAULT = ECircularLayoutStyle.COMPACT;
    private ECircularLayoutStyle circularLayoutStyle = CIRCULAR_LAYOUT_STYLE_DEFAULT;
    private static final String CIRCULAR_MINIMUM_NODE_DISTANCE = "circular-layout/@min-node-distance";
    private static final int CIRCULAR_MINIMUM_NODE_DISTANCE_DEFAULT = 50;
    private int circularMinimumNodeDistance = 50;
    private static final String SCROLL_SENSITIVITY = "control/@scroll-sensitivity";
    private static final int SCROLL_SENSITIVITY_DEFAULT = 4;
    private int scrollSensitivity = 4;
    private static final String ZOOM_SENSITIVITY = "control/@zoom-sensitivity";
    private static final int ZOOM_SENSITIVITY_DEFAULT = 4;
    private int zoomSensitivity = 4;
    private static final String MOUSE_WHEEL_ACTION = "control/@wheel-action";
    private static final EMouseAction MOUSE_WHEEL_ACTION_DEFAULT = EMouseAction.SCROLL;
    private EMouseAction mouseWheelAction = MOUSE_WHEEL_ACTION_DEFAULT;
    private static final String VIEW_SYNCHRONIZATION = "control/@view-synchronization";
    private static final boolean VIEW_SYNCHRONIZATION_DEFAULT = true;
    private boolean viewSynchronization = true;
    private static final String SHOW_SCROLLBARS = "control/@show-scrollbars";
    private static final boolean SHOW_SCROLLBARS_DEFAULT = false;
    private boolean showScrollbars = false;
    private static final String ANIMATION_SPEED = "layout/@animation-speed";
    private static final int ANIMATION_SPEED_DEFAULT = 5;
    private int animationSpeed = 5;

    GraphViewSettingsConfigItem() {
        this.proximityBrowsingChildDepth = this.getProximityBrowsingChildDepthDefaultValue();
        this.proximityBrowsingParentDepth = this.getProximityBrowsingParentDepthDefaultValue();
        this.autoProximityBrowsingActivationThreshold = this.getAutoProximityBrowsingActivationThresholdDefaultValue();
        this.visibilityWarningThreshold = this.getVisibilityWarningThresholdDefaultValue();
        this.hierarchicalOrientation = this.getHierarchicalOrientationDefaultValue();
    }

    protected abstract String getXPath(String var1);

    protected abstract int getProximityBrowsingChildDepthDefaultValue();

    protected abstract int getProximityBrowsingParentDepthDefaultValue();

    protected abstract int getAutoProximityBrowsingActivationThresholdDefaultValue();

    protected abstract int getVisibilityWarningThresholdDefaultValue();

    protected abstract int getHierarchicalOrientationDefaultValue();

    @Override
    public void load(Document document) {
        switch (Ascii.toLowerCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(DEFAULT_GRAPH_LAYOUT), ""))) {
            case "hierarchical": {
                this.defaultGraphLayout = EGraphLayout.HIERARCHICAL;
                break;
            }
            case "orthogonal": {
                this.defaultGraphLayout = EGraphLayout.ORTHOGONAL;
                break;
            }
            case "circular": {
                this.defaultGraphLayout = EGraphLayout.CIRCULAR;
                break;
            }
        }
        this.autoLayouting = GraphViewSettingsConfigItem.getBoolean(document, this.getXPath(AUTO_LAYOUTING), true);
        this.proximityBrowsing = GraphViewSettingsConfigItem.getBoolean(document, this.getXPath(PROXIMITY_BROWSING), true);
        this.proximityBrowsingChildDepth = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(PROXIMITY_BROWSING_CHILD_DEPTH), this.getProximityBrowsingChildDepthDefaultValue());
        this.proximityBrowsingParentDepth = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(PROXIMITY_BROWSING_PARENT_DEPTH), this.getProximityBrowsingParentDepthDefaultValue());
        this.autoProximityBrowsingActivationThreshold = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(AUTO_PROXIMITY_BROWSING_ACTIVATION_THRESHOLD), this.getAutoProximityBrowsingActivationThresholdDefaultValue());
        this.visibilityWarningThreshold = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(VISIBILITY_WARNING_THRESHOLD), this.getVisibilityWarningThresholdDefaultValue());
        this.drawBends = GraphViewSettingsConfigItem.getBoolean(document, this.getXPath(DRAW_BENDS), false);
        switch (Ascii.toLowerCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(HIERARCHICAL_ORTHOGONAL_EDGEROUTING), ""))) {
            case "orthogonal-edge-routing": {
                this.hierarchicalOrthogonalEdgeRouting = true;
                break;
            }
        }
        this.hierarchicalOrientation = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(HIERARCHICAL_ORIENTATION), this.getHierarchicalOrientationDefaultValue());
        this.hierarchicalMinimumLayerDistance = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(HIERARCHICAL_MINIMUM_LAYER_DISTANCE), 50);
        this.hierarchicalMinimumNodeDistance = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(HIERARCHICAL_MINIMUM_NODE_DISTANCE), 25);
        switch (Ascii.toLowerCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(ORTHOGONAL_LAYOUT_STYLE), ""))) {
            case "normal": {
                this.orthogonalLayoutStyle = EOrthogonalLayoutStyle.NORMAL;
                break;
            }
            case "tree": {
                this.orthogonalLayoutStyle = EOrthogonalLayoutStyle.TREE;
                break;
            }
        }
        switch (Ascii.toLowerCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(ORTHOGONAL_ORIENTATION), ""))) {
            case "vertical": {
                this.orthogonalOrientation = ELayoutOrientation.VERTICAL;
                break;
            }
            case "horizontal": {
                this.orthogonalOrientation = ELayoutOrientation.HORIZONTAL;
                break;
            }
        }
        this.orthogonalMinimumNodeDistance = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(ORTHOGONAL_MINIMUM_NODE_DISTANCE), 50);
        switch (Ascii.toLowerCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(CIRCULAR_LAYOUT_STYLE), ""))) {
            case "compact": {
                this.circularLayoutStyle = ECircularLayoutStyle.COMPACT;
                break;
            }
            case "isolated": {
                this.circularLayoutStyle = ECircularLayoutStyle.ISOLATED;
                break;
            }
            case "single-cycle": {
                this.circularLayoutStyle = ECircularLayoutStyle.SINGLE_CYCLE;
                break;
            }
        }
        this.circularMinimumNodeDistance = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(CIRCULAR_MINIMUM_NODE_DISTANCE), 50);
        this.scrollSensitivity = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(SCROLL_SENSITIVITY), 4);
        this.zoomSensitivity = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(ZOOM_SENSITIVITY), 4);
        try {
            this.mouseWheelAction = EMouseAction.valueOf(Ascii.toUpperCase(GraphViewSettingsConfigItem.getString(document, this.getXPath(MOUSE_WHEEL_ACTION), MOUSE_WHEEL_ACTION_DEFAULT.toString())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.viewSynchronization = GraphViewSettingsConfigItem.getBoolean(document, this.getXPath(VIEW_SYNCHRONIZATION), true);
        this.showScrollbars = GraphViewSettingsConfigItem.getBoolean(document, this.getXPath(SHOW_SCROLLBARS), false);
        this.animationSpeed = GraphViewSettingsConfigItem.getInteger(document, this.getXPath(ANIMATION_SPEED), 5);
    }

    @Override
    public void store(Document document) {
        switch (this.defaultGraphLayout) {
            case HIERARCHICAL: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(DEFAULT_GRAPH_LAYOUT), "hierarchical");
                break;
            }
            case ORTHOGONAL: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(DEFAULT_GRAPH_LAYOUT), "orthogonal");
                break;
            }
            case CIRCULAR: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(DEFAULT_GRAPH_LAYOUT), "circular");
            }
        }
        GraphViewSettingsConfigItem.setBoolean(document, this.getXPath(AUTO_LAYOUTING), this.autoLayouting);
        GraphViewSettingsConfigItem.setBoolean(document, this.getXPath(PROXIMITY_BROWSING), this.proximityBrowsing);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(PROXIMITY_BROWSING_CHILD_DEPTH), this.proximityBrowsingChildDepth);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(PROXIMITY_BROWSING_PARENT_DEPTH), this.proximityBrowsingParentDepth);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(AUTO_PROXIMITY_BROWSING_ACTIVATION_THRESHOLD), this.autoProximityBrowsingActivationThreshold);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(VISIBILITY_WARNING_THRESHOLD), this.visibilityWarningThreshold);
        GraphViewSettingsConfigItem.setBoolean(document, this.getXPath(DRAW_BENDS), this.drawBends);
        GraphViewSettingsConfigItem.setString(document, this.getXPath(HIERARCHICAL_ORTHOGONAL_EDGEROUTING), this.hierarchicalOrthogonalEdgeRouting ? "orthogonal-edge-routing" : "default");
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(HIERARCHICAL_ORIENTATION), this.hierarchicalOrientation);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(HIERARCHICAL_MINIMUM_LAYER_DISTANCE), this.hierarchicalMinimumLayerDistance);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(HIERARCHICAL_MINIMUM_NODE_DISTANCE), this.hierarchicalMinimumNodeDistance);
        switch (this.orthogonalLayoutStyle) {
            case NORMAL: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(ORTHOGONAL_LAYOUT_STYLE), "default");
                break;
            }
            case TREE: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(ORTHOGONAL_LAYOUT_STYLE), "tree");
            }
        }
        switch (this.orthogonalOrientation) {
            case VERTICAL: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(ORTHOGONAL_ORIENTATION), "vertical");
                break;
            }
            case HORIZONTAL: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(ORTHOGONAL_ORIENTATION), "horizontal");
            }
        }
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(ORTHOGONAL_MINIMUM_NODE_DISTANCE), this.orthogonalMinimumNodeDistance);
        switch (this.circularLayoutStyle) {
            case COMPACT: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(CIRCULAR_LAYOUT_STYLE), "compact");
                break;
            }
            case ISOLATED: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(CIRCULAR_LAYOUT_STYLE), "isolated");
                break;
            }
            case SINGLE_CYCLE: {
                GraphViewSettingsConfigItem.setString(document, this.getXPath(CIRCULAR_LAYOUT_STYLE), "single-cycle");
            }
        }
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(CIRCULAR_MINIMUM_NODE_DISTANCE), this.circularMinimumNodeDistance);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(SCROLL_SENSITIVITY), this.scrollSensitivity);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(ZOOM_SENSITIVITY), this.zoomSensitivity);
        GraphViewSettingsConfigItem.setString(document, this.getXPath(MOUSE_WHEEL_ACTION), Ascii.toLowerCase(this.mouseWheelAction.toString()));
        GraphViewSettingsConfigItem.setBoolean(document, this.getXPath(VIEW_SYNCHRONIZATION), this.viewSynchronization);
        GraphViewSettingsConfigItem.setBoolean(document, this.getXPath(SHOW_SCROLLBARS), this.showScrollbars);
        GraphViewSettingsConfigItem.setInteger(document, this.getXPath(ANIMATION_SPEED), this.animationSpeed);
    }

    public final EGraphLayout getDefaultGraphLayout() {
        return this.defaultGraphLayout;
    }

    public final boolean getAutoLayouting() {
        return this.autoLayouting;
    }

    public final boolean getProximityBrowsing() {
        return this.proximityBrowsing;
    }

    public final int getProximityBrowsingChildDepth() {
        return this.proximityBrowsingChildDepth;
    }

    public final int getProximityBrowsingParentDepth() {
        return this.proximityBrowsingParentDepth;
    }

    public final int getAutoProximityBrowsingActivationThreshold() {
        return this.autoProximityBrowsingActivationThreshold;
    }

    public final int getVisibilityWarningThreshold() {
        return this.visibilityWarningThreshold;
    }

    public final boolean getDrawBends() {
        return this.drawBends;
    }

    public final boolean getHierarchicalOrthogonalEdgeRouting() {
        return this.hierarchicalOrthogonalEdgeRouting;
    }

    public final int getHierarchicalOrientation() {
        return this.hierarchicalOrientation;
    }

    public final int getHierarchicalMinimumLayerDistance() {
        return this.hierarchicalMinimumLayerDistance;
    }

    public final int getHierarchicalMinimumNodeDistance() {
        return this.hierarchicalMinimumNodeDistance;
    }

    public final EOrthogonalLayoutStyle getOrthogonalLayoutStyle() {
        return this.orthogonalLayoutStyle;
    }

    public final ELayoutOrientation getOrthogonalOrientation() {
        return this.orthogonalOrientation;
    }

    public final int getOrthogonalMinimumNodeDistance() {
        return this.orthogonalMinimumNodeDistance;
    }

    public final ECircularLayoutStyle getCircularLayoutStyle() {
        return this.circularLayoutStyle;
    }

    public final int getCircularMinimumNodeDistance() {
        return this.circularMinimumNodeDistance;
    }

    public final int getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    public final int getZoomSensitivity() {
        return this.zoomSensitivity;
    }

    public final EMouseAction getMouseWheelAction() {
        return this.mouseWheelAction;
    }

    public final boolean getViewSynchronization() {
        return this.viewSynchronization;
    }

    public final boolean getShowScrollbars() {
        return this.showScrollbars;
    }

    public final int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public final void setDefaultGraphLayout(EGraphLayout eGraphLayout) {
        this.defaultGraphLayout = eGraphLayout;
    }

    public final void setAutoLayouting(boolean bl2) {
        this.autoLayouting = bl2;
    }

    public final void setProximityBrowsing(boolean bl2) {
        this.proximityBrowsing = bl2;
    }

    public final void setProximityBrowsingChildDepth(int n2) {
        this.proximityBrowsingChildDepth = n2;
    }

    public final void setProximityBrowsingParentDepth(int n2) {
        this.proximityBrowsingParentDepth = n2;
    }

    public final void setAutoProximityBrowsingActivationThreshold(int n2) {
        this.autoProximityBrowsingActivationThreshold = n2;
    }

    public final void setVisibilityWarningThreshold(int n2) {
        this.visibilityWarningThreshold = n2;
    }

    public final void setDrawBends(boolean bl2) {
        this.drawBends = bl2;
    }

    public final void setHierarchicalOrthogonalEdgeRouting(boolean bl2) {
        this.hierarchicalOrthogonalEdgeRouting = bl2;
    }

    public final void setHierarchicalOrientation(int n2) {
        this.hierarchicalOrientation = n2;
    }

    public final void setHierarchicalMinimumLayerDistance(int n2) {
        this.hierarchicalMinimumLayerDistance = n2;
    }

    public final void setHierarchicalMinimumNodeDistance(int n2) {
        this.hierarchicalMinimumNodeDistance = n2;
    }

    public final void setOrthogonalLayoutStyle(EOrthogonalLayoutStyle eOrthogonalLayoutStyle) {
        this.orthogonalLayoutStyle = eOrthogonalLayoutStyle;
    }

    public final void setOrthogonalOrientation(ELayoutOrientation eLayoutOrientation) {
        this.orthogonalOrientation = eLayoutOrientation;
    }

    public final void setOrthogonalMinimumNodeDistance(int n2) {
        this.orthogonalMinimumNodeDistance = n2;
    }

    public final void setCircularLayoutStyle(ECircularLayoutStyle eCircularLayoutStyle) {
        this.circularLayoutStyle = eCircularLayoutStyle;
    }

    public final void setCircularMinimumNodeDistance(int n2) {
        this.circularMinimumNodeDistance = n2;
    }

    public final void setScrollSensitivity(int n2) {
        this.scrollSensitivity = n2;
    }

    public final void setZoomSensitivity(int n2) {
        this.zoomSensitivity = n2;
    }

    public final void setMouseWheelAction(EMouseAction eMouseAction) {
        this.mouseWheelAction = eMouseAction;
    }

    public final void setViewSynchronization(boolean bl2) {
        this.viewSynchronization = bl2;
    }

    public final void setShowScrollbars(boolean bl2) {
        this.showScrollbars = bl2;
    }

    public final void setAnimationSpeed(int n2) {
        this.animationSpeed = n2;
    }
}

