/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.config;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.bindiff.config.ConfigItem;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class GeneralSettingsConfigItem
extends ConfigItem {
    private static final String CONFIG_FILE_FORMAT_VERSION = "/bindiff/@config-version";
    private static final int CONFIG_FILE_FORMAT_VERSION_DEFAULT = 6;
    private int configFileFormatVersion = 6;
    private static final String SOCKET_PORT = "/bindiff/ui/@port";
    private static final int SOCKET_PORT_DEFAULT = 2000;
    private int socketPort = 2000;
    private static final String IDA_DIRECTORY = "/bindiff/ida/@directory";
    private static final String IDA_DIRECTORY_DEFAULT = "";
    private String idaDirectory = "";
    private static final String WORKSPACE_DIRECTORY = "/bindiff/preferences/workspace/@directory";
    private static final String WORKSPACE_DIRECTORY_DEFAULT = "";
    private String workspaceDirectory = "";
    private static final String DEFAULT_WORKSPACE = "/bindiff/preferences/workspace/@default";
    private static final String DEFAULT_WORKSPACE_DEFAULT = "";
    private String defaultWorkspace = "";
    private static final String DIFF_ENGINE_PATH = "/bindiff/ui/@directory";
    private static final String DIFF_ENGINE_PATH_DEFAULT = "";
    private String diffEnginePath = "";
    private static final String ADD_EXISTING_DIFF_LAST_DIR = "/bindiff/preferences/history/entry[@for='add-existing-diff-dir']/@v";
    private static final String ADD_EXISTING_DIFF_LAST_DIR_DEFAULT = "";
    private String addExistingDiffLastDir = "";
    private static final String DIRECTORY_DIFF_LAST_PRIMARY_DIR = "/bindiff/preferences/history/entry[@for='directory-diff-primary-dir']/@v";
    private static final String DIRECTORY_DIFF_LAST_PRIMARY_DIR_DEFAULT = "";
    private String directoryDiffLastPrimaryDir = "";
    private static final String DIRECTORY_DIFF_LAST_SECONDARY_DIR = "/bindiff/preferences/history/entry[@for='directory-diff-secondary-dir']/@v";
    private static final String DIRECTORY_DIFF_LAST_SECONDARY_DIR_DEFAULT = "";
    private String directoryDiffLastSecondaryDir = "";
    private static final String RECENT_WORKSPACE_DIRECTORIES = "/bindiff/preferences/history/list[@for='workspace-dir']/entry/@v";
    private static final ImmutableList<String> RECENT_WORKSPACE_DIRECTORIES_DEFAULT = ImmutableList.of();
    private List<String> recentWorkspaceDirectories = RECENT_WORKSPACE_DIRECTORIES_DEFAULT;
    private static final String NEW_DIFF_LAST_PRIMARY_DIR = "/bindiff/preferences/history/entry[@for='new-diff-primary-dir']/@v";
    private static final String NEW_DIFF_LAST_PRIMARY_DIR_DEFAULT = "";
    private String newDiffLastPrimaryDir = "";
    private static final String NEW_DIFF_LAST_SECONDARY_DIR = "/bindiff/preferences/history/entry[@for='new-diff-secondary-dir']/@v";
    private static final String NEW_DIFF_LAST_SECONDARY_DIR_DEFAULT = "";
    private String newDiffLastSecondaryDir = "";
    private static final String LOG_LEVEL = "/bindiff/log/@level";
    private static final Level LOG_LEVEL_DEFAULT = Level.INFO;
    private Level logLevel = LOG_LEVEL_DEFAULT;
    private static final String CONSOLE_LOGGING = "/bindiff/log/@to-stderr";
    private static final boolean CONSOLE_LOGGING_DEFAULT = false;
    private boolean consoleLogging = false;
    private static final String FILE_LOGGING = "/bindiff/log/@to-file";
    private static final boolean FILE_LOGGING_DEFAULT = false;
    private boolean fileLogging = false;
    private static final String LOG_FILE_LOCATION = "/bindiff/log/@directory";
    private static final String LOG_FILE_LOCATION_DEFAULT = "";
    private String logFileLocation = "";
    private static final String SCREEN_WIDTH = "/bindiff/preferences/layout/window/@screenWidth";
    private static final int SCREEN_WIDTH_DEFAULT = 0;
    private int screenWidth = 0;
    private static final String SCREEN_HEIGHT = "/bindiff/preferences/layout/window/@screenHeight";
    private static final int SCREEN_HEIGHT_DEFAULT = 0;
    private int screenHeight = 0;
    private static final String WINDOW_X_POS = "/bindiff/preferences/layout/window/@x";
    private static final int WINDOW_X_POS_DEFAULT = 0;
    private int windowXPos = 0;
    private static final String WINDOW_Y_POS = "/bindiff/preferences/layout/window/@y";
    private static final int WINDOW_Y_POS_DEFAULT = 0;
    private int windowYPos = 0;
    private static final String WINDOW_WIDTH = "/bindiff/preferences/layout/window/@width";
    private static final int WINDOW_WIDTH_DEFAULT = 800;
    private int windowWidth = 800;
    private static final String WINDOW_HEIGHT = "/bindiff/preferences/layout/window/@height";
    private static final int WINDOW_HEIGHT_DEFAULT = 600;
    private int windowHeight = 600;
    private static final String WINDOW_STATE_WAS_MAXIMIZED = "/bindiff/preferences/layout/window/@maximized";
    private static final boolean WINDOW_STATE_WAS_MAXIMIZED_DEFAULT = false;
    private boolean windowStateWasMaximized = false;
    private static final String WORKSPACE_TREE_DIVIDER_POSITION = "/bindiff/preferences/layout/divider-position/@v";
    private static final int WORKSPACE_TREE_DIVIDER_POSITION_DEFAULT = 200;
    private int workspaceTreeDividerPosition = 200;

    @Override
    public void load(Document document) {
        this.configFileFormatVersion = GeneralSettingsConfigItem.getInteger(document, CONFIG_FILE_FORMAT_VERSION, 6);
        this.diffEnginePath = GeneralSettingsConfigItem.getString(document, DIFF_ENGINE_PATH, "");
        this.defaultWorkspace = GeneralSettingsConfigItem.getString(document, DEFAULT_WORKSPACE, "");
        this.idaDirectory = GeneralSettingsConfigItem.getString(document, IDA_DIRECTORY, "");
        this.workspaceDirectory = GeneralSettingsConfigItem.getString(document, WORKSPACE_DIRECTORY, "");
        this.recentWorkspaceDirectories = GeneralSettingsConfigItem.getStrings(document, RECENT_WORKSPACE_DIRECTORIES, RECENT_WORKSPACE_DIRECTORIES_DEFAULT);
        this.socketPort = GeneralSettingsConfigItem.getInteger(document, SOCKET_PORT, 2000);
        this.newDiffLastPrimaryDir = GeneralSettingsConfigItem.getString(document, NEW_DIFF_LAST_PRIMARY_DIR, "");
        this.newDiffLastSecondaryDir = GeneralSettingsConfigItem.getString(document, NEW_DIFF_LAST_SECONDARY_DIR, "");
        this.directoryDiffLastPrimaryDir = GeneralSettingsConfigItem.getString(document, DIRECTORY_DIFF_LAST_PRIMARY_DIR, "");
        this.directoryDiffLastSecondaryDir = GeneralSettingsConfigItem.getString(document, DIRECTORY_DIFF_LAST_SECONDARY_DIR, "");
        this.addExistingDiffLastDir = GeneralSettingsConfigItem.getString(document, ADD_EXISTING_DIFF_LAST_DIR, "");
        this.logLevel = GeneralSettingsConfigItem.getLevel(document, LOG_LEVEL, LOG_LEVEL_DEFAULT);
        this.consoleLogging = GeneralSettingsConfigItem.getBoolean(document, CONSOLE_LOGGING, false);
        this.fileLogging = GeneralSettingsConfigItem.getBoolean(document, FILE_LOGGING, false);
        this.logFileLocation = GeneralSettingsConfigItem.getString(document, LOG_FILE_LOCATION, "");
        this.windowStateWasMaximized = GeneralSettingsConfigItem.getBoolean(document, WINDOW_STATE_WAS_MAXIMIZED, false);
        this.windowXPos = GeneralSettingsConfigItem.getInteger(document, WINDOW_X_POS, 0);
        this.windowYPos = GeneralSettingsConfigItem.getInteger(document, WINDOW_Y_POS, 0);
        this.windowWidth = GeneralSettingsConfigItem.getInteger(document, WINDOW_WIDTH, 800);
        this.windowHeight = GeneralSettingsConfigItem.getInteger(document, WINDOW_HEIGHT, 600);
        this.screenWidth = GeneralSettingsConfigItem.getInteger(document, SCREEN_WIDTH, 0);
        this.screenHeight = GeneralSettingsConfigItem.getInteger(document, SCREEN_HEIGHT, 0);
        this.workspaceTreeDividerPosition = GeneralSettingsConfigItem.getInteger(document, WORKSPACE_TREE_DIVIDER_POSITION, 200);
    }

    @Override
    public void store(Document document) {
        GeneralSettingsConfigItem.setString(document, DIFF_ENGINE_PATH, this.diffEnginePath);
        GeneralSettingsConfigItem.setString(document, DEFAULT_WORKSPACE, this.defaultWorkspace);
        GeneralSettingsConfigItem.setInteger(document, CONFIG_FILE_FORMAT_VERSION, this.configFileFormatVersion);
        GeneralSettingsConfigItem.setString(document, IDA_DIRECTORY, this.idaDirectory);
        GeneralSettingsConfigItem.setString(document, WORKSPACE_DIRECTORY, this.workspaceDirectory);
        GeneralSettingsConfigItem.setStrings(document, RECENT_WORKSPACE_DIRECTORIES, this.recentWorkspaceDirectories);
        GeneralSettingsConfigItem.setInteger(document, SOCKET_PORT, this.socketPort);
        GeneralSettingsConfigItem.setString(document, NEW_DIFF_LAST_PRIMARY_DIR, this.newDiffLastPrimaryDir);
        GeneralSettingsConfigItem.setString(document, NEW_DIFF_LAST_SECONDARY_DIR, this.newDiffLastSecondaryDir);
        GeneralSettingsConfigItem.setString(document, DIRECTORY_DIFF_LAST_PRIMARY_DIR, this.directoryDiffLastPrimaryDir);
        GeneralSettingsConfigItem.setString(document, DIRECTORY_DIFF_LAST_SECONDARY_DIR, this.directoryDiffLastSecondaryDir);
        GeneralSettingsConfigItem.setString(document, ADD_EXISTING_DIFF_LAST_DIR, this.addExistingDiffLastDir);
        GeneralSettingsConfigItem.setLevel(document, LOG_LEVEL, this.logLevel);
        GeneralSettingsConfigItem.setBoolean(document, CONSOLE_LOGGING, this.consoleLogging);
        GeneralSettingsConfigItem.setBoolean(document, FILE_LOGGING, this.fileLogging);
        GeneralSettingsConfigItem.setString(document, LOG_FILE_LOCATION, this.logFileLocation);
        GeneralSettingsConfigItem.setBoolean(document, WINDOW_STATE_WAS_MAXIMIZED, this.windowStateWasMaximized);
        GeneralSettingsConfigItem.setInteger(document, WINDOW_X_POS, this.windowXPos);
        GeneralSettingsConfigItem.setInteger(document, WINDOW_Y_POS, this.windowYPos);
        GeneralSettingsConfigItem.setInteger(document, WINDOW_WIDTH, this.windowWidth);
        GeneralSettingsConfigItem.setInteger(document, WINDOW_HEIGHT, this.windowHeight);
        GeneralSettingsConfigItem.setInteger(document, SCREEN_WIDTH, this.screenWidth);
        GeneralSettingsConfigItem.setInteger(document, SCREEN_HEIGHT, this.screenHeight);
        GeneralSettingsConfigItem.setInteger(document, WORKSPACE_TREE_DIVIDER_POSITION, this.workspaceTreeDividerPosition);
    }

    public int getVersion() {
        return this.configFileFormatVersion;
    }

    public void setVersion(int n2) {
        this.configFileFormatVersion = n2;
    }

    public String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public void setDefaultWorkspace(String string) {
        this.defaultWorkspace = string;
    }

    public String getDiffEnginePath() {
        return this.diffEnginePath;
    }

    public void setDiffEnginePath(String string) {
        this.diffEnginePath = string;
    }

    public final String getIdaDirectory() {
        return this.idaDirectory;
    }

    public void setIdaDirectory(String string) {
        this.idaDirectory = string;
    }

    public final String getWorkspaceDirectory() {
        return this.workspaceDirectory;
    }

    public void setWorkspaceDirectory(String string) {
        this.workspaceDirectory = string;
    }

    public List<String> getRecentWorkspaceDirectories() {
        return this.recentWorkspaceDirectories;
    }

    public void setRecentWorkspaceDirectories(List<String> list) {
        this.recentWorkspaceDirectories = list;
    }

    public final int getSocketPort() {
        return this.socketPort;
    }

    public final void setSocketPort(int n2) {
        this.socketPort = n2;
    }

    public final String getNewDiffLastPrimaryDir() {
        return this.newDiffLastPrimaryDir;
    }

    public final void setNewDiffLastPrimaryDir(String string) {
        this.newDiffLastPrimaryDir = string;
    }

    public final String getNewDiffLastSecondaryDir() {
        return this.newDiffLastSecondaryDir;
    }

    public final void setNewDiffLastSecondaryDir(String string) {
        this.newDiffLastSecondaryDir = string;
    }

    public final String getDirectoryDiffLastPrimaryDir() {
        return this.directoryDiffLastPrimaryDir;
    }

    public final void setDirectoryDiffLastPrimaryDir(String string) {
        this.directoryDiffLastPrimaryDir = string;
    }

    public final String getDirectoryDiffLastSecondaryDir() {
        return this.directoryDiffLastSecondaryDir;
    }

    public final void setDirectoryDiffLastSecondaryDir(String string) {
        this.directoryDiffLastSecondaryDir = string;
    }

    public final String getAddExistingDiffLastDir() {
        return this.addExistingDiffLastDir;
    }

    public final void setAddExistingDiffLastDir(String string) {
        this.addExistingDiffLastDir = string;
    }

    public final Level getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(Level level) {
        this.logLevel = level;
    }

    public final boolean getConsoleLogging() {
        return this.consoleLogging;
    }

    public final void setConsoleLogging(boolean bl2) {
        this.consoleLogging = bl2;
    }

    public final boolean getFileLogging() {
        return this.fileLogging;
    }

    public final void setFileLogging(boolean bl2) {
        this.fileLogging = bl2;
    }

    public final String getLogFileLocation() {
        return this.logFileLocation;
    }

    public final void setLogFileLocation(String string) {
        this.logFileLocation = string;
    }

    public final boolean getWindowStateWasMaximized() {
        return this.windowStateWasMaximized;
    }

    public final void setWindowStateWasMaximized(boolean bl2) {
        this.windowStateWasMaximized = bl2;
    }

    public final int getWindowXPos() {
        return this.windowXPos;
    }

    public final void setWindowXPos(int n2) {
        this.windowXPos = n2;
    }

    public final int getWindowYPos() {
        return this.windowYPos;
    }

    public final void setWindowYPos(int n2) {
        this.windowYPos = n2;
    }

    public final int getWindowWidth() {
        return this.windowWidth;
    }

    public final void setWindowWidth(int n2) {
        this.windowWidth = n2;
    }

    public final int getWindowHeight() {
        return this.windowHeight;
    }

    public final void setWindowHeight(int n2) {
        this.windowHeight = n2;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final void setScreenWidth(int n2) {
        this.screenWidth = n2;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public final void setScreenHeight(int n2) {
        this.screenHeight = n2;
    }

    public final int getWorkspaceTreeDividerPosition() {
        return this.workspaceTreeDividerPosition;
    }

    public final void setWorkspaceTreeDividerPosition(int n2) {
        this.workspaceTreeDividerPosition = n2;
    }
}

