/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.config;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.bindiff.logging.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ConfigItem {
    protected static XPath xpath = XPathFactory.newInstance().newXPath();

    public abstract void load(Document var1);

    public abstract void store(Document var1);

    protected static boolean getBoolean(Document document, String string, boolean bl2) {
        return Boolean.valueOf(ConfigItem.getString(document, string, String.valueOf(bl2)));
    }

    protected static void setBoolean(Document document, String string, boolean bl2) {
        ConfigItem.setString(document, string, String.valueOf(bl2));
    }

    protected static int getInteger(Document document, String string, int n2) {
        try {
            return Integer.valueOf(ConfigItem.getString(document, string, String.valueOf(n2)));
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    protected static void setInteger(Document document, String string, int n2) {
        ConfigItem.setString(document, string, String.valueOf(n2));
    }

    protected static Level getLevel(Document document, String string, Level level) {
        switch (Ascii.toLowerCase(ConfigItem.getString(document, string, ""))) {
            case "debug": {
                return Level.ALL;
            }
            case "info": {
                return Level.INFO;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "error": {
                return Level.SEVERE;
            }
            case "off": {
                return Level.OFF;
            }
        }
        return level;
    }

    protected static void setLevel(Document document, String string, Level level) {
        ConfigItem.setString(document, string, Logger.levelToString(level));
    }

    protected static long getLong(Document document, String string, long l2) {
        try {
            return Long.valueOf(ConfigItem.getString(document, string, String.valueOf(l2)));
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    protected void setLong(String string, Document document, long l2) {
        ConfigItem.setString(document, string, String.valueOf(l2));
    }

    protected static List<String> getStrings(Document document, String string, List<String> list) {
        NodeList nodeList = (NodeList)xpath.evaluate(string, document, XPathConstants.NODESET);
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            arrayList.add(nodeList.item(i2).getNodeValue());
        }
        return !arrayList.isEmpty() ? arrayList : list;
    }

    private static void doSetStrings(Document document, String string, List<String> list, boolean bl2) {
        Object object;
        Node node;
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("Expression must be an XPath AbsoluteLocationPath");
        }
        List<String> list2 = Splitter.on('/').splitToList(string.substring(1));
        if (list2.size() < 2) {
            throw new IllegalArgumentException("AbsoluteLocationPath too short");
        }
        String string2 = null;
        String string3 = null;
        int n2 = list2.size() - 1;
        String string4 = list2.get(n2);
        if (string4.startsWith("@")) {
            string3 = string4.substring(1);
            if (!bl2) {
                --n2;
            }
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("AbsoluteLocationPath too short");
        }
        if (!bl2) {
            string2 = Iterables.get(Splitter.onPattern("\\[|=|\\]").split(list2.get(n2)), 0);
            --n2;
        }
        StringBuilder stringBuilder = new StringBuilder(list2.get(0));
        for (int i2 = 1; i2 <= n2; ++i2) {
            stringBuilder.append('/').append(list2.get(i2));
        }
        Object object2 = (Node)xpath.evaluate(stringBuilder.toString(), document, XPathConstants.NODE);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (object2 == null) {
            for (int i3 = 0; i3 <= n2; ++i3) {
                String string5 = list2.get(i3);
                stringBuilder2.append('/').append(string5);
                node = (Node)xpath.evaluate(stringBuilder2.toString(), document, XPathConstants.NODE);
                if (node != null) {
                    object2 = node;
                    continue;
                }
                if (string5.startsWith("@")) {
                    object = document.createAttribute(string5.substring(1));
                    object2.getAttributes().setNamedItem((Node)object);
                    object2 = object;
                    break;
                }
                object = Splitter.onPattern("\\[|=|\\]").splitToList(string5);
                Element element = document.createElement((String)object.get(0));
                Object object3 = object2 = object2 != null ? object2.appendChild(element) : document.appendChild(element);
                if (object.size() != 3) continue;
                String string6 = (String)object.get(1);
                String string7 = (String)object.get(2);
                element.setAttribute(string6.substring(1), string7.substring(1, string7.length() - 1));
            }
        }
        if (object2 != null) {
            if (bl2) {
                if (!list.isEmpty()) {
                    object2.setTextContent(list.get(0));
                }
                return;
            }
            object2.setTextContent("");
            for (String string5 : list) {
                node = document.createElement(string2);
                if (string3 == null) {
                    object = node;
                } else {
                    object = document.createAttribute(string3);
                    node.getAttributes().setNamedItem((Node)object);
                }
                object.setTextContent(string5);
                object2.appendChild(node);
            }
        }
    }

    protected static void setStrings(Document document, String string, List<String> list) {
        ConfigItem.doSetStrings(document, string, list, false);
    }

    protected static String getString(Document document, String string, String string2) {
        String string3 = xpath.evaluate(string, document);
        return !string3.isEmpty() ? string3 : string2;
    }

    protected static void setString(Document document, String string, String string2) {
        ConfigItem.doSetStrings(document, string, Arrays.asList(string2), true);
    }

    protected static Color getColor(Document document, String string, Color color) {
        try {
            return Color.decode(ConfigItem.getString(document, string, String.valueOf(color.getRGB())));
        }
        catch (NumberFormatException numberFormatException) {
            return color;
        }
    }

    protected static void setColor(Document document, String string, Color color) {
        ConfigItem.setString(document, string, String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
    }
}

