/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.config;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.InitialCallGraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.InitialFlowGraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.ThemeConfigItem;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class BinDiffConfig {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final BinDiffConfig instance = new BinDiffConfig();
    private final GeneralSettingsConfigItem mainSettings = new GeneralSettingsConfigItem();
    private final ThemeConfigItem colorSettings = new ThemeConfigItem();
    private final GraphViewSettingsConfigItem initialCallGraphSettings = new InitialCallGraphViewSettingsConfigItem();
    private final GraphViewSettingsConfigItem initialFlowGraphSettings = new InitialFlowGraphViewSettingsConfigItem();

    private BinDiffConfig() {
    }

    public static BinDiffConfig getInstance() {
        return instance;
    }

    public static void delete() {
        try {
            Files.delete(FileSystems.getDefault().getPath(BinDiffConfig.getConfigFileName(), new String[0]));
        }
        catch (SecurityException securityException) {
            throw new IOException("Couldn't delete config file: " + securityException.getMessage(), securityException);
        }
    }

    public GeneralSettingsConfigItem getMainSettings() {
        return this.mainSettings;
    }

    public ThemeConfigItem getThemeSettings() {
        return this.colorSettings;
    }

    public GraphViewSettingsConfigItem getInitialCallGraphSettings() {
        return this.initialCallGraphSettings;
    }

    public GraphViewSettingsConfigItem getInitialFlowGraphSettings() {
        return this.initialFlowGraphSettings;
    }

    public void read() {
        DocumentBuilder documentBuilder;
        File file = new File(BinDiffConfig.getConfigFileName()).getCanonicalFile();
        if (!file.exists()) {
            file = new File(BinDiffConfig.getMachineConfigFileName());
        }
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        try {
            Document document = file.exists() ? documentBuilder.parse(file.getPath()) : documentBuilder.newDocument();
            this.mainSettings.load(document);
            this.initialCallGraphSettings.load(document);
            this.initialFlowGraphSettings.load(document);
            this.colorSettings.load(document);
        }
        catch (XPathException | SAXException exception) {
            throw new IOException("Failed to parse configuration file: " + exception.getMessage(), exception);
        }
    }

    public void write() {
        DOMImplementationLS dOMImplementationLS;
        Document document;
        DocumentBuilder documentBuilder;
        logger.at(Level.INFO).log("Saving configuration...");
        File file = new File(BinDiffConfig.getConfigurationDirectory());
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        File file2 = new File(BinDiffConfig.getConfigFileName()).getCanonicalFile();
        try {
            document = file2.exists() ? documentBuilder.parse(file2.getPath()) : documentBuilder.newDocument();
            this.mainSettings.store(document);
            this.initialCallGraphSettings.store(document);
            this.initialFlowGraphSettings.store(document);
            this.colorSettings.store(document);
        }
        catch (XPathException xPathException) {
            throw new IOException("Failed to store configuration file: " + xPathException.getMessage(), xPathException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Failed to validate configuration file: " + sAXException.getMessage(), sAXException);
        }
        try {
            dOMImplementationLS = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            throw new RuntimeException(exception);
        }
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setByteStream(new FileOutputStream(file2));
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        lSSerializer.write(document, lSOutput);
    }

    public static String getConfigFileName() {
        return BinDiffConfig.getConfigurationDirectory() + "bindiff.xml";
    }

    public static String getConfigurationDirectory() {
        return SystemHelpers.getApplicationDataDirectory("BinDiff");
    }

    public static final String getMachineConfigFileName() {
        return SystemHelpers.getAllUsersApplicationDataDirectory("BinDiff") + "bindiff.xml";
    }
}

