/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff;

import com.google.common.base.StandardSystemProperty;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.ThemeConfigItem;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.logging.Logger;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.resources.Constants;
import com.google.security.zynamics.bindiff.socketserver.SocketServer;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class BinDiff {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static String workspaceFileName = null;

    private BinDiff() {
    }

    private static boolean initializeConfigFile() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        try {
            binDiffConfig.read();
            if (binDiffConfig.getMainSettings().getVersion() < 6) {
                int n2 = CMessageBox.showYesNoWarning(null, "Your configuration file is obsolete. Do you want to overwrite it with a new default configuration file?");
                try {
                    if (n2 == 0) {
                        BinDiffConfig.delete();
                    }
                }
                catch (IOException iOException) {
                    CMessageBox.showError(null, "Couldn't delete configuration file.");
                    return false;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Error while parsing configuration file");
            CMessageBox.showError(null, iOException.getMessage());
            return false;
        }
    }

    private static void initializeTheme() {
        ThemeConfigItem themeConfigItem = BinDiffConfig.getInstance().getThemeSettings();
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(objectArray);
        Font font = themeConfigItem.getUiFont();
        if (Arrays.binarySearch(objectArray, font.getFamily()) >= 0) {
            GuiHelper.setDefaultFont(font);
        } else {
            logger.at(Level.WARNING).log("Font not installed/found: %s", font.getFontName());
        }
        Font font2 = themeConfigItem.getCodeFont();
        if (Arrays.binarySearch(objectArray, font2.getFamily()) >= 0) {
            GuiHelper.setMonospacedFont(font2);
        } else {
            logger.at(Level.WARNING).log("Font not installed/found: %s", font2.getFontName());
        }
        for (String string : new String[]{"Button.font", "CheckBox.font", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "DesktopIcon.font", "InternalFrame.font", "InternalFrame.titleFont", "Label.font", "List.font", "Menu.font", "MenuBar.font", "MenuItem.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "Text.font", "TextArea.font", "TextField.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"}) {
            UIManager.put(string, GuiHelper.getDefaultFont());
        }
    }

    private static void initializeGlobalTooltipDelays() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(60000);
        toolTipManager.setInitialDelay(1250);
        toolTipManager.setReshowDelay(500);
    }

    private static void initializeLogging() {
        GeneralSettingsConfigItem generalSettingsConfigItem = BinDiffConfig.getInstance().getMainSettings();
        try {
            FileHandler fileHandler = new FileHandler(Logger.getLoggingFilePath(generalSettingsConfigItem.getLogFileLocation()));
            Logger.setFileHandler(fileHandler);
        }
        catch (IOException | SecurityException exception) {
            CMessageBox.showWarning(null, "Failed to initialize file logger. Could not create log file handler.");
        }
        Logger.setConsoleLogging(generalSettingsConfigItem.getConsoleLogging());
        Logger.setFileLogging(generalSettingsConfigItem.getFileLogging());
        Logger.setLogLevel(generalSettingsConfigItem.getLogLevel());
    }

    private static void initializeStandardHotKeys() {
        InputMap inputMap = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        for (int i2 = 112; i2 <= 123; ++i2) {
            inputMap.remove(KeyStroke.getKeyStroke(i2, 0));
        }
    }

    private static void parseCommandLine(String[] stringArray) {
        for (String string : stringArray) {
            if ("-c".equals(string)) {
                Logger.setConsoleLogging(true);
                continue;
            }
            if ("-f".equals(string)) {
                FileHandler fileHandler;
                try {
                    fileHandler = new FileHandler(Logger.getDefaultLoggingDirectoryPath());
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.WARNING).withCause(iOException)).log("Could not create log file handler");
                    continue;
                }
                Logger.setFileHandler(fileHandler);
                continue;
            }
            if (workspaceFileName != null || string.startsWith("-")) continue;
            workspaceFileName = string;
        }
    }

    public static void applyLoggingChanges() {
        char c2;
        logger.at(Level.INFO).log("Applying logger changes...");
        GeneralSettingsConfigItem generalSettingsConfigItem = BinDiffConfig.getInstance().getMainSettings();
        Logger.setConsoleLogging(generalSettingsConfigItem.getConsoleLogging());
        String string = generalSettingsConfigItem.getLogFileLocation();
        if (string != null && string.length() > 1 && !File.separator.equals(String.valueOf(c2 = string.charAt(string.length() - 1)))) {
            string = string + File.separator;
        }
        if (string == null || !new File(string).exists()) {
            throw new IOException();
        }
        Logger.setFileHandler(new FileHandler(string + "bindiff_ui.log"));
        Logger.setLogLevel(generalSettingsConfigItem.getLogLevel());
    }

    private static void initializeSocketServer(MainWindow mainWindow) {
        SwingUtilities.invokeLater(() -> {
            int n2 = Constants.getSocketPort();
            try {
                new SocketServer(n2, mainWindow.getController().getTabPanelManager().getWorkspaceTabPanel().getController()).startListening();
            }
            catch (IOException iOException) {
                CMessageBox.showError(mainWindow, String.format("Could not listen on port %s. BinDiff exits.", n2));
                System.exit(1);
            }
        });
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            System.setProperty(CMessageBox.DEFAULT_WINDOW_TITLE_PROPERTY, "BinDiff");
            if (!BinDiff.initializeConfigFile()) {
                return;
            }
            BinDiff.initializeLogging();
            logger.at(Level.INFO).log("Starting %s (Java %s)", (Object)"BinDiff 6", (Object)StandardSystemProperty.JAVA_VERSION.value());
            BinDiff.initializeTheme();
            BinDiff.parseCommandLine(stringArray);
            BinDiff.initializeGlobalTooltipDelays();
            BinDiff.initializeStandardHotKeys();
            Workspace workspace = new Workspace();
            MainWindow mainWindow = new MainWindow(workspace);
            workspace.setParentWindow(mainWindow);
            mainWindow.setVisible(true);
            GuiHelper.applyWindowFix(mainWindow);
            BinDiff.initializeSocketServer(mainWindow);
            if (workspaceFileName != null) {
                mainWindow.getController().getTabPanelManager().getWorkspaceTabPanel().getController().loadWorkspace(workspaceFileName);
            }
        });
    }

    static {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "BinDiff");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

