/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeUtil;
import java.nio.ByteBuffer;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    public static boolean isValidUtf8(byte[] byArray) {
        return processor.isValidUtf8(byArray, 0, byArray.length);
    }

    public static boolean isValidUtf8(byte[] byArray, int n2, int n3) {
        return processor.isValidUtf8(byArray, n2, n3);
    }

    public static int partialIsValidUtf8(int n2, byte[] byArray, int n3, int n4) {
        return processor.partialIsValidUtf8(n2, byArray, n3, n4);
    }

    private static int incompleteStateFor(int n2) {
        return n2 > -12 ? -1 : n2;
    }

    private static int incompleteStateFor(int n2, int n3) {
        return n2 > -12 || n3 > -65 ? -1 : n2 ^ n3 << 8;
    }

    private static int incompleteStateFor(int n2, int n3, int n4) {
        return n2 > -12 || n3 > -65 || n4 > -65 ? -1 : n2 ^ n3 << 8 ^ n4 << 16;
    }

    private static int incompleteStateFor(byte[] byArray, int n2, int n3) {
        byte by2 = byArray[n2 - 1];
        switch (n3 - n2) {
            case 0: {
                return Utf8.incompleteStateFor(by2);
            }
            case 1: {
                return Utf8.incompleteStateFor(by2, byArray[n2]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by2, (int)byArray[n2], (int)byArray[n2 + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                return Utf8.incompleteStateFor(n2);
            }
            case 1: {
                return Utf8.incompleteStateFor(n2, byteBuffer.get(n3));
            }
            case 2: {
                return Utf8.incompleteStateFor(n2, (int)byteBuffer.get(n3), (int)byteBuffer.get(n3 + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) < '\u0080'; ++n2) {
        }
        while (n2 < n3) {
            char c2 = charSequence.charAt(n2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
            } else {
                n4 += Utf8.encodedLengthGeneral(charSequence, n2);
                break;
            }
            ++n2;
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n4 + 0x100000000L));
        }
        return n4;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
                continue;
            }
            n4 += 2;
            if ('\ud800' > c2 || c2 > '\udfff') continue;
            int n5 = Character.codePointAt(charSequence, i2);
            if (n5 < 65536) {
                throw new UnpairedSurrogateException(i2, n3);
            }
            ++i2;
        }
        return n4;
    }

    static int encode(CharSequence charSequence, byte[] byArray, int n2, int n3) {
        return processor.encodeUtf8(charSequence, byArray, n2, n3);
    }

    static boolean isValidUtf8(ByteBuffer byteBuffer) {
        return processor.isValidUtf8(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    static int partialIsValidUtf8(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return processor.partialIsValidUtf8(n2, byteBuffer, n3, n4);
    }

    static String decodeUtf8(ByteBuffer byteBuffer, int n2, int n3) {
        return processor.decodeUtf8(byteBuffer, n2, n3);
    }

    static String decodeUtf8(byte[] byArray, int n2, int n3) {
        return processor.decodeUtf8(byArray, n2, n3);
    }

    static void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        processor.encodeUtf8(charSequence, byteBuffer);
    }

    private static int estimateConsecutiveAscii(ByteBuffer byteBuffer, int n2, int n3) {
        int n4;
        int n5 = n3 - 7;
        for (n4 = n2; n4 < n5 && (byteBuffer.getLong(n4) & 0x8080808080808080L) == 0L; n4 += 8) {
        }
        return n4 - n2;
    }

    private Utf8() {
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte by2) {
            return by2 >= 0;
        }

        private static boolean isTwoBytes(byte by2) {
            return by2 < -32;
        }

        private static boolean isThreeBytes(byte by2) {
            return by2 < -16;
        }

        private static void handleOneByte(byte by2, char[] cArray, int n2) {
            cArray[n2] = (char)by2;
        }

        private static void handleTwoBytes(byte by2, byte by3, char[] cArray, int n2) {
            if (by2 < -62 || DecodeUtil.isNotTrailingByte(by3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            cArray[n2] = (char)((by2 & 0x1F) << 6 | DecodeUtil.trailingByteValue(by3));
        }

        private static void handleThreeBytes(byte by2, byte by3, byte by4, char[] cArray, int n2) {
            if (DecodeUtil.isNotTrailingByte(by3) || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || DecodeUtil.isNotTrailingByte(by4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            cArray[n2] = (char)((by2 & 0xF) << 12 | DecodeUtil.trailingByteValue(by3) << 6 | DecodeUtil.trailingByteValue(by4));
        }

        private static void handleFourBytes(byte by2, byte by3, byte by4, byte by5, char[] cArray, int n2) {
            if (DecodeUtil.isNotTrailingByte(by3) || (by2 << 28) + (by3 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(by4) || DecodeUtil.isNotTrailingByte(by5)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int n3 = (by2 & 7) << 18 | DecodeUtil.trailingByteValue(by3) << 12 | DecodeUtil.trailingByteValue(by4) << 6 | DecodeUtil.trailingByteValue(by5);
            cArray[n2] = DecodeUtil.highSurrogate(n3);
            cArray[n2 + 1] = DecodeUtil.lowSurrogate(n3);
        }

        private static boolean isNotTrailingByte(byte by2) {
            return by2 > -65;
        }

        private static int trailingByteValue(byte by2) {
            return by2 & 0x3F;
        }

        private static char highSurrogate(int n2) {
            return (char)(55232 + (n2 >>> 10));
        }

        private static char lowSurrogate(int n2) {
            return (char)(56320 + (n2 & 0x3FF));
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        int partialIsValidUtf8(int n2, byte[] byArray, int n3, int n4) {
            if ((n3 | n4 | byArray.length - n4) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", byArray.length, n3, n4));
            }
            long l2 = n3;
            long l3 = n4;
            if (n2 != 0) {
                if (l2 >= l3) {
                    return n2;
                }
                byte by2 = (byte)n2;
                if (by2 < -32) {
                    if (by2 < -62 || UnsafeUtil.getByte(byArray, l2++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(n2 >> 8));
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(byArray, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || UnsafeUtil.getByte(byArray, l2++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(n2 >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(byArray, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(n2 >> 16);
                    }
                    if (by5 == 0) {
                        by5 = UnsafeUtil.getByte(byArray, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || UnsafeUtil.getByte(byArray, l2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(byArray, l2, (int)(l3 - l2));
        }

        @Override
        int partialIsValidUtf8Direct(int n2, ByteBuffer byteBuffer, int n3, int n4) {
            if ((n3 | n4 | byteBuffer.limit() - n4) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n3, n4));
            }
            long l2 = UnsafeUtil.addressOffset(byteBuffer) + (long)n3;
            long l3 = l2 + (long)(n4 - n3);
            if (n2 != 0) {
                if (l2 >= l3) {
                    return n2;
                }
                byte by2 = (byte)n2;
                if (by2 < -32) {
                    if (by2 < -62 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(n2 >> 8));
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(n2 >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(n2 >> 16);
                    }
                    if (by5 == 0) {
                        by5 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(l2, (int)(l3 - l2));
        }

        @Override
        String decodeUtf8(byte[] byArray, int n2, int n3) {
            byte by2;
            int n4;
            if ((n2 | n3 | byArray.length - n2 - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n2, n3));
            }
            int n5 = n4 + n3;
            char[] cArray = new char[n3];
            int n6 = 0;
            for (n4 = n2; n4 < n5 && DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(byArray, (long)n4)); ++n4) {
                DecodeUtil.handleOneByte(by2, cArray, n6++);
            }
            while (n4 < n5) {
                if (DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(byArray, (long)n4++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n6++);
                    while (n4 < n5 && DecodeUtil.isOneByte(by3 = UnsafeUtil.getByte(byArray, (long)n4))) {
                        ++n4;
                        DecodeUtil.handleOneByte(by3, cArray, n6++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n4 >= n5) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, UnsafeUtil.getByte(byArray, (long)n4++), cArray, n6++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n4 >= n5 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, UnsafeUtil.getByte(byArray, (long)n4++), UnsafeUtil.getByte(byArray, (long)n4++), cArray, n6++);
                    continue;
                }
                if (n4 >= n5 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, UnsafeUtil.getByte(byArray, (long)n4++), UnsafeUtil.getByte(byArray, (long)n4++), UnsafeUtil.getByte(byArray, (long)n4++), cArray, n6++);
                ++n6;
            }
            return new String(cArray, 0, n6);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer byteBuffer, int n2, int n3) {
            byte by2;
            long l2;
            if ((n2 | n3 | byteBuffer.limit() - n2 - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n2, n3));
            }
            long l3 = l2 + (long)n3;
            char[] cArray = new char[n3];
            int n4 = 0;
            for (l2 = UnsafeUtil.addressOffset(byteBuffer) + (long)n2; l2 < l3 && DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(l2)); ++l2) {
                DecodeUtil.handleOneByte(by2, cArray, n4++);
            }
            while (l2 < l3) {
                if (DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(l2++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n4++);
                    while (l2 < l3 && DecodeUtil.isOneByte(by3 = UnsafeUtil.getByte(l2))) {
                        ++l2;
                        DecodeUtil.handleOneByte(by3, cArray, n4++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (l2 >= l3) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, UnsafeUtil.getByte(l2++), cArray, n4++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (l2 >= l3 - 1L) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), cArray, n4++);
                    continue;
                }
                if (l2 >= l3 - 2L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), cArray, n4++);
                ++n4;
            }
            return new String(cArray, 0, n4);
        }

        @Override
        int encodeUtf8(CharSequence charSequence, byte[] byArray, int n2, int n3) {
            char c2;
            int n4;
            long l2 = n2;
            long l3 = l2 + (long)n3;
            int n5 = charSequence.length();
            if (n5 > n3 || byArray.length - n3 < n2) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n5 - 1) + " at index " + (n2 + n3));
            }
            for (n4 = 0; n4 < n5 && (c2 = charSequence.charAt(n4)) < '\u0080'; ++n4) {
                UnsafeUtil.putByte(byArray, l2++, (byte)c2);
            }
            if (n4 == n5) {
                return (int)l2;
            }
            while (n4 < n5) {
                c2 = charSequence.charAt(n4);
                if (c2 < '\u0080' && l2 < l3) {
                    UnsafeUtil.putByte(byArray, l2++, (byte)c2);
                } else if (c2 < '\u0800' && l2 <= l3 - 2L) {
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x3C0 | c2 >>> 6));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & c2));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && l2 <= l3 - 3L) {
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x1E0 | c2 >>> 12));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & c2));
                } else if (l2 <= l3 - 4L) {
                    char c3;
                    if (n4 + 1 == n5 || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n4))) {
                        throw new UnpairedSurrogateException(n4 - 1, n5);
                    }
                    int n6 = Character.toCodePoint(c2, c3);
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0xF0 | n6 >>> 18));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & n6 >>> 12));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & n6 >>> 6));
                    UnsafeUtil.putByte(byArray, l2++, (byte)(0x80 | 0x3F & n6));
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n4 + 1 != n5 && Character.isSurrogatePair(c2, charSequence.charAt(n4 + 1)))) {
                        throw new UnpairedSurrogateException(n4, n5);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + l2);
                }
                ++n4;
            }
            return (int)l2;
        }

        @Override
        void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
            char c2;
            int n2;
            long l2 = UnsafeUtil.addressOffset(byteBuffer);
            long l3 = l2 + (long)byteBuffer.position();
            long l4 = l2 + (long)byteBuffer.limit();
            int n3 = charSequence.length();
            if ((long)n3 > l4 - l3) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n3 - 1) + " at index " + byteBuffer.limit());
            }
            for (n2 = 0; n2 < n3 && (c2 = charSequence.charAt(n2)) < '\u0080'; ++n2) {
                UnsafeUtil.putByte(l3++, (byte)c2);
            }
            if (n2 == n3) {
                byteBuffer.position((int)(l3 - l2));
                return;
            }
            while (n2 < n3) {
                c2 = charSequence.charAt(n2);
                if (c2 < '\u0080' && l3 < l4) {
                    UnsafeUtil.putByte(l3++, (byte)c2);
                } else if (c2 < '\u0800' && l3 <= l4 - 2L) {
                    UnsafeUtil.putByte(l3++, (byte)(0x3C0 | c2 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && l3 <= l4 - 3L) {
                    UnsafeUtil.putByte(l3++, (byte)(0x1E0 | c2 >>> 12));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2));
                } else if (l3 <= l4 - 4L) {
                    char c3;
                    if (n2 + 1 == n3 || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n2))) {
                        throw new UnpairedSurrogateException(n2 - 1, n3);
                    }
                    int n4 = Character.toCodePoint(c2, c3);
                    UnsafeUtil.putByte(l3++, (byte)(0xF0 | n4 >>> 18));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4));
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n2 + 1 != n3 && Character.isSurrogatePair(c2, charSequence.charAt(n2 + 1)))) {
                        throw new UnpairedSurrogateException(n2, n3);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + l3);
                }
                ++n2;
            }
            byteBuffer.position((int)(l3 - l2));
        }

        private static int unsafeEstimateConsecutiveAscii(byte[] byArray, long l2, int n2) {
            if (n2 < 16) {
                return 0;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (UnsafeUtil.getByte(byArray, l2++) >= 0) continue;
                return i2;
            }
            return n2;
        }

        private static int unsafeEstimateConsecutiveAscii(long l2, int n2) {
            int n3;
            int n4 = n2;
            if (n4 < 16) {
                return 0;
            }
            for (int i2 = n3 = 8 - ((int)l2 & 7); i2 > 0; --i2) {
                if (UnsafeUtil.getByte(l2++) >= 0) continue;
                return n3 - i2;
            }
            n4 -= n3;
            while (n4 >= 8 && (UnsafeUtil.getLong(l2) & 0x8080808080808080L) == 0L) {
                l2 += 8L;
                n4 -= 8;
            }
            return n2 - n4;
        }

        private static int partialIsValidUtf8(byte[] byArray, long l2, int n2) {
            int n3 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(byArray, l2, n2);
            n2 -= n3;
            l2 += (long)n3;
            while (true) {
                byte by2;
                int n4 = 0;
                while (n2 > 0) {
                    byte by3 = UnsafeUtil.getByte(byArray, l2++);
                    n4 = by3;
                    if (by3 < 0) break;
                    --n2;
                }
                if (n2 == 0) {
                    return 0;
                }
                --n2;
                if (n4 < -32) {
                    if (n2 == 0) {
                        return n4;
                    }
                    --n2;
                    if (n4 >= -62 && UnsafeUtil.getByte(byArray, l2++) <= -65) continue;
                    return -1;
                }
                if (n4 < -16) {
                    if (n2 < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n4, l2, n2);
                    }
                    n2 -= 2;
                    if (!((by2 = UnsafeUtil.getByte(byArray, l2++)) > -65 || n4 == -32 && by2 < -96 || n4 == -19 && by2 >= -96) && UnsafeUtil.getByte(byArray, l2++) <= -65) continue;
                    return -1;
                }
                if (n2 < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n4, l2, n2);
                }
                n2 -= 3;
                if ((by2 = UnsafeUtil.getByte(byArray, l2++)) > -65 || (n4 << 28) + (by2 - -112) >> 30 != 0 || UnsafeUtil.getByte(byArray, l2++) > -65 || UnsafeUtil.getByte(byArray, l2++) > -65) break;
            }
            return -1;
        }

        private static int partialIsValidUtf8(long l2, int n2) {
            int n3 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(l2, n2);
            l2 += (long)n3;
            n2 -= n3;
            while (true) {
                byte by2;
                int n4 = 0;
                while (n2 > 0) {
                    byte by3 = UnsafeUtil.getByte(l2++);
                    n4 = by3;
                    if (by3 < 0) break;
                    --n2;
                }
                if (n2 == 0) {
                    return 0;
                }
                --n2;
                if (n4 < -32) {
                    if (n2 == 0) {
                        return n4;
                    }
                    --n2;
                    if (n4 >= -62 && UnsafeUtil.getByte(l2++) <= -65) continue;
                    return -1;
                }
                if (n4 < -16) {
                    if (n2 < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(l2, n4, n2);
                    }
                    n2 -= 2;
                    if (!((by2 = UnsafeUtil.getByte(l2++)) > -65 || n4 == -32 && by2 < -96 || n4 == -19 && by2 >= -96) && UnsafeUtil.getByte(l2++) <= -65) continue;
                    return -1;
                }
                if (n2 < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(l2, n4, n2);
                }
                n2 -= 3;
                if ((by2 = UnsafeUtil.getByte(l2++)) > -65 || (n4 << 28) + (by2 - -112) >> 30 != 0 || UnsafeUtil.getByte(l2++) > -65 || UnsafeUtil.getByte(l2++) > -65) break;
            }
            return -1;
        }

        private static int unsafeIncompleteStateFor(byte[] byArray, int n2, long l2, int n3) {
            switch (n3) {
                case 0: {
                    return Utf8.incompleteStateFor(n2);
                }
                case 1: {
                    return Utf8.incompleteStateFor(n2, UnsafeUtil.getByte(byArray, l2));
                }
                case 2: {
                    return Utf8.incompleteStateFor(n2, UnsafeUtil.getByte(byArray, l2), UnsafeUtil.getByte(byArray, l2 + 1L));
                }
            }
            throw new AssertionError();
        }

        private static int unsafeIncompleteStateFor(long l2, int n2, int n3) {
            switch (n3) {
                case 0: {
                    return Utf8.incompleteStateFor(n2);
                }
                case 1: {
                    return Utf8.incompleteStateFor(n2, UnsafeUtil.getByte(l2));
                }
                case 2: {
                    return Utf8.incompleteStateFor(n2, UnsafeUtil.getByte(l2), UnsafeUtil.getByte(l2 + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        @Override
        int partialIsValidUtf8(int n2, byte[] byArray, int n3, int n4) {
            if (n2 != 0) {
                if (n3 >= n4) {
                    return n2;
                }
                byte by2 = (byte)n2;
                if (by2 < -32) {
                    if (by2 < -62 || byArray[n3++] > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(n2 >> 8));
                    if (by3 == 0) {
                        by3 = byArray[n3++];
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || byArray[n3++] > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(n2 >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = byArray[n3++];
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(n2 >> 16);
                    }
                    if (by5 == 0) {
                        by5 = byArray[n3++];
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || byArray[n3++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8(byArray, n3, n4);
        }

        @Override
        int partialIsValidUtf8Direct(int n2, ByteBuffer byteBuffer, int n3, int n4) {
            return this.partialIsValidUtf8Default(n2, byteBuffer, n3, n4);
        }

        @Override
        String decodeUtf8(byte[] byArray, int n2, int n3) {
            byte by2;
            int n4;
            if ((n2 | n3 | byArray.length - n2 - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n2, n3));
            }
            int n5 = n4 + n3;
            char[] cArray = new char[n3];
            int n6 = 0;
            for (n4 = n2; n4 < n5 && DecodeUtil.isOneByte(by2 = byArray[n4]); ++n4) {
                DecodeUtil.handleOneByte(by2, cArray, n6++);
            }
            while (n4 < n5) {
                if (DecodeUtil.isOneByte(by2 = byArray[n4++])) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n6++);
                    while (n4 < n5 && DecodeUtil.isOneByte(by3 = byArray[n4])) {
                        ++n4;
                        DecodeUtil.handleOneByte(by3, cArray, n6++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n4 >= n5) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, byArray[n4++], cArray, n6++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n4 >= n5 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, byArray[n4++], byArray[n4++], cArray, n6++);
                    continue;
                }
                if (n4 >= n5 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, byArray[n4++], byArray[n4++], byArray[n4++], cArray, n6++);
                ++n6;
            }
            return new String(cArray, 0, n6);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer byteBuffer, int n2, int n3) {
            return this.decodeUtf8Default(byteBuffer, n2, n3);
        }

        @Override
        int encodeUtf8(CharSequence charSequence, byte[] byArray, int n2, int n3) {
            char c2;
            int n4;
            int n5 = charSequence.length();
            int n6 = n2;
            int n7 = n2 + n3;
            for (n4 = 0; n4 < n5 && n4 + n6 < n7 && (c2 = charSequence.charAt(n4)) < '\u0080'; ++n4) {
                byArray[n6 + n4] = (byte)c2;
            }
            if (n4 == n5) {
                return n6 + n5;
            }
            n6 += n4;
            while (n4 < n5) {
                c2 = charSequence.charAt(n4);
                if (c2 < '\u0080' && n6 < n7) {
                    byArray[n6++] = (byte)c2;
                } else if (c2 < '\u0800' && n6 <= n7 - 2) {
                    byArray[n6++] = (byte)(0x3C0 | c2 >>> 6);
                    byArray[n6++] = (byte)(0x80 | 0x3F & c2);
                } else if ((c2 < '\ud800' || '\udfff' < c2) && n6 <= n7 - 3) {
                    byArray[n6++] = (byte)(0x1E0 | c2 >>> 12);
                    byArray[n6++] = (byte)(0x80 | 0x3F & c2 >>> 6);
                    byArray[n6++] = (byte)(0x80 | 0x3F & c2);
                } else if (n6 <= n7 - 4) {
                    char c3;
                    if (n4 + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n4))) {
                        throw new UnpairedSurrogateException(n4 - 1, n5);
                    }
                    int n8 = Character.toCodePoint(c2, c3);
                    byArray[n6++] = (byte)(0xF0 | n8 >>> 18);
                    byArray[n6++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                    byArray[n6++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                    byArray[n6++] = (byte)(0x80 | 0x3F & n8);
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n4 + 1 != charSequence.length() && Character.isSurrogatePair(c2, charSequence.charAt(n4 + 1)))) {
                        throw new UnpairedSurrogateException(n4, n5);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + n6);
                }
                ++n4;
            }
            return n6;
        }

        @Override
        void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
            this.encodeUtf8Default(charSequence, byteBuffer);
        }

        private static int partialIsValidUtf8(byte[] byArray, int n2, int n3) {
            while (n2 < n3 && byArray[n2] >= 0) {
                ++n2;
            }
            return n2 >= n3 ? 0 : SafeProcessor.partialIsValidUtf8NonAscii(byArray, n2, n3);
        }

        private static int partialIsValidUtf8NonAscii(byte[] byArray, int n2, int n3) {
            while (true) {
                byte by2;
                byte by3;
                if (n2 >= n3) {
                    return 0;
                }
                if ((by3 = byArray[n2++]) >= 0) continue;
                if (by3 < -32) {
                    if (n2 >= n3) {
                        return by3;
                    }
                    if (by3 >= -62 && byArray[n2++] <= -65) continue;
                    return -1;
                }
                if (by3 < -16) {
                    if (n2 >= n3 - 1) {
                        return Utf8.incompleteStateFor(byArray, n2, n3);
                    }
                    if (!((by2 = byArray[n2++]) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && by2 >= -96) && byArray[n2++] <= -65) continue;
                    return -1;
                }
                if (n2 >= n3 - 2) {
                    return Utf8.incompleteStateFor(byArray, n2, n3);
                }
                if ((by2 = byArray[n2++]) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || byArray[n2++] > -65 || byArray[n2++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        final boolean isValidUtf8(byte[] byArray, int n2, int n3) {
            return this.partialIsValidUtf8(0, byArray, n2, n3) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        final boolean isValidUtf8(ByteBuffer byteBuffer, int n2, int n3) {
            return this.partialIsValidUtf8(0, byteBuffer, n2, n3) == 0;
        }

        final int partialIsValidUtf8(int n2, ByteBuffer byteBuffer, int n3, int n4) {
            if (byteBuffer.hasArray()) {
                int n5 = byteBuffer.arrayOffset();
                return this.partialIsValidUtf8(n2, byteBuffer.array(), n5 + n3, n5 + n4);
            }
            if (byteBuffer.isDirect()) {
                return this.partialIsValidUtf8Direct(n2, byteBuffer, n3, n4);
            }
            return this.partialIsValidUtf8Default(n2, byteBuffer, n3, n4);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final int partialIsValidUtf8Default(int n2, ByteBuffer byteBuffer, int n3, int n4) {
            if (n2 != 0) {
                if (n3 >= n4) {
                    return n2;
                }
                byte by2 = (byte)n2;
                if (by2 < -32) {
                    if (by2 < -62 || byteBuffer.get(n3++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(n2 >> 8));
                    if (by3 == 0) {
                        by3 = byteBuffer.get(n3++);
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || byteBuffer.get(n3++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(n2 >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = byteBuffer.get(n3++);
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(n2 >> 16);
                    }
                    if (by5 == 0) {
                        by5 = byteBuffer.get(n3++);
                        if (n3 >= n4) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || byteBuffer.get(n3++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(byteBuffer, n3, n4);
        }

        private static int partialIsValidUtf8(ByteBuffer byteBuffer, int n2, int n3) {
            n2 += Utf8.estimateConsecutiveAscii(byteBuffer, n2, n3);
            while (true) {
                byte by2;
                byte by3;
                if (n2 >= n3) {
                    return 0;
                }
                if ((by3 = byteBuffer.get(n2++)) >= 0) continue;
                if (by3 < -32) {
                    if (n2 >= n3) {
                        return by3;
                    }
                    if (by3 < -62 || byteBuffer.get(n2) > -65) {
                        return -1;
                    }
                    ++n2;
                    continue;
                }
                if (by3 < -16) {
                    if (n2 >= n3 - 1) {
                        return Utf8.incompleteStateFor(byteBuffer, by3, n2, n3 - n2);
                    }
                    if ((by2 = byteBuffer.get(n2++)) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && by2 >= -96 || byteBuffer.get(n2) > -65) {
                        return -1;
                    }
                    ++n2;
                    continue;
                }
                if (n2 >= n3 - 2) {
                    return Utf8.incompleteStateFor(byteBuffer, by3, n2, n3 - n2);
                }
                if ((by2 = byteBuffer.get(n2++)) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || byteBuffer.get(n2++) > -65 || byteBuffer.get(n2++) > -65) break;
            }
            return -1;
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3);

        final String decodeUtf8(ByteBuffer byteBuffer, int n2, int n3) {
            if (byteBuffer.hasArray()) {
                int n4 = byteBuffer.arrayOffset();
                return this.decodeUtf8(byteBuffer.array(), n4 + n2, n3);
            }
            if (byteBuffer.isDirect()) {
                return this.decodeUtf8Direct(byteBuffer, n2, n3);
            }
            return this.decodeUtf8Default(byteBuffer, n2, n3);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3);

        final String decodeUtf8Default(ByteBuffer byteBuffer, int n2, int n3) {
            byte by2;
            int n4;
            if ((n2 | n3 | byteBuffer.limit() - n2 - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n2, n3));
            }
            int n5 = n4 + n3;
            char[] cArray = new char[n3];
            int n6 = 0;
            for (n4 = n2; n4 < n5 && DecodeUtil.isOneByte(by2 = byteBuffer.get(n4)); ++n4) {
                DecodeUtil.handleOneByte(by2, cArray, n6++);
            }
            while (n4 < n5) {
                if (DecodeUtil.isOneByte(by2 = byteBuffer.get(n4++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n6++);
                    while (n4 < n5 && DecodeUtil.isOneByte(by3 = byteBuffer.get(n4))) {
                        ++n4;
                        DecodeUtil.handleOneByte(by3, cArray, n6++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n4 >= n5) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, byteBuffer.get(n4++), cArray, n6++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n4 >= n5 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, byteBuffer.get(n4++), byteBuffer.get(n4++), cArray, n6++);
                    continue;
                }
                if (n4 >= n5 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, byteBuffer.get(n4++), byteBuffer.get(n4++), byteBuffer.get(n4++), cArray, n6++);
                ++n6;
            }
            return new String(cArray, 0, n6);
        }

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        final void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
            if (byteBuffer.hasArray()) {
                int n2 = byteBuffer.arrayOffset();
                int n3 = Utf8.encode(charSequence, byteBuffer.array(), n2 + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n3 - n2);
            } else if (byteBuffer.isDirect()) {
                this.encodeUtf8Direct(charSequence, byteBuffer);
            } else {
                this.encodeUtf8Default(charSequence, byteBuffer);
            }
        }

        abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

        final void encodeUtf8Default(CharSequence charSequence, ByteBuffer byteBuffer) {
            int n2;
            int n3 = charSequence.length();
            int n4 = byteBuffer.position();
            try {
                char c2;
                for (n2 = 0; n2 < n3 && (c2 = charSequence.charAt(n2)) < '\u0080'; ++n2) {
                    byteBuffer.put(n4 + n2, (byte)c2);
                }
                if (n2 == n3) {
                    byteBuffer.position(n4 + n2);
                    return;
                }
                n4 += n2;
                while (n2 < n3) {
                    c2 = charSequence.charAt(n2);
                    if (c2 < '\u0080') {
                        byteBuffer.put(n4, (byte)c2);
                    } else if (c2 < '\u0800') {
                        byteBuffer.put(n4++, (byte)(0xC0 | c2 >>> 6));
                        byteBuffer.put(n4, (byte)(0x80 | 0x3F & c2));
                    } else if (c2 < '\ud800' || '\udfff' < c2) {
                        byteBuffer.put(n4++, (byte)(0xE0 | c2 >>> 12));
                        byteBuffer.put(n4++, (byte)(0x80 | 0x3F & c2 >>> 6));
                        byteBuffer.put(n4, (byte)(0x80 | 0x3F & c2));
                    } else {
                        char c3;
                        if (n2 + 1 == n3 || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n2))) {
                            throw new UnpairedSurrogateException(n2, n3);
                        }
                        int n5 = Character.toCodePoint(c2, c3);
                        byteBuffer.put(n4++, (byte)(0xF0 | n5 >>> 18));
                        byteBuffer.put(n4++, (byte)(0x80 | 0x3F & n5 >>> 12));
                        byteBuffer.put(n4++, (byte)(0x80 | 0x3F & n5 >>> 6));
                        byteBuffer.put(n4, (byte)(0x80 | 0x3F & n5));
                    }
                    ++n2;
                    ++n4;
                }
                byteBuffer.position(n4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                int n6 = byteBuffer.position() + Math.max(n2, n4 - byteBuffer.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n2) + " at index " + n6);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n2, int n3) {
            super("Unpaired surrogate at index " + n2 + " of " + n3);
        }
    }
}

