/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Logger logger = Logger.getLogger(UnsafeUtil.class.getName());
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final Class<?> MEMORY_CLASS = Android.getMemoryClass();
    private static final boolean IS_ANDROID_64 = UnsafeUtil.determineAndroidSupportByAddressSize(Long.TYPE);
    private static final boolean IS_ANDROID_32 = UnsafeUtil.determineAndroidSupportByAddressSize(Integer.TYPE);
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());
    private static final int STRIDE = 8;
    private static final int STRIDE_ALIGNMENT_MASK = 7;
    private static final int BYTE_ARRAY_ALIGNMENT = (int)(BYTE_ARRAY_BASE_OFFSET & 7L);
    static final boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static boolean isAndroid64() {
        return IS_ANDROID_64;
    }

    static <T> T allocateInstance(Class<T> clazz) {
        try {
            return (T)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayBaseOffset(clazz) : -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayIndexScale(clazz) : -1;
    }

    static byte getByte(Object object, long l2) {
        return MEMORY_ACCESSOR.getByte(object, l2);
    }

    static void putByte(Object object, long l2, byte by2) {
        MEMORY_ACCESSOR.putByte(object, l2, by2);
    }

    static int getInt(Object object, long l2) {
        return MEMORY_ACCESSOR.getInt(object, l2);
    }

    static void putInt(Object object, long l2, int n2) {
        MEMORY_ACCESSOR.putInt(object, l2, n2);
    }

    static long getLong(Object object, long l2) {
        return MEMORY_ACCESSOR.getLong(object, l2);
    }

    static void putLong(Object object, long l2, long l3) {
        MEMORY_ACCESSOR.putLong(object, l2, l3);
    }

    static boolean getBoolean(Object object, long l2) {
        return MEMORY_ACCESSOR.getBoolean(object, l2);
    }

    static void putBoolean(Object object, long l2, boolean bl2) {
        MEMORY_ACCESSOR.putBoolean(object, l2, bl2);
    }

    static float getFloat(Object object, long l2) {
        return MEMORY_ACCESSOR.getFloat(object, l2);
    }

    static void putFloat(Object object, long l2, float f2) {
        MEMORY_ACCESSOR.putFloat(object, l2, f2);
    }

    static double getDouble(Object object, long l2) {
        return MEMORY_ACCESSOR.getDouble(object, l2);
    }

    static void putDouble(Object object, long l2, double d2) {
        MEMORY_ACCESSOR.putDouble(object, l2, d2);
    }

    static Object getObject(Object object, long l2) {
        return MEMORY_ACCESSOR.getObject(object, l2);
    }

    static void putObject(Object object, long l2, Object object2) {
        MEMORY_ACCESSOR.putObject(object, l2, object2);
    }

    static byte getByte(byte[] byArray, long l2) {
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l2);
    }

    static void putByte(byte[] byArray, long l2, byte by2) {
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + l2, by2);
    }

    static int getInt(int[] nArray, long l2) {
        return MEMORY_ACCESSOR.getInt(nArray, INT_ARRAY_BASE_OFFSET + l2 * INT_ARRAY_INDEX_SCALE);
    }

    static void putInt(int[] nArray, long l2, int n2) {
        MEMORY_ACCESSOR.putInt(nArray, INT_ARRAY_BASE_OFFSET + l2 * INT_ARRAY_INDEX_SCALE, n2);
    }

    static long getLong(long[] lArray, long l2) {
        return MEMORY_ACCESSOR.getLong(lArray, LONG_ARRAY_BASE_OFFSET + l2 * LONG_ARRAY_INDEX_SCALE);
    }

    static void putLong(long[] lArray, long l2, long l3) {
        MEMORY_ACCESSOR.putLong(lArray, LONG_ARRAY_BASE_OFFSET + l2 * LONG_ARRAY_INDEX_SCALE, l3);
    }

    static boolean getBoolean(boolean[] blArray, long l2) {
        return MEMORY_ACCESSOR.getBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l2 * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    static void putBoolean(boolean[] blArray, long l2, boolean bl2) {
        MEMORY_ACCESSOR.putBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l2 * BOOLEAN_ARRAY_INDEX_SCALE, bl2);
    }

    static float getFloat(float[] fArray, long l2) {
        return MEMORY_ACCESSOR.getFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l2 * FLOAT_ARRAY_INDEX_SCALE);
    }

    static void putFloat(float[] fArray, long l2, float f2) {
        MEMORY_ACCESSOR.putFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l2 * FLOAT_ARRAY_INDEX_SCALE, f2);
    }

    static double getDouble(double[] dArray, long l2) {
        return MEMORY_ACCESSOR.getDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l2 * DOUBLE_ARRAY_INDEX_SCALE);
    }

    static void putDouble(double[] dArray, long l2, double d2) {
        MEMORY_ACCESSOR.putDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l2 * DOUBLE_ARRAY_INDEX_SCALE, d2);
    }

    static Object getObject(Object[] objectArray, long l2) {
        return MEMORY_ACCESSOR.getObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l2 * OBJECT_ARRAY_INDEX_SCALE);
    }

    static void putObject(Object[] objectArray, long l2, Object object) {
        MEMORY_ACCESSOR.putObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l2 * OBJECT_ARRAY_INDEX_SCALE, object);
    }

    static void copyMemory(byte[] byArray, long l2, long l3, long l4) {
        MEMORY_ACCESSOR.copyMemory(byArray, l2, l3, l4);
    }

    static void copyMemory(long l2, byte[] byArray, long l3, long l4) {
        MEMORY_ACCESSOR.copyMemory(l2, byArray, l3, l4);
    }

    static void copyMemory(byte[] byArray, long l2, byte[] byArray2, long l3, long l4) {
        System.arraycopy(byArray, (int)l2, byArray2, (int)l3, (int)l4);
    }

    static byte getByte(long l2) {
        return MEMORY_ACCESSOR.getByte(l2);
    }

    static void putByte(long l2, byte by2) {
        MEMORY_ACCESSOR.putByte(l2, by2);
    }

    static int getInt(long l2) {
        return MEMORY_ACCESSOR.getInt(l2);
    }

    static void putInt(long l2, int n2) {
        MEMORY_ACCESSOR.putInt(l2, n2);
    }

    static long getLong(long l2) {
        return MEMORY_ACCESSOR.getLong(l2);
    }

    static void putLong(long l2, long l3) {
        MEMORY_ACCESSOR.putLong(l2, l3);
    }

    static long addressOffset(ByteBuffer byteBuffer) {
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        return MEMORY_ACCESSOR.getStaticObject(field);
    }

    static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() {
                    Class<Unsafe> clazz = Unsafe.class;
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!clazz.isInstance(object)) continue;
                        return (Unsafe)clazz.cast(object);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        if (Android.isOnAndroidDevice()) {
            if (IS_ANDROID_64) {
                return new Android64MemoryAccessor(UNSAFE);
            }
            if (IS_ANDROID_32) {
                return new Android32MemoryAccessor(UNSAFE);
            }
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("arrayBaseOffset", Class.class);
            clazz.getMethod("arrayIndexScale", Class.class);
            clazz.getMethod("getInt", Object.class, Long.TYPE);
            clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            clazz.getMethod("getObject", Object.class, Long.TYPE);
            clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            if (Android.isOnAndroidDevice()) {
                return true;
            }
            clazz.getMethod("getByte", Object.class, Long.TYPE);
            clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            clazz.getMethod("getBoolean", Object.class, Long.TYPE);
            clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            clazz.getMethod("getFloat", Object.class, Long.TYPE);
            clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            clazz.getMethod("getDouble", Object.class, Long.TYPE);
            clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            if (UnsafeUtil.bufferAddressField() == null) {
                return false;
            }
            if (Android.isOnAndroidDevice()) {
                return true;
            }
            clazz.getMethod("getByte", Long.TYPE);
            clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
            clazz.getMethod("getInt", Long.TYPE);
            clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Long.TYPE);
            clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean determineAndroidSupportByAddressSize(Class<?> clazz) {
        if (!Android.isOnAndroidDevice()) {
            return false;
        }
        try {
            Class<?> clazz2 = MEMORY_CLASS;
            clazz2.getMethod("peekLong", clazz, Boolean.TYPE);
            clazz2.getMethod("pokeLong", clazz, Long.TYPE, Boolean.TYPE);
            clazz2.getMethod("pokeInt", clazz, Integer.TYPE, Boolean.TYPE);
            clazz2.getMethod("peekInt", clazz, Boolean.TYPE);
            clazz2.getMethod("pokeByte", clazz, Byte.TYPE);
            clazz2.getMethod("peekByte", clazz);
            clazz2.getMethod("pokeByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            clazz2.getMethod("peekByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Field bufferAddressField() {
        Field field;
        if (Android.isOnAndroidDevice() && (field = UnsafeUtil.field(Buffer.class, "effectiveDirectAddress")) != null) {
            return field;
        }
        field = UnsafeUtil.field(Buffer.class, "address");
        return field != null && field.getType() == Long.TYPE ? field : null;
    }

    private static int firstDifferingByteIndexNativeEndian(long l2, long l3) {
        int n2 = IS_BIG_ENDIAN ? Long.numberOfLeadingZeros(l2 ^ l3) : Long.numberOfTrailingZeros(l2 ^ l3);
        return n2 >> 3;
    }

    static int mismatch(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 + n4 > byArray.length || n3 + n4 > byArray2.length) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            int n6 = BYTE_ARRAY_ALIGNMENT + n2 & 7;
            while (n5 < n4 && (n6 & 7) != 0) {
                if (byArray[n2 + n5] != byArray2[n3 + n5]) {
                    return n5;
                }
                ++n5;
                ++n6;
            }
            int n7 = (n4 - n5 & 0xFFFFFFF8) + n5;
            while (n5 < n7) {
                long l2;
                long l3 = UnsafeUtil.getLong((Object)byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2 + (long)n5);
                if (l3 != (l2 = UnsafeUtil.getLong((Object)byArray2, BYTE_ARRAY_BASE_OFFSET + (long)n3 + (long)n5))) {
                    return n5 + UnsafeUtil.firstDifferingByteIndexNativeEndian(l3, l2);
                }
                n5 += 8;
            }
        }
        while (n5 < n4) {
            if (byArray[n2 + n5] != byArray2[n3 + n5]) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String string) {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    private static byte getByteBigEndian(Object object, long l2) {
        return (byte)(UnsafeUtil.getInt(object, l2 & 0xFFFFFFFFFFFFFFFCL) >>> (int)(((l2 ^ 0xFFFFFFFFFFFFFFFFL) & 3L) << 3) & 0xFF);
    }

    private static byte getByteLittleEndian(Object object, long l2) {
        return (byte)(UnsafeUtil.getInt(object, l2 & 0xFFFFFFFFFFFFFFFCL) >>> (int)((l2 & 3L) << 3) & 0xFF);
    }

    private static void putByteBigEndian(Object object, long l2, byte by2) {
        int n2 = UnsafeUtil.getInt(object, l2 & 0xFFFFFFFFFFFFFFFCL);
        int n3 = (~((int)l2) & 3) << 3;
        int n4 = n2 & ~(255 << n3) | (0xFF & by2) << n3;
        UnsafeUtil.putInt(object, l2 & 0xFFFFFFFFFFFFFFFCL, n4);
    }

    private static void putByteLittleEndian(Object object, long l2, byte by2) {
        int n2 = UnsafeUtil.getInt(object, l2 & 0xFFFFFFFFFFFFFFFCL);
        int n3 = ((int)l2 & 3) << 3;
        int n4 = n2 & ~(255 << n3) | (0xFF & by2) << n3;
        UnsafeUtil.putInt(object, l2 & 0xFFFFFFFFFFFFFFFCL, n4);
    }

    private static boolean getBooleanBigEndian(Object object, long l2) {
        return UnsafeUtil.getByteBigEndian(object, l2) != 0;
    }

    private static boolean getBooleanLittleEndian(Object object, long l2) {
        return UnsafeUtil.getByteLittleEndian(object, l2) != 0;
    }

    private static void putBooleanBigEndian(Object object, long l2, boolean bl2) {
        UnsafeUtil.putByteBigEndian(object, l2, (byte)(bl2 ? 1 : 0));
    }

    private static void putBooleanLittleEndian(Object object, long l2, boolean bl2) {
        UnsafeUtil.putByteLittleEndian(object, l2, (byte)(bl2 ? 1 : 0));
    }

    private static final class Android32MemoryAccessor
    extends MemoryAccessor {
        private static final long SMALL_ADDRESS_MASK = -1L;

        private static int smallAddress(long l2) {
            return (int)(0xFFFFFFFFFFFFFFFFL & l2);
        }

        Android32MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(long l2, byte by2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(long l2, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(Object object, long l2) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l2);
            }
            return UnsafeUtil.getByteLittleEndian(object, l2);
        }

        @Override
        public void putByte(Object object, long l2, byte by2) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l2, by2);
            } else {
                UnsafeUtil.putByteLittleEndian(object, l2, by2);
            }
        }

        @Override
        public boolean getBoolean(Object object, long l2) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l2);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l2);
        }

        @Override
        public void putBoolean(Object object, long l2, boolean bl2) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l2, bl2);
            } else {
                UnsafeUtil.putBooleanLittleEndian(object, l2, bl2);
            }
        }

        @Override
        public float getFloat(Object object, long l2) {
            return Float.intBitsToFloat(this.getInt(object, l2));
        }

        @Override
        public void putFloat(Object object, long l2, float f2) {
            this.putInt(object, l2, Float.floatToIntBits(f2));
        }

        @Override
        public double getDouble(Object object, long l2) {
            return Double.longBitsToDouble(this.getLong(object, l2));
        }

        @Override
        public void putDouble(Object object, long l2, double d2) {
            this.putLong(object, l2, Double.doubleToLongBits(d2));
        }

        @Override
        public void copyMemory(long l2, byte[] byArray, long l3, long l4) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyMemory(byte[] byArray, long l2, long l3, long l4) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
    }

    private static final class Android64MemoryAccessor
    extends MemoryAccessor {
        Android64MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(long l2, byte by2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(long l2, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(Object object, long l2) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l2);
            }
            return UnsafeUtil.getByteLittleEndian(object, l2);
        }

        @Override
        public void putByte(Object object, long l2, byte by2) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l2, by2);
            } else {
                UnsafeUtil.putByteLittleEndian(object, l2, by2);
            }
        }

        @Override
        public boolean getBoolean(Object object, long l2) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l2);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l2);
        }

        @Override
        public void putBoolean(Object object, long l2, boolean bl2) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l2, bl2);
            } else {
                UnsafeUtil.putBooleanLittleEndian(object, l2, bl2);
            }
        }

        @Override
        public float getFloat(Object object, long l2) {
            return Float.intBitsToFloat(this.getInt(object, l2));
        }

        @Override
        public void putFloat(Object object, long l2, float f2) {
            this.putInt(object, l2, Float.floatToIntBits(f2));
        }

        @Override
        public double getDouble(Object object, long l2) {
            return Double.longBitsToDouble(this.getLong(object, l2));
        }

        @Override
        public void putDouble(Object object, long l2, double d2) {
            this.putLong(object, l2, Double.doubleToLongBits(d2));
        }

        @Override
        public void copyMemory(long l2, byte[] byArray, long l3, long l4) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyMemory(byte[] byArray, long l2, long l3, long l4) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l2) {
            return this.unsafe.getByte(l2);
        }

        @Override
        public void putByte(long l2, byte by2) {
            this.unsafe.putByte(l2, by2);
        }

        @Override
        public int getInt(long l2) {
            return this.unsafe.getInt(l2);
        }

        @Override
        public void putInt(long l2, int n2) {
            this.unsafe.putInt(l2, n2);
        }

        @Override
        public long getLong(long l2) {
            return this.unsafe.getLong(l2);
        }

        @Override
        public void putLong(long l2, long l3) {
            this.unsafe.putLong(l2, l3);
        }

        @Override
        public byte getByte(Object object, long l2) {
            return this.unsafe.getByte(object, l2);
        }

        @Override
        public void putByte(Object object, long l2, byte by2) {
            this.unsafe.putByte(object, l2, by2);
        }

        @Override
        public boolean getBoolean(Object object, long l2) {
            return this.unsafe.getBoolean(object, l2);
        }

        @Override
        public void putBoolean(Object object, long l2, boolean bl2) {
            this.unsafe.putBoolean(object, l2, bl2);
        }

        @Override
        public float getFloat(Object object, long l2) {
            return this.unsafe.getFloat(object, l2);
        }

        @Override
        public void putFloat(Object object, long l2, float f2) {
            this.unsafe.putFloat(object, l2, f2);
        }

        @Override
        public double getDouble(Object object, long l2) {
            return this.unsafe.getDouble(object, l2);
        }

        @Override
        public void putDouble(Object object, long l2, double d2) {
            this.unsafe.putDouble(object, l2, d2);
        }

        @Override
        public void copyMemory(long l2, byte[] byArray, long l3, long l4) {
            this.unsafe.copyMemory(null, l2, byArray, BYTE_ARRAY_BASE_OFFSET + l3, l4);
        }

        @Override
        public void copyMemory(byte[] byArray, long l2, long l3, long l4) {
            this.unsafe.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + l2, null, l3, l4);
        }

        @Override
        public Object getStaticObject(Field field) {
            return this.getObject(this.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset(field));
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        public final int getInt(Object object, long l2) {
            return this.unsafe.getInt(object, l2);
        }

        public final void putInt(Object object, long l2, int n2) {
            this.unsafe.putInt(object, l2, n2);
        }

        public final long getLong(Object object, long l2) {
            return this.unsafe.getLong(object, l2);
        }

        public final void putLong(Object object, long l2, long l3) {
            this.unsafe.putLong(object, l2, l3);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        public final Object getObject(Object object, long l2) {
            return this.unsafe.getObject(object, l2);
        }

        public final void putObject(Object object, long l2, Object object2) {
            this.unsafe.putObject(object, l2, object2);
        }

        public final int arrayBaseOffset(Class<?> clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public final int arrayIndexScale(Class<?> clazz) {
            return this.unsafe.arrayIndexScale(clazz);
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract Object getStaticObject(Field var1);

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void copyMemory(byte[] var1, long var2, long var4, long var6);
    }
}

