/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public final class UnknownFieldSet
implements MessageLite {
    private static final UnknownFieldSet defaultInstance = new UnknownFieldSet(Collections.emptyMap(), Collections.emptyMap());
    private final Map<Integer, Field> fields;
    private final Map<Integer, Field> fieldsDescending;
    private static final Parser PARSER = new Parser();

    private UnknownFieldSet() {
        this.fields = null;
        this.fieldsDescending = null;
    }

    public static Builder newBuilder() {
        return Builder.create();
    }

    public static Builder newBuilder(UnknownFieldSet unknownFieldSet) {
        return UnknownFieldSet.newBuilder().mergeFrom(unknownFieldSet);
    }

    public static UnknownFieldSet getDefaultInstance() {
        return defaultInstance;
    }

    @Override
    public UnknownFieldSet getDefaultInstanceForType() {
        return defaultInstance;
    }

    UnknownFieldSet(Map<Integer, Field> map, Map<Integer, Field> map2) {
        this.fields = map;
        this.fieldsDescending = map2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof UnknownFieldSet && this.fields.equals(((UnknownFieldSet)object).fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Map<Integer, Field> asMap() {
        return this.fields;
    }

    public boolean hasField(int n2) {
        return this.fields.containsKey(n2);
    }

    public Field getField(int n2) {
        Field field = this.fields.get(n2);
        return field == null ? Field.getDefaultInstance() : field;
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            Field field = entry.getValue();
            field.writeTo((int)entry.getKey(), codedOutputStream);
        }
    }

    public String toString() {
        return TextFormat.printer().printToString(this);
    }

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(codedBuilder.getCodedOutput());
            return codedBuilder.build();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream outputStream) {
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream);
        codedOutputStream.writeRawVarint32(this.getSerializedSize());
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public int getSerializedSize() {
        int n2 = 0;
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            n2 += entry.getValue().getSerializedSize(entry.getKey());
        }
        return n2;
    }

    public void writeAsMessageSetTo(CodedOutputStream codedOutputStream) {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            entry.getValue().writeAsMessageSetExtensionTo((int)entry.getKey(), codedOutputStream);
        }
    }

    void writeTo(Writer writer) {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (Map.Entry<Integer, Field> entry : this.fieldsDescending.entrySet()) {
                entry.getValue().writeTo((int)entry.getKey(), writer);
            }
        } else {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                entry.getValue().writeTo((int)entry.getKey(), writer);
            }
        }
    }

    void writeAsMessageSetTo(Writer writer) {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (Map.Entry<Integer, Field> entry : this.fieldsDescending.entrySet()) {
                entry.getValue().writeAsMessageSetExtensionTo(entry.getKey(), writer);
            }
        } else {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                entry.getValue().writeAsMessageSetExtensionTo(entry.getKey(), writer);
            }
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int n2 = 0;
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            n2 += entry.getValue().getSerializedSizeAsMessageSetExtension(entry.getKey());
        }
        return n2;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    public static UnknownFieldSet parseFrom(CodedInputStream codedInputStream) {
        return UnknownFieldSet.newBuilder().mergeFrom(codedInputStream).build();
    }

    public static UnknownFieldSet parseFrom(ByteString byteString) {
        return UnknownFieldSet.newBuilder().mergeFrom(byteString).build();
    }

    public static UnknownFieldSet parseFrom(byte[] byArray) {
        return UnknownFieldSet.newBuilder().mergeFrom(byArray).build();
    }

    public static UnknownFieldSet parseFrom(InputStream inputStream) {
        return UnknownFieldSet.newBuilder().mergeFrom(inputStream).build();
    }

    @Override
    public Builder newBuilderForType() {
        return UnknownFieldSet.newBuilder();
    }

    @Override
    public Builder toBuilder() {
        return UnknownFieldSet.newBuilder().mergeFrom(this);
    }

    public final Parser getParserForType() {
        return PARSER;
    }

    public static final class Parser
    extends AbstractParser<UnknownFieldSet> {
        @Override
        public UnknownFieldSet parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
            Builder builder = UnknownFieldSet.newBuilder();
            try {
                builder.mergeFrom(codedInputStream);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException iOException) {
                throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    }

    public static final class Field {
        private static final Field fieldDefaultInstance = Field.newBuilder().build();
        private List<Long> varint;
        private List<Integer> fixed32;
        private List<Long> fixed64;
        private List<ByteString> lengthDelimited;
        private List<UnknownFieldSet> group;

        private Field() {
        }

        public static Builder newBuilder() {
            return Builder.create();
        }

        public static Builder newBuilder(Field field) {
            return Field.newBuilder().mergeFrom(field);
        }

        public static Field getDefaultInstance() {
            return fieldDefaultInstance;
        }

        public List<Long> getVarintList() {
            return this.varint;
        }

        public List<Integer> getFixed32List() {
            return this.fixed32;
        }

        public List<Long> getFixed64List() {
            return this.fixed64;
        }

        public List<ByteString> getLengthDelimitedList() {
            return this.lengthDelimited;
        }

        public List<UnknownFieldSet> getGroupList() {
            return this.group;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Field)) {
                return false;
            }
            return Arrays.equals(this.getIdentityArray(), ((Field)object).getIdentityArray());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getIdentityArray());
        }

        private Object[] getIdentityArray() {
            return new Object[]{this.varint, this.fixed32, this.fixed64, this.lengthDelimited, this.group};
        }

        public ByteString toByteString(int n2) {
            try {
                ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize(n2));
                this.writeTo(n2, codedBuilder.getCodedOutput());
                return codedBuilder.build();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Serializing to a ByteString should never fail with an IOException", iOException);
            }
        }

        public void writeTo(int n2, CodedOutputStream codedOutputStream) {
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                long l2 = iterator.next();
                codedOutputStream.writeUInt64(n2, l2);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                codedOutputStream.writeFixed32(n2, n3);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                long l3 = (Long)iterator.next();
                codedOutputStream.writeFixed64(n2, l3);
            }
            for (ByteString byteString : this.lengthDelimited) {
                codedOutputStream.writeBytes(n2, byteString);
            }
            for (UnknownFieldSet unknownFieldSet : this.group) {
                codedOutputStream.writeGroup(n2, unknownFieldSet);
            }
        }

        public int getSerializedSize(int n2) {
            int n3 = 0;
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                long l2 = iterator.next();
                n3 += CodedOutputStream.computeUInt64Size(n2, l2);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                n3 += CodedOutputStream.computeFixed32Size(n2, n4);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                long l3 = (Long)iterator.next();
                n3 += CodedOutputStream.computeFixed64Size(n2, l3);
            }
            for (ByteString byteString : this.lengthDelimited) {
                n3 += CodedOutputStream.computeBytesSize(n2, byteString);
            }
            for (UnknownFieldSet unknownFieldSet : this.group) {
                n3 += CodedOutputStream.computeGroupSize(n2, unknownFieldSet);
            }
            return n3;
        }

        public void writeAsMessageSetExtensionTo(int n2, CodedOutputStream codedOutputStream) {
            for (ByteString byteString : this.lengthDelimited) {
                codedOutputStream.writeRawMessageSetExtension(n2, byteString);
            }
        }

        void writeTo(int n2, Writer writer) {
            writer.writeInt64List(n2, this.varint, false);
            writer.writeFixed32List(n2, this.fixed32, false);
            writer.writeFixed64List(n2, this.fixed64, false);
            writer.writeBytesList(n2, this.lengthDelimited);
            if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                for (int i2 = 0; i2 < this.group.size(); ++i2) {
                    writer.writeStartGroup(n2);
                    this.group.get(i2).writeTo(writer);
                    writer.writeEndGroup(n2);
                }
            } else {
                for (int i3 = this.group.size() - 1; i3 >= 0; --i3) {
                    writer.writeEndGroup(n2);
                    this.group.get(i3).writeTo(writer);
                    writer.writeStartGroup(n2);
                }
            }
        }

        private void writeAsMessageSetExtensionTo(int n2, Writer writer) {
            if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
                ListIterator<ByteString> listIterator = this.lengthDelimited.listIterator(this.lengthDelimited.size());
                while (listIterator.hasPrevious()) {
                    writer.writeMessageSetItem(n2, listIterator.previous());
                }
            } else {
                for (ByteString byteString : this.lengthDelimited) {
                    writer.writeMessageSetItem(n2, byteString);
                }
            }
        }

        public int getSerializedSizeAsMessageSetExtension(int n2) {
            int n3 = 0;
            for (ByteString byteString : this.lengthDelimited) {
                n3 += CodedOutputStream.computeRawMessageSetExtensionSize(n2, byteString);
            }
            return n3;
        }

        public static final class Builder {
            private Field result;

            private Builder() {
            }

            private static Builder create() {
                Builder builder = new Builder();
                builder.result = new Field();
                return builder;
            }

            public Field build() {
                if (this.result.varint == null) {
                    this.result.varint = Collections.emptyList();
                } else {
                    this.result.varint = Collections.unmodifiableList(this.result.varint);
                }
                if (this.result.fixed32 == null) {
                    this.result.fixed32 = Collections.emptyList();
                } else {
                    this.result.fixed32 = Collections.unmodifiableList(this.result.fixed32);
                }
                if (this.result.fixed64 == null) {
                    this.result.fixed64 = Collections.emptyList();
                } else {
                    this.result.fixed64 = Collections.unmodifiableList(this.result.fixed64);
                }
                if (this.result.lengthDelimited == null) {
                    this.result.lengthDelimited = Collections.emptyList();
                } else {
                    this.result.lengthDelimited = Collections.unmodifiableList(this.result.lengthDelimited);
                }
                if (this.result.group == null) {
                    this.result.group = Collections.emptyList();
                } else {
                    this.result.group = Collections.unmodifiableList(this.result.group);
                }
                Field field = this.result;
                this.result = null;
                return field;
            }

            public Builder clear() {
                this.result = new Field();
                return this;
            }

            public Builder mergeFrom(Field field) {
                if (!field.varint.isEmpty()) {
                    if (this.result.varint == null) {
                        this.result.varint = new ArrayList();
                    }
                    this.result.varint.addAll(field.varint);
                }
                if (!field.fixed32.isEmpty()) {
                    if (this.result.fixed32 == null) {
                        this.result.fixed32 = new ArrayList();
                    }
                    this.result.fixed32.addAll(field.fixed32);
                }
                if (!field.fixed64.isEmpty()) {
                    if (this.result.fixed64 == null) {
                        this.result.fixed64 = new ArrayList();
                    }
                    this.result.fixed64.addAll(field.fixed64);
                }
                if (!field.lengthDelimited.isEmpty()) {
                    if (this.result.lengthDelimited == null) {
                        this.result.lengthDelimited = new ArrayList();
                    }
                    this.result.lengthDelimited.addAll(field.lengthDelimited);
                }
                if (!field.group.isEmpty()) {
                    if (this.result.group == null) {
                        this.result.group = new ArrayList();
                    }
                    this.result.group.addAll(field.group);
                }
                return this;
            }

            public Builder addVarint(long l2) {
                if (this.result.varint == null) {
                    this.result.varint = new ArrayList();
                }
                this.result.varint.add(l2);
                return this;
            }

            public Builder addFixed32(int n2) {
                if (this.result.fixed32 == null) {
                    this.result.fixed32 = new ArrayList();
                }
                this.result.fixed32.add(n2);
                return this;
            }

            public Builder addFixed64(long l2) {
                if (this.result.fixed64 == null) {
                    this.result.fixed64 = new ArrayList();
                }
                this.result.fixed64.add(l2);
                return this;
            }

            public Builder addLengthDelimited(ByteString byteString) {
                if (this.result.lengthDelimited == null) {
                    this.result.lengthDelimited = new ArrayList();
                }
                this.result.lengthDelimited.add(byteString);
                return this;
            }

            public Builder addGroup(UnknownFieldSet unknownFieldSet) {
                if (this.result.group == null) {
                    this.result.group = new ArrayList();
                }
                this.result.group.add(unknownFieldSet);
                return this;
            }
        }
    }

    public static final class Builder
    implements MessageLite.Builder {
        private Map<Integer, Field> fields;
        private int lastFieldNumber;
        private Field.Builder lastField;

        private Builder() {
        }

        private static Builder create() {
            Builder builder = new Builder();
            builder.reinitialize();
            return builder;
        }

        private Field.Builder getFieldBuilder(int n2) {
            if (this.lastField != null) {
                if (n2 == this.lastFieldNumber) {
                    return this.lastField;
                }
                this.addField(this.lastFieldNumber, this.lastField.build());
            }
            if (n2 == 0) {
                return null;
            }
            Field field = this.fields.get(n2);
            this.lastFieldNumber = n2;
            this.lastField = Field.newBuilder();
            if (field != null) {
                this.lastField.mergeFrom(field);
            }
            return this.lastField;
        }

        @Override
        public UnknownFieldSet build() {
            UnknownFieldSet unknownFieldSet;
            this.getFieldBuilder(0);
            if (this.fields.isEmpty()) {
                unknownFieldSet = UnknownFieldSet.getDefaultInstance();
            } else {
                Map<Integer, Field> map = null;
                map = Collections.unmodifiableMap(((TreeMap)this.fields).descendingMap());
                unknownFieldSet = new UnknownFieldSet(Collections.unmodifiableMap(this.fields), map);
            }
            this.fields = null;
            return unknownFieldSet;
        }

        @Override
        public UnknownFieldSet buildPartial() {
            return this.build();
        }

        @Override
        public Builder clone() {
            this.getFieldBuilder(0);
            Map<Integer, Field> map = null;
            map = Collections.unmodifiableMap(((TreeMap)this.fields).descendingMap());
            return UnknownFieldSet.newBuilder().mergeFrom(new UnknownFieldSet(this.fields, map));
        }

        @Override
        public UnknownFieldSet getDefaultInstanceForType() {
            return UnknownFieldSet.getDefaultInstance();
        }

        private void reinitialize() {
            this.fields = Collections.emptyMap();
            this.lastFieldNumber = 0;
            this.lastField = null;
        }

        @Override
        public Builder clear() {
            this.reinitialize();
            return this;
        }

        public Builder clearField(int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            if (this.lastField != null && this.lastFieldNumber == n2) {
                this.lastField = null;
                this.lastFieldNumber = 0;
            }
            if (this.fields.containsKey(n2)) {
                this.fields.remove(n2);
            }
            return this;
        }

        public Builder mergeFrom(UnknownFieldSet unknownFieldSet) {
            if (unknownFieldSet != UnknownFieldSet.getDefaultInstance()) {
                for (Map.Entry entry : unknownFieldSet.fields.entrySet()) {
                    this.mergeField((Integer)entry.getKey(), (Field)entry.getValue());
                }
            }
            return this;
        }

        public Builder mergeField(int n2, Field field) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            if (this.hasField(n2)) {
                this.getFieldBuilder(n2).mergeFrom(field);
            } else {
                this.addField(n2, field);
            }
            return this;
        }

        public Builder mergeVarintField(int n2, int n3) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            this.getFieldBuilder(n2).addVarint(n3);
            return this;
        }

        public Builder mergeLengthDelimitedField(int n2, ByteString byteString) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            this.getFieldBuilder(n2).addLengthDelimited(byteString);
            return this;
        }

        public boolean hasField(int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            return n2 == this.lastFieldNumber || this.fields.containsKey(n2);
        }

        public Builder addField(int n2, Field field) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            if (this.lastField != null && this.lastFieldNumber == n2) {
                this.lastField = null;
                this.lastFieldNumber = 0;
            }
            if (this.fields.isEmpty()) {
                this.fields = new TreeMap<Integer, Field>();
            }
            this.fields.put(n2, field);
            return this;
        }

        public Map<Integer, Field> asMap() {
            this.getFieldBuilder(0);
            return Collections.unmodifiableMap(this.fields);
        }

        @Override
        public Builder mergeFrom(CodedInputStream codedInputStream) {
            int n2;
            while ((n2 = codedInputStream.readTag()) != 0 && this.mergeFieldFrom(n2, codedInputStream)) {
            }
            return this;
        }

        public boolean mergeFieldFrom(int n2, CodedInputStream codedInputStream) {
            int n3 = WireFormat.getTagFieldNumber(n2);
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    this.getFieldBuilder(n3).addVarint(codedInputStream.readInt64());
                    return true;
                }
                case 1: {
                    this.getFieldBuilder(n3).addFixed64(codedInputStream.readFixed64());
                    return true;
                }
                case 2: {
                    this.getFieldBuilder(n3).addLengthDelimited(codedInputStream.readBytes());
                    return true;
                }
                case 3: {
                    Builder builder = UnknownFieldSet.newBuilder();
                    codedInputStream.readGroup(n3, builder, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    this.getFieldBuilder(n3).addGroup(builder.build());
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.getFieldBuilder(n3).addFixed32(codedInputStream.readFixed32());
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public Builder mergeFrom(ByteString byteString) {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(byte[] byArray) {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(InputStream inputStream) {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return this;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return false;
            }
            int n3 = CodedInputStream.readRawVarint32(n2, inputStream);
            AbstractMessageLite.Builder.LimitedInputStream limitedInputStream = new AbstractMessageLite.Builder.LimitedInputStream(inputStream, n3);
            this.mergeFrom(limitedInputStream);
            return true;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeDelimitedFrom(inputStream);
        }

        @Override
        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeFrom(codedInputStream);
        }

        @Override
        public Builder mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeFrom(byteString);
        }

        @Override
        public Builder mergeFrom(byte[] byArray, int n2, int n3) {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n2, n3);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeFrom(byArray);
        }

        @Override
        public Builder mergeFrom(byte[] byArray, int n2, int n3, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeFrom(byArray, n2, n3);
        }

        @Override
        public Builder mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
            return this.mergeFrom(inputStream);
        }

        @Override
        public Builder mergeFrom(MessageLite messageLite) {
            if (messageLite instanceof UnknownFieldSet) {
                return this.mergeFrom((UnknownFieldSet)messageLite);
            }
            throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
        }

        @Override
        public boolean isInitialized() {
            return true;
        }
    }
}

