/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;

final class TextFormatEscaper {
    private TextFormatEscaper() {
    }

    static String escapeBytes(ByteSequence byteSequence) {
        StringBuilder stringBuilder = new StringBuilder(byteSequence.size());
        block12: for (int i2 = 0; i2 < byteSequence.size(); ++i2) {
            byte by2 = byteSequence.byteAt(i2);
            switch (by2) {
                case 7: {
                    stringBuilder.append("\\a");
                    continue block12;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    continue block12;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block12;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (by2 >= 32 && by2 <= 126) {
                        stringBuilder.append((char)by2);
                        continue block12;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)(48 + (by2 >>> 6 & 3)));
                    stringBuilder.append((char)(48 + (by2 >>> 3 & 7)));
                    stringBuilder.append((char)(48 + (by2 & 7)));
                }
            }
        }
        return stringBuilder.toString();
    }

    static String escapeBytes(final ByteString byteString) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public int size() {
                return byteString.size();
            }

            @Override
            public byte byteAt(int n2) {
                return byteString.byteAt(n2);
            }
        });
    }

    static String escapeBytes(final byte[] byArray) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public int size() {
                return byArray.length;
            }

            @Override
            public byte byteAt(int n2) {
                return byArray[n2];
            }
        });
    }

    static String escapeText(String string) {
        return TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(string));
    }

    static String escapeDoubleQuotesAndBackslashes(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static interface ByteSequence {
        public int size();

        public byte byteAt(int var1);
    }
}

