/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    private MapEntryLite(WireFormat.FieldType fieldType, K k2, WireFormat.FieldType fieldType2, V v2) {
        this.metadata = new Metadata<K, V>(fieldType, k2, fieldType2, v2);
        this.key = k2;
        this.value = v2;
    }

    private MapEntryLite(Metadata<K, V> metadata, K k2, V v2) {
        this.metadata = metadata;
        this.key = k2;
        this.value = v2;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType fieldType, K k2, WireFormat.FieldType fieldType2, V v2) {
        return new MapEntryLite<K, V>(fieldType, k2, fieldType2, v2);
    }

    static <K, V> void writeTo(CodedOutputStream codedOutputStream, Metadata<K, V> metadata, K k2, V v2) {
        FieldSet.writeElement(codedOutputStream, metadata.keyType, 1, k2);
        FieldSet.writeElement(codedOutputStream, metadata.valueType, 2, v2);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K k2, V v2) {
        return FieldSet.computeElementSize(metadata.keyType, 1, k2) + FieldSet.computeElementSize(metadata.valueType, 2, v2);
    }

    static <T> T parseField(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite, WireFormat.FieldType fieldType, T t2) {
        switch (fieldType) {
            case MESSAGE: {
                MessageLite.Builder builder = ((MessageLite)t2).toBuilder();
                codedInputStream.readMessage(builder, extensionRegistryLite);
                return (T)builder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(codedInputStream.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(codedInputStream, fieldType, true);
    }

    public void serializeTo(CodedOutputStream codedOutputStream, int n2, K k2, V v2) {
        codedOutputStream.writeTag(n2, 2);
        codedOutputStream.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, k2, v2));
        MapEntryLite.writeTo(codedOutputStream, this.metadata, k2, v2);
    }

    public int computeMessageSize(int n2, K k2, V v2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, k2, v2));
    }

    public Map.Entry<K, V> parseEntry(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
        return MapEntryLite.parseEntry(byteString.newCodedInput(), this.metadata, extensionRegistryLite);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream codedInputStream, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistryLite) {
        int n2;
        Object k2 = metadata.defaultKey;
        Object v2 = metadata.defaultValue;
        while ((n2 = codedInputStream.readTag()) != 0) {
            if (n2 == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                k2 = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, metadata.keyType, k2);
                continue;
            }
            if (n2 == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                v2 = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, metadata.valueType, v2);
                continue;
            }
            if (codedInputStream.skipField(n2)) continue;
            break;
        }
        return new AbstractMap.SimpleImmutableEntry(k2, v2);
    }

    public void parseInto(MapFieldLite<K, V> mapFieldLite, CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
        int n2;
        int n3 = codedInputStream.readRawVarint32();
        int n4 = codedInputStream.pushLimit(n3);
        Object k2 = this.metadata.defaultKey;
        Object v2 = this.metadata.defaultValue;
        while ((n2 = codedInputStream.readTag()) != 0) {
            if (n2 == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                k2 = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, this.metadata.keyType, k2);
                continue;
            }
            if (n2 == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                v2 = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, this.metadata.valueType, v2);
                continue;
            }
            if (codedInputStream.skipField(n2)) continue;
            break;
        }
        codedInputStream.checkLastTagWas(0);
        codedInputStream.popLimit(n4);
        mapFieldLite.put(k2, v2);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType fieldType, K k2, WireFormat.FieldType fieldType2, V v2) {
            this.keyType = fieldType;
            this.defaultKey = k2;
            this.valueType = fieldType2;
            this.defaultValue = v2;
        }
    }
}

