/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList<Double>
implements Internal.DoubleList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final DoubleArrayList EMPTY_LIST = new DoubleArrayList(new double[0], 0);
    private double[] array;
    private int size;

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    DoubleArrayList() {
        this(new double[10], 0);
    }

    private DoubleArrayList(double[] dArray, int n2) {
        this.array = dArray;
        this.size = n2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.ensureIsMutable();
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n3, this.array, n2, this.size - n3);
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (this.size != doubleArrayList.size) {
            return false;
        }
        double[] dArray = doubleArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (Double.doubleToLongBits(this.array[i2]) == Double.doubleToLongBits(dArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            long l2 = Double.doubleToLongBits(this.array[i2]);
            n2 = 31 * n2 + Internal.hashLong(l2);
        }
        return n2;
    }

    @Override
    public Internal.DoubleList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        return new DoubleArrayList(Arrays.copyOf(this.array, n2), this.size);
    }

    @Override
    public Double get(int n2) {
        return this.getDouble(n2);
    }

    @Override
    public double getDouble(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Double set(int n2, Double d2) {
        return this.setDouble(n2, d2);
    }

    @Override
    public double setDouble(int n2, double d2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        double d3 = this.array[n2];
        this.array[n2] = d2;
        return d3;
    }

    @Override
    public boolean add(Double d2) {
        this.addDouble(d2);
        return true;
    }

    @Override
    public void add(int n2, Double d2) {
        this.addDouble(n2, d2);
    }

    @Override
    public void addDouble(double d2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            double[] dArray = new double[n2];
            System.arraycopy(this.array, 0, dArray, 0, this.size);
            this.array = dArray;
        }
        this.array[this.size++] = d2;
    }

    private void addDouble(int n2, double d2) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            double[] dArray = new double[n3];
            System.arraycopy(this.array, 0, dArray, 0, n2);
            System.arraycopy(this.array, n2, dArray, n2 + 1, this.size - n2);
            this.array = dArray;
        }
        this.array[n2] = d2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof DoubleArrayList)) {
            return super.addAll(collection);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)collection;
        if (doubleArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < doubleArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + doubleArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(doubleArrayList.array, 0, this.array, this.size, doubleArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!object.equals(this.array[i2])) continue;
            System.arraycopy(this.array, i2 + 1, this.array, i2, this.size - i2 - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Double remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        double d2 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return d2;
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

