/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStreamReader;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.IterableByteBufferInputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CodedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_RECURSION_LIMIT = 100;
    private static final int DEFAULT_SIZE_LIMIT = Integer.MAX_VALUE;
    int recursionDepth;
    int recursionLimit = 100;
    int sizeLimit = Integer.MAX_VALUE;
    CodedInputStreamReader wrapper;
    private boolean shouldDiscardUnknownFields = false;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return CodedInputStream.newInstance(inputStream, 4096);
    }

    public static CodedInputStream newInstance(InputStream inputStream, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        if (inputStream == null) {
            return CodedInputStream.newInstance(Internal.EMPTY_BYTE_ARRAY);
        }
        return new StreamDecoder(inputStream, n2);
    }

    public static CodedInputStream newInstance(Iterable<ByteBuffer> iterable) {
        if (!UnsafeDirectNioDecoder.isSupported()) {
            return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
        }
        return CodedInputStream.newInstance(iterable, false);
    }

    static CodedInputStream newInstance(Iterable<ByteBuffer> iterable, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        for (ByteBuffer byteBuffer : iterable) {
            n3 += byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                n2 |= 1;
                continue;
            }
            if (byteBuffer.isDirect()) {
                n2 |= 2;
                continue;
            }
            n2 |= 4;
        }
        if (n2 == 2) {
            return new IterableDirectByteBufferDecoder(iterable, n3, bl2);
        }
        return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n2, int n3) {
        return CodedInputStream.newInstance(byArray, n2, n3, false);
    }

    static CodedInputStream newInstance(byte[] byArray, int n2, int n3, boolean bl2) {
        ArrayDecoder arrayDecoder = new ArrayDecoder(byArray, n2, n3, bl2);
        try {
            arrayDecoder.pushLimit(n3);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return arrayDecoder;
    }

    public static CodedInputStream newInstance(ByteBuffer byteBuffer) {
        return CodedInputStream.newInstance(byteBuffer, false);
    }

    static CodedInputStream newInstance(ByteBuffer byteBuffer, boolean bl2) {
        if (byteBuffer.hasArray()) {
            return CodedInputStream.newInstance(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), bl2);
        }
        if (byteBuffer.isDirect() && UnsafeDirectNioDecoder.isSupported()) {
            return new UnsafeDirectNioDecoder(byteBuffer, bl2);
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(byArray);
        return CodedInputStream.newInstance(byArray, 0, byArray.length, true);
    }

    private CodedInputStream() {
    }

    public abstract int readTag();

    public abstract void checkLastTagWas(int var1);

    public abstract int getLastTag();

    public abstract boolean skipField(int var1);

    @Deprecated
    public abstract boolean skipField(int var1, CodedOutputStream var2);

    public abstract void skipMessage();

    public abstract void skipMessage(CodedOutputStream var1);

    public abstract double readDouble();

    public abstract float readFloat();

    public abstract long readUInt64();

    public abstract long readInt64();

    public abstract int readInt32();

    public abstract long readFixed64();

    public abstract int readFixed32();

    public abstract boolean readBool();

    public abstract String readString();

    public abstract String readStringRequireUtf8();

    public abstract void readGroup(int var1, MessageLite.Builder var2, ExtensionRegistryLite var3);

    public abstract <T extends MessageLite> T readGroup(int var1, Parser<T> var2, ExtensionRegistryLite var3);

    @Deprecated
    public abstract void readUnknownGroup(int var1, MessageLite.Builder var2);

    public abstract void readMessage(MessageLite.Builder var1, ExtensionRegistryLite var2);

    public abstract <T extends MessageLite> T readMessage(Parser<T> var1, ExtensionRegistryLite var2);

    public abstract ByteString readBytes();

    public abstract byte[] readByteArray();

    public abstract ByteBuffer readByteBuffer();

    public abstract int readUInt32();

    public abstract int readEnum();

    public abstract int readSFixed32();

    public abstract long readSFixed64();

    public abstract int readSInt32();

    public abstract long readSInt64();

    public abstract int readRawVarint32();

    public abstract long readRawVarint64();

    abstract long readRawVarint64SlowPath();

    public abstract int readRawLittleEndian32();

    public abstract long readRawLittleEndian64();

    public abstract void enableAliasing(boolean var1);

    public final int setRecursionLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + n2);
        }
        int n3 = this.recursionLimit;
        this.recursionLimit = n2;
        return n3;
    }

    public final int setSizeLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + n2);
        }
        int n3 = this.sizeLimit;
        this.sizeLimit = n2;
        return n3;
    }

    final void discardUnknownFields() {
        this.shouldDiscardUnknownFields = true;
    }

    final void unsetDiscardUnknownFields() {
        this.shouldDiscardUnknownFields = false;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public abstract void resetSizeCounter();

    public abstract int pushLimit(int var1);

    public abstract void popLimit(int var1);

    public abstract int getBytesUntilLimit();

    public abstract boolean isAtEnd();

    public abstract int getTotalBytesRead();

    public abstract byte readRawByte();

    public abstract byte[] readRawBytes(int var1);

    public abstract void skipRawBytes(int var1);

    public static int decodeZigZag32(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }

    public static int readRawVarint32(int n2, InputStream inputStream) {
        int n3;
        int n4;
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        int n5 = n2 & 0x7F;
        for (n4 = 7; n4 < 32; n4 += 7) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n5 |= (n3 & 0x7F) << n4;
            if ((n3 & 0x80) != 0) continue;
            return n5;
        }
        while (n4 < 64) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n3 & 0x80) == 0) {
                return n5;
            }
            n4 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    static int readRawVarint32(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n2, inputStream);
    }

    private static final class IterableDirectByteBufferDecoder
    extends CodedInputStream {
        private Iterable<ByteBuffer> input;
        private Iterator<ByteBuffer> iterator;
        private ByteBuffer currentByteBuffer;
        private boolean immutable;
        private boolean enableAliasing;
        private int totalBufferSize;
        private int bufferSizeAfterCurrentLimit;
        private int currentLimit = Integer.MAX_VALUE;
        private int lastTag;
        private int totalBytesRead;
        private int startOffset;
        private long currentByteBufferPos;
        private long currentByteBufferStartPos;
        private long currentAddress;
        private long currentByteBufferLimit;

        private IterableDirectByteBufferDecoder(Iterable<ByteBuffer> iterable, int n2, boolean bl2) {
            this.totalBufferSize = n2;
            this.input = iterable;
            this.iterator = this.input.iterator();
            this.immutable = bl2;
            this.totalBytesRead = 0;
            this.startOffset = 0;
            if (n2 == 0) {
                this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
                this.currentByteBufferPos = 0L;
                this.currentByteBufferStartPos = 0L;
                this.currentByteBufferLimit = 0L;
                this.currentAddress = 0L;
            } else {
                this.tryGetNextByteBuffer();
            }
        }

        private void getNextByteBuffer() {
            if (!this.iterator.hasNext()) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.tryGetNextByteBuffer();
        }

        private void tryGetNextByteBuffer() {
            this.currentByteBuffer = this.iterator.next();
            this.totalBytesRead += (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
            this.currentByteBufferStartPos = this.currentByteBufferPos = (long)this.currentByteBuffer.position();
            this.currentByteBufferLimit = this.currentByteBuffer.limit();
            this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
            this.currentByteBufferPos += this.currentAddress;
            this.currentByteBufferStartPos += this.currentAddress;
            this.currentByteBufferLimit += this.currentAddress;
        }

        @Override
        public int readTag() {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n2) {
            if (this.lastTag != n2) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n2) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n2, CodedOutputStream codedOutputStream) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    long l2 = this.readInt64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeRawVarint32(n2);
                    this.skipMessage(codedOutputStream);
                    int n3 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4);
                    this.checkLastTagWas(n3);
                    codedOutputStream.writeRawVarint32(n3);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n4 = this.readRawLittleEndian32();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed32NoTag(n4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                String string = new String(byArray, Internal.UTF_8);
                this.currentByteBufferPos += (long)n2;
                return string;
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                String string = new String(byArray, Internal.UTF_8);
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                int n3 = (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
                String string = Utf8.decodeUtf8(this.currentByteBuffer, n3, n2);
                this.currentByteBufferPos += (long)n2;
                return string;
            }
            if (n2 >= 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return Utf8.decodeUtf8(byArray, 0, n2);
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n2, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n2, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n2, MessageLite.Builder builder) {
            this.readGroup(n2, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                if (this.immutable && this.enableAliasing) {
                    int n3 = (int)(this.currentByteBufferPos - this.currentAddress);
                    ByteString byteString = ByteString.wrap(this.slice(n3, n3 + n2));
                    this.currentByteBufferPos += (long)n2;
                    return byteString;
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                this.currentByteBufferPos += (long)n2;
                return ByteString.wrap(byArray);
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return ByteString.wrap(byArray);
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public byte[] readByteArray() {
            return this.readRawBytes(this.readRawVarint32());
        }

        @Override
        public ByteBuffer readByteBuffer() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentRemaining()) {
                if (!this.immutable && this.enableAliasing) {
                    this.currentByteBufferPos += (long)n2;
                    return this.slice((int)(this.currentByteBufferPos - this.currentAddress - (long)n2), (int)(this.currentByteBufferPos - this.currentAddress));
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                this.currentByteBufferPos += (long)n2;
                return ByteBuffer.wrap(byArray);
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return ByteBuffer.wrap(byArray);
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() {
            return IterableDirectByteBufferDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() {
            return IterableDirectByteBufferDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() {
            block4: {
                int n2;
                long l2;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l2 = this.currentByteBufferPos;
                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                if ((n2 = UnsafeUtil.getByte(l2++)) >= 0) {
                                    ++this.currentByteBufferPos;
                                    return n2;
                                }
                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                if ((n2 ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = UnsafeUtil.getByte(l2++);
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0) break block4;
                }
                this.currentByteBufferPos = l2;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        @Override
        public long readRawVarint64() {
            block4: {
                long l2;
                long l3;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l3 = this.currentByteBufferPos;
                                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                                if ((n2 = UnsafeUtil.getByte(l3++)) >= 0) {
                                                    ++this.currentByteBufferPos;
                                                    return n2;
                                                }
                                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                                if ((n2 ^= UnsafeUtil.getByte(l3++) << 7) >= 0) break block5;
                                                l2 = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= UnsafeUtil.getByte(l3++) << 14) < 0) break block7;
                                            l2 = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= UnsafeUtil.getByte(l3++) << 21) >= 0) break block8;
                                        l2 = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n2 ^ (long)UnsafeUtil.getByte(l3++) << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)UnsafeUtil.getByte(l3++) << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l3++) < 0L) break block4;
                }
                this.currentByteBufferPos = l3;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() {
            if (this.currentRemaining() >= 4L) {
                long l2 = this.currentByteBufferPos;
                this.currentByteBufferPos += 4L;
                return UnsafeUtil.getByte(l2) & 0xFF | (UnsafeUtil.getByte(l2 + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l2 + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l2 + 3L) & 0xFF) << 24;
            }
            return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() {
            if (this.currentRemaining() >= 8L) {
                long l2 = this.currentByteBufferPos;
                this.currentByteBufferPos += 8L;
                return (long)UnsafeUtil.getByte(l2) & 0xFFL | ((long)UnsafeUtil.getByte(l2 + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l2 + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l2 + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l2 + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l2 + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l2 + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l2 + 7L) & 0xFFL) << 56;
            }
            return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl2) {
            this.enableAliasing = bl2;
        }

        @Override
        public void resetSizeCounter() {
            this.startOffset = (int)((long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public int pushLimit(int n2) {
            int n3;
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n2 += this.getTotalBytesRead()) > (n3 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
            return n3;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.totalBufferSize += this.bufferSizeAfterCurrentLimit;
            int n2 = this.totalBufferSize - this.startOffset;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterCurrentLimit = n2 - this.currentLimit;
                this.totalBufferSize -= this.bufferSizeAfterCurrentLimit;
            } else {
                this.bufferSizeAfterCurrentLimit = 0;
            }
        }

        @Override
        public void popLimit(int n2) {
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() {
            return (long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos == (long)this.totalBufferSize;
        }

        @Override
        public int getTotalBytesRead() {
            return (int)((long)(this.totalBytesRead - this.startOffset) + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public byte readRawByte() {
            if (this.currentRemaining() == 0L) {
                this.getNextByteBuffer();
            }
            return UnsafeUtil.getByte(this.currentByteBufferPos++);
        }

        @Override
        public byte[] readRawBytes(int n2) {
            if (n2 >= 0 && (long)n2 <= this.currentRemaining()) {
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                this.currentByteBufferPos += (long)n2;
                return byArray;
            }
            if (n2 >= 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return byArray;
            }
            if (n2 <= 0) {
                if (n2 == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void readRawBytesTo(byte[] byArray, int n2, int n3) {
            if (n3 >= 0 && n3 <= this.remaining()) {
                int n4 = n3;
                while (n4 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n5 = Math.min(n4, (int)this.currentRemaining());
                    UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, (long)(n3 - n4 + n2), (long)n5);
                    n4 -= n5;
                    this.currentByteBufferPos += (long)n5;
                }
                return;
            }
            if (n3 <= 0) {
                if (n3 == 0) {
                    return;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n2) {
            if (n2 >= 0 && (long)n2 <= (long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos) {
                int n3 = n2;
                while (n3 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n4 = Math.min(n3, (int)this.currentRemaining());
                    n3 -= n4;
                    this.currentByteBufferPos += (long)n4;
                }
                return;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void skipRawVarint() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private int remaining() {
            return (int)((long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos);
        }

        private long currentRemaining() {
            return this.currentByteBufferLimit - this.currentByteBufferPos;
        }

        private ByteBuffer slice(int n2, int n3) {
            int n4 = this.currentByteBuffer.position();
            int n5 = this.currentByteBuffer.limit();
            try {
                this.currentByteBuffer.position(n2);
                this.currentByteBuffer.limit(n3);
                ByteBuffer byteBuffer = this.currentByteBuffer.slice();
                return byteBuffer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            finally {
                this.currentByteBuffer.position(n4);
                this.currentByteBuffer.limit(n5);
            }
        }
    }

    private static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        private StreamDecoder(InputStream inputStream, int n2) {
            Internal.checkNotNull(inputStream, "input");
            this.input = inputStream;
            this.buffer = new byte[n2];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        @Override
        public int readTag() {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n2) {
            if (this.lastTag != n2) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n2) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n2, CodedOutputStream codedOutputStream) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    long l2 = this.readInt64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeRawVarint32(n2);
                    this.skipMessage(codedOutputStream);
                    int n3 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4);
                    this.checkLastTagWas(n3);
                    codedOutputStream.writeRawVarint32(n3);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n4 = this.readRawLittleEndian32();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed32NoTag(n4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.bufferSize - this.pos) {
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= this.bufferSize) {
                this.refillBuffer(n2);
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            return new String(this.readRawBytesSlowPath(n2, false), Internal.UTF_8);
        }

        @Override
        public String readStringRequireUtf8() {
            int n2;
            byte[] byArray;
            int n3;
            int n4 = this.readRawVarint32();
            if (n4 <= this.bufferSize - (n3 = this.pos) && n4 > 0) {
                byArray = this.buffer;
                this.pos = n3 + n4;
                n2 = n3;
            } else {
                if (n4 == 0) {
                    return "";
                }
                if (n4 <= this.bufferSize) {
                    this.refillBuffer(n4);
                    byArray = this.buffer;
                    n2 = 0;
                    this.pos = n2 + n4;
                } else {
                    byArray = this.readRawBytesSlowPath(n4, false);
                    n2 = 0;
                }
            }
            return Utf8.decodeUtf8(byArray, n2, n4);
        }

        @Override
        public void readGroup(int n2, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n2, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n2, MessageLite.Builder builder) {
            this.readGroup(n2, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                ByteString byteString = ByteString.copyFrom(this.buffer, this.pos, n2);
                this.pos += n2;
                return byteString;
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            return this.readBytesSlowPath(n2);
        }

        @Override
        public byte[] readByteArray() {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                byte[] byArray = Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2);
                this.pos += n2;
                return byArray;
            }
            return this.readRawBytesSlowPath(n2, false);
        }

        @Override
        public ByteBuffer readByteBuffer() {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2));
                this.pos += n2;
                return byteBuffer;
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            return ByteBuffer.wrap(this.readRawBytesSlowPath(n2, true));
        }

        @Override
        public int readUInt32() {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() {
            return StreamDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() {
            block4: {
                int n2;
                int n3;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n3 = this.pos;
                                if (this.bufferSize == n3) break block4;
                                byArray = this.buffer;
                                if ((n2 = byArray[n3++]) >= 0) {
                                    this.pos = n3;
                                    return n2;
                                }
                                if (this.bufferSize - n3 < 9) break block4;
                                if ((n2 ^= byArray[n3++] << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= byArray[n3++] << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= byArray[n3++] << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = byArray[n3++];
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0) break block4;
                }
                this.pos = n3;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() {
            if (this.bufferSize - this.pos >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() {
            block4: {
                long l2;
                int n2;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n3;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n2 = this.pos;
                                                if (this.bufferSize == n2) break block4;
                                                byArray = this.buffer;
                                                if ((n3 = byArray[n2++]) >= 0) {
                                                    this.pos = n2;
                                                    return n3;
                                                }
                                                if (this.bufferSize - n2 < 9) break block4;
                                                if ((n3 ^= byArray[n2++] << 7) >= 0) break block5;
                                                l2 = n3 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n3 ^= byArray[n2++] << 14) < 0) break block7;
                                            l2 = n3 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n3 ^= byArray[n2++] << 21) >= 0) break block8;
                                        l2 = n3 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n3 ^ (long)byArray[n2++] << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)byArray[n2++] << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)byArray[n2++] << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)byArray[n2++] << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)byArray[n2++] << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) break block4;
                }
                this.pos = n2;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() {
            int n2 = this.pos;
            if (this.bufferSize - n2 < 4) {
                this.refillBuffer(4);
                n2 = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() {
            int n2 = this.pos;
            if (this.bufferSize - n2 < 8) {
                this.refillBuffer(8);
                n2 = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl2) {
        }

        @Override
        public void resetSizeCounter() {
            this.totalBytesRetired = -this.pos;
        }

        @Override
        public int pushLimit(int n2) {
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n3 = this.currentLimit;
            if ((n2 += this.totalBytesRetired + this.pos) > n3) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
            return n3;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int n2 = this.totalBytesRetired + this.bufferSize;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        @Override
        public void popLimit(int n2) {
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            int n2 = this.totalBytesRetired + this.pos;
            return this.currentLimit - n2;
        }

        @Override
        public boolean isAtEnd() {
            return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
        }

        @Override
        public int getTotalBytesRead() {
            return this.totalBytesRetired + this.pos;
        }

        private void refillBuffer(int n2) {
            if (!this.tryRefillBuffer(n2)) {
                if (n2 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private boolean tryRefillBuffer(int n2) {
            int n3;
            int n4;
            if (this.pos + n2 <= this.bufferSize) {
                throw new IllegalStateException("refillBuffer() called when " + n2 + " bytes were already available in buffer");
            }
            if (n2 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                return false;
            }
            if (this.totalBytesRetired + this.pos + n2 > this.currentLimit) {
                return false;
            }
            if (this.refillCallback != null) {
                this.refillCallback.onRefill();
            }
            if ((n4 = this.pos) > 0) {
                if (this.bufferSize > n4) {
                    System.arraycopy(this.buffer, n4, this.buffer, 0, this.bufferSize - n4);
                }
                this.totalBytesRetired += n4;
                this.bufferSize -= n4;
                this.pos = 0;
            }
            if ((n3 = this.input.read(this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || n3 < -1 || n3 > this.buffer.length) {
                throw new IllegalStateException(this.input.getClass() + "#read(byte[]) returned invalid result: " + n3 + "\nThe InputStream implementation is buggy.");
            }
            if (n3 > 0) {
                this.bufferSize += n3;
                this.recomputeBufferSizeAfterLimit();
                return this.bufferSize >= n2 ? true : this.tryRefillBuffer(n2);
            }
            return false;
        }

        @Override
        public byte readRawByte() {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            return this.buffer[this.pos++];
        }

        @Override
        public byte[] readRawBytes(int n2) {
            int n3 = this.pos;
            if (n2 <= this.bufferSize - n3 && n2 > 0) {
                this.pos = n3 + n2;
                return Arrays.copyOfRange(this.buffer, n3, n3 + n2);
            }
            return this.readRawBytesSlowPath(n2, false);
        }

        private byte[] readRawBytesSlowPath(int n2, boolean bl2) {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(n2);
            if (byArray != null) {
                return bl2 ? (byte[])byArray.clone() : byArray;
            }
            int n3 = this.pos;
            int n4 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n5 = n2 - n4;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n5);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, n3, byArray2, 0, n4);
            int n6 = n4;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
                n6 += byArray3.length;
            }
            return byArray2;
        }

        private byte[] readRawBytesSlowPathOneChunk(int n2) {
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n3 = this.totalBytesRetired + this.pos + n2;
            if (n3 - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (n3 > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n4 = this.bufferSize - this.pos;
            int n5 = n2 - n4;
            if (n5 < 4096 || n5 <= this.input.available()) {
                int n6;
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, this.pos, byArray, 0, n4);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                for (int i2 = n4; i2 < byArray.length; i2 += n6) {
                    n6 = this.input.read(byArray, i2, n2 - i2);
                    if (n6 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n6;
                }
                return byArray;
            }
            return null;
        }

        private List<byte[]> readRawBytesSlowPathRemainingChunks(int n2) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            while (n2 > 0) {
                int n3;
                byte[] byArray = new byte[Math.min(n2, 4096)];
                for (int i2 = 0; i2 < byArray.length; i2 += n3) {
                    n3 = this.input.read(byArray, i2, byArray.length - i2);
                    if (n3 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n3;
                }
                n2 -= byArray.length;
                arrayList.add(byArray);
            }
            return arrayList;
        }

        private ByteString readBytesSlowPath(int n2) {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(n2);
            if (byArray != null) {
                return ByteString.copyFrom(byArray);
            }
            int n3 = this.pos;
            int n4 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n5 = n2 - n4;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n5);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, n3, byArray2, 0, n4);
            int n6 = n4;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
                n6 += byArray3.length;
            }
            return ByteString.wrap(byArray2);
        }

        @Override
        public void skipRawBytes(int n2) {
            if (n2 <= this.bufferSize - this.pos && n2 >= 0) {
                this.pos += n2;
            } else {
                this.skipRawBytesSlowPath(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skipRawBytesSlowPath(int n2) {
            int n3;
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + n2 > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n4 = 0;
            if (this.refillCallback == null) {
                this.totalBytesRetired += this.pos;
                this.bufferSize = 0;
                this.pos = 0;
                try {
                    long l2;
                    for (n4 = this.bufferSize - this.pos; n4 < n2; n4 += (int)l2) {
                        n3 = n2 - n4;
                        l2 = this.input.skip(n3);
                        if (l2 < 0L || l2 > (long)n3) {
                            throw new IllegalStateException(this.input.getClass() + "#skip returned invalid result: " + l2 + "\nThe InputStream implementation is buggy.");
                        }
                        if (l2 != 0L) continue;
                        break;
                    }
                }
                finally {
                    this.totalBytesRetired += n4;
                    this.recomputeBufferSizeAfterLimit();
                }
            }
            if (n4 < n2) {
                n3 = this.bufferSize - this.pos;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
                while (n2 - n3 > this.bufferSize) {
                    n3 += this.bufferSize;
                    this.pos = this.bufferSize;
                    this.refillBuffer(1);
                }
                this.pos = n2 - n3;
            }
        }

        private static interface RefillCallback {
            public void onRefill();
        }

        private class SkippedDataSink
        implements RefillCallback {
            private int lastPos;
            private ByteArrayOutputStream byteArrayStream;

            private SkippedDataSink() {
                this.lastPos = StreamDecoder.this.pos;
            }

            @Override
            public void onRefill() {
                if (this.byteArrayStream == null) {
                    this.byteArrayStream = new ByteArrayOutputStream();
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                this.lastPos = 0;
            }

            ByteBuffer getSkippedData() {
                if (this.byteArrayStream == null) {
                    return ByteBuffer.wrap(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos);
                return ByteBuffer.wrap(this.byteArrayStream.toByteArray());
            }
        }
    }

    private static final class UnsafeDirectNioDecoder
    extends CodedInputStream {
        private final ByteBuffer buffer;
        private final boolean immutable;
        private final long address;
        private long limit;
        private long pos;
        private long startPos;
        private int bufferSizeAfterLimit;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private UnsafeDirectNioDecoder(ByteBuffer byteBuffer, boolean bl2) {
            this.buffer = byteBuffer;
            this.address = UnsafeUtil.addressOffset(byteBuffer);
            this.limit = this.address + (long)byteBuffer.limit();
            this.startPos = this.pos = this.address + (long)byteBuffer.position();
            this.immutable = bl2;
        }

        @Override
        public int readTag() {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n2) {
            if (this.lastTag != n2) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n2) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n2, CodedOutputStream codedOutputStream) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    long l2 = this.readInt64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeRawVarint32(n2);
                    this.skipMessage(codedOutputStream);
                    int n3 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4);
                    this.checkLastTagWas(n3);
                    codedOutputStream.writeRawVarint32(n3);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n4 = this.readRawLittleEndian32();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed32NoTag(n4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                String string = new String(byArray, Internal.UTF_8);
                this.pos += (long)n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                int n3 = this.bufferPos(this.pos);
                String string = Utf8.decodeUtf8(this.buffer, n3, n2);
                this.pos += (long)n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n2, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n2, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n2, MessageLite.Builder builder) {
            this.readGroup(n2, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                if (this.immutable && this.enableAliasing) {
                    ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n2);
                    this.pos += (long)n2;
                    return ByteString.wrap(byteBuffer);
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                this.pos += (long)n2;
                return ByteString.wrap(byArray);
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public byte[] readByteArray() {
            return this.readRawBytes(this.readRawVarint32());
        }

        @Override
        public ByteBuffer readByteBuffer() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                if (!this.immutable && this.enableAliasing) {
                    ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n2);
                    this.pos += (long)n2;
                    return byteBuffer;
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                this.pos += (long)n2;
                return ByteBuffer.wrap(byArray);
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() {
            return UnsafeDirectNioDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() {
            return UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() {
            block4: {
                int n2;
                long l2;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l2 = this.pos;
                                if (this.limit == l2) break block4;
                                if ((n2 = UnsafeUtil.getByte(l2++)) >= 0) {
                                    this.pos = l2;
                                    return n2;
                                }
                                if (this.limit - l2 < 9L) break block4;
                                if ((n2 ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = UnsafeUtil.getByte(l2++);
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0) break block4;
                }
                this.pos = l2;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() {
            if (this.remaining() >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (UnsafeUtil.getByte(this.pos++) < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() {
            block4: {
                long l2;
                long l3;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l3 = this.pos;
                                                if (this.limit == l3) break block4;
                                                if ((n2 = UnsafeUtil.getByte(l3++)) >= 0) {
                                                    this.pos = l3;
                                                    return n2;
                                                }
                                                if (this.limit - l3 < 9L) break block4;
                                                if ((n2 ^= UnsafeUtil.getByte(l3++) << 7) >= 0) break block5;
                                                l2 = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= UnsafeUtil.getByte(l3++) << 14) < 0) break block7;
                                            l2 = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= UnsafeUtil.getByte(l3++) << 21) >= 0) break block8;
                                        l2 = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n2 ^ (long)UnsafeUtil.getByte(l3++) << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)UnsafeUtil.getByte(l3++) << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l3++) < 0L) break block4;
                }
                this.pos = l3;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() {
            long l2 = this.pos;
            if (this.limit - l2 < 4L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l2 + 4L;
            return UnsafeUtil.getByte(l2) & 0xFF | (UnsafeUtil.getByte(l2 + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l2 + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l2 + 3L) & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() {
            long l2 = this.pos;
            if (this.limit - l2 < 8L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l2 + 8L;
            return (long)UnsafeUtil.getByte(l2) & 0xFFL | ((long)UnsafeUtil.getByte(l2 + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l2 + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l2 + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l2 + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l2 + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l2 + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l2 + 7L) & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl2) {
            this.enableAliasing = bl2;
        }

        @Override
        public void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public int pushLimit(int n2) {
            int n3;
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n2 += this.getTotalBytesRead()) > (n3 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
            return n3;
        }

        @Override
        public void popLimit(int n2) {
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return (int)(this.pos - this.startPos);
        }

        @Override
        public byte readRawByte() {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return UnsafeUtil.getByte(this.pos++);
        }

        @Override
        public byte[] readRawBytes(int n2) {
            if (n2 >= 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.slice(this.pos, this.pos + (long)n2).get(byArray);
                this.pos += (long)n2;
                return byArray;
            }
            if (n2 <= 0) {
                if (n2 == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n2) {
            if (n2 >= 0 && n2 <= this.remaining()) {
                this.pos += (long)n2;
                return;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += (long)this.bufferSizeAfterLimit;
            int n2 = (int)(this.limit - this.startPos);
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.limit -= (long)this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        private int remaining() {
            return (int)(this.limit - this.pos);
        }

        private int bufferPos(long l2) {
            return (int)(l2 - this.address);
        }

        private ByteBuffer slice(long l2, long l3) {
            int n2 = this.buffer.position();
            int n3 = this.buffer.limit();
            try {
                this.buffer.position(this.bufferPos(l2));
                this.buffer.limit(this.bufferPos(l3));
                ByteBuffer byteBuffer = this.buffer.slice();
                return byteBuffer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            finally {
                this.buffer.position(n2);
                this.buffer.limit(n3);
            }
        }
    }

    private static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        private ArrayDecoder(byte[] byArray, int n2, int n3, boolean bl2) {
            this.buffer = byArray;
            this.limit = n2 + n3;
            this.startPos = this.pos = n2;
            this.immutable = bl2;
        }

        @Override
        public int readTag() {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n2) {
            if (this.lastTag != n2) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n2) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n2, CodedOutputStream codedOutputStream) {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    long l2 = this.readInt64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeRawVarint32(n2);
                    this.skipMessage(codedOutputStream);
                    int n3 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4);
                    this.checkLastTagWas(n3);
                    codedOutputStream.writeRawVarint32(n3);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n4 = this.readRawLittleEndian32();
                    codedOutputStream.writeRawVarint32(n2);
                    codedOutputStream.writeFixed32NoTag(n4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                String string = Utf8.decodeUtf8(this.buffer, this.pos, n2);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n2, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n2, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n2, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n2, MessageLite.Builder builder) {
            this.readGroup(n2, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                ByteString byteString = this.immutable && this.enableAliasing ? ByteString.wrap(this.buffer, this.pos, n2) : ByteString.copyFrom(this.buffer, this.pos, n2);
                this.pos += n2;
                return byteString;
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            return ByteString.wrap(this.readRawBytes(n2));
        }

        @Override
        public byte[] readByteArray() {
            int n2 = this.readRawVarint32();
            return this.readRawBytes(n2);
        }

        @Override
        public ByteBuffer readByteBuffer() {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                ByteBuffer byteBuffer = !this.immutable && this.enableAliasing ? ByteBuffer.wrap(this.buffer, this.pos, n2).slice() : ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2));
                this.pos += n2;
                return byteBuffer;
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() {
            return ArrayDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() {
            block4: {
                int n2;
                int n3;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n3 = this.pos;
                                if (this.limit == n3) break block4;
                                byArray = this.buffer;
                                if ((n2 = byArray[n3++]) >= 0) {
                                    this.pos = n3;
                                    return n2;
                                }
                                if (this.limit - n3 < 9) break block4;
                                if ((n2 ^= byArray[n3++] << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= byArray[n3++] << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= byArray[n3++] << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = byArray[n3++];
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0) break block4;
                }
                this.pos = n3;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() {
            if (this.limit - this.pos >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() {
            block4: {
                long l2;
                int n2;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n3;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n2 = this.pos;
                                                if (this.limit == n2) break block4;
                                                byArray = this.buffer;
                                                if ((n3 = byArray[n2++]) >= 0) {
                                                    this.pos = n2;
                                                    return n3;
                                                }
                                                if (this.limit - n2 < 9) break block4;
                                                if ((n3 ^= byArray[n2++] << 7) >= 0) break block5;
                                                l2 = n3 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n3 ^= byArray[n2++] << 14) < 0) break block7;
                                            l2 = n3 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n3 ^= byArray[n2++] << 21) >= 0) break block8;
                                        l2 = n3 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n3 ^ (long)byArray[n2++] << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)byArray[n2++] << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)byArray[n2++] << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)byArray[n2++] << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)byArray[n2++] << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) break block4;
                }
                this.pos = n2;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() {
            int n2 = this.pos;
            if (this.limit - n2 < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() {
            int n2 = this.pos;
            if (this.limit - n2 < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl2) {
            this.enableAliasing = bl2;
        }

        @Override
        public void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public int pushLimit(int n2) {
            int n3;
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n2 += this.getTotalBytesRead()) > (n3 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
            return n3;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int n2 = this.limit - this.startPos;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        @Override
        public void popLimit(int n2) {
            this.currentLimit = n2;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        @Override
        public byte readRawByte() {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        @Override
        public byte[] readRawBytes(int n2) {
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                int n3 = this.pos;
                this.pos += n2;
                return Arrays.copyOfRange(this.buffer, n3, this.pos);
            }
            if (n2 <= 0) {
                if (n2 == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n2) {
            if (n2 >= 0 && n2 <= this.limit - this.pos) {
                this.pos += n2;
                return;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }
}

