/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable = true;

    AbstractProtobufList() {
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        if (!(object instanceof RandomAccess)) {
            return super.equals(object);
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.get(i2).equals(list.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = this.size();
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = 31 * n3 + this.get(i2).hashCode();
        }
        return n3;
    }

    @Override
    public boolean add(E e2) {
        this.ensureIsMutable();
        return super.add(e2);
    }

    @Override
    public void add(int n2, E e2) {
        this.ensureIsMutable();
        super.add(n2, e2);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.ensureIsMutable();
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.ensureIsMutable();
        return super.addAll(n2, collection);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        this.isMutable = false;
    }

    @Override
    public E remove(int n2) {
        this.ensureIsMutable();
        return super.remove(n2);
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        return super.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.ensureIsMutable();
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.ensureIsMutable();
        return super.retainAll(collection);
    }

    @Override
    public E set(int n2, E e2) {
        this.ensureIsMutable();
        return super.set(n2, e2);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

