/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageReflection;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    protected int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        return MessageReflection.isInitialized(this);
    }

    protected Message.Builder newBuilderForType(BuilderParent builderParent) {
        throw new UnsupportedOperationException("Nested builder is not supported for this type.");
    }

    @Override
    public List<String> findInitializationErrors() {
        return MessageReflection.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return MessageReflection.delimitWithCommas(this.findInitializationErrors());
    }

    @Override
    public boolean hasOneof(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException("hasOneof() is not implemented.");
    }

    @Override
    public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
    }

    @Override
    public final String toString() {
        return TextFormat.printer().printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) {
        MessageReflection.writeMessageTo(this, this.getAllFields(), codedOutputStream, false);
    }

    @Override
    int getMemoizedSerializedSize() {
        return this.memoizedSize;
    }

    @Override
    void setMemoizedSerializedSize(int n2) {
        this.memoizedSize = n2;
    }

    @Override
    public int getSerializedSize() {
        int n2 = this.memoizedSize;
        if (n2 != -1) {
            return n2;
        }
        this.memoizedSize = MessageReflection.getSerializedSize(this, this.getAllFields());
        return this.memoizedSize;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        if (this.getDescriptorForType() != message.getDescriptorForType()) {
            return false;
        }
        return AbstractMessage.compareFields(this.getAllFields(), message.getAllFields()) && this.getUnknownFields().equals(message.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int n2 = this.memoizedHashCode;
        if (n2 == 0) {
            n2 = 41;
            n2 = 19 * n2 + this.getDescriptorForType().hashCode();
            n2 = AbstractMessage.hashFields(n2, this.getAllFields());
            this.memoizedHashCode = n2 = 29 * n2 + this.getUnknownFields().hashCode();
        }
        return n2;
    }

    private static ByteString toByteString(Object object) {
        if (object instanceof byte[]) {
            return ByteString.copyFrom((byte[])object);
        }
        return (ByteString)object;
    }

    private static boolean compareBytes(Object object, Object object2) {
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        return AbstractMessage.toByteString(object).equals(AbstractMessage.toByteString(object2));
    }

    private static Map convertMapEntryListToMap(List list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator = list.iterator();
        Message message = (Message)iterator.next();
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("key");
        Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("value");
        Object object = message.getField(fieldDescriptor2);
        if (object instanceof Descriptors.EnumValueDescriptor) {
            object = ((Descriptors.EnumValueDescriptor)object).getNumber();
        }
        hashMap.put(message.getField(fieldDescriptor), object);
        while (iterator.hasNext()) {
            message = (Message)iterator.next();
            object = message.getField(fieldDescriptor2);
            if (object instanceof Descriptors.EnumValueDescriptor) {
                object = ((Descriptors.EnumValueDescriptor)object).getNumber();
            }
            hashMap.put(message.getField(fieldDescriptor), object);
        }
        return hashMap;
    }

    private static boolean compareMapField(Object object, Object object2) {
        Map map = AbstractMessage.convertMapEntryListToMap((List)object);
        Map map2 = AbstractMessage.convertMapEntryListToMap((List)object2);
        return MapFieldLite.equals(map, map2);
    }

    static boolean compareFields(Map<Descriptors.FieldDescriptor, Object> map, Map<Descriptors.FieldDescriptor, Object> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : map.keySet()) {
            if (!map2.containsKey(fieldDescriptor)) {
                return false;
            }
            Object object = map.get(fieldDescriptor);
            Object object2 = map2.get(fieldDescriptor);
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                if (fieldDescriptor.isRepeated()) {
                    List list = (List)object;
                    List list2 = (List)object2;
                    if (list.size() != list2.size()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        if (AbstractMessage.compareBytes(list.get(i2), list2.get(i2))) continue;
                        return false;
                    }
                    continue;
                }
                if (AbstractMessage.compareBytes(object, object2)) continue;
                return false;
            }
            if (!(fieldDescriptor.isMapField() ? !AbstractMessage.compareMapField(object, object2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static int hashMapField(Object object) {
        return MapFieldLite.calculateHashCodeForMap(AbstractMessage.convertMapEntryListToMap((List)object));
    }

    protected static int hashFields(int n2, Map<Descriptors.FieldDescriptor, Object> map) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            n2 = 37 * n2 + fieldDescriptor.getNumber();
            if (fieldDescriptor.isMapField()) {
                n2 = 53 * n2 + AbstractMessage.hashMapField(object);
                continue;
            }
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                n2 = 53 * n2 + object.hashCode();
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                List list = (List)object;
                n2 = 53 * n2 + Internal.hashEnumList(list);
                continue;
            }
            n2 = 53 * n2 + Internal.hashEnum((Internal.EnumLite)object);
        }
        return n2;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    @Deprecated
    protected static int hashLong(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    @Deprecated
    protected static int hashBoolean(boolean bl2) {
        return bl2 ? 1231 : 1237;
    }

    @Deprecated
    protected static int hashEnum(Internal.EnumLite enumLite) {
        return enumLite.getNumber();
    }

    @Deprecated
    protected static int hashEnumList(List<? extends Internal.EnumLite> list) {
        int n2 = 1;
        for (Internal.EnumLite enumLite : list) {
            n2 = 31 * n2 + AbstractMessage.hashEnum(enumLite);
        }
        return n2;
    }

    public static abstract class Builder<BuilderType extends Builder<BuilderType>>
    extends AbstractMessageLite.Builder
    implements Message.Builder {
        @Override
        public BuilderType clone() {
            throw new UnsupportedOperationException("clone() should be implemented in subclasses.");
        }

        @Override
        public boolean hasOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("hasOneof() is not implemented.");
        }

        @Override
        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
        }

        public BuilderType clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("clearOneof() is not implemented.");
        }

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return MessageReflection.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return MessageReflection.delimitWithCommas(this.findInitializationErrors());
        }

        protected BuilderType internalMergeFrom(AbstractMessageLite abstractMessageLite) {
            return (BuilderType)this.mergeFrom((Message)((Object)abstractMessageLite));
        }

        public BuilderType mergeFrom(Message message) {
            return this.mergeFrom(message, message.getAllFields());
        }

        BuilderType mergeFrom(Message message, Map<Descriptors.FieldDescriptor, Object> map) {
            if (message.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
                if (fieldDescriptor.isRepeated()) {
                    for (Object e2 : (List)entry.getValue()) {
                        this.addRepeatedField(fieldDescriptor, e2);
                    }
                    continue;
                }
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message message2 = (Message)this.getField(fieldDescriptor);
                    if (message2 == message2.getDefaultInstanceForType()) {
                        this.setField(fieldDescriptor, entry.getValue());
                        continue;
                    }
                    this.setField(fieldDescriptor, message2.newBuilderForType().mergeFrom(message2).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(fieldDescriptor, entry.getValue());
            }
            this.mergeUnknownFields(message.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream) {
            return (BuilderType)this.mergeFrom(codedInputStream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
            int n2;
            UnknownFieldSet.Builder builder;
            boolean bl2 = codedInputStream.shouldDiscardUnknownFields();
            UnknownFieldSet.Builder builder2 = builder = bl2 ? null : UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((n2 = codedInputStream.readTag()) != 0) {
                MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(this);
                if (MessageReflection.mergeFieldFrom(codedInputStream, builder, extensionRegistryLite, this.getDescriptorForType(), builderAdapter, n2)) continue;
                break;
            }
            if (builder != null) {
                this.setUnknownFields(builder.build());
            }
            return (BuilderType)this;
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFieldSet).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor fieldDescriptor) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        @Override
        public Message.Builder getRepeatedFieldBuilder(Descriptors.FieldDescriptor fieldDescriptor, int n2) {
            throw new UnsupportedOperationException("getRepeatedFieldBuilder() called on an unsupported message type.");
        }

        public String toString() {
            return TextFormat.printer().printToString(this);
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(MessageReflection.findMissingFields(message));
        }

        void markClean() {
            throw new IllegalStateException("Should be overridden by subclasses.");
        }

        void dispose() {
            throw new IllegalStateException("Should be overridden by subclasses.");
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString) {
            return (BuilderType)((Builder)super.mergeFrom(byteString));
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
            return (BuilderType)((Builder)super.mergeFrom(byteString, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray) {
            return (BuilderType)((Builder)super.mergeFrom(byArray));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n2, int n3) {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n2, n3));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) {
            return (BuilderType)((Builder)super.mergeFrom(byArray, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n2, int n3, ExtensionRegistryLite extensionRegistryLite) {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n2, n3, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream) {
            return (BuilderType)((Builder)super.mergeFrom(inputStream));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
            return (BuilderType)((Builder)super.mergeFrom(inputStream, extensionRegistryLite));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) {
            return super.mergeDelimitedFrom(inputStream);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
            return super.mergeDelimitedFrom(inputStream, extensionRegistryLite);
        }
    }

    protected static interface BuilderParent {
        public void markDirty();
    }
}

