/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Internal;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

@GwtCompatible(emulated=true)
public final class Uninterruptibles {
    @GwtIncompatible
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        boolean bl2 = false;
        while (true) {
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    @Beta
    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, Duration duration) {
        return Uninterruptibles.awaitUninterruptibly(countDownLatch, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l2, TimeUnit timeUnit) {
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                try {
                    boolean bl3 = countDownLatch.await(l3, TimeUnit.NANOSECONDS);
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    @Beta
    public static boolean awaitUninterruptibly(Condition condition, Duration duration) {
        return Uninterruptibles.awaitUninterruptibly(condition, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @GwtIncompatible
    public static boolean awaitUninterruptibly(Condition condition, long l2, TimeUnit timeUnit) {
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                try {
                    boolean bl3 = condition.await(l3, TimeUnit.NANOSECONDS);
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    public static void joinUninterruptibly(Thread thread) {
        boolean bl2 = false;
        while (true) {
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    @Beta
    public static void joinUninterruptibly(Thread thread, Duration duration) {
        Uninterruptibles.joinUninterruptibly(thread, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @GwtIncompatible
    public static void joinUninterruptibly(Thread thread, long l2, TimeUnit timeUnit) {
        Preconditions.checkNotNull(thread);
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.timedJoin(thread, l3);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @CanIgnoreReturnValue
    public static <V> V getUninterruptibly(Future<V> future) {
        boolean bl2 = false;
        while (true) {
            try {
                V v2 = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    @Beta
    public static <V> V getUninterruptibly(Future<V> future, Duration duration) {
        return Uninterruptibles.getUninterruptibly(future, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    public static <V> V getUninterruptibly(Future<V> future, long l2, TimeUnit timeUnit) {
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                V v2;
                try {
                    v2 = future.get(l3, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                return v2;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    public static <E> E takeUninterruptibly(BlockingQueue<E> blockingQueue) {
        boolean bl2 = false;
        while (true) {
            try {
                E e2 = blockingQueue.take();
                return e2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    public static <E> void putUninterruptibly(BlockingQueue<E> blockingQueue, E e2) {
        boolean bl2 = false;
        while (true) {
            try {
                blockingQueue.put(e2);
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    @Beta
    public static void sleepUninterruptibly(Duration duration) {
        Uninterruptibles.sleepUninterruptibly(Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @GwtIncompatible
    public static void sleepUninterruptibly(long l2, TimeUnit timeUnit) {
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(l3);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @GwtIncompatible
    @Beta
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, Duration duration) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, long l2, TimeUnit timeUnit) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, 1, l2, timeUnit);
    }

    @GwtIncompatible
    @Beta
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, int n2, Duration duration) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, n2, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, int n2, long l2, TimeUnit timeUnit) {
        boolean bl2 = false;
        try {
            long l3 = timeUnit.toNanos(l2);
            long l4 = System.nanoTime() + l3;
            while (true) {
                try {
                    boolean bl3 = semaphore.tryAcquire(n2, l3, TimeUnit.NANOSECONDS);
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Uninterruptibles() {
    }
}

