/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
final class TimeoutFuture<V>
extends FluentFuture.TrustedFuture<V> {
    private @Nullable ListenableFuture<V> delegateRef;
    private @Nullable ScheduledFuture<?> timer;

    static <V> ListenableFuture<V> create(ListenableFuture<V> listenableFuture, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TimeoutFuture<V> timeoutFuture = new TimeoutFuture<V>(listenableFuture);
        Fire<V> fire = new Fire<V>(timeoutFuture);
        timeoutFuture.timer = scheduledExecutorService.schedule(fire, l2, timeUnit);
        listenableFuture.addListener(fire, MoreExecutors.directExecutor());
        return timeoutFuture;
    }

    private TimeoutFuture(ListenableFuture<V> listenableFuture) {
        this.delegateRef = Preconditions.checkNotNull(listenableFuture);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<V> listenableFuture = this.delegateRef;
        ScheduledFuture<?> scheduledFuture = this.timer;
        if (listenableFuture != null) {
            long l2;
            String string = "inputFuture=[" + listenableFuture + "]";
            if (scheduledFuture != null && (l2 = scheduledFuture.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
                string = string + ", remaining delay=[" + l2 + " ms]";
            }
            return string;
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        ScheduledFuture<?> scheduledFuture = this.timer;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        private TimeoutFutureException(String string) {
            super(string);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    private static final class Fire<V>
    implements Runnable {
        @Nullable TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture listenableFuture = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (listenableFuture == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (listenableFuture.isDone()) {
                timeoutFuture.setFuture(listenableFuture);
            } else {
                try {
                    ScheduledFuture scheduledFuture = ((TimeoutFuture)timeoutFuture).timer;
                    ((TimeoutFuture)timeoutFuture).timer = null;
                    String string = "Timed out";
                    try {
                        long l2;
                        if (scheduledFuture != null && (l2 = Math.abs(scheduledFuture.getDelay(TimeUnit.MILLISECONDS))) > 10L) {
                            string = string + " (timeout delayed by " + l2 + " ms after scheduled time)";
                        }
                        string = string + ": " + listenableFuture;
                    }
                    finally {
                        timeoutFuture.setException(new TimeoutFutureException(string));
                    }
                }
                finally {
                    listenableFuture.cancel(true);
                }
            }
        }
    }
}

