/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.Internal;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

@Beta
@GwtIncompatible
public interface TimeLimiter {
    public <T> T newProxy(T var1, Class<T> var2, long var3, TimeUnit var5);

    default public <T> T newProxy(T t2, Class<T> clazz, Duration duration) {
        return this.newProxy(t2, clazz, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> var1, long var2, TimeUnit var4);

    @CanIgnoreReturnValue
    default public <T> T callWithTimeout(Callable<T> callable, Duration duration) {
        return this.callWithTimeout(callable, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> var1, long var2, TimeUnit var4);

    @CanIgnoreReturnValue
    default public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, Duration duration) {
        return this.callUninterruptiblyWithTimeout(callable, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public void runWithTimeout(Runnable var1, long var2, TimeUnit var4);

    default public void runWithTimeout(Runnable runnable, Duration duration) {
        this.runWithTimeout(runnable, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public void runUninterruptiblyWithTimeout(Runnable var1, long var2, TimeUnit var4);

    default public void runUninterruptiblyWithTimeout(Runnable runnable, Duration duration) {
        this.runUninterruptiblyWithTimeout(runnable, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }
}

