/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.ForwardingCondition;
import com.google.common.util.concurrent.ForwardingLock;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Beta
@GwtIncompatible
public abstract class Striped<L> {
    private static final int LARGE_LAZY_CUTOFF = 1024;
    private static final Supplier<ReadWriteLock> READ_WRITE_LOCK_SUPPLIER = new Supplier<ReadWriteLock>(){

        @Override
        public ReadWriteLock get() {
            return new ReentrantReadWriteLock();
        }
    };
    private static final Supplier<ReadWriteLock> WEAK_SAFE_READ_WRITE_LOCK_SUPPLIER = new Supplier<ReadWriteLock>(){

        @Override
        public ReadWriteLock get() {
            return new WeakSafeReadWriteLock();
        }
    };
    private static final int ALL_SET = -1;

    private Striped() {
    }

    public abstract L get(Object var1);

    public abstract L getAt(int var1);

    abstract int indexFor(Object var1);

    public abstract int size();

    public Iterable<L> bulkGet(Iterable<?> iterable) {
        int n2;
        Object[] objectArray = Iterables.toArray(iterable, Object.class);
        if (objectArray.length == 0) {
            return ImmutableList.of();
        }
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            nArray[n2] = this.indexFor(objectArray[n2]);
        }
        Arrays.sort(nArray);
        n2 = nArray[0];
        objectArray[0] = this.getAt(n2);
        for (int i2 = 1; i2 < objectArray.length; ++i2) {
            int n3 = nArray[i2];
            if (n3 == n2) {
                objectArray[i2] = objectArray[i2 - 1];
                continue;
            }
            objectArray[i2] = this.getAt(n3);
            n2 = n3;
        }
        List<Object> list = Arrays.asList(objectArray);
        return Collections.unmodifiableList(list);
    }

    static <L> Striped<L> custom(int n2, Supplier<L> supplier) {
        return new CompactStriped(n2, supplier);
    }

    public static Striped<Lock> lock(int n2) {
        return Striped.custom(n2, new Supplier<Lock>(){

            @Override
            public Lock get() {
                return new PaddedLock();
            }
        });
    }

    public static Striped<Lock> lazyWeakLock(int n2) {
        return Striped.lazy(n2, new Supplier<Lock>(){

            @Override
            public Lock get() {
                return new ReentrantLock(false);
            }
        });
    }

    private static <L> Striped<L> lazy(int n2, Supplier<L> supplier) {
        return n2 < 1024 ? new SmallLazyStriped<L>(n2, supplier) : new LargeLazyStriped<L>(n2, supplier);
    }

    public static Striped<Semaphore> semaphore(int n2, final int n3) {
        return Striped.custom(n2, new Supplier<Semaphore>(){

            @Override
            public Semaphore get() {
                return new PaddedSemaphore(n3);
            }
        });
    }

    public static Striped<Semaphore> lazyWeakSemaphore(int n2, final int n3) {
        return Striped.lazy(n2, new Supplier<Semaphore>(){

            @Override
            public Semaphore get() {
                return new Semaphore(n3, false);
            }
        });
    }

    public static Striped<ReadWriteLock> readWriteLock(int n2) {
        return Striped.custom(n2, READ_WRITE_LOCK_SUPPLIER);
    }

    public static Striped<ReadWriteLock> lazyWeakReadWriteLock(int n2) {
        return Striped.lazy(n2, WEAK_SAFE_READ_WRITE_LOCK_SUPPLIER);
    }

    private static int ceilToPowerOfTwo(int n2) {
        return 1 << IntMath.log2(n2, RoundingMode.CEILING);
    }

    private static int smear(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private static class PaddedSemaphore
    extends Semaphore {
        long unused1;
        long unused2;
        long unused3;

        PaddedSemaphore(int n2) {
            super(n2, false);
        }
    }

    private static class PaddedLock
    extends ReentrantLock {
        long unused1;
        long unused2;
        long unused3;

        PaddedLock() {
            super(false);
        }
    }

    @VisibleForTesting
    static class LargeLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final ConcurrentMap<Integer, L> locks;
        final Supplier<L> supplier;
        final int size;

        LargeLazyStriped(int n2, Supplier<L> supplier) {
            super(n2);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.supplier = supplier;
            this.locks = new MapMaker().weakValues().makeMap();
        }

        @Override
        public L getAt(int n2) {
            Object object;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(n2, this.size());
            }
            if ((object = this.locks.get(n2)) != null) {
                return (L)object;
            }
            L l2 = this.supplier.get();
            object = this.locks.putIfAbsent(n2, l2);
            return (L)MoreObjects.firstNonNull(object, l2);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @VisibleForTesting
    static class SmallLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final AtomicReferenceArray<ArrayReference<? extends L>> locks;
        final Supplier<L> supplier;
        final int size;
        final ReferenceQueue<L> queue = new ReferenceQueue();

        SmallLazyStriped(int n2, Supplier<L> supplier) {
            super(n2);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.locks = new AtomicReferenceArray(this.size);
            this.supplier = supplier;
        }

        @Override
        public L getAt(int n2) {
            ArrayReference<? extends L> arrayReference;
            L l2;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(n2, this.size());
            }
            L l3 = l2 = (arrayReference = this.locks.get(n2)) == null ? null : (L)arrayReference.get();
            if (l2 != null) {
                return l2;
            }
            L l4 = this.supplier.get();
            ArrayReference<L> arrayReference2 = new ArrayReference<L>(l4, n2, this.queue);
            while (!this.locks.compareAndSet(n2, arrayReference, arrayReference2)) {
                arrayReference = this.locks.get(n2);
                l2 = arrayReference == null ? null : (L)arrayReference.get();
                if (l2 == null) continue;
                return l2;
            }
            this.drainQueue();
            return l4;
        }

        private void drainQueue() {
            Reference<L> reference;
            while ((reference = this.queue.poll()) != null) {
                ArrayReference arrayReference = (ArrayReference)reference;
                this.locks.compareAndSet(arrayReference.index, arrayReference, null);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        private static final class ArrayReference<L>
        extends WeakReference<L> {
            final int index;

            ArrayReference(L l2, int n2, ReferenceQueue<L> referenceQueue) {
                super(l2, referenceQueue);
                this.index = n2;
            }
        }
    }

    private static class CompactStriped<L>
    extends PowerOfTwoStriped<L> {
        private final Object[] array;

        private CompactStriped(int n2, Supplier<L> supplier) {
            super(n2);
            Preconditions.checkArgument(n2 <= 0x40000000, "Stripes must be <= 2^30)");
            this.array = new Object[this.mask + 1];
            for (int i2 = 0; i2 < this.array.length; ++i2) {
                this.array[i2] = supplier.get();
            }
        }

        @Override
        public L getAt(int n2) {
            return (L)this.array[n2];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    private static abstract class PowerOfTwoStriped<L>
    extends Striped<L> {
        final int mask;

        PowerOfTwoStriped(int n2) {
            Preconditions.checkArgument(n2 > 0, "Stripes must be positive");
            this.mask = n2 > 0x40000000 ? -1 : Striped.ceilToPowerOfTwo(n2) - 1;
        }

        @Override
        final int indexFor(Object object) {
            int n2 = Striped.smear(object.hashCode());
            return n2 & this.mask;
        }

        @Override
        public final L get(Object object) {
            return this.getAt(this.indexFor(object));
        }
    }

    private static final class WeakSafeCondition
    extends ForwardingCondition {
        private final Condition delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeCondition(Condition condition, WeakSafeReadWriteLock weakSafeReadWriteLock) {
            this.delegate = condition;
            this.strongReference = weakSafeReadWriteLock;
        }

        @Override
        Condition delegate() {
            return this.delegate;
        }
    }

    private static final class WeakSafeLock
    extends ForwardingLock {
        private final Lock delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeLock(Lock lock, WeakSafeReadWriteLock weakSafeReadWriteLock) {
            this.delegate = lock;
            this.strongReference = weakSafeReadWriteLock;
        }

        @Override
        Lock delegate() {
            return this.delegate;
        }

        @Override
        public Condition newCondition() {
            return new WeakSafeCondition(this.delegate.newCondition(), this.strongReference);
        }
    }

    private static final class WeakSafeReadWriteLock
    implements ReadWriteLock {
        private final ReadWriteLock delegate = new ReentrantReadWriteLock();

        WeakSafeReadWriteLock() {
        }

        @Override
        public Lock readLock() {
            return new WeakSafeLock(this.delegate.readLock(), this);
        }

        @Override
        public Lock writeLock() {
            return new WeakSafeLock(this.delegate.writeLock(), this);
        }
    }
}

